/*
 * Decompiled with CFR 0.152.
 */
package org.scalatestplus.junit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatest.Reporter;
import org.scalatest.StatefulStatus;
import org.scalatest.Tracker;
import org.scalatest.events.Event;
import org.scalatest.events.IndentedText;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.events.TopOfMethod;
import org.scalatest.events.TopOfMethod$;
import org.scalatest.exceptions.PayloadField;
import org.scalatestplus.junit.JUnitHelper$;
import org.scalatestplus.junit.Resources$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.package$;

public class MyRunListener
extends RunListener {
    private final Reporter report;
    private final Tracker theTracker;
    private final StatefulStatus status;
    private final Set failedTests;
    private final Pattern TEST_DESCRIPTION_PATTERN;

    public MyRunListener(Reporter report, Map<String, Object> config, Tracker theTracker, StatefulStatus status) {
        this.report = report;
        this.theTracker = theTracker;
        this.status = status;
        this.failedTests = Collections.synchronizedSet(new HashSet());
        this.TEST_DESCRIPTION_PATTERN = Pattern.compile("^(.*)\\((.*)\\)");
    }

    public Set<String> failedTests() {
        return this.failedTests;
    }

    public Some<TopOfMethod> getTopOfMethod(String className, String methodName) {
        return Some$.MODULE$.apply((Object)TopOfMethod$.MODULE$.apply(className, new StringBuilder(15).append("public void ").append(className).append(".").append(methodName).append("()").toString()));
    }

    public void testFailure(Failure failure) {
        None$ none$;
        this.failedTests().add(failure.getDescription().getDisplayName());
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(failure.getDescription());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String testName = (String)tuple3._1();
        String testClass = (String)tuple3._2();
        String testClassName = (String)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)testName, (Object)testClass, (Object)testClassName);
        String testName2 = (String)tuple32._1();
        String testClass2 = (String)tuple32._2();
        String testClassName2 = (String)tuple32._3();
        Throwable throwableOrNull = failure.getException();
        None$ throwable = throwableOrNull != null ? Some$.MODULE$.apply((Object)throwableOrNull) : None$.MODULE$;
        String message = throwableOrNull != null ? throwableOrNull.toString() : Resources$.MODULE$.jUnitTestFailed();
        IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testName2, 1, true);
        None$ none$2 = throwable;
        if (none$2 instanceof PayloadField) {
            Option optPayload = (Option)((PayloadField)none$2);
            none$ = ((PayloadField)optPayload).payload();
        } else {
            none$ = None$.MODULE$;
        }
        None$ payload = none$;
        this.report.apply((Event)TestFailed$.MODULE$.apply(this.theTracker.nextOrdinal(), message, testClassName2, testClass2, (Option)Some$.MODULE$.apply((Object)testClass2), testName2, testName2, (IndexedSeq)package$.MODULE$.Vector().empty(), (IndexedSeq)package$.MODULE$.Vector().empty(), (Option)throwable, (Option)None$.MODULE$, (Option)Some$.MODULE$.apply((Object)formatter), (Option)Some$.MODULE$.apply((Object)SeeStackDepthException$.MODULE$), (Option)None$.MODULE$, (Option)payload, TestFailed$.MODULE$.$lessinit$greater$default$16(), TestFailed$.MODULE$.$lessinit$greater$default$17()));
    }

    public void testFinished(Description description) {
        if (!this.failedTests().contains(description.getDisplayName())) {
            Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String testName = (String)tuple3._1();
            String testClass = (String)tuple3._2();
            String testClassName = (String)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)testName, (Object)testClass, (Object)testClassName);
            String testName2 = (String)tuple32._1();
            String testClass2 = (String)tuple32._2();
            String testClassName2 = (String)tuple32._3();
            IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testName2, 1, true);
            this.report.apply((Event)TestSucceeded$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option)Some$.MODULE$.apply((Object)testClass2), testName2, testName2, (IndexedSeq)package$.MODULE$.Vector().empty(), (Option)None$.MODULE$, (Option)Some$.MODULE$.apply((Object)formatter), this.getTopOfMethod(testClass2, testName2), TestSucceeded$.MODULE$.$lessinit$greater$default$11(), TestSucceeded$.MODULE$.$lessinit$greater$default$12(), TestSucceeded$.MODULE$.$lessinit$greater$default$13(), TestSucceeded$.MODULE$.$lessinit$greater$default$14()));
            return;
        }
        this.status.setFailed();
    }

    public void testIgnored(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String testName = (String)tuple3._1();
        String testClass = (String)tuple3._2();
        String testClassName = (String)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)testName, (Object)testClass, (Object)testClassName);
        String testName2 = (String)tuple32._1();
        String testClass2 = (String)tuple32._2();
        String testClassName2 = (String)tuple32._3();
        IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testName2, 1, true);
        this.report.apply((Event)TestIgnored$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option)Some$.MODULE$.apply((Object)testClass2), testName2, testName2, (Option)Some$.MODULE$.apply((Object)formatter), this.getTopOfMethod(testClass2, testName2), TestIgnored$.MODULE$.$lessinit$greater$default$9(), TestIgnored$.MODULE$.$lessinit$greater$default$10(), TestIgnored$.MODULE$.$lessinit$greater$default$11()));
    }

    public void testRunFinished(Result result) {
    }

    public void testRunStarted(Description description) {
    }

    public void testStarted(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String testName = (String)tuple3._1();
        String testClass = (String)tuple3._2();
        String testClassName = (String)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)testName, (Object)testClass, (Object)testClassName);
        String testName2 = (String)tuple32._1();
        String testClass2 = (String)tuple32._2();
        String testClassName2 = (String)tuple32._3();
        this.report.apply((Event)TestStarting$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option)Some$.MODULE$.apply((Object)testClass2), testName2, testName2, (Option)Some$.MODULE$.apply((Object)MotionToSuppress$.MODULE$), this.getTopOfMethod(testClass2, testName2), TestStarting$.MODULE$.$lessinit$greater$default$9(), TestStarting$.MODULE$.$lessinit$greater$default$10(), TestStarting$.MODULE$.$lessinit$greater$default$11(), TestStarting$.MODULE$.$lessinit$greater$default$12()));
    }

    public Pattern TEST_DESCRIPTION_PATTERN() {
        return this.TEST_DESCRIPTION_PATTERN;
    }

    private Tuple3<String, String, String> parseTestDescription(Description description) {
        Matcher matcher = this.TEST_DESCRIPTION_PATTERN().matcher(description.getDisplayName());
        if (!matcher.find()) {
            throw new RuntimeException(new StringBuilder(25).append("unexpected displayName [").append(description.getDisplayName()).append("]").toString());
        }
        String testName = matcher.group(1);
        String testClass = matcher.group(2);
        String testClassName = testClass.replaceAll(".*\\.", "");
        return Tuple3$.MODULE$.apply((Object)testName, (Object)testClass, (Object)testClassName);
    }
}

