/*
 * Decompiled with CFR 0.152.
 */
package org.scalastyle.sbt;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.scalastyle.Directory$;
import org.scalastyle.FileSpec;
import org.scalastyle.Message;
import org.scalastyle.OutputResult;
import org.scalastyle.ScalastyleChecker;
import org.scalastyle.ScalastyleChecker$;
import org.scalastyle.ScalastyleConfiguration;
import org.scalastyle.ScalastyleConfiguration$;
import org.scalastyle.XmlOutput$;
import org.scalastyle.sbt.SbtLogOutput;
import sbt.internal.util.Init;
import sbt.internal.util.ManagedLogger;
import sbt.io.RichFile$;
import sbt.package$;
import sbt.std.TaskStreams;
import sbt.util.Logger;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.io.Codec$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger$;

public final class Tasks$ {
    public static Tasks$ MODULE$;

    static {
        new Tasks$();
    }

    public void doScalastyle(Seq<String> args, File config, Option<URL> configUrl, boolean failOnError, boolean failOnWarning, Seq<File> scalastyleSources, File scalastyleTarget, TaskStreams<Init.ScopedKey<?>> streams, Integer refreshHours, File target, String urlCacheFile) {
        ManagedLogger logger = streams.log();
        String quietArg = "q";
        String silentArg = "s";
        String warnErrorArg = "w";
        Set supportedArgs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{quietArg, silentArg, warnErrorArg}));
        boolean quiet = args.contains((Object)quietArg);
        boolean silent = args.contains((Object)silentArg);
        boolean warnError = args.contains((Object)warnErrorArg);
        File configFileToUse = Tasks$.getConfigFile$1(target, configUrl, config, urlCacheFile, streams, refreshHours, target, logger, quiet);
        if (!configFileToUse.exists()) {
            throw scala.sys.package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("config does not exist: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configFileToUse})));
        }
        this.doScalastyleWithConfig$1(configFileToUse, args, failOnError, failOnWarning, scalastyleSources, scalastyleTarget, target, logger, supportedArgs, quiet, silent, warnError);
    }

    public void doGenerateConfig(File config, TaskStreams<Init.ScopedKey<?>> streams) {
        this.extractFileFromJar(this.getClass().getResource("/scalastyle-config.xml"), RichFile$.MODULE$.absolutePath$extension(package$.MODULE$.fileToRichFile(config)), (Logger)streams.log());
    }

    private List<Message<FileSpec>> runScalastyle(File config, Seq<File> filesToProcess) {
        ScalastyleConfiguration configuration = ScalastyleConfiguration$.MODULE$.readFromXml(RichFile$.MODULE$.absolutePath$extension(package$.MODULE$.fileToRichFile(config)));
        return new ScalastyleChecker(ScalastyleChecker$.MODULE$.$lessinit$greater$default$1()).checkFiles(configuration, (Seq)Directory$.MODULE$.getFiles((Option)None$.MODULE$, filesToProcess, (Seq)Nil$.MODULE$));
    }

    private OutputResult printResults(Config config, Logger logger, List<Message<FileSpec>> messages, boolean quiet, boolean warnError, boolean silent) {
        OutputResult outputResult;
        block0: {
            long start = Tasks$.now$1();
            outputResult = new SbtLogOutput<FileSpec>(config, logger, warnError, silent).output((Seq<Message<FileSpec>>)messages);
            if (quiet) break block0;
            logger.info((Function0 & Serializable & scala.Serializable)() -> "scalastyle Processed " + outputResult.files() + " file(s)");
            logger.info((Function0 & Serializable & scala.Serializable)() -> "scalastyle Found " + outputResult.errors() + " errors");
            logger.info((Function0 & Serializable & scala.Serializable)() -> "scalastyle Found " + outputResult.warnings() + " warnings");
            logger.info((Function0 & Serializable & scala.Serializable)() -> "scalastyle Found " + outputResult.infos() + " infos");
            logger.info((Function0 & Serializable & scala.Serializable)() -> "scalastyle Finished in " + (Tasks$.now$1() - start) + " ms");
        }
        return outputResult;
    }

    private boolean printResults$default$4() {
        return false;
    }

    private boolean printResults$default$5() {
        return false;
    }

    private boolean printResults$default$6() {
        return false;
    }

    private void saveToXml(Config config, List<Message<FileSpec>> messages, String path, Codec codec) {
        XmlOutput$.MODULE$.save(config, path, codec.charSet().toString(), messages);
    }

    private <A> Iterator<A> enumToIterator(Enumeration<A> e) {
        return new Iterator<A>(e){
            private final Enumeration e$1;

            public Iterator<A> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<A> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<A> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<A> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<A> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<A, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<A, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<A> filter(Function1<A, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<A, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<A> withFilter(Function1<A, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<A> filterNot(Function1<A, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<A, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, A, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<A, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<A> takeWhile(Function1<A, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<A>, Iterator<A>> partition(Function1<A, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<A>, Iterator<A>> span(Function1<A, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<A> dropWhile(Function1<A, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<A, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<A, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<A, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<A, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<A, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<A> find(Function1<A, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<A, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<A, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<A> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<A>, Iterator<A>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<A> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<A> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<A> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public List<A> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<A, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<A, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, A, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<A, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, A, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<A, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, A, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<A, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, A, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<A, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, A, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public <B> A min(Ordering<B> cmp) {
                return (A)TraversableOnce.min$((TraversableOnce)this, cmp);
            }

            public <B> A max(Ordering<B> cmp) {
                return (A)TraversableOnce.max$((TraversableOnce)this, cmp);
            }

            public <B> A maxBy(Function1<A, B> f, Ordering<B> cmp) {
                return (A)TraversableOnce.maxBy$((TraversableOnce)this, f, cmp);
            }

            public <B> A minBy(Function1<A, B> f, Ordering<B> cmp) {
                return (A)TraversableOnce.minBy$((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<A> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<A> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<A> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<A> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<A> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, A, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<A, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public A next() {
                return (A)this.e$1.nextElement();
            }

            public boolean hasNext() {
                return this.e$1.hasMoreElements();
            }
            {
                this.e$1 = e$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        };
    }

    private void extractFileFromJar(URL url, String destination, Logger logger) {
        block2: {
            File target = package$.MODULE$.file(destination);
            if (!this.safeToCreateFile(target)) break block2;
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection instanceof JarURLConnection) {
                JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                String entryName = jarURLConnection.getEntryName();
                JarFile jarFile = jarURLConnection.getJarFile();
                this.enumToIterator(jarFile.entries()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Tasks$.$anonfun$extractFileFromJar$2(entryName, x$3))).foreach((Function1 & Serializable & scala.Serializable)e -> {
                    Tasks$.createFile$1(jarFile, e, target, logger);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private boolean safeToCreateFile(File file) {
        return file.exists() ? this.askUser$1(file) : true;
    }

    private static final void handleResult$1(boolean hasError, boolean hasWarning, boolean failOnError$1, boolean failOnWarning$1, ManagedLogger logger$1, boolean warnError$1) {
        block2: {
            block1: {
                if (hasError && failOnError$1 || hasWarning && (warnError$1 || failOnWarning$1)) {
                    throw scala.sys.package$.MODULE$.error("Failing because of negative scalastyle result");
                }
                if (!hasError) break block1;
                logger$1.error((Function0 & Serializable & scala.Serializable)() -> "errors exist");
                break block2;
            }
            if (!hasWarning) break block2;
            logger$1.warn((Function0 & Serializable & scala.Serializable)() -> "warnings exist");
        }
    }

    public static final /* synthetic */ void $anonfun$doScalastyle$4(TaskStreams streams$1, String x$1) {
        streams$1.log().info((Function0 & Serializable & scala.Serializable)() -> x$1);
    }

    public static final /* synthetic */ void $anonfun$doScalastyle$6(TaskStreams streams$1, String x$2) {
        streams$1.log().error((Function0 & Serializable & scala.Serializable)() -> x$2);
    }

    private static final File getConfigFile$1(File targetDirectory, Option configUrl, File config, String outputFile, TaskStreams streams$1, Integer refreshHours$1, File target$1, ManagedLogger logger$1, boolean quiet$1) {
        File f;
        block8: {
            File file;
            Option option = configUrl;
            if (option instanceof Some) {
                Object object;
                Some some = (Some)option;
                URL url = (URL)some.value();
                File targetConfigFile = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(target$1), outputFile);
                if (!targetConfigFile.exists() || TimeUnit.MILLISECONDS.toHours(new Date().getTime() - targetConfigFile.lastModified()) >= (long)Predef$.MODULE$.Integer2int(refreshHours$1)) {
                    int n;
                    try {
                        logger$1.info((Function0 & Serializable & scala.Serializable)() -> "downloading " + url + " to " + targetConfigFile.getAbsolutePath());
                        n = Process$.MODULE$.apply(targetConfigFile).$hash$less(url).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$1 -> {
                            Tasks$.$anonfun$doScalastyle$4(streams$1, x$1);
                            return BoxedUnit.UNIT;
                        }, (Function1 & Serializable & scala.Serializable)x$2 -> {
                            Tasks$.$anonfun$doScalastyle$6(streams$1, x$2);
                            return BoxedUnit.UNIT;
                        }));
                    }
                    catch (Exception ex) {
                        throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to download remote config: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ex})));
                    }
                    object = BoxesRunTime.boxToInteger((int)n);
                } else {
                    object = BoxedUnit.UNIT;
                }
                file = targetConfigFile;
            } else if (None$.MODULE$.equals(option)) {
                file = config;
            } else {
                throw new MatchError((Object)option);
            }
            f = file;
            if (quiet$1) break block8;
            logger$1.info((Function0 & Serializable & scala.Serializable)() -> "scalastyle using config " + f.getAbsolutePath());
        }
        return f;
    }

    public static final /* synthetic */ boolean $anonfun$doScalastyle$9(File f$2, File s) {
        return f$2.getAbsolutePath().startsWith(s.getAbsolutePath());
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isInProject$1(Seq sources, File f, ManagedLogger logger$1) {
        void var3_3;
        block0: {
            boolean validFile;
            boolean bl = validFile = f.exists() && sources.exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Tasks$.$anonfun$doScalastyle$9(f, s)));
            if (validFile) break block0;
            logger$1.warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " does not exist in project"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f})));
        }
        return (boolean)var3_3;
    }

    private final void doScalastyleWithConfig$1(File config, Seq args$1, boolean failOnError$1, boolean failOnWarning$1, Seq scalastyleSources$1, File scalastyleTarget$1, File target$1, ManagedLogger logger$1, Set supportedArgs$1, boolean quiet$1, boolean silent$1, boolean warnError$1) {
        Config messageConfig = ConfigFactory.load((ClassLoader)new ScalastyleChecker(ScalastyleChecker$.MODULE$.$lessinit$greater$default$1()).getClass().getClassLoader());
        Seq seq = (Seq)((TraversableLike)((TraversableLike)args$1.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)supportedArgs$1.contains((Object)elem)))).map((Function1 & Serializable & scala.Serializable)s -> package$.MODULE$.file(s), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Tasks$.isInProject$1(scalastyleSources$1, f, logger$1)));
        Seq seq2 = Nil$.MODULE$.equals(seq) ? scalastyleSources$1 : seq;
        Seq filesToProcess = seq2;
        List<Message<FileSpec>> messages = this.runScalastyle(config, (Seq<File>)filesToProcess);
        this.saveToXml(messageConfig, messages, RichFile$.MODULE$.absolutePath$extension(package$.MODULE$.fileToRichFile(scalastyleTarget$1)), Codec$.MODULE$.fallbackSystemCodec());
        Config x$5 = messageConfig;
        ManagedLogger x$6 = logger$1;
        List<Message<FileSpec>> x$7 = messages;
        boolean x$8 = quiet$1;
        boolean x$9 = silent$1;
        boolean x$10 = warnError$1;
        OutputResult result = this.printResults(x$5, (Logger)x$6, x$7, x$8, x$10, x$9);
        if (!quiet$1) {
            logger$1.success((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("created output: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{target$1})));
        }
        Tasks$.handleResult$1(result.errors() > 0, result.warnings() > 0, failOnError$1, failOnWarning$1, logger$1, warnError$1);
    }

    private static final long now$1() {
        return new Date().getTime();
    }

    private static final void createFile$1(JarFile jarFile, JarEntry e, File target, Logger logger$2) {
        package$.MODULE$.IO().transfer(jarFile.getInputStream(e), target);
        logger$2.success((Function0 & Serializable & scala.Serializable)() -> "created: " + target);
    }

    public static final /* synthetic */ boolean $anonfun$extractFileFromJar$2(String entryName$1, JarEntry x$3) {
        String string = x$3.getName();
        String string2 = entryName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final boolean askUser$1(File file$1) {
        boolean bl;
        block1: {
            Some some;
            char c;
            boolean bl2;
            do {
                String question = new StringOps(Predef$.MODULE$.augmentString("The file %s exists, do you want to overwrite it? (y/n): ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file$1.getPath()}));
                bl2 = false;
                some = null;
                Option option = new StringOps(Predef$.MODULE$.augmentString(Console$.MODULE$.readLine(question, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])).toLowerCase())).headOption();
                if (!(option instanceof Some)) continue;
                bl2 = true;
                some = (Some)option;
                char c2 = BoxesRunTime.unboxToChar((Object)some.value());
                if ('y' != c2) continue;
                bl = true;
                break block1;
            } while (!bl2 || 'n' != (c = BoxesRunTime.unboxToChar((Object)some.value())));
            bl = false;
        }
        return bl;
    }

    private Tasks$() {
        MODULE$ = this;
    }
}

