/*
 * Decompiled with CFR 0.152.
 */
package breeze.util;

import breeze.collection.mutable.SparseArray;
import breeze.linalg.Counter;
import breeze.linalg.Counter$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.linalg.Tensor;
import breeze.linalg.Vector;
import breeze.linalg.VectorBuilder;
import breeze.linalg.VectorBuilder$;
import breeze.math.Semiring$;
import breeze.storage.Zero;
import breeze.storage.Zero$;
import breeze.util.Encoder$;
import breeze.util.Index;
import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface Encoder<T> {
    public static <T> Encoder<T> fromIndex(Index<T> index) {
        return Encoder$.MODULE$.fromIndex(index);
    }

    public Index<T> index();

    public static SparseVector mkSparseVector$(Encoder $this) {
        return $this.mkSparseVector();
    }

    default public SparseVector<Object> mkSparseVector() {
        return SparseVector$.MODULE$.zeros(this.index().size(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
    }

    public static DenseVector mkDenseVector$(Encoder $this, double d) {
        return $this.mkDenseVector(d);
    }

    default public DenseVector<Object> mkDenseVector(double d) {
        double[] array = new double[this.index().size()];
        Arrays.fill(array, d);
        return new DenseVector<Object>(array);
    }

    public static double mkDenseVector$default$1$(Encoder $this) {
        return $this.mkDenseVector$default$1();
    }

    default public double mkDenseVector$default$1() {
        return 0.0;
    }

    public static Vector mkVector$(Encoder $this) {
        return $this.mkVector();
    }

    default public Vector<Object> mkVector() {
        return this.mkSparseVector();
    }

    public static DenseMatrix mkMatrix$(Encoder $this) {
        return $this.mkMatrix();
    }

    default public DenseMatrix<Object> mkMatrix() {
        return DenseMatrix$.MODULE$.zeros(this.index().size(), this.index().size(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
    }

    public static Counter decode$(Encoder $this, Vector v, boolean keepZeros) {
        return $this.decode(v, keepZeros);
    }

    /*
     * WARNING - void declaration
     */
    default public Counter<T, Object> decode(Vector<Object> v, boolean keepZeros) {
        void var3_3;
        Counter ctr = Counter$.MODULE$.apply(Zero$.MODULE$.DoubleZero());
        v.active().pairs().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                if (keepZeros || v != 0.0) {
                    ctr.update(this.index().get(i), BoxesRunTime.boxToDouble((double)v));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        return var3_3;
    }

    public static boolean decode$default$2$(Encoder $this) {
        return $this.decode$default$2();
    }

    default public boolean decode$default$2() {
        return false;
    }

    public static DenseVector encodeDense$(Encoder $this, Tensor c, boolean ignoreOutOfIndex) {
        return $this.encodeDense(c, ignoreOutOfIndex);
    }

    /*
     * WARNING - void declaration
     */
    default public DenseVector<Object> encodeDense(Tensor<T, Object> c, boolean ignoreOutOfIndex) {
        void var3_3;
        DenseVector<Object> vec = this.mkDenseVector(this.mkDenseVector$default$1());
        c.active().pairs().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                int ki = this.index().apply(k);
                if (ki < 0) {
                    if (!ignoreOutOfIndex) {
                        throw new RuntimeException(new StringBuilder(21).append("Error, not in index: ").append(k).toString());
                    }
                } else {
                    vec.update(ki, (Object)BoxesRunTime.boxToDouble((double)v));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        return var3_3;
    }

    public static boolean encodeDense$default$2$(Encoder $this) {
        return $this.encodeDense$default$2();
    }

    default public boolean encodeDense$default$2() {
        return false;
    }

    public static SparseVector encodeSparse$(Encoder $this, Tensor c, boolean ignoreOutOfIndex) {
        return $this.encodeSparse(c, ignoreOutOfIndex);
    }

    default public SparseVector<Object> encodeSparse(Tensor<T, Object> c, boolean ignoreOutOfIndex) {
        VectorBuilder<Object> vec = new VectorBuilder<Object>(this.index().size(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
        vec.reserve(c.activeSize());
        c.active().pairs().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                int ki = this.index().apply(k);
                if (ki < 0) {
                    if (!ignoreOutOfIndex) {
                        throw new RuntimeException(new StringBuilder(21).append("Error, not in index: ").append(k).toString());
                    }
                } else {
                    vec.add(ki, BoxesRunTime.boxToDouble((double)v));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        return vec.toSparseVector();
    }

    public static boolean encodeSparse$default$2$(Encoder $this) {
        return $this.encodeSparse$default$2();
    }

    default public boolean encodeSparse$default$2() {
        return false;
    }

    public static Vector encode$(Encoder $this, Tensor c, boolean ignoreOutOfIndex) {
        return $this.encode(c, ignoreOutOfIndex);
    }

    /*
     * WARNING - void declaration
     */
    default public Vector<Object> encode(Tensor<T, Object> c, boolean ignoreOutOfIndex) {
        void var3_3;
        Vector<Object> vec = this.mkVector();
        c.active().pairs().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                int ki = this.index().apply(k);
                if (ki < 0) {
                    if (!ignoreOutOfIndex) {
                        throw new RuntimeException(new StringBuilder(21).append("Error, not in index: ").append(k).toString());
                    }
                } else {
                    vec.update(BoxesRunTime.boxToInteger((int)ki), BoxesRunTime.boxToDouble((double)v));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        return var3_3;
    }

    public static boolean encode$default$2$(Encoder $this) {
        return $this.encode$default$2();
    }

    default public boolean encode$default$2() {
        return false;
    }

    public static DenseMatrix encode$(Encoder $this, Tensor c) {
        return $this.encode(c);
    }

    /*
     * WARNING - void declaration
     */
    default public DenseMatrix<Object> encode(Tensor<Tuple2<T, T>, Object> c) {
        void var2_2;
        DenseMatrix<Object> vec = this.mkMatrix();
        c.active().pairs().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                Object k = tuple2._1();
                Object l = tuple2._2();
                double v = BoxesRunTime.unboxToDouble((Object)tuple22._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((JProcedure1 & Serializable)x$1 -> {
            int li;
            int ki;
            double v;
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                Object k = tuple2._1();
                Object l = tuple2._2();
                v = BoxesRunTime.unboxToDouble((Object)tuple22._2());
                ki = this.index().apply(k);
                li = this.index().apply(l);
                if (ki < 0) {
                    throw new RuntimeException(new StringBuilder(21).append("Error, not in index: ").append(k).toString());
                }
                if (li < 0) {
                    throw new RuntimeException(new StringBuilder(21).append("Error, not in index: ").append(k).toString());
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            vec.update(ki, li, BoxesRunTime.boxToDouble((double)v));
        });
        return var2_2;
    }

    public static Object mkArray$(Encoder $this, ClassTag evidence$1) {
        return $this.mkArray(evidence$1);
    }

    default public <V> Object mkArray(ClassTag<V> evidence$1) {
        return Arrays$.MODULE$.newGenericArray(this.index().size(), evidence$1);
    }

    public static Object fillArray$(Encoder $this, Function0 function0, ClassTag evidence$2) {
        return $this.fillArray(function0, evidence$2);
    }

    default public <V> Object fillArray(Function0<V> function0, ClassTag<V> evidence$2) {
        return Array$.MODULE$.fill(this.index().size(), function0, evidence$2);
    }

    public static Object tabulateArray$(Encoder $this, Function1 f, ClassTag evidence$3) {
        return $this.tabulateArray(f, evidence$3);
    }

    /*
     * WARNING - void declaration
     */
    default public <V> Object tabulateArray(Function1<T, V> f, ClassTag<V> evidence$3) {
        void var3_3;
        Object arr = Arrays$.MODULE$.newGenericArray(this.index().size(), evidence$3);
        this.index().pairs().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object e = tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object e = tuple2._1();
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            ScalaRunTime$.MODULE$.array_update(arr, i, f.apply(e));
        });
        return var3_3;
    }

    public static DenseVector tabulateDenseVector$(Encoder $this, Function1 f) {
        return $this.tabulateDenseVector(f);
    }

    default public DenseVector<Object> tabulateDenseVector(Function1<T, Object> f) {
        return new DenseVector<Object>(this.tabulateArray(f, ClassTag$.MODULE$.apply(Double.TYPE)));
    }

    public static Map decode$(Encoder $this, Object array) {
        return $this.decode(array);
    }

    default public <V> Map<T, V> decode(Object array) {
        Object object = Predef$.MODULE$.genericArrayOps(array);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        return (Map)Predef$.MODULE$.Map().empty().$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object v = tuple2._1();
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return Tuple2$.MODULE$.apply(this.index().get(i), v);
        }, ClassTag$.MODULE$.apply(Tuple2.class))));
    }

    public static SparseArray mkSparseArray$(Encoder $this, ClassTag evidence$4, Zero evidence$5) {
        return $this.mkSparseArray(evidence$4, evidence$5);
    }

    default public <V> SparseArray<V> mkSparseArray(ClassTag<V> evidence$4, Zero<V> evidence$5) {
        return new SparseArray<V>(this.index().size(), evidence$4, evidence$5);
    }

    public static Map decode$(Encoder $this, SparseArray array) {
        return $this.decode(array);
    }

    default public <V> Map<T, V> decode(SparseArray<V> array) {
        return (Map)Predef$.MODULE$.Map().empty().$plus$plus((IterableOnce)array.iterator().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
            Object v = tuple2._2();
            return Tuple2$.MODULE$.apply(this.index().get(i), v);
        }));
    }

    public static class SimpleEncoder<T>
    implements Encoder<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Index index;

        public SimpleEncoder(Index<T> index) {
            this.index = index;
        }

        @Override
        public Index<T> index() {
            return this.index;
        }
    }
}

