/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.regression;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.stats.regression.LassoCalculator$;
import breeze.stats.regression.LassoResult;
import breeze.stats.regression.LassoResult$;
import breeze.stats.regression.LeastSquaresRegressionResult;
import breeze.stats.regression.leastSquaresDestructive$;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LassoCalculator
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(LassoCalculator.class, "0bitmap$1");
    public long 0bitmap$1;
    private final DenseMatrix data;
    private final DenseVector outputs;
    private final double lambda;
    private final double[] workArray;
    private final int MAX_ITER;
    private final double IMPROVE_THRESHOLD;
    private final DenseVector<Object> outputCopy;
    private final DenseMatrix<Object> singleColumnMatrix;
    private final DenseVector<Object> resultVec;
    public LassoResult result$lzy1;

    public static LassoCalculator apply(DenseMatrix<Object> denseMatrix, DenseVector<Object> denseVector, double d, double[] dArray, int n, double d2) {
        return LassoCalculator$.MODULE$.apply(denseMatrix, denseVector, d, dArray, n, d2);
    }

    public static LassoCalculator fromProduct(Product product2) {
        return LassoCalculator$.MODULE$.fromProduct(product2);
    }

    public static LassoCalculator unapply(LassoCalculator lassoCalculator) {
        return LassoCalculator$.MODULE$.unapply(lassoCalculator);
    }

    public static int $lessinit$greater$default$5() {
        return LassoCalculator$.MODULE$.$lessinit$greater$default$5();
    }

    public static double $lessinit$greater$default$6() {
        return LassoCalculator$.MODULE$.$lessinit$greater$default$6();
    }

    public LassoCalculator(DenseMatrix<Object> data, DenseVector<Object> outputs, double lambda, double[] workArray, int MAX_ITER, double IMPROVE_THRESHOLD) {
        this.data = data;
        this.outputs = outputs;
        this.lambda = lambda;
        this.workArray = workArray;
        this.MAX_ITER = MAX_ITER;
        this.IMPROVE_THRESHOLD = IMPROVE_THRESHOLD;
        Predef$.MODULE$.require(data.rows() == outputs.size());
        Predef$.MODULE$.require(data.rows() > data.cols());
        Predef$.MODULE$.require(data.rows() == outputs.size());
        Object object = Predef$.MODULE$.doubleArrayOps(workArray);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(object) >= 2 * data.rows() * data.cols());
        this.outputCopy = DenseVector$.MODULE$.zeros(outputs.size(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        this.singleColumnMatrix = new DenseMatrix(data.rows(), 1, ClassTag$.MODULE$.apply(Double.TYPE));
        this.resultVec = DenseVector$.MODULE$.zeros(data.cols(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.data()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.outputs()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.lambda()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.workArray()));
        n = Statics.mix((int)n, (int)this.MAX_ITER());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.IMPROVE_THRESHOLD()));
        return Statics.finalizeHash((int)n, (int)6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LassoCalculator)) return false;
        LassoCalculator lassoCalculator = (LassoCalculator)object;
        if (this.lambda() != lassoCalculator.lambda()) return false;
        if (this.MAX_ITER() != lassoCalculator.MAX_ITER()) return false;
        if (this.IMPROVE_THRESHOLD() != lassoCalculator.IMPROVE_THRESHOLD()) return false;
        DenseMatrix<Object> denseMatrix = this.data();
        DenseMatrix<Object> denseMatrix2 = lassoCalculator.data();
        if (denseMatrix == null) {
            if (denseMatrix2 != null) {
                return false;
            }
        } else if (!((Object)denseMatrix).equals(denseMatrix2)) return false;
        DenseVector<Object> denseVector = this.outputs();
        DenseVector<Object> denseVector2 = lassoCalculator.outputs();
        if (denseVector == null) {
            if (denseVector2 != null) {
                return false;
            }
        } else if (!((Object)denseVector).equals(denseVector2)) return false;
        if (this.workArray() != lassoCalculator.workArray()) return false;
        if (!lassoCalculator.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof LassoCalculator;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "LassoCalculator";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToDouble((double)this._3());
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this._5());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToDouble((double)this._6());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "data";
                break;
            }
            case 1: {
                string = "outputs";
                break;
            }
            case 2: {
                string = "lambda";
                break;
            }
            case 3: {
                string = "workArray";
                break;
            }
            case 4: {
                string = "MAX_ITER";
                break;
            }
            case 5: {
                string = "IMPROVE_THRESHOLD";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public DenseMatrix<Object> data() {
        return this.data;
    }

    public DenseVector<Object> outputs() {
        return this.outputs;
    }

    public double lambda() {
        return this.lambda;
    }

    public double[] workArray() {
        return this.workArray;
    }

    public int MAX_ITER() {
        return this.MAX_ITER;
    }

    public double IMPROVE_THRESHOLD() {
        return this.IMPROVE_THRESHOLD;
    }

    public LassoResult result() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    LassoResult lassoResult;
                    boolean improvedResult = true;
                    int iter = 0;
                    while (improvedResult && iter < this.MAX_ITER()) {
                        ++iter;
                        improvedResult = false;
                        int yy = this.data().cols();
                        for (int i = 0; i < this.data().cols(); ++i) {
                            int n = i;
                            LeastSquaresRegressionResult eoc = this.estimateOneColumn(n);
                            double oldCoefficient = BoxesRunTime.unboxToDouble((Object)this.resultVec.apply(n));
                            this.resultVec.update(n, (Object)BoxesRunTime.boxToDouble((double)this.shrink(BoxesRunTime.unboxToDouble((Object)eoc.coefficients().apply(0)))));
                            if (oldCoefficient == BoxesRunTime.unboxToDouble((Object)this.resultVec.apply(n))) continue;
                            improvedResult = true;
                        }
                    }
                    this.result$lzy1 = lassoResult = LassoResult$.MODULE$.apply(this.resultVec, this.computeRsquared(), this.lambda());
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return lassoResult;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.result$lzy1;
    }

    private double shrink(double x) {
        double sb = package$.MODULE$.signum(x);
        double ab = sb * x;
        return ab > this.lambda() ? sb * (ab - this.lambda()) : 0.0;
    }

    private void copyColumn(int column) {
        Predef$.MODULE$.require(column < this.data().cols());
        Predef$.MODULE$.require(column >= 0);
        int yy = this.outputs().size();
        for (int i = 0; i < this.outputs().size(); ++i) {
            int n = i;
            this.singleColumnMatrix.update(n, 0, this.data().apply(n, column));
            double o = BoxesRunTime.unboxToDouble((Object)this.outputs().apply(n));
            int yy2 = this.data().cols();
            for (int i2 = 0; i2 < this.data().cols(); ++i2) {
                int n2 = i2;
                if (n2 == column) continue;
                o -= BoxesRunTime.unboxToDouble((Object)this.data().apply(n, n2)) * BoxesRunTime.unboxToDouble((Object)this.resultVec.apply(n2));
            }
            this.outputCopy.update(n, (Object)BoxesRunTime.boxToDouble((double)o));
        }
    }

    /*
     * WARNING - void declaration
     */
    private double computeRsquared() {
        void var1_1;
        double r2 = 0.0;
        int yy = this.outputs().size();
        for (int i = 0; i < this.outputs().size(); ++i) {
            int n = i;
            double o = BoxesRunTime.unboxToDouble((Object)this.outputs().apply(n));
            int i2 = 0;
            int yy2 = this.data().cols();
            while (i2 < this.data().cols()) {
                int n2 = i2++;
                o -= BoxesRunTime.unboxToDouble((Object)this.data().apply(n, n2)) * BoxesRunTime.unboxToDouble((Object)this.resultVec.apply(n2));
            }
            r2 += o * o;
        }
        return (double)var1_1;
    }

    private LeastSquaresRegressionResult estimateOneColumn(int column) {
        this.copyColumn(column);
        return (LeastSquaresRegressionResult)leastSquaresDestructive$.MODULE$.apply(this.singleColumnMatrix, this.outputCopy, this.workArray(), leastSquaresDestructive$.MODULE$.matrixVectorWithWorkArray());
    }

    public LassoCalculator copy(DenseMatrix<Object> data, DenseVector<Object> outputs, double lambda, double[] workArray, int MAX_ITER, double IMPROVE_THRESHOLD) {
        return new LassoCalculator(data, outputs, lambda, workArray, MAX_ITER, IMPROVE_THRESHOLD);
    }

    public DenseMatrix<Object> copy$default$1() {
        return this.data();
    }

    public DenseVector<Object> copy$default$2() {
        return this.outputs();
    }

    public double copy$default$3() {
        return this.lambda();
    }

    public double[] copy$default$4() {
        return this.workArray();
    }

    public int copy$default$5() {
        return this.MAX_ITER();
    }

    public double copy$default$6() {
        return this.IMPROVE_THRESHOLD();
    }

    public DenseMatrix<Object> _1() {
        return this.data();
    }

    public DenseVector<Object> _2() {
        return this.outputs();
    }

    public double _3() {
        return this.lambda();
    }

    public double[] _4() {
        return this.workArray();
    }

    public int _5() {
        return this.MAX_ITER();
    }

    public double _6() {
        return this.IMPROVE_THRESHOLD();
    }
}

