/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.mcmc;

import breeze.stats.distributions.Process;
import breeze.stats.distributions.RandBasis;
import breeze.stats.mcmc.BaseMetropolisHastings$;
import breeze.stats.mcmc.MetropolisHastings;
import breeze.stats.mcmc.TracksStatistics;
import scala.Function1;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public abstract class BaseMetropolisHastings<T>
implements MetropolisHastings<T>,
Process<T>,
TracksStatistics {
    private final Function1<T, Object> logLikelihoodFunc;
    private final int dropCount;
    private final RandBasis rand;
    private T last;
    private long acceptances;
    private long totalCount;
    private long acceptanceAboveOne;

    public static <T> int $lessinit$greater$default$3() {
        return BaseMetropolisHastings$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> int $lessinit$greater$default$4() {
        return BaseMetropolisHastings$.MODULE$.$lessinit$greater$default$4();
    }

    public BaseMetropolisHastings(Function1<T, Object> logLikelihoodFunc, T init, int burnIn, int dropCount, RandBasis rand) {
        this.logLikelihoodFunc = logLikelihoodFunc;
        this.dropCount = dropCount;
        this.rand = rand;
        this.last = init;
        this.acceptances = 0L;
        this.totalCount = 0L;
        this.acceptanceAboveOne = 0L;
        int i = 0;
        int yy = burnIn;
        while (i < burnIn) {
            int n = i++;
            this.getNext();
        }
    }

    @Override
    public RandBasis rand() {
        return this.rand;
    }

    @Override
    public double logLikelihood(T x) {
        return BoxesRunTime.unboxToDouble((Object)this.logLikelihoodFunc.apply(x));
    }

    @Override
    public long aboveOneCount() {
        return this.acceptanceAboveOne;
    }

    @Override
    public long total() {
        return this.totalCount;
    }

    @Override
    public long acceptanceCount() {
        return this.acceptances;
    }

    private T getNext() {
        T t;
        ++this.totalCount;
        T maybeNext = this.proposalDraw(this.last);
        double logAcceptanceRatio = this.logLikelihoodRatio((Object)this.last, (Object)maybeNext);
        if (logAcceptanceRatio > 0.0) {
            this.last = maybeNext;
            ++this.acceptanceAboveOne;
            t = maybeNext;
        } else if (package$.MODULE$.log(this.nextDouble()) < logAcceptanceRatio) {
            this.last = maybeNext;
            ++this.acceptances;
            t = maybeNext;
        } else {
            t = this.last;
        }
        return t;
    }

    @Override
    public T draw() {
        T t;
        if (this.dropCount == 0) {
            t = this.getNext();
        } else {
            int i = 0;
            int yy = this.dropCount;
            while (i < this.dropCount) {
                int n = i++;
                this.getNext();
            }
            t = this.getNext();
        }
        return t;
    }
}

