/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.LU$primitive$LU_DM_Impl_Double$;
import breeze.linalg.Matrix;
import breeze.linalg.NumericOps;
import breeze.linalg.cholesky$;
import breeze.linalg.cholesky$ImplCholesky_DM$;
import breeze.linalg.det$;
import breeze.linalg.diag$;
import breeze.linalg.inv$;
import breeze.linalg.mpow$;
import breeze.linalg.mpow$implDM_Double_Int$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.sum$;
import breeze.linalg.trace$;
import breeze.numerics.package$multidigamma$;
import breeze.numerics.package$multidigamma$multidigammaImplDoubleInt$;
import breeze.numerics.package$multidigammalog$;
import breeze.numerics.package$multidigammalog$multidigammalogImplDoubleInt$;
import breeze.stats.distributions.ChiSquared$;
import breeze.stats.distributions.ContinuousDistr;
import breeze.stats.distributions.Moments;
import breeze.stats.distributions.RandBasis;
import breeze.stats.distributions.Wishart$;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Wishart
implements ContinuousDistr<DenseMatrix<Object>>,
Moments<DenseMatrix<Object>, DenseMatrix<Object>>,
Product {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(Wishart.class, "0bitmap$1");
    public double normalizer$lzy1;
    public long 0bitmap$1;
    private final double df;
    private final DenseMatrix scale;
    private final RandBasis randBasis;
    private final int dims;
    private final DenseMatrix<Object> invScale;
    private final DenseMatrix<Object> chol;

    public static Wishart unapply(Wishart wishart) {
        return Wishart$.MODULE$.unapply(wishart);
    }

    public Wishart(double df, DenseMatrix<Object> scale, RandBasis randBasis) {
        this.df = df;
        this.scale = scale;
        this.randBasis = randBasis;
        ContinuousDistr.$init$(this);
        this.dims = scale.rows();
        Predef$.MODULE$.require(this.dims == scale.cols(), Wishart::$init$$$anonfun$1);
        Predef$.MODULE$.require(df > (double)(this.dims - 1), Wishart::$init$$$anonfun$2);
        this.invScale = (DenseMatrix)inv$.MODULE$.apply(scale, inv$.MODULE$.canInvUsingLU_Double(LU$primitive$LU_DM_Impl_Double$.MODULE$));
        this.chol = (DenseMatrix)cholesky$.MODULE$.apply(scale, (UFunc.UImpl)cholesky$ImplCholesky_DM$.MODULE$);
    }

    @Override
    public double normalizer() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    double d;
                    this.normalizer$lzy1 = d = ContinuousDistr.normalizer$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return d;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.normalizer$lzy1;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.df()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.scale()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Wishart)) return false;
        Wishart wishart = (Wishart)object;
        if (this.df() != wishart.df()) return false;
        DenseMatrix<Object> denseMatrix = this.scale();
        DenseMatrix<Object> denseMatrix2 = wishart.scale();
        if (denseMatrix == null) {
            if (denseMatrix2 != null) {
                return false;
            }
        } else if (!((Object)denseMatrix).equals(denseMatrix2)) return false;
        if (!wishart.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Wishart;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Wishart";
    }

    public Object productElement(int n) {
        Serializable serializable;
        int n2 = n;
        if (0 == n2) {
            serializable = BoxesRunTime.boxToDouble((double)this._1());
        } else if (1 == n2) {
            serializable = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return serializable;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "df";
        } else if (1 == n2) {
            string = "scale";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public double df() {
        return this.df;
    }

    public DenseMatrix<Object> scale() {
        return this.scale;
    }

    @Override
    public double unnormalizedLogPdf(DenseMatrix<Object> x) {
        return package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)det$.MODULE$.apply(x, det$.MODULE$.canDetUsingLU(LU$primitive$LU_DM_Impl_Double$.MODULE$)))) * 0.5 * (this.df() - (double)this.dims - 1.0) - 0.5 * BoxesRunTime.unboxToDouble((Object)trace$.MODULE$.apply(this.invScale.$times(x, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()), trace$.MODULE$.impl_trace_using_diag_and_sum(diag$.MODULE$.diagDMDVImpl(), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))));
    }

    @Override
    public double logNormalizer() {
        return package$.MODULE$.log(2.0) * (double)this.dims * 0.5 * this.df() + package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)det$.MODULE$.apply(this.scale(), det$.MODULE$.canDetUsingLU(LU$primitive$LU_DM_Impl_Double$.MODULE$)))) * 0.5 * this.df() + BoxesRunTime.unboxToDouble((Object)package$multidigammalog$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(0.5 * this.df())), BoxesRunTime.boxToInteger((int)this.dims), (UFunc.UImpl2)package$multidigammalog$multidigammalogImplDoubleInt$.MODULE$));
    }

    @Override
    public DenseMatrix<Object> mean() {
        return (DenseMatrix)this.scale().$times$colon$times(BoxesRunTime.boxToDouble((double)this.df()), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar());
    }

    @Override
    public DenseMatrix<Object> variance() {
        DenseMatrix t = ((DenseVector)diag$.MODULE$.apply(this.scale(), diag$.MODULE$.diagDMDVImpl())).toDenseMatrix();
        return (DenseMatrix)((ImmutableNumericOps)((NumericOps)mpow$.MODULE$.apply(this.scale(), BoxesRunTime.boxToInteger((int)2), (UFunc.UImpl2)mpow$implDM_Double_Int$.MODULE$)).$plus(t.$times(t.t(HasOps$.MODULE$.canTranspose_DM()), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()), HasOps$.MODULE$.op_DM_DM_Double_OpAdd())).$times$colon$times(BoxesRunTime.boxToDouble((double)this.df()), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar());
    }

    @Override
    public double entropy() {
        double elnx = BoxesRunTime.unboxToDouble((Object)package$multidigamma$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.df() / (double)2)), BoxesRunTime.boxToInteger((int)this.dims), (UFunc.UImpl2)package$multidigamma$multidigammaImplDoubleInt$.MODULE$)) + (double)this.dims * package$.MODULE$.log(2.0) + package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)det$.MODULE$.apply(this.scale(), det$.MODULE$.canDetUsingLU(LU$primitive$LU_DM_Impl_Double$.MODULE$))));
        return -this.logNormalizer() - (this.df() - (double)this.dims - 1.0) / (double)2 * elnx + this.df() * (double)this.dims / (double)2;
    }

    @Override
    public DenseMatrix<Object> mode() {
        Predef$.MODULE$.require(this.df() >= (double)(this.dims + 1));
        return (DenseMatrix)this.scale().$times$colon$times(BoxesRunTime.boxToDouble((double)(this.df() - (double)this.dims - 1.0)), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar());
    }

    @Override
    public DenseMatrix<Object> draw() {
        Matrix a = DenseMatrix$.MODULE$.zeros(this.dims, this.dims, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        int yy = this.dims;
        for (int i = 0; i < this.dims; ++i) {
            int n = i;
            ((DenseMatrix)a).update(n, n, BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(ChiSquared$.MODULE$.apply(this.df() - (double)n, this.randBasis).draw())));
            int i2 = 0;
            int yy2 = n;
            while (i2 < n) {
                int n2 = i2++;
                ((DenseMatrix)a).update(n, n2, this.randBasis.gaussian().draw());
            }
        }
        DenseMatrix sample = (DenseMatrix)this.chol.$times(a, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
        sample = (DenseMatrix)sample.$times(sample.t(HasOps$.MODULE$.canTranspose_DM()), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
        return sample;
    }

    public Wishart copy(double df, DenseMatrix<Object> scale, RandBasis randBasis) {
        return new Wishart(df, scale, randBasis);
    }

    public double copy$default$1() {
        return this.df();
    }

    public DenseMatrix<Object> copy$default$2() {
        return this.scale();
    }

    public double _1() {
        return this.df();
    }

    public DenseMatrix<Object> _2() {
        return this.scale();
    }

    private static final String $init$$$anonfun$1() {
        return "Scale must be a square matrix";
    }

    private static final String $init$$$anonfun$2() {
        return "df must be greater than one less than the dimensionality";
    }
}

