/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.generic.UFunc;
import breeze.numerics.package$expm1$;
import breeze.numerics.package$expm1$expm1DoubleImpl$;
import breeze.numerics.package$log$;
import breeze.numerics.package$log$logDoubleImpl$;
import breeze.numerics.package$log1p$;
import breeze.numerics.package$log1p$log1pDoubleImpl$;
import breeze.numerics.package$round$;
import breeze.numerics.package$round$roundDoubleImpl$;
import breeze.stats.distributions.DiscreteDistr;
import breeze.stats.distributions.Logarthmic$;
import breeze.stats.distributions.Moments;
import breeze.stats.distributions.RandBasis;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class Logarthmic
implements DiscreteDistr<Object>,
Moments<Object, Object>,
Product {
    private final double p;
    private final RandBasis rand;
    private final double h;

    public static Logarthmic unapply(Logarthmic logarthmic) {
        return Logarthmic$.MODULE$.unapply(logarthmic);
    }

    public Logarthmic(double p, RandBasis rand) {
        this.p = p;
        this.rand = rand;
        Predef$.MODULE$.require(p >= 0.0);
        Predef$.MODULE$.require(p <= 1.0);
        this.h = BoxesRunTime.unboxToDouble((Object)package$log1p$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(-p)), (UFunc.UImpl)package$log1p$log1pDoubleImpl$.MODULE$));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.p()));
        return Statics.finalizeHash((int)n, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Logarthmic)) return false;
        Logarthmic logarthmic = (Logarthmic)object;
        if (this.p() != logarthmic.p()) return false;
        if (!logarthmic.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Logarthmic;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Logarthmic";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)this._1());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "p";
    }

    public double p() {
        return this.p;
    }

    @Override
    public int draw() {
        double u1;
        double q;
        double u2 = BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw());
        return u2 > this.p() ? 1 : (u2 < (q = -BoxesRunTime.unboxToDouble((Object)package$expm1$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((u1 = BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw())) * this.h)), (UFunc.UImpl)package$expm1$expm1DoubleImpl$.MODULE$))) * q ? (int)BoxesRunTime.unboxToLong((Object)package$round$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 + BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)u2), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$)) / BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)q), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$)))), (UFunc.UImpl)package$round$roundDoubleImpl$.MODULE$)) : (u2 > q ? 1 : 2));
    }

    @Override
    public double probabilityOf(int x) {
        return -1.0 / BoxesRunTime.unboxToDouble((Object)package$log1p$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(-this.p())), (UFunc.UImpl)package$log1p$log1pDoubleImpl$.MODULE$)) * package$.MODULE$.pow(this.p(), Int$.MODULE$.int2double(x)) / (double)x;
    }

    @Override
    public double mean() {
        return -1.0 / BoxesRunTime.unboxToDouble((Object)package$log1p$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(-this.p())), (UFunc.UImpl)package$log1p$log1pDoubleImpl$.MODULE$)) * (this.p() / (1.0 - this.p()));
    }

    @Override
    public double variance() {
        double l1p = BoxesRunTime.unboxToDouble((Object)package$log1p$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(-this.p())), (UFunc.UImpl)package$log1p$log1pDoubleImpl$.MODULE$));
        double onemp = 1.0 - this.p();
        double denompart = onemp * l1p;
        return -this.p() * (this.p() + l1p) / (denompart * denompart);
    }

    @Override
    public double mode() {
        return 1.0;
    }

    @Override
    public double entropy() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public Logarthmic copy(double p, RandBasis rand) {
        return new Logarthmic(p, rand);
    }

    public double copy$default$1() {
        return this.p();
    }

    public double _1() {
        return this.p();
    }
}

