/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.generic.UFunc;
import breeze.numerics.package$I$;
import breeze.numerics.package$I$iBoolImpl$;
import breeze.optimize.DiffFunction;
import breeze.stats.distributions.Bernoulli$;
import breeze.stats.distributions.Bernoulli$SufficientStatistic$;
import breeze.stats.distributions.Beta$;
import breeze.stats.distributions.Density;
import breeze.stats.distributions.DiscreteDistr;
import breeze.stats.distributions.Moments;
import breeze.stats.distributions.RandBasis;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class Bernoulli
implements DiscreteDistr<Object>,
Moments<Object, Object>,
Product {
    private final double p;
    private final RandBasis rand;

    public static Beta$ conjugateFamily() {
        return Bernoulli$.MODULE$.conjugateFamily();
    }

    public static Bernoulli distribution(double d, RandBasis randBasis) {
        return Bernoulli$.MODULE$.distribution(d, randBasis);
    }

    public static SufficientStatistic emptySufficientStatistic() {
        return Bernoulli$.MODULE$.emptySufficientStatistic();
    }

    public static DiffFunction<Object> likelihoodFunction(SufficientStatistic sufficientStatistic) {
        return Bernoulli$.MODULE$.likelihoodFunction(sufficientStatistic);
    }

    public static double mle(SufficientStatistic sufficientStatistic) {
        return Bernoulli$.MODULE$.mle(sufficientStatistic);
    }

    public static Tuple2<Object, Object> posterior(Tuple2<Object, Object> tuple2, IterableOnce<Object> iterableOnce) {
        return Bernoulli$.MODULE$.posterior(tuple2, iterableOnce);
    }

    public static Density<Object> predictive(Tuple2<Object, Object> tuple2, RandBasis randBasis) {
        return Bernoulli$.MODULE$.predictive(tuple2, randBasis);
    }

    public static SufficientStatistic sufficientStatisticFor(boolean bl) {
        return Bernoulli$.MODULE$.sufficientStatisticFor(bl);
    }

    public static Bernoulli unapply(Bernoulli bernoulli) {
        return Bernoulli$.MODULE$.unapply(bernoulli);
    }

    public Bernoulli(double p, RandBasis rand) {
        this.p = p;
        this.rand = rand;
        Predef$.MODULE$.require(p >= 0.0);
        Predef$.MODULE$.require(p <= 1.0);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.p()));
        return Statics.finalizeHash((int)n, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Bernoulli)) return false;
        Bernoulli bernoulli = (Bernoulli)object;
        if (this.p() != bernoulli.p()) return false;
        if (!bernoulli.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Bernoulli;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Bernoulli";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)this._1());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "p";
    }

    public double p() {
        return this.p;
    }

    @Override
    public double probabilityOf(boolean b) {
        return b ? this.p() : 1.0 - this.p();
    }

    @Override
    public boolean draw() {
        return BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw()) < this.p();
    }

    public String toString() {
        return new StringBuilder(11).append("Bernoulli(").append(this.p()).append(")").toString();
    }

    @Override
    public double mean() {
        return this.p();
    }

    @Override
    public double variance() {
        return this.p() * (1.0 - this.p());
    }

    @Override
    public double mode() {
        return BoxesRunTime.unboxToDouble((Object)package$I$.MODULE$.apply(BoxesRunTime.boxToBoolean((this.p() >= 0.5 ? 1 : 0) != 0), (UFunc.UImpl)package$I$iBoolImpl$.MODULE$));
    }

    @Override
    public double entropy() {
        return -this.p() * package$.MODULE$.log(this.p()) - (1.0 - this.p()) * package$.MODULE$.log1p(-this.p());
    }

    public Bernoulli copy(double p, RandBasis rand) {
        return new Bernoulli(p, rand);
    }

    public double copy$default$1() {
        return this.p();
    }

    public double _1() {
        return this.p();
    }

    public static class SufficientStatistic
    implements breeze.stats.distributions.SufficientStatistic<SufficientStatistic>,
    Product,
    Serializable {
        private final double numYes;
        private final double n;

        public static SufficientStatistic apply(double d, double d2) {
            return Bernoulli$SufficientStatistic$.MODULE$.apply(d, d2);
        }

        public static SufficientStatistic fromProduct(Product product2) {
            return Bernoulli$SufficientStatistic$.MODULE$.fromProduct(product2);
        }

        public static SufficientStatistic unapply(SufficientStatistic sufficientStatistic) {
            return Bernoulli$SufficientStatistic$.MODULE$.unapply(sufficientStatistic);
        }

        public SufficientStatistic(double numYes, double n) {
            this.numYes = numYes;
            this.n = n;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.numYes()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.n()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SufficientStatistic)) return false;
            SufficientStatistic sufficientStatistic = (SufficientStatistic)object;
            if (this.numYes() != sufficientStatistic.numYes()) return false;
            if (this.n() != sufficientStatistic.n()) return false;
            if (!sufficientStatistic.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SufficientStatistic;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SufficientStatistic";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "numYes";
            } else if (1 == n2) {
                string = "n";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public double numYes() {
            return this.numYes;
        }

        public double n() {
            return this.n;
        }

        @Override
        public SufficientStatistic $times(double weight) {
            return Bernoulli$SufficientStatistic$.MODULE$.apply(this.numYes() * weight, this.n() * weight);
        }

        @Override
        public SufficientStatistic $plus(SufficientStatistic t) {
            return Bernoulli$SufficientStatistic$.MODULE$.apply(this.numYes() + t.numYes(), this.n() + t.n());
        }

        public SufficientStatistic copy(double numYes, double n) {
            return new SufficientStatistic(numYes, n);
        }

        public double copy$default$1() {
            return this.numYes();
        }

        public double copy$default$2() {
            return this.n();
        }

        public double _1() {
            return this.numYes();
        }

        public double _2() {
            return this.n();
        }
    }
}

