/*
 * Decompiled with CFR 0.152.
 */
package breeze.signal.support;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.convert$;
import breeze.linalg.diff$;
import breeze.linalg.max$;
import breeze.linalg.min$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.sum$;
import breeze.math.Semiring$;
import breeze.numerics.package$cos$;
import breeze.numerics.package$cos$cosDoubleImpl$;
import breeze.numerics.package$isEven$;
import breeze.numerics.package$isOdd$;
import breeze.numerics.package$sincpi$;
import breeze.numerics.package$sincpi$sincpiDoubleImpl$;
import breeze.signal.OptWindowFunction;
import breeze.signal.OptWindowFunction$Blackman$;
import breeze.signal.OptWindowFunction$Hamming$;
import breeze.signal.OptWindowFunction$Hanning$;
import breeze.signal.OptWindowFunction$None$;
import breeze.signal.OptWindowFunction$User$;
import breeze.signal.support.CanFirwin;
import breeze.signal.support.FIRKernel1D;
import breeze.signal.support.WindowFunctions$;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.Float$;
import scala.Int$;
import scala.Long$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;

public final class CanFirwin$
implements Serializable {
    public static final CanFirwin$ MODULE$ = new CanFirwin$();

    private CanFirwin$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CanFirwin$.class);
    }

    public CanFirwin<Object> firwinDouble() {
        return new CanFirwin<Object>(){

            public FIRKernel1D apply(int taps, DenseVector omegas, double nyquist, boolean zeroPass, boolean scale, double multiplier, OptWindowFunction optWindow) {
                return new FIRKernel1D<T>((DenseVector)CanFirwin$.MODULE$.firwinDoubleImpl(taps, omegas, nyquist, zeroPass, scale, optWindow).$times(BoxesRunTime.boxToDouble((double)multiplier), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), multiplier, new StringBuilder(59).append("FIRKernel1D(firwin): ").append(taps).append(" taps, ").append(omegas).append(", ").append(optWindow).append(", zeroPass=").append(zeroPass).append(", nyquist=").append(nyquist).append(", scale=").append(scale).toString());
            }
        };
    }

    public CanFirwin<Object> firwinT_Int() {
        return new CanFirwin<Object>(){

            public FIRKernel1D apply(int taps, DenseVector omegas, double nyquist, boolean zeroPass, boolean scale, double multiplier, OptWindowFunction optWindow) {
                return new FIRKernel1D<T>((DenseVector)convert$.MODULE$.apply(CanFirwin$.MODULE$.firwinDoubleImpl(taps, omegas, nyquist, zeroPass, scale, optWindow).$times(BoxesRunTime.boxToDouble((double)multiplier), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), Int$.MODULE$, HasOps$.MODULE$.canMapV1DV(DenseVector$.MODULE$.DV_scalarOf(), convert$.MODULE$.impl2_Double_Int(), DenseVector$.MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Integer.TYPE)))), multiplier, new StringBuilder(59).append("FIRKernel1D(firwin): ").append(taps).append(" taps, ").append(omegas).append(", ").append(optWindow).append(", zeroPass=").append(zeroPass).append(", nyquist=").append(nyquist).append(", scale=").append(scale).toString());
            }
        };
    }

    public CanFirwin<Object> firwinT_Long() {
        return new CanFirwin<Object>(){

            public FIRKernel1D apply(int taps, DenseVector omegas, double nyquist, boolean zeroPass, boolean scale, double multiplier, OptWindowFunction optWindow) {
                return new FIRKernel1D<T>((DenseVector)convert$.MODULE$.apply(CanFirwin$.MODULE$.firwinDoubleImpl(taps, omegas, nyquist, zeroPass, scale, optWindow).$times(BoxesRunTime.boxToDouble((double)multiplier), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), Long$.MODULE$, HasOps$.MODULE$.canMapV1DV(DenseVector$.MODULE$.DV_scalarOf(), convert$.MODULE$.impl2_Double_Long(), DenseVector$.MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Long.TYPE)))), multiplier, new StringBuilder(59).append("FIRKernel1D(firwin): ").append(taps).append(" taps, ").append(omegas).append(", ").append(optWindow).append(", zeroPass=").append(zeroPass).append(", nyquist=").append(nyquist).append(", scale=").append(scale).toString());
            }
        };
    }

    public CanFirwin<Object> firwinT_Float() {
        return new CanFirwin<Object>(){

            public FIRKernel1D apply(int taps, DenseVector omegas, double nyquist, boolean zeroPass, boolean scale, double multiplier, OptWindowFunction optWindow) {
                return new FIRKernel1D<T>((DenseVector)convert$.MODULE$.apply(CanFirwin$.MODULE$.firwinDoubleImpl(taps, omegas, nyquist, zeroPass, scale, optWindow).$times(BoxesRunTime.boxToDouble((double)multiplier), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), Float$.MODULE$, HasOps$.MODULE$.canMapV1DV(DenseVector$.MODULE$.DV_scalarOf(), convert$.MODULE$.impl2_Double_Float(), DenseVector$.MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Float.TYPE)))), multiplier, new StringBuilder(59).append("FIRKernel1D(firwin): ").append(taps).append(" taps, ").append(omegas).append(", ").append(optWindow).append(", zeroPass=").append(zeroPass).append(", nyquist=").append(nyquist).append(", scale=").append(scale).toString());
            }
        };
    }

    public DenseVector<Object> firwinDoubleImpl(int taps, DenseVector<Object> omegas, double nyquist, boolean zeroPass, boolean scale, OptWindowFunction optWindow) {
        DenseVector<Object> denseVector;
        Predef$.MODULE$.require(omegas.length() > 0, this::firwinDoubleImpl$$anonfun$1);
        Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)min$.MODULE$.apply(omegas, min$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) >= 0.0, this::firwinDoubleImpl$$anonfun$2);
        Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(omegas, max$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) <= nyquist, this::firwinDoubleImpl$$anonfun$3);
        if (omegas.length() > 1) {
            Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)min$.MODULE$.apply(diff$.MODULE$.apply(omegas, diff$.MODULE$.implDV_DV_Double()), min$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) > 0.0, this::firwinDoubleImpl$$anonfun$4);
        }
        boolean nyquistPass = zeroPass != BoxesRunTime.unboxToBoolean((Object)package$isOdd$.MODULE$.apply(BoxesRunTime.boxToInteger((int)omegas.length()), package$isOdd$.MODULE$.isOddImpl_Int()));
        double[] tempCutoff = (double[])((DenseVector)omegas.$div(BoxesRunTime.boxToDouble((double)nyquist), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpDiv())).toArray(ClassTag$.MODULE$.apply(Double.TYPE));
        if (zeroPass) {
            Object object = Predef$.MODULE$.doubleArrayOps(tempCutoff);
            tempCutoff = (double[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)BoxesRunTime.boxToDouble((double)0.0), ClassTag$.MODULE$.apply(Double.TYPE));
        }
        if (nyquistPass) {
            Object object = Predef$.MODULE$.doubleArrayOps(tempCutoff);
            tempCutoff = (double[])ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)BoxesRunTime.boxToDouble((double)1.0), ClassTag$.MODULE$.apply(Double.TYPE));
        }
        Vector scaledCutoff = DenseVector$.MODULE$.apply(tempCutoff);
        Predef$.MODULE$.require(!nyquistPass || !BoxesRunTime.unboxToBoolean((Object)package$isEven$.MODULE$.apply(BoxesRunTime.boxToInteger((int)taps), package$isEven$.MODULE$.isEvenImpl_Int())), this::firwinDoubleImpl$$anonfun$5);
        double alpha = 0.5 * (double)(taps - 1);
        DenseVector m = (DenseVector)DenseVector$.MODULE$.tabulate(taps, (JFunction1.mcDI.sp & Serializable)i -> i, ClassTag$.MODULE$.apply(Double.TYPE)).$minus(BoxesRunTime.boxToDouble((double)alpha), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpSub());
        Vector h = DenseVector$.MODULE$.zeros(m.length(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        Object object = Predef$.MODULE$.doubleArrayOps((double[])((DenseVector)scaledCutoff).toArray(ClassTag$.MODULE$.apply(Double.TYPE)));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        ArrayOps$.MODULE$.foreach$extension(object2, arg_0 -> this.firwinDoubleImpl$$anonfun$6(m, (DenseVector)h, arg_0));
        OptWindowFunction optWindowFunction = optWindow;
        if (optWindowFunction instanceof OptWindowFunction.Hamming) {
            OptWindowFunction.Hamming hamming = OptWindowFunction$Hamming$.MODULE$.unapply((OptWindowFunction.Hamming)optWindowFunction);
            double d = hamming._1();
            double d2 = hamming._2();
            double alpha2 = d;
            double beta = d2;
            denseVector = WindowFunctions$.MODULE$.hammingWindow(taps, alpha2, beta);
        } else if (optWindowFunction instanceof OptWindowFunction.Hanning) {
            OptWindowFunction.Hanning hanning = OptWindowFunction$Hanning$.MODULE$.unapply((OptWindowFunction.Hanning)optWindowFunction);
            double d = hanning._1();
            double d3 = hanning._2();
            double alpha3 = d;
            double beta = d3;
            denseVector = WindowFunctions$.MODULE$.hammingWindow(taps, alpha3, beta);
        } else if (optWindowFunction instanceof OptWindowFunction.Blackman) {
            OptWindowFunction.Blackman blackman = OptWindowFunction$Blackman$.MODULE$.unapply((OptWindowFunction.Blackman)optWindowFunction);
            double d = blackman._1();
            double d4 = blackman._2();
            double d5 = blackman._3();
            double a0 = d;
            double a1 = d4;
            double a2 = d5;
            denseVector = WindowFunctions$.MODULE$.blackmanWindow(taps, a0, a1, a2);
        } else if (OptWindowFunction$None$.MODULE$.equals(optWindowFunction)) {
            denseVector = DenseVector$.MODULE$.ones(taps, ClassTag$.MODULE$.apply(Double.TYPE), Semiring$.MODULE$.semiringD());
        } else if (optWindowFunction instanceof OptWindowFunction.User) {
            OptWindowFunction.User user = OptWindowFunction$User$.MODULE$.unapply((OptWindowFunction.User)optWindowFunction);
            DenseVector<Object> denseVector2 = user._1();
            DenseVector<Object> dv = denseVector2;
            Predef$.MODULE$.require(dv.length() == taps, this::$anonfun$2);
            denseVector = dv;
        } else {
            throw new MatchError((Object)optWindowFunction);
        }
        DenseVector<Object> win = denseVector;
        ((DenseVector)h).$times$eq(win, HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpMulScalar());
        if (scale) {
            double scaleFrequency = BoxesRunTime.unboxToDouble(((DenseVector)scaledCutoff).apply(0)) == 0.0 ? 0.0 : (BoxesRunTime.unboxToDouble(((DenseVector)scaledCutoff).apply(1)) == 1.0 ? 1.0 : (BoxesRunTime.unboxToDouble(((DenseVector)scaledCutoff).apply(0)) + BoxesRunTime.unboxToDouble(((DenseVector)scaledCutoff).apply(1))) / 2.0);
            DenseVector c = (DenseVector)package$cos$.MODULE$.apply(m.$times$colon$times(BoxesRunTime.boxToDouble((double)(Math.PI * scaleFrequency)), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.DV_scalarOf(), (UFunc.UImpl)package$cos$cosDoubleImpl$.MODULE$, DenseVector$.MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Double.TYPE))));
            double s = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((DenseVector)h).$times$colon$times(c, HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues())));
            ((DenseVector)h).$div$eq(BoxesRunTime.boxToDouble((double)s), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpDiv());
        }
        return h;
    }

    private final String firwinDoubleImpl$$anonfun$1() {
        return "At least one cutoff frequency must be given!";
    }

    private final String firwinDoubleImpl$$anonfun$2() {
        return "The cutoff frequencies must be bigger than zero!";
    }

    private final String firwinDoubleImpl$$anonfun$3() {
        return "The cutoff frequencies must be smaller than the nyquist frequency!";
    }

    private final String firwinDoubleImpl$$anonfun$4() {
        return "The cutoff frequency must be monotonically increasing.";
    }

    private final String firwinDoubleImpl$$anonfun$5() {
        return "A filter with an even number of taps must have zero response at the Nyquist rate.";
    }

    private final /* synthetic */ DenseVector firwinDoubleImpl$$anonfun$6(DenseVector m$1, DenseVector h$1, Tuple2 band) {
        return BoxesRunTime.unboxToBoolean((Object)package$isEven$.MODULE$.apply(band._2(), package$isEven$.MODULE$.isEvenImpl_Int())) ? (DenseVector)h$1.$minus$eq(((ImmutableNumericOps)package$sincpi$.MODULE$.apply(m$1.$times$colon$times(band._1(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.DV_scalarOf(), (UFunc.UImpl)package$sincpi$sincpiDoubleImpl$.MODULE$, DenseVector$.MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Double.TYPE))))).$times$colon$times(band._1(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double()) : (DenseVector)h$1.$plus$eq(((ImmutableNumericOps)package$sincpi$.MODULE$.apply(m$1.$times$colon$times(band._1(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.DV_scalarOf(), (UFunc.UImpl)package$sincpi$sincpiDoubleImpl$.MODULE$, DenseVector$.MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Double.TYPE))))).$times$colon$times(band._1(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
    }

    private final String $anonfun$2() {
        return "Length of specified window function is not the same as taps option!";
    }
}

