/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.NumericOps;
import breeze.linalg.Tensor;
import breeze.linalg.Vector;
import breeze.linalg.max$;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.optimize.DiffFunction;
import breeze.optimize.proximal.ProjectProbabilitySimplex;
import breeze.optimize.proximal.ProjectProbabilitySimplex$;
import breeze.optimize.proximal.Proximal;
import breeze.optimize.proximal.ProximalL1;
import breeze.optimize.proximal.ProximalL1$;
import breeze.optimize.proximal.QuadraticMinimizer$;
import breeze.optimize.proximal.QuadraticMinimizer$Cost$;
import breeze.optimize.proximal.QuadraticMinimizer$State$;
import breeze.storage.Zero$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import dev.ludovic.netlib.lapack.LAPACK;
import java.io.Serializable;
import org.netlib.util.intW;
import scala.Array$;
import scala.Enumeration;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class QuadraticMinimizer
implements SerializableLogging {
    private volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;
    private final int nGram;
    private final Proximal proximal;
    private final DenseMatrix<Object> Aeq;
    private final DenseVector<Object> beq;
    private final double abstol;
    private final double reltol;
    private final double alpha;
    public final QuadraticMinimizer$State$ State$lzy1;
    private final int linearEquality;
    private final int n;
    private final int full;
    private final int upperSize;
    private final DenseMatrix<Object> wsH;
    private final DenseMatrix transAeq;
    private final int admmIters;

    public static QuadraticMinimizer apply(int n, Enumeration.Value value, double d) {
        return QuadraticMinimizer$.MODULE$.apply(n, value, d);
    }

    public static double approximateMaxEigen(DenseMatrix<Object> denseMatrix) {
        return QuadraticMinimizer$.MODULE$.approximateMaxEigen(denseMatrix);
    }

    public static double approximateMinEigen(DenseMatrix<Object> denseMatrix) {
        return QuadraticMinimizer$.MODULE$.approximateMinEigen(denseMatrix);
    }

    public static double computeObjective(DenseMatrix<Object> denseMatrix, DenseVector<Object> denseVector, DenseVector<Object> denseVector2) {
        return QuadraticMinimizer$.MODULE$.computeObjective(denseMatrix, denseVector, denseVector2);
    }

    public static void dgetrs(DenseMatrix<Object> denseMatrix, int[] nArray, DenseVector<Object> denseVector) {
        QuadraticMinimizer$.MODULE$.dgetrs(denseMatrix, nArray, denseVector);
    }

    public static void dpotrs(DenseMatrix<Object> denseMatrix, DenseVector<Object> denseVector) {
        QuadraticMinimizer$.MODULE$.dpotrs(denseMatrix, denseVector);
    }

    public static void gemv(double d, DenseMatrix<Object> denseMatrix, DenseVector<Object> denseVector, double d2, DenseVector<Object> denseVector2) {
        QuadraticMinimizer$.MODULE$.gemv(d, denseMatrix, denseVector, d2, denseVector2);
    }

    public static void main(String[] stringArray) {
        QuadraticMinimizer$.MODULE$.main(stringArray);
    }

    public static double normColumn(DenseMatrix<Object> denseMatrix) {
        return QuadraticMinimizer$.MODULE$.normColumn(denseMatrix);
    }

    public static DenseVector<Object> optimizeWithLBFGS(DenseVector<Object> denseVector, DenseMatrix<Object> denseMatrix, DenseVector<Object> denseVector2) {
        return QuadraticMinimizer$.MODULE$.optimizeWithLBFGS(denseVector, denseMatrix, denseVector2);
    }

    public static Proximal $lessinit$greater$default$2() {
        return QuadraticMinimizer$.MODULE$.$lessinit$greater$default$2();
    }

    public static DenseMatrix<Object> $lessinit$greater$default$3() {
        return QuadraticMinimizer$.MODULE$.$lessinit$greater$default$3();
    }

    public static double apply$default$3() {
        return QuadraticMinimizer$.MODULE$.apply$default$3();
    }

    public static DenseVector<Object> $lessinit$greater$default$4() {
        return QuadraticMinimizer$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$5() {
        return QuadraticMinimizer$.MODULE$.$lessinit$greater$default$5();
    }

    public static double $lessinit$greater$default$6() {
        return QuadraticMinimizer$.MODULE$.$lessinit$greater$default$6();
    }

    public static double $lessinit$greater$default$7() {
        return QuadraticMinimizer$.MODULE$.$lessinit$greater$default$7();
    }

    public static double $lessinit$greater$default$8() {
        return QuadraticMinimizer$.MODULE$.$lessinit$greater$default$8();
    }

    public QuadraticMinimizer(int nGram, Proximal proximal, DenseMatrix<Object> Aeq, DenseVector<Object> beq, int maxIters, double abstol, double reltol, double alpha) {
        this.nGram = nGram;
        this.proximal = proximal;
        this.Aeq = Aeq;
        this.beq = beq;
        this.abstol = abstol;
        this.reltol = reltol;
        this.alpha = alpha;
        this.State$lzy1 = new QuadraticMinimizer$State$(this);
        SerializableLogging.$init$(this);
        int n = this.linearEquality = Aeq != null ? Aeq.rows() : 0;
        if (this.linearEquality() > 0 && beq.length() != this.linearEquality()) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(139).append("QuadraticMinimizer linear equalities should match beq vector").append(": ").append("QuadraticMinimizer.this.beq.length.==(QuadraticMinimizer.this.linearEquality)").toString()})));
        }
        this.n = nGram + this.linearEquality();
        this.full = this.n() * this.n();
        this.upperSize = nGram * (nGram + 1) / 2;
        this.wsH = DenseMatrix$.MODULE$.zeros(this.n(), this.n(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        this.transAeq = this.linearEquality() > 0 ? (DenseMatrix)Aeq.t(HasOps$.MODULE$.canTranspose_DM()) : null;
        this.admmIters = maxIters < 0 ? Math.max(400, 20 * this.n()) : maxIters;
    }

    @Override
    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return this.breeze$util$SerializableLogging$$_the_logger;
    }

    @Override
    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        this.breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    public final QuadraticMinimizer$State$ State() {
        return this.State$lzy1;
    }

    public int linearEquality() {
        return this.linearEquality;
    }

    public int n() {
        return this.n;
    }

    public int full() {
        return this.full;
    }

    public int upperSize() {
        return this.upperSize;
    }

    public DenseMatrix<Object> transAeq() {
        return this.transAeq;
    }

    public int admmIters() {
        return this.admmIters;
    }

    public Proximal getProximal() {
        return this.proximal;
    }

    private void updateQuasiDefinite() {
        if (this.linearEquality() > 0) {
            ((NumericOps)this.wsH.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.nGram), this.nGram + this.Aeq.rows()), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.Aeq.cols()), HasOps$.MODULE$.canSliceColsAndRows())).$colon$eq(this.Aeq, HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
            ((NumericOps)this.wsH.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.nGram), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.nGram), this.nGram + this.Aeq.rows()), HasOps$.MODULE$.canSliceColsAndRows())).$colon$eq(this.transAeq(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
            ((NumericOps)this.wsH.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.nGram), this.nGram + this.Aeq.rows()), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.nGram), this.nGram + this.Aeq.rows()), HasOps$.MODULE$.canSliceColsAndRows())).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.dm_s_UpdateOp_Double_OpSet());
        }
    }

    public void updateGram(DenseMatrix<Object> H) {
        ((NumericOps)this.wsH.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.nGram), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.nGram), HasOps$.MODULE$.canSliceColsAndRows())).$colon$eq(H, HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
        this.updateQuasiDefinite();
    }

    public void updateGram(double[] upper) {
        if (upper.length != this.upperSize()) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(112).append("QuadraticMinimizer:updateGram upper triangular size mismatch").append(": ").append("upper.length.==(QuadraticMinimizer.this.upperSize)").toString()})));
        }
        int pos = 0;
        double h = 0.0;
        for (int i = 0; i < this.nGram; ++i) {
            for (int j = 0; j <= i; ++j) {
                h = upper[pos];
                this.wsH.update(i, j, BoxesRunTime.boxToDouble((double)h));
                this.wsH.update(j, i, BoxesRunTime.boxToDouble((double)h));
                ++pos;
            }
        }
        this.updateQuasiDefinite();
    }

    public State initialize() {
        State state;
        int[] pivot = null;
        if (this.linearEquality() > 0) {
            pivot = (int[])Array$.MODULE$.fill(this.n(), QuadraticMinimizer::initialize$$anonfun$1, ClassTag$.MODULE$.apply(Integer.TYPE));
        }
        Vector x = DenseVector$.MODULE$.zeros(this.nGram, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        Vector z = DenseVector$.MODULE$.zeros(this.nGram, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        Vector u = DenseVector$.MODULE$.zeros(this.nGram, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        Vector scale = DenseVector$.MODULE$.zeros(this.n(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        if (this.proximal == null) {
            state = this.State().apply((DenseVector<Object>)x, (DenseVector<Object>)u, (DenseVector<Object>)z, (DenseVector<Object>)scale, null, pivot, null, null, null, null, 0, false);
        } else {
            Vector xHat = DenseVector$.MODULE$.zeros(this.nGram, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            Vector zOld = DenseVector$.MODULE$.zeros(this.nGram, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            Vector residual = DenseVector$.MODULE$.zeros(this.nGram, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            Vector s = DenseVector$.MODULE$.zeros(this.nGram, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            state = this.State().apply((DenseVector<Object>)x, (DenseVector<Object>)u, (DenseVector<Object>)z, (DenseVector<Object>)scale, null, pivot, (DenseVector<Object>)xHat, (DenseVector<Object>)zOld, (DenseVector<Object>)residual, (DenseVector<Object>)s, 0, false);
        }
        return state;
    }

    private State reset(DenseVector<Object> q, State state) {
        int nlinear = q.length();
        intW info = new intW(0);
        if (this.linearEquality() > 0) {
            int equality = nlinear + this.beq.length();
            if (this.wsH.rows() != equality || this.wsH.cols() != equality) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(161).append("QuadraticMinimizer:reset quasi definite and linear size mismatch").append(": ").append("QuadraticMinimizer.this.wsH.rows.==(equality).&&(QuadraticMinimizer.this.wsH.cols.==(equality))").toString()})));
            }
            LAPACK.getInstance().dgetrf(this.n(), this.n(), (double[])this.wsH.data(), package$.MODULE$.max(1, this.n()), state.pivot(), info);
        } else {
            if (this.wsH.rows() != nlinear || this.wsH.cols() != nlinear) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(153).append("QuadraticMinimizer:reset cholesky and linear size mismatch").append(": ").append("QuadraticMinimizer.this.wsH.rows.==(nlinear).&&(QuadraticMinimizer.this.wsH.cols.==(nlinear))").toString()})));
            }
            LAPACK.getInstance().dpotrf("L", this.n(), (double[])this.wsH.data(), package$.MODULE$.max(1, this.n()), info);
        }
        state.x().$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        state.u().$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        state.z().$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        return this.State().apply(state.x(), state.u(), state.z(), state.scale(), this.wsH, state.pivot(), state.xHat(), state.zOld(), state.residual(), state.s(), 0, false);
    }

    private void updatePrimal(DenseVector<Object> q, DenseVector<Object> x, DenseVector<Object> u, DenseVector<Object> z, DenseVector<Object> scale, double rho, DenseMatrix<Object> R, int[] pivot) {
        int i = 0;
        int yy = z.length();
        while (i < z.length()) {
            int n = i++;
            double entryScale = rho * (BoxesRunTime.unboxToDouble((Object)z.apply(n)) - BoxesRunTime.unboxToDouble((Object)u.apply(n))) - BoxesRunTime.unboxToDouble((Object)q.apply(n));
            scale.update(n, (Object)BoxesRunTime.boxToDouble((double)entryScale));
        }
        if (this.linearEquality() > 0) {
            int i2 = 0;
            int yy2 = this.beq.length();
            while (i2 < this.beq.length()) {
                int n = i2++;
                scale.update(this.nGram + n, this.beq.apply(n));
            }
        }
        if (this.linearEquality() > 0) {
            QuadraticMinimizer$.MODULE$.dgetrs(R, pivot, scale);
        } else {
            QuadraticMinimizer$.MODULE$.dpotrs(R, scale);
        }
        int i3 = 0;
        int yy3 = x.length();
        while (i3 < x.length()) {
            int n = i3++;
            x.update(n, scale.apply(n));
        }
    }

    public State minimizeAndReturnState(DenseVector<Object> q, double rho, State initialState, boolean resetState) {
        int nextIter;
        State startState;
        State state = startState = resetState ? this.reset(q, initialState) : initialState;
        if (this.proximal == null) {
            this.updatePrimal(q, startState.x(), startState.u(), startState.z(), startState.scale(), rho, startState.R(), startState.pivot());
            startState.z().$colon$eq(startState.x(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            return this.State().apply(startState.x(), startState.u(), startState.z(), startState.scale(), startState.R(), startState.pivot(), startState.xHat(), startState.zOld(), startState.residual(), startState.s(), 1, true);
        }
        double convergenceScale = package$.MODULE$.sqrt(Int$.MODULE$.int2double(this.n()));
        for (nextIter = 0; nextIter <= this.admmIters(); ++nextIter) {
            this.updatePrimal(q, startState.x(), startState.u(), startState.z(), startState.scale(), rho, startState.R(), startState.pivot());
            startState.zOld().$colon$eq(startState.z(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            startState.zOld().$times$eq(BoxesRunTime.boxToDouble((double)(1.0 - this.alpha)), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
            startState.xHat().$colon$eq(startState.x(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            startState.xHat().$times$eq(BoxesRunTime.boxToDouble((double)this.alpha), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
            startState.xHat().$plus$eq(startState.zOld(), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
            startState.zOld().$colon$eq(startState.z(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            startState.z().$colon$eq(startState.xHat(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            startState.z().$plus$eq(startState.u(), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
            this.proximal.prox(startState.z(), rho);
            startState.xHat().$minus$eq(startState.z(), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double());
            startState.u().$plus$eq(startState.xHat(), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
            startState.residual().$colon$eq(startState.x(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            startState.residual().$minus$eq(startState.z(), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double());
            double residualNorm = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(startState.residual(), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))));
            startState.s().$colon$eq(startState.z(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            startState.s().$minus$eq(startState.zOld(), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double());
            startState.s().$times$eq(BoxesRunTime.boxToDouble((double)(-rho)), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
            double sNorm = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(startState.s(), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))));
            startState.residual().$colon$eq(startState.z(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            startState.residual().$times$eq(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
            startState.s().$colon$eq(startState.u(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            startState.s().$times$eq(BoxesRunTime.boxToDouble((double)rho), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
            double epsPrimal = convergenceScale * this.abstol + this.reltol * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(norm$.MODULE$.apply(startState.x(), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))), norm$.MODULE$.apply(startState.residual(), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))), max$.MODULE$.maxImpl2_Double()));
            double epsDual = convergenceScale * this.abstol + this.reltol * BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(startState.s(), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))));
            if (!(residualNorm < epsPrimal) || !(sNorm < epsDual)) continue;
            return this.State().apply(startState.x(), startState.u(), startState.z(), startState.scale(), startState.R(), startState.pivot(), startState.xHat(), startState.zOld(), startState.residual(), startState.s(), nextIter, true);
        }
        return this.State().apply(startState.x(), startState.u(), startState.z(), startState.scale(), startState.R(), startState.pivot(), startState.xHat(), startState.zOld(), startState.residual(), startState.s(), nextIter, false);
    }

    public boolean minimizeAndReturnState$default$4() {
        return true;
    }

    private double computeRhoSparse(DenseMatrix<Object> H) {
        double eigenMax = QuadraticMinimizer$.MODULE$.normColumn(H);
        if (this.linearEquality() > 0) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(104).append("QuadraticMinimizer:computeRho L1 with affine not supported").append(": ").append("QuadraticMinimizer.this.linearEquality.<=(0)").toString()})));
        }
        double eigenMin = QuadraticMinimizer$.MODULE$.approximateMinEigen(H);
        return package$.MODULE$.sqrt(eigenMin * eigenMax);
    }

    /*
     * Enabled aggressive block sorting
     */
    private double computeRho(DenseMatrix<Object> H) {
        double d;
        Proximal proximal = this.proximal;
        if (proximal == null) {
            return 0.0;
        }
        if (proximal instanceof ProximalL1) {
            ProximalL1 proximalL1 = ProximalL1$.MODULE$.unapply((ProximalL1)proximal);
            double d2 = proximalL1._1();
            double lambda = d2;
            d = this.computeRhoSparse(H);
            return d;
        }
        if (proximal instanceof ProjectProbabilitySimplex) {
            ProjectProbabilitySimplex projectProbabilitySimplex = ProjectProbabilitySimplex$.MODULE$.unapply((ProjectProbabilitySimplex)proximal);
            double d3 = projectProbabilitySimplex._1();
            double lambda = d3;
            d = this.computeRhoSparse(H);
            return d;
        }
        d = package$.MODULE$.sqrt(QuadraticMinimizer$.MODULE$.normColumn(H));
        return d;
    }

    public State minimizeAndReturnState(DenseVector<Object> q, State initialState) {
        double rho = this.computeRho(this.wsH);
        int i = 0;
        int yy = q.length();
        while (i < q.length()) {
            int n = i++;
            this.wsH.update(n, n, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.wsH.apply(n, n)) + rho)));
        }
        return this.minimizeAndReturnState(q, rho, initialState, this.minimizeAndReturnState$default$4());
    }

    public State minimizeAndReturnState(DenseMatrix<Object> H, DenseVector<Object> q, State initialState) {
        this.updateGram(H);
        return this.minimizeAndReturnState(q, initialState);
    }

    public State minimizeAndReturnState(double[] upper, DenseVector<Object> q, State initialState) {
        this.updateGram(upper);
        return this.minimizeAndReturnState(q, initialState);
    }

    public DenseVector<Object> minimize(DenseVector<Object> q, State initialState) {
        return this.minimizeAndReturnState(q, initialState).z();
    }

    public DenseVector<Object> minimize(DenseMatrix<Object> H, DenseVector<Object> q, State initialState) {
        return this.minimizeAndReturnState(H, q, initialState).z();
    }

    public DenseVector<Object> minimize(double[] upper, DenseVector<Object> q, State initialState) {
        return this.minimizeAndReturnState(upper, q, initialState).z();
    }

    public State minimizeAndReturnState(DenseMatrix<Object> H, DenseVector<Object> q) {
        return this.minimizeAndReturnState(H, q, this.initialize());
    }

    public State minimizeAndReturnState(DenseVector<Object> q) {
        return this.minimizeAndReturnState(q, this.initialize());
    }

    public DenseVector<Object> minimize(DenseMatrix<Object> H, DenseVector<Object> q) {
        return this.minimize(H, q, this.initialize());
    }

    public DenseVector<Object> minimize(DenseVector<Object> q) {
        return this.minimize(q, this.initialize());
    }

    private static final int initialize$$anonfun$1() {
        return 0;
    }

    public static class Cost
    implements DiffFunction<DenseVector<Object>>,
    Product,
    Serializable {
        private final DenseMatrix H;
        private final DenseVector q;

        public static Cost fromProduct(Product product2) {
            return QuadraticMinimizer$Cost$.MODULE$.fromProduct(product2);
        }

        public static Cost unapply(Cost cost) {
            return QuadraticMinimizer$Cost$.MODULE$.unapply(cost);
        }

        public Cost(DenseMatrix<Object> H, DenseVector<Object> q) {
            this.H = H;
            this.q = q;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Cost)) return false;
            Cost cost = (Cost)object;
            DenseMatrix<Object> denseMatrix = this.H();
            DenseMatrix<Object> denseMatrix2 = cost.H();
            if (denseMatrix == null) {
                if (denseMatrix2 != null) {
                    return false;
                }
            } else if (!((Object)denseMatrix).equals(denseMatrix2)) return false;
            DenseVector<Object> denseVector = this.q();
            DenseVector<Object> denseVector2 = cost.q();
            if (denseVector == null) {
                if (denseVector2 != null) {
                    return false;
                }
            } else if (!((Object)denseVector).equals(denseVector2)) return false;
            if (!cost.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Cost;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Cost";
        }

        public Object productElement(int n) {
            Tensor tensor;
            int n2 = n;
            if (0 == n2) {
                tensor = this._1();
            } else if (1 == n2) {
                tensor = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return tensor;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "H";
            } else if (1 == n2) {
                string = "q";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public DenseMatrix<Object> H() {
            return this.H;
        }

        public DenseVector<Object> q() {
            return this.q;
        }

        @Override
        public Tuple2<Object, DenseVector<Object>> calculate(DenseVector<Object> x) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)QuadraticMinimizer$.MODULE$.computeObjective(this.H(), this.q(), x)), ((NumericOps)this.H().$times(x, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$plus(this.q(), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double()));
        }

        public Cost copy(DenseMatrix<Object> H, DenseVector<Object> q) {
            return new Cost(H, q);
        }

        public DenseMatrix<Object> copy$default$1() {
            return this.H();
        }

        public DenseVector<Object> copy$default$2() {
            return this.q();
        }

        public DenseMatrix<Object> _1() {
            return this.H();
        }

        public DenseVector<Object> _2() {
            return this.q();
        }
    }

    public class State
    implements Product,
    Serializable {
        private final DenseVector x;
        private final DenseVector u;
        private final DenseVector z;
        private final DenseVector scale;
        private final DenseMatrix R;
        private final int[] pivot;
        private final DenseVector xHat;
        private final DenseVector zOld;
        private final DenseVector residual;
        private final DenseVector s;
        private final int iter;
        private final boolean converged;
        private final /* synthetic */ QuadraticMinimizer $outer;

        public State(QuadraticMinimizer $outer, DenseVector<Object> x, DenseVector<Object> u, DenseVector<Object> z, DenseVector<Object> scale, DenseMatrix<Object> R, int[] pivot, DenseVector<Object> xHat, DenseVector<Object> zOld, DenseVector<Object> residual, DenseVector<Object> s, int iter, boolean converged) {
            this.x = x;
            this.u = u;
            this.z = z;
            this.scale = scale;
            this.R = R;
            this.pivot = pivot;
            this.xHat = xHat;
            this.zOld = zOld;
            this.residual = residual;
            this.s = s;
            this.iter = iter;
            this.converged = converged;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.x()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.u()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.z()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.scale()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.R()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pivot()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.xHat()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.zOld()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.residual()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.s()));
            n = Statics.mix((int)n, (int)this.iter());
            n = Statics.mix((int)n, (int)(this.converged() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)12);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            if (((State)object).breeze$optimize$proximal$QuadraticMinimizer$State$$$outer() != this.$outer) return false;
            State state = (State)object;
            if (this.iter() != state.iter()) return false;
            if (this.converged() != state.converged()) return false;
            DenseVector<Object> denseVector = this.x();
            DenseVector<Object> denseVector2 = state.x();
            if (denseVector == null) {
                if (denseVector2 != null) {
                    return false;
                }
            } else if (!((Object)denseVector).equals(denseVector2)) return false;
            DenseVector<Object> denseVector3 = this.u();
            DenseVector<Object> denseVector4 = state.u();
            if (denseVector3 == null) {
                if (denseVector4 != null) {
                    return false;
                }
            } else if (!((Object)denseVector3).equals(denseVector4)) return false;
            DenseVector<Object> denseVector5 = this.z();
            DenseVector<Object> denseVector6 = state.z();
            if (denseVector5 == null) {
                if (denseVector6 != null) {
                    return false;
                }
            } else if (!((Object)denseVector5).equals(denseVector6)) return false;
            DenseVector<Object> denseVector7 = this.scale();
            DenseVector<Object> denseVector8 = state.scale();
            if (denseVector7 == null) {
                if (denseVector8 != null) {
                    return false;
                }
            } else if (!((Object)denseVector7).equals(denseVector8)) return false;
            DenseMatrix<Object> denseMatrix = this.R();
            DenseMatrix<Object> denseMatrix2 = state.R();
            if (denseMatrix == null) {
                if (denseMatrix2 != null) {
                    return false;
                }
            } else if (!((Object)denseMatrix).equals(denseMatrix2)) return false;
            if (this.pivot() != state.pivot()) return false;
            DenseVector<Object> denseVector9 = this.xHat();
            DenseVector<Object> denseVector10 = state.xHat();
            if (denseVector9 == null) {
                if (denseVector10 != null) {
                    return false;
                }
            } else if (!((Object)denseVector9).equals(denseVector10)) return false;
            DenseVector<Object> denseVector11 = this.zOld();
            DenseVector<Object> denseVector12 = state.zOld();
            if (denseVector11 == null) {
                if (denseVector12 != null) {
                    return false;
                }
            } else if (!((Object)denseVector11).equals(denseVector12)) return false;
            DenseVector<Object> denseVector13 = this.residual();
            DenseVector<Object> denseVector14 = state.residual();
            if (denseVector13 == null) {
                if (denseVector14 != null) {
                    return false;
                }
            } else if (!((Object)denseVector13).equals(denseVector14)) return false;
            DenseVector<Object> denseVector15 = this.s();
            DenseVector<Object> denseVector16 = state.s();
            if (denseVector15 == null) {
                if (denseVector16 != null) {
                    return false;
                }
            } else if (!((Object)denseVector15).equals(denseVector16)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 12;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    serializable = this._1();
                    break;
                }
                case 1: {
                    serializable = this._2();
                    break;
                }
                case 2: {
                    serializable = this._3();
                    break;
                }
                case 3: {
                    serializable = this._4();
                    break;
                }
                case 4: {
                    serializable = this._5();
                    break;
                }
                case 5: {
                    serializable = (Serializable)this._6();
                    break;
                }
                case 6: {
                    serializable = this._7();
                    break;
                }
                case 7: {
                    serializable = this._8();
                    break;
                }
                case 8: {
                    serializable = this._9();
                    break;
                }
                case 9: {
                    serializable = this._10();
                    break;
                }
                case 10: {
                    serializable = BoxesRunTime.boxToInteger((int)this._11());
                    break;
                }
                case 11: {
                    serializable = BoxesRunTime.boxToBoolean((boolean)this._12());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "x";
                    break;
                }
                case 1: {
                    string = "u";
                    break;
                }
                case 2: {
                    string = "z";
                    break;
                }
                case 3: {
                    string = "scale";
                    break;
                }
                case 4: {
                    string = "R";
                    break;
                }
                case 5: {
                    string = "pivot";
                    break;
                }
                case 6: {
                    string = "xHat";
                    break;
                }
                case 7: {
                    string = "zOld";
                    break;
                }
                case 8: {
                    string = "residual";
                    break;
                }
                case 9: {
                    string = "s";
                    break;
                }
                case 10: {
                    string = "iter";
                    break;
                }
                case 11: {
                    string = "converged";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public DenseVector<Object> x() {
            return this.x;
        }

        public DenseVector<Object> u() {
            return this.u;
        }

        public DenseVector<Object> z() {
            return this.z;
        }

        public DenseVector<Object> scale() {
            return this.scale;
        }

        public DenseMatrix<Object> R() {
            return this.R;
        }

        public int[] pivot() {
            return this.pivot;
        }

        public DenseVector<Object> xHat() {
            return this.xHat;
        }

        public DenseVector<Object> zOld() {
            return this.zOld;
        }

        public DenseVector<Object> residual() {
            return this.residual;
        }

        public DenseVector<Object> s() {
            return this.s;
        }

        public int iter() {
            return this.iter;
        }

        public boolean converged() {
            return this.converged;
        }

        public State copy(DenseVector<Object> x, DenseVector<Object> u, DenseVector<Object> z, DenseVector<Object> scale, DenseMatrix<Object> R, int[] pivot, DenseVector<Object> xHat, DenseVector<Object> zOld, DenseVector<Object> residual, DenseVector<Object> s, int iter, boolean converged) {
            return new State(this.$outer, x, u, z, scale, R, pivot, xHat, zOld, residual, s, iter, converged);
        }

        public DenseVector<Object> copy$default$1() {
            return this.x();
        }

        public DenseVector<Object> copy$default$2() {
            return this.u();
        }

        public DenseVector<Object> copy$default$3() {
            return this.z();
        }

        public DenseVector<Object> copy$default$4() {
            return this.scale();
        }

        public DenseMatrix<Object> copy$default$5() {
            return this.R();
        }

        public int[] copy$default$6() {
            return this.pivot();
        }

        public DenseVector<Object> copy$default$7() {
            return this.xHat();
        }

        public DenseVector<Object> copy$default$8() {
            return this.zOld();
        }

        public DenseVector<Object> copy$default$9() {
            return this.residual();
        }

        public DenseVector<Object> copy$default$10() {
            return this.s();
        }

        public int copy$default$11() {
            return this.iter();
        }

        public boolean copy$default$12() {
            return this.converged();
        }

        public DenseVector<Object> _1() {
            return this.x();
        }

        public DenseVector<Object> _2() {
            return this.u();
        }

        public DenseVector<Object> _3() {
            return this.z();
        }

        public DenseVector<Object> _4() {
            return this.scale();
        }

        public DenseMatrix<Object> _5() {
            return this.R();
        }

        public int[] _6() {
            return this.pivot();
        }

        public DenseVector<Object> _7() {
            return this.xHat();
        }

        public DenseVector<Object> _8() {
            return this.zOld();
        }

        public DenseVector<Object> _9() {
            return this.residual();
        }

        public DenseVector<Object> _10() {
            return this.s();
        }

        public int _11() {
            return this.iter();
        }

        public boolean _12() {
            return this.converged();
        }

        public final /* synthetic */ QuadraticMinimizer breeze$optimize$proximal$QuadraticMinimizer$State$$$outer() {
            return this.$outer;
        }
    }
}

