/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.LapackException;
import breeze.linalg.Matrix;
import breeze.linalg.Vector;
import breeze.linalg.cholesky$;
import breeze.linalg.cholesky$ImplCholesky_DM$;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.math.Semiring;
import breeze.math.Semiring$;
import breeze.numerics.package$;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGS$;
import breeze.optimize.OWLQN;
import breeze.optimize.linear.ConjugateGradient;
import breeze.optimize.linear.ConjugateGradient$;
import breeze.optimize.linear.NNLS;
import breeze.optimize.linear.NNLS$;
import breeze.optimize.linear.PowerMethod;
import breeze.optimize.linear.PowerMethod$;
import breeze.optimize.proximal.Constraint$;
import breeze.optimize.proximal.ProjectBox$;
import breeze.optimize.proximal.ProjectPos$;
import breeze.optimize.proximal.ProjectProbabilitySimplex$;
import breeze.optimize.proximal.Proximal;
import breeze.optimize.proximal.ProximalL1$;
import breeze.optimize.proximal.QpGenerator$;
import breeze.optimize.proximal.QuadraticMinimizer;
import breeze.optimize.proximal.QuadraticMinimizer$Cost$;
import breeze.stats.distributions.Rand;
import breeze.stats.distributions.Rand$;
import breeze.storage.Zero$;
import dev.ludovic.netlib.blas.BLAS;
import dev.ludovic.netlib.lapack.LAPACK;
import java.io.Serializable;
import org.netlib.util.intW;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple6;
import scala.Tuple6$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class QuadraticMinimizer$
implements Serializable {
    public static final QuadraticMinimizer$Cost$ Cost;
    public static final QuadraticMinimizer$ MODULE$;

    private QuadraticMinimizer$() {
    }

    static {
        MODULE$ = new QuadraticMinimizer$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QuadraticMinimizer$.class);
    }

    public Proximal $lessinit$greater$default$2() {
        return null;
    }

    public DenseMatrix<Object> $lessinit$greater$default$3() {
        return null;
    }

    public DenseVector<Object> $lessinit$greater$default$4() {
        return null;
    }

    public int $lessinit$greater$default$5() {
        return -1;
    }

    public double $lessinit$greater$default$6() {
        return 1.0E-6;
    }

    public double $lessinit$greater$default$7() {
        return 1.0E-4;
    }

    public double $lessinit$greater$default$8() {
        return 1.0;
    }

    public void gemv(double alpha, DenseMatrix<Object> A, DenseVector<Object> x, double beta, DenseVector<Object> y) {
        String tStrA = A.isTranspose() ? "T" : "N";
        int mA = !A.isTranspose() ? A.rows() : A.cols();
        int nA = !A.isTranspose() ? A.rows() : A.cols();
        BLAS.getInstance().dgemv(tStrA, mA, nA, alpha, (double[])A.data(), mA, (double[])x.data(), 1, beta, (double[])y.data(), 1);
    }

    public void dgetrs(DenseMatrix<Object> A, int[] pivot, DenseVector<Object> x) {
        int n = x.length();
        if (A.rows() != n) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"A.rows.==(n)"})));
        }
        int nrhs = 1;
        intW info = new intW(0);
        LAPACK.getInstance().dgetrs("No transpose", n, nrhs, (double[])A.data(), 0, n, pivot, 0, (double[])x.data(), 0, n, info);
        if (info.val > 0) {
            throw new LapackException("DGETRS: LU solve unsuccessful");
        }
    }

    public void dpotrs(DenseMatrix<Object> A, DenseVector<Object> x) {
        int n = x.length();
        int nrhs = 1;
        if (A.rows() != n) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"A.rows.==(n)"})));
        }
        intW info = new intW(0);
        LAPACK.getInstance().dpotrs("L", n, nrhs, (double[])A.data(), 0, n, (double[])x.data(), 0, n, info);
        if (info.val > 0) {
            throw new LapackException("DPOTRS : Leading minor of order i of A is not positive definite.");
        }
    }

    public double normColumn(DenseMatrix<Object> H) {
        DoubleRef absColSum = DoubleRef.create((double)0.0);
        DoubleRef maxColSum = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), H.cols()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)c -> {
            double d;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), H.rows()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)r -> {
                double d;
                absColSum$2.elem = d = absColSum$2.elem + scala.math.package$.MODULE$.abs(BoxesRunTime.unboxToDouble(H.apply(r, c)));
            });
            if (absColSum$1.elem > maxColSum$1.elem) {
                double d2;
                maxColSum$1.elem = d2 = absColSum$1.elem;
            }
            absColSum$1.elem = d = 0.0;
        });
        return maxColSum.elem;
    }

    public double approximateMaxEigen(DenseMatrix<Object> H) {
        PowerMethod pm = new PowerMethod(PowerMethod$.MODULE$.$lessinit$greater$default$1(), PowerMethod$.MODULE$.$lessinit$greater$default$2());
        DenseVector init = (DenseVector)DenseVector$.MODULE$.rand(H.rows(), (Rand)Rand$.MODULE$.gaussian(0.0, 1.0), ClassTag$.MODULE$.apply(Double.TYPE));
        return pm.eigen(H, init);
    }

    public double approximateMinEigen(DenseMatrix<Object> H) {
        DenseMatrix R = (DenseMatrix)((ImmutableNumericOps)cholesky$.MODULE$.apply(H, (UFunc.UImpl)cholesky$ImplCholesky_DM$.MODULE$)).t(HasOps$.MODULE$.canTranspose_DM());
        PowerMethod pmInv = PowerMethod$.MODULE$.inverse(PowerMethod$.MODULE$.inverse$default$1(), PowerMethod$.MODULE$.inverse$default$2());
        DenseVector init = (DenseVector)DenseVector$.MODULE$.rand(H.rows(), (Rand)Rand$.MODULE$.gaussian(0.0, 1.0), ClassTag$.MODULE$.apply(Double.TYPE));
        return 1.0 / pmInv.eigen(R, init);
    }

    public QuadraticMinimizer apply(int rank2, Enumeration.Value constraint, double lambda) {
        QuadraticMinimizer quadraticMinimizer;
        Enumeration.Value value = constraint;
        Enumeration.Value value2 = Constraint$.MODULE$.SMOOTH();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            quadraticMinimizer = new QuadraticMinimizer(rank2, this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        } else {
            Enumeration.Value value4 = Constraint$.MODULE$.POSITIVE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                quadraticMinimizer = new QuadraticMinimizer(rank2, ProjectPos$.MODULE$.apply(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
            } else {
                Enumeration.Value value6 = Constraint$.MODULE$.BOX();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    Vector lb = DenseVector$.MODULE$.zeros(rank2, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
                    DenseVector<Object> ub = DenseVector$.MODULE$.ones(rank2, ClassTag$.MODULE$.apply(Double.TYPE), Semiring$.MODULE$.semiringD());
                    quadraticMinimizer = new QuadraticMinimizer(rank2, ProjectBox$.MODULE$.apply((DenseVector<Object>)lb, ub), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
                } else {
                    Enumeration.Value value8 = Constraint$.MODULE$.PROBABILITYSIMPLEX();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        quadraticMinimizer = new QuadraticMinimizer(rank2, ProjectProbabilitySimplex$.MODULE$.apply(lambda), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
                    } else {
                        Enumeration.Value value10 = Constraint$.MODULE$.EQUALITY();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            Matrix Aeq = DenseMatrix$.MODULE$.ones(1, rank2, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero(), (Semiring)Semiring$.MODULE$.semiringD());
                            DenseVector<Object> beq = DenseVector$.MODULE$.ones(1, ClassTag$.MODULE$.apply(Double.TYPE), Semiring$.MODULE$.semiringD());
                            quadraticMinimizer = new QuadraticMinimizer(rank2, ProjectPos$.MODULE$.apply(), (DenseMatrix<Object>)Aeq, beq, this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
                        } else {
                            Enumeration.Value value12 = Constraint$.MODULE$.SPARSE();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                quadraticMinimizer = new QuadraticMinimizer(rank2, ProximalL1$.MODULE$.apply(ProximalL1$.MODULE$.$lessinit$greater$default$1()).setLambda(lambda), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                }
            }
        }
        return quadraticMinimizer;
    }

    public double apply$default$3() {
        return 1.0;
    }

    public double computeObjective(DenseMatrix<Object> h, DenseVector<Object> q, DenseVector<Object> x) {
        double res = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((ImmutableNumericOps)x.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$times(h, HasOps$.MODULE$.impl_OpMulMatrix_DVTt_DMT_eq_DMT((UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()))).$times(x, HasOps$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)HasOps$.MODULE$.canDotD()))) * 0.5 + BoxesRunTime.unboxToDouble((Object)q.dot(x, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
        return res;
    }

    public DenseVector<Object> optimizeWithLBFGS(DenseVector<Object> init, DenseMatrix<Object> H, DenseVector<Object> q) {
        LBFGS<DenseVector<Object>> lbfgs = new LBFGS<DenseVector<Object>>(-1, 7, LBFGS$.MODULE$.$lessinit$greater$default$3(), DenseVector$.MODULE$.space_Double());
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> state = lbfgs.minimizeAndReturnState(QuadraticMinimizer$Cost$.MODULE$.apply(H, q), init);
        return state.x();
    }

    public void main(String[] args) {
        if (args.length < 4) {
            Predef$.MODULE$.println((Object)"Usage: QpSolver n m lambda beta");
            Predef$.MODULE$.println((Object)"Test QpSolver with a simple quadratic function of dimension n and m equalities lambda beta for elasticNet");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        int problemSize = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[0]));
        int nequalities = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[1]));
        double lambda = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(args[2]));
        double beta = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(args[3]));
        Predef$.MODULE$.println((Object)new StringBuilder(48).append("Generating randomized QPs with rank ").append(problemSize).append(" equalities ").append(nequalities).toString());
        Tuple6<DenseMatrix<Object>, DenseVector<Object>, DenseVector<Object>, DenseVector<Object>, DenseVector<Object>, DenseMatrix<Object>> tuple6 = QpGenerator$.MODULE$.apply(problemSize, nequalities);
        if (tuple6 == null) {
            throw new MatchError(tuple6);
        }
        DenseMatrix aeq = (DenseMatrix)tuple6._1();
        DenseVector b = (DenseVector)tuple6._2();
        DenseVector bl = (DenseVector)tuple6._3();
        DenseVector bu = (DenseVector)tuple6._4();
        DenseVector q = (DenseVector)tuple6._5();
        DenseMatrix h = (DenseMatrix)tuple6._6();
        Tuple6 tuple62 = Tuple6$.MODULE$.apply((Object)aeq, (Object)b, (Object)bl, (Object)bu, (Object)q, (Object)h);
        DenseMatrix aeq2 = (DenseMatrix)tuple62._1();
        DenseVector b2 = (DenseVector)tuple62._2();
        DenseVector bl2 = (DenseVector)tuple62._3();
        DenseVector bu2 = (DenseVector)tuple62._4();
        DenseVector q2 = (DenseVector)tuple62._5();
        DenseMatrix h2 = (DenseMatrix)tuple62._6();
        Predef$.MODULE$.println((Object)new StringBuilder(86).append("Test QuadraticMinimizer, CG , BFGS and OWLQN with ").append(problemSize).append(" variables and ").append(nequalities).append(" equality constraints").toString());
        long luStart = System.nanoTime();
        DenseVector luResult = (DenseVector)((ImmutableNumericOps)h2.$bslash(q2, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpSolveMatrixBy_DMD_DVD_eq_DVD())).$times$colon$times(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar());
        long luTime = System.nanoTime() - luStart;
        ConjugateGradient<DenseVector<Object>, DenseMatrix<Object>> cg = new ConjugateGradient<DenseVector<Object>, DenseMatrix<Object>>(ConjugateGradient$.MODULE$.$lessinit$greater$default$1(), ConjugateGradient$.MODULE$.$lessinit$greater$default$2(), ConjugateGradient$.MODULE$.$lessinit$greater$default$3(), ConjugateGradient$.MODULE$.$lessinit$greater$default$4(), DenseVector$.MODULE$.space_Double(), HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD());
        long startCg = System.nanoTime();
        DenseVector<Object> cgResult = cg.minimize((DenseVector<Object>)q2.$times$colon$times(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), h2);
        long cgTime = System.nanoTime() - startCg;
        QuadraticMinimizer qpSolver = new QuadraticMinimizer(problemSize, this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        long qpStart = System.nanoTime();
        DenseVector<Object> result = qpSolver.minimize(h2, q2);
        long qpTime = System.nanoTime() - qpStart;
        long startBFGS = System.nanoTime();
        DenseVector<Object> bfgsResult = this.optimizeWithLBFGS((DenseVector)DenseVector$.MODULE$.rand(problemSize, DenseVector$.MODULE$.rand$default$2(), ClassTag$.MODULE$.apply(Double.TYPE)), h2, q2);
        long bfgsTime = System.nanoTime() - startBFGS;
        Predef$.MODULE$.println((Object)new StringBuilder(27).append("||qp - lu|| norm ").append(norm$.MODULE$.apply(result.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))).append(" max-norm ").append(norm$.MODULE$.apply(result.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToDouble((double)package$.MODULE$.inf()), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(27).append("||cg - lu|| norm ").append(norm$.MODULE$.apply(cgResult.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))).append(" max-norm ").append(norm$.MODULE$.apply(cgResult.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToDouble((double)package$.MODULE$.inf()), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(29).append("||bfgs - lu|| norm ").append(norm$.MODULE$.apply(bfgsResult.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))).append(" max-norm ").append(norm$.MODULE$.apply(bfgsResult.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToDouble((double)package$.MODULE$.inf()), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))).toString());
        double luObj = this.computeObjective(h2, q2, luResult);
        double bfgsObj = this.computeObjective(h2, q2, bfgsResult);
        double qpObj = this.computeObjective(h2, q2, result);
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Objective lu ").append(luObj).append(" bfgs ").append(bfgsObj).append(" qp ").append(qpObj).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(34).append("dim ").append(problemSize).append(" lu ").append((double)luTime / 1000000.0).append(" ms qp ").append((double)qpTime / 1000000.0).append(" ms cg ").append((double)cgTime / 1000000.0).append(" ms bfgs ").append((double)bfgsTime / 1000000.0).append(" ms").toString());
        double lambdaL1 = lambda * beta;
        double lambdaL2 = lambda * (1.0 - beta);
        DenseMatrix regularizedGram = (DenseMatrix)h2.$plus(DenseMatrix$.MODULE$.eye(h2.rows(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero(), Semiring$.MODULE$.semiringD()).$times$colon$times(BoxesRunTime.boxToDouble((double)lambdaL2), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar()), HasOps$.MODULE$.op_DM_DM_Double_OpAdd());
        QuadraticMinimizer sparseQp = this.apply(h2.rows(), Constraint$.MODULE$.SPARSE(), lambdaL1);
        long sparseQpStart = System.nanoTime();
        QuadraticMinimizer.State sparseQpResult = sparseQp.minimizeAndReturnState(regularizedGram, q2);
        long sparseQpTime = System.nanoTime() - sparseQpStart;
        OWLQN<Object, DenseVector<Object>> owlqn = new OWLQN<Object, DenseVector<Object>>(-1, 7, lambdaL1, 1.0E-6, DenseVector$.MODULE$.space_Double());
        DenseVector init = (DenseVector)DenseVector$.MODULE$.rand(problemSize, DenseVector$.MODULE$.rand$default$2(), ClassTag$.MODULE$.apply(Double.TYPE));
        long startOWLQN = System.nanoTime();
        FirstOrderMinimizer.State<Object, Object, Object> owlqnResult = owlqn.minimizeAndReturnState(QuadraticMinimizer$Cost$.MODULE$.apply(regularizedGram, q2), (DenseVector<Object>)((Object)init));
        long owlqnTime = System.nanoTime() - startOWLQN;
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("||owlqn - sparseqp|| norm ").append(norm$.MODULE$.apply(((ImmutableNumericOps)owlqnResult.x()).$minus(sparseQpResult.x(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))).append(" inf-norm ").append(norm$.MODULE$.apply(((ImmutableNumericOps)owlqnResult.x()).$minus(sparseQpResult.x(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToDouble((double)package$.MODULE$.inf()), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("sparseQp ").append((double)sparseQpTime / 1000000.0).append(" ms iters ").append(sparseQpResult.iter()).append(" owlqn ").append((double)owlqnTime / 1000000.0).append(" ms iters ").append(owlqnResult.iter()).toString());
        QuadraticMinimizer posQp = this.apply(h2.rows(), Constraint$.MODULE$.POSITIVE(), 0.0);
        long posQpStart = System.nanoTime();
        QuadraticMinimizer.State posQpResult = posQp.minimizeAndReturnState(h2, q2);
        long posQpTime = System.nanoTime() - posQpStart;
        NNLS nnls = new NNLS(NNLS$.MODULE$.$lessinit$greater$default$1());
        long nnlsStart = System.nanoTime();
        NNLS.State nnlsResult = nnls.minimizeAndReturnState(h2, q2);
        long nnlsTime = System.nanoTime() - nnlsStart;
        Predef$.MODULE$.println((Object)new StringBuilder(32).append("posQp ").append((double)posQpTime / 1000000.0).append(" ms iters ").append(posQpResult.iter()).append(" nnls ").append((double)nnlsTime / 1000000.0).append(" ms iters ").append(nnlsResult.iter()).toString());
        QuadraticMinimizer boundsQp = new QuadraticMinimizer(h2.rows(), ProjectBox$.MODULE$.apply(bl2, bu2), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        long boundsQpStart = System.nanoTime();
        QuadraticMinimizer.State boundsQpResult = boundsQp.minimizeAndReturnState(h2, q2);
        long boundsQpTime = System.nanoTime() - boundsQpStart;
        Predef$.MODULE$.println((Object)new StringBuilder(30).append("boundsQp ").append((double)boundsQpTime / 1000000.0).append(" ms iters ").append(boundsQpResult.iter()).append(" converged ").append(boundsQpResult.converged()).toString());
        QuadraticMinimizer qpEquality = new QuadraticMinimizer(h2.rows(), ProjectPos$.MODULE$.apply(), aeq2, b2, this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        long qpEqualityStart = System.nanoTime();
        QuadraticMinimizer.State qpEqualityResult = qpEquality.minimizeAndReturnState(h2, q2);
        long qpEqualityTime = System.nanoTime() - qpEqualityStart;
        Predef$.MODULE$.println((Object)new StringBuilder(33).append("Qp Equality ").append((double)qpEqualityTime / 1000000.0).append(" ms iters ").append(qpEqualityResult.iter()).append(" converged ").append(qpEqualityResult.converged()).toString());
    }
}

