/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.optimize.proximal.Proximal;
import breeze.optimize.proximal.ProximalHuber$;
import java.io.Serializable;
import scala.Function1;
import scala.Product;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class ProximalHuber
implements Proximal,
Product,
Serializable {
    public static ProximalHuber apply() {
        return ProximalHuber$.MODULE$.apply();
    }

    public static ProximalHuber fromProduct(Product product2) {
        return ProximalHuber$.MODULE$.fromProduct(product2);
    }

    public static boolean unapply(ProximalHuber proximalHuber) {
        return ProximalHuber$.MODULE$.unapply(proximalHuber);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ProximalHuber)) return false;
        ProximalHuber proximalHuber = (ProximalHuber)object;
        boolean bl = proximalHuber.canEqual(this);
        if (!bl) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ProximalHuber;
    }

    public int productArity() {
        return 0;
    }

    public String productPrefix() {
        return "ProximalHuber";
    }

    public Object productElement(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public double proxScalar(double v, double rho, Function1<Object, Object> oracle, double l, double u, double x0) {
        int MAX_ITER = 1000;
        double tol = 1.0E-8;
        double g = 0.0;
        double x = package$.MODULE$.max(l, package$.MODULE$.min(x0, u));
        double lIter = l;
        double uIter = u;
        for (int iter = 0; iter < MAX_ITER && u - l > tol; ++iter) {
            g = (double)-1 / x + rho * (x - v);
            if (g > 0.0) {
                lIter = package$.MODULE$.max(lIter, x - g / rho);
                uIter = x;
            } else if (g < 0.0) {
                lIter = x;
                uIter = package$.MODULE$.min(uIter, x - g / rho);
            }
            x = (lIter + uIter) / (double)2;
        }
        return x;
    }

    public void proxSeparable(DenseVector<Object> x, double rho, Function1<Object, Object> oracle, double l, double u) {
        x.map((Function1)(JFunction1.mcDD.sp & Serializable)_$4 -> this.proxScalar(_$4, rho, oracle, l, u, 0.0), DenseVector$.MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Double.TYPE)));
        int i = 0;
        int yy = x.length();
        while (i < x.length()) {
            int n = i++;
            x.update(n, (Object)BoxesRunTime.boxToDouble((double)this.proxScalar(BoxesRunTime.unboxToDouble((Object)x.apply(n)), rho, oracle, l, u, 0.0)));
        }
    }

    public double subgradHuber(double x) {
        double d;
        if (package$.MODULE$.abs(x) <= 1.0) {
            d = (double)2 * x;
        } else {
            double projx = x > 0.0 ? x : -x;
            d = (double)2 * projx;
        }
        return d;
    }

    @Override
    public void prox(DenseVector<Object> x2, double rho) {
        this.proxSeparable(x2, rho, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x -> this.subgradHuber(x), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public ProximalHuber copy() {
        return new ProximalHuber();
    }
}

