/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.sum$;
import breeze.math.Semiring$;
import breeze.optimize.DiffFunction;
import breeze.optimize.DiffFunction$;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.OWLQN;
import breeze.optimize.ProjectedQuasiNewton;
import breeze.optimize.ProjectedQuasiNewton$;
import breeze.optimize.SpectralProjectedGradient;
import breeze.optimize.SpectralProjectedGradient$;
import breeze.optimize.proximal.Constraint$;
import breeze.optimize.proximal.LinearGenerator$;
import breeze.optimize.proximal.LinearGenerator$Cost$;
import breeze.optimize.proximal.LogisticGenerator$;
import breeze.optimize.proximal.NonlinearMinimizer;
import breeze.optimize.proximal.NonlinearMinimizer$Projection$;
import breeze.optimize.proximal.NonlinearMinimizer$ProximalPrimal$;
import breeze.optimize.proximal.ProjectBox$;
import breeze.optimize.proximal.ProjectHyperPlane$;
import breeze.optimize.proximal.ProjectIdentity$;
import breeze.optimize.proximal.ProjectL1;
import breeze.optimize.proximal.ProjectL1$;
import breeze.optimize.proximal.ProjectPos$;
import breeze.optimize.proximal.ProjectProbabilitySimplex$;
import breeze.optimize.proximal.Proximal;
import breeze.optimize.proximal.ProximalL1;
import breeze.optimize.proximal.ProximalL1$;
import breeze.optimize.proximal.QuadraticMinimizer;
import breeze.optimize.proximal.QuadraticMinimizer$;
import breeze.optimize.proximal.QuadraticMinimizer$Cost$;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction2;

public final class NonlinearMinimizer$
implements Serializable {
    public static final NonlinearMinimizer$ProximalPrimal$ ProximalPrimal;
    public static final NonlinearMinimizer$Projection$ Projection;
    public static final NonlinearMinimizer$ MODULE$;

    private NonlinearMinimizer$() {
    }

    static {
        MODULE$ = new NonlinearMinimizer$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NonlinearMinimizer$.class);
    }

    public int $lessinit$greater$default$2() {
        return -1;
    }

    public int $lessinit$greater$default$3() {
        return 3;
    }

    public int $lessinit$greater$default$4() {
        return 7;
    }

    public double $lessinit$greater$default$5() {
        return 1.0;
    }

    public double $lessinit$greater$default$6() {
        return 1.0;
    }

    public double $lessinit$greater$default$7() {
        return 1.0E-6;
    }

    public double $lessinit$greater$default$8() {
        return 1.0E-4;
    }

    public FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> project(Proximal proximal, int maxIter, int m, double tolerance, boolean usePQN) {
        NonlinearMinimizer.Projection projectionOp = NonlinearMinimizer$Projection$.MODULE$.apply(proximal);
        return usePQN ? new ProjectedQuasiNewton(1.0E-6, m, ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$3(), ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$4(), maxIter, ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$6(), ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$7(), (Function1<DenseVector<Object>, DenseVector<Object>>)(Function1 & Serializable)x -> projectionOp.project((DenseVector<Object>)x), ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$9(), DenseVector$.MODULE$.space_Double()) : new SpectralProjectedGradient((Function1 & Serializable)x -> projectionOp.project((DenseVector<Object>)x), tolerance, SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$3(), SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$4(), SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$5(), SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$6(), m, maxIter, SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$9(), SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$10(), SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$11(), SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$12(), DenseVector$.MODULE$.space_Double());
    }

    public int project$default$2() {
        return -1;
    }

    public int project$default$3() {
        return 10;
    }

    public double project$default$4() {
        return 1.0E-6;
    }

    public boolean project$default$5() {
        return false;
    }

    public FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> apply(int ndim, Enumeration.Value constraint, double lambda, boolean usePQN) {
        FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> firstOrderMinimizer;
        Enumeration.Value value = constraint;
        Enumeration.Value value2 = Constraint$.MODULE$.IDENTITY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            firstOrderMinimizer = this.project(ProjectIdentity$.MODULE$.apply(), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
        } else {
            Enumeration.Value value4 = Constraint$.MODULE$.POSITIVE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                firstOrderMinimizer = this.project(ProjectPos$.MODULE$.apply(), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
            } else {
                Enumeration.Value value6 = Constraint$.MODULE$.BOX();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    Vector lb = DenseVector$.MODULE$.zeros(ndim, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
                    DenseVector<Object> ub = DenseVector$.MODULE$.ones(ndim, ClassTag$.MODULE$.apply(Double.TYPE), Semiring$.MODULE$.semiringD());
                    firstOrderMinimizer = this.project(ProjectBox$.MODULE$.apply((DenseVector<Object>)lb, ub), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
                } else {
                    Enumeration.Value value8 = Constraint$.MODULE$.EQUALITY();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        DenseVector<Object> aeq = DenseVector$.MODULE$.ones(ndim, ClassTag$.MODULE$.apply(Double.TYPE), Semiring$.MODULE$.semiringD());
                        firstOrderMinimizer = this.project(ProjectHyperPlane$.MODULE$.apply(aeq, 1.0), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
                    } else {
                        Enumeration.Value value10 = Constraint$.MODULE$.PROBABILITYSIMPLEX();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            firstOrderMinimizer = this.project(ProjectProbabilitySimplex$.MODULE$.apply(lambda), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
                        } else {
                            Enumeration.Value value12 = Constraint$.MODULE$.SPARSE();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                firstOrderMinimizer = this.project(ProjectL1$.MODULE$.apply(lambda), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
                            } else {
                                throw new IllegalArgumentException("NonlinearMinimizer does not support the Projection Operator");
                            }
                        }
                    }
                }
            }
        }
        return firstOrderMinimizer;
    }

    public boolean apply$default$4() {
        return false;
    }

    public void main(String[] args) {
        if (args.length < 3) {
            Predef$.MODULE$.println((Object)"Usage: ProjectedQuasiNewton n lambda beta");
            Predef$.MODULE$.println((Object)"Test NonlinearMinimizer with a quadratic function of dimenion n and m equalities with lambda beta for elasticNet");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        int problemSize = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[0]));
        double lambda = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(args[1]));
        double beta = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(args[2]));
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("Generating Linear and Logistic Loss with rank ").append(problemSize).toString());
        Tuple3<DiffFunction<DenseVector<Object>>, DenseMatrix<Object>, DenseVector<Object>> tuple3 = LinearGenerator$.MODULE$.apply(problemSize);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        DiffFunction quadraticCost = (DiffFunction)tuple3._1();
        DenseMatrix h = (DenseMatrix)tuple3._2();
        DenseVector q = (DenseVector)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)quadraticCost, (Object)h, (Object)q);
        DiffFunction quadraticCost2 = (DiffFunction)tuple32._1();
        DenseMatrix h2 = (DenseMatrix)tuple32._2();
        DenseVector q2 = (DenseVector)tuple32._3();
        double lambdaL1 = lambda * beta;
        double lambdaL2 = lambda * (1.0 - beta);
        OWLQN<Object, DenseVector<Object>> owlqn = new OWLQN<Object, DenseVector<Object>>(-1, 10, lambdaL1, 1.0E-6, DenseVector$.MODULE$.space_Double());
        DenseMatrix regularizedGram = (DenseMatrix)h2.$plus(DenseMatrix$.MODULE$.eye(h2.rows(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero(), Semiring$.MODULE$.semiringD()).$times$colon$times(BoxesRunTime.boxToDouble((double)lambdaL2), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar()), HasOps$.MODULE$.op_DM_DM_Double_OpAdd());
        QuadraticMinimizer sparseQp = QuadraticMinimizer$.MODULE$.apply(h2.rows(), Constraint$.MODULE$.SPARSE(), lambdaL1);
        long sparseQpStart = System.nanoTime();
        QuadraticMinimizer.State sparseQpResult = sparseQp.minimizeAndReturnState(regularizedGram, q2);
        long sparseQpTime = System.nanoTime() - sparseQpStart;
        Vector init = DenseVector$.MODULE$.zeros(problemSize, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        long owlqnStart = System.nanoTime();
        FirstOrderMinimizer.State<Object, Object, Object> owlqnResult = owlqn.minimizeAndReturnState(LinearGenerator$Cost$.MODULE$.apply(regularizedGram, q2), (DenseVector<Object>)init);
        long owlqnTime = System.nanoTime() - owlqnStart;
        Predef$.MODULE$.println((Object)"ElasticNet Formulation");
        Predef$.MODULE$.println((Object)"Linear Regression");
        double owlqnObj = QuadraticMinimizer$.MODULE$.computeObjective(regularizedGram, q2, (DenseVector)owlqnResult.x()) + lambdaL1 * BoxesRunTime.unboxToDouble((Object)((Vector)owlqnResult.x()).foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDD.sp & Serializable)(agg, entry) -> agg + package$.MODULE$.abs(entry)));
        double sparseQpL1Obj = BoxesRunTime.unboxToDouble((Object)sparseQpResult.x().foldLeft(BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(agg, entry) -> agg + package$.MODULE$.abs(entry)));
        double sparseQpObj = QuadraticMinimizer$.MODULE$.computeObjective(regularizedGram, q2, sparseQpResult.x()) + lambdaL1 * sparseQpL1Obj;
        QuadraticMinimizer.Cost quadraticCostWithL2 = QuadraticMinimizer$Cost$.MODULE$.apply(regularizedGram, q2);
        ((DenseVector)init).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        ProjectL1 projectL1Linear = ProjectL1$.MODULE$.apply(sparseQpL1Obj);
        long nlSparseStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlSparseResult = this.project(projectL1Linear, this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5()).minimizeAndReturnState(quadraticCostWithL2, (DenseVector<Object>)init);
        long nlSparseTime = System.nanoTime() - nlSparseStart;
        double nlSparseL1Obj = BoxesRunTime.unboxToDouble((Object)((Vector)nlSparseResult.x()).foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDD.sp & Serializable)(agg, entry) -> agg + package$.MODULE$.abs(entry)));
        double nlSparseObj = QuadraticMinimizer$.MODULE$.computeObjective(regularizedGram, q2, nlSparseResult.x()) + lambdaL1 * nlSparseL1Obj;
        ((DenseVector)init).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        NonlinearMinimizer nlProx = new NonlinearMinimizer(ProximalL1$.MODULE$.apply(lambdaL1), this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        long nlProxStart = System.nanoTime();
        NonlinearMinimizer.State nlProxResult = nlProx.minimizeAndReturnState(quadraticCostWithL2, (DenseVector<Object>)init);
        long nlProxTime = System.nanoTime() - nlProxStart;
        double nlProxObj = QuadraticMinimizer$.MODULE$.computeObjective(regularizedGram, q2, nlProxResult.z()) + lambdaL1 * BoxesRunTime.unboxToDouble((Object)nlProxResult.z().foldLeft(BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(agg, entry) -> agg + package$.MODULE$.abs(entry)));
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("owlqn ").append((double)owlqnTime / 1000000.0).append(" ms iters ").append(owlqnResult.iter()).append(" sparseQp ").append((double)sparseQpTime / 1000000.0).append(" ms iters ").append(sparseQpResult.iter()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("nlSparseTime ").append((double)nlSparseTime / 1000000.0).append(" ms iters ").append(nlSparseResult.iter()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("nlProxTime ").append((double)nlProxTime / 1000000.0).append(" ms iters ").append(nlProxResult.iter()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("owlqnObj ").append(owlqnObj).append(" sparseQpObj ").append(sparseQpObj).append(" nlSparseObj ").append(nlSparseObj).append(" nlProxObj ").append(nlProxObj).toString());
        DiffFunction<DenseVector<Object>> logisticLoss = LogisticGenerator$.MODULE$.apply(problemSize);
        DiffFunction<DenseVector<Object>> elasticNetLoss = DiffFunction$.MODULE$.withL2Regularization(logisticLoss, lambdaL2, DenseVector$.MODULE$.space_Double());
        Predef$.MODULE$.println((Object)"Linear Regression with Bounds");
        ((DenseVector)init).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> nlBox = this.apply(problemSize, Constraint$.MODULE$.BOX(), 0.0, this.apply$default$4());
        long nlBoxStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlBoxResult = nlBox.minimizeAndReturnState(quadraticCostWithL2, (DenseVector<Object>)init);
        long nlBoxTime = System.nanoTime() - nlBoxStart;
        double nlBoxObj = BoxesRunTime.unboxToDouble((Object)quadraticCostWithL2.calculate(nlBoxResult.x())._1());
        QuadraticMinimizer qpBox = QuadraticMinimizer$.MODULE$.apply(problemSize, Constraint$.MODULE$.BOX(), 0.0);
        long qpBoxStart = System.nanoTime();
        QuadraticMinimizer.State qpBoxResult = qpBox.minimizeAndReturnState(regularizedGram, q2);
        long qpBoxTime = System.nanoTime() - qpBoxStart;
        double qpBoxObj = QuadraticMinimizer$.MODULE$.computeObjective(regularizedGram, q2, qpBoxResult.x());
        Predef$.MODULE$.println((Object)new StringBuilder(16).append("qpBox ").append((double)qpBoxTime / 1000000.0).append(" ms iters ").append(qpBoxResult.iter()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(16).append("nlBox ").append((double)nlBoxTime / 1000000.0).append(" ms iters ").append(nlBoxResult.iter()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("qpBoxObj ").append(qpBoxObj).append(" nlBoxObj ").append(nlBoxObj).toString());
        Predef$.MODULE$.println((Object)"Logistic Regression with Bounds");
        ((DenseVector)init).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        long nlBoxLogisticStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlBoxLogisticResult = nlBox.minimizeAndReturnState(elasticNetLoss, (DenseVector<Object>)init);
        long nlBoxLogisticTime = System.nanoTime() - nlBoxLogisticStart;
        double nlBoxLogisticObj = BoxesRunTime.unboxToDouble((Object)elasticNetLoss.calculate(nlBoxLogisticResult.x())._1());
        Predef$.MODULE$.println((Object)new StringBuilder(22).append("Objective nl ").append(nlBoxLogisticObj).append(" time ").append((double)nlBoxLogisticTime / 1000000.0).append(" ms").toString());
        Predef$.MODULE$.println((Object)"Linear Regression with ProbabilitySimplex");
        FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> nlSimplex = this.apply(problemSize, Constraint$.MODULE$.PROBABILITYSIMPLEX(), 1.0, this.apply$default$4());
        ((DenseVector)init).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        long nlSimplexStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlSimplexResult = nlSimplex.minimizeAndReturnState(quadraticCost2, (DenseVector<Object>)init);
        long nlSimplexTime = System.nanoTime() - nlSimplexStart;
        double nlSimplexObj = BoxesRunTime.unboxToDouble((Object)quadraticCost2.calculate(nlSimplexResult.x())._1());
        long qpSimplexStart = System.nanoTime();
        QuadraticMinimizer.State qpSimplexResult = QuadraticMinimizer$.MODULE$.apply(problemSize, Constraint$.MODULE$.EQUALITY(), QuadraticMinimizer$.MODULE$.apply$default$3()).minimizeAndReturnState(h2, q2);
        long qpSimplexTime = System.nanoTime() - qpSimplexStart;
        double qpSimplexObj = BoxesRunTime.unboxToDouble((Object)quadraticCost2.calculate(qpSimplexResult.x())._1());
        Predef$.MODULE$.println((Object)new StringBuilder(17).append("Objective nl ").append(nlSimplexObj).append(" qp ").append(qpSimplexObj).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Constraint nl ").append(sum$.MODULE$.apply(nlSimplexResult.x(), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))).append(" qp ").append(sum$.MODULE$.apply(qpSimplexResult.x(), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("time nl ").append((double)nlSimplexTime / 1000000.0).append(" ms qp ").append((double)qpSimplexTime / 1000000.0).append(" ms").toString());
        Predef$.MODULE$.println((Object)"Logistic Regression with ProbabilitySimplex");
        ((DenseVector)init).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        long nlLogisticSimplexStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlLogisticSimplexResult = nlSimplex.minimizeAndReturnState(elasticNetLoss, (DenseVector<Object>)init);
        long nlLogisticSimplexTime = System.nanoTime() - nlLogisticSimplexStart;
        double nlLogisticSimplexObj = BoxesRunTime.unboxToDouble((Object)elasticNetLoss.calculate(nlLogisticSimplexResult.x())._1());
        ((DenseVector)init).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        NonlinearMinimizer nlProxSimplex = new NonlinearMinimizer(ProjectProbabilitySimplex$.MODULE$.apply(1.0), this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        long nlProxLogisticSimplexStart = System.nanoTime();
        NonlinearMinimizer.State nlProxLogisticSimplexResult = nlProxSimplex.minimizeAndReturnState(elasticNetLoss, (DenseVector<Object>)init);
        long nlProxLogisticSimplexTime = System.nanoTime() - nlProxLogisticSimplexStart;
        double nlProxLogisticSimplexObj = BoxesRunTime.unboxToDouble((Object)elasticNetLoss.calculate(nlProxLogisticSimplexResult.z())._1());
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("Objective nl ").append(nlLogisticSimplexObj).append(" admm ").append(nlProxLogisticSimplexObj).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(20).append("Constraint nl ").append(sum$.MODULE$.apply(nlLogisticSimplexResult.x(), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))).append(" admm ").append(sum$.MODULE$.apply(nlProxLogisticSimplexResult.z(), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(32).append("time nlProjection ").append((double)nlLogisticSimplexTime / 1000000.0).append(" ms nlProx ").append((double)nlProxLogisticSimplexTime / 1000000.0).append(" ms").toString());
        Predef$.MODULE$.println((Object)"Logistic Regression with ProximalL1 and ProjectL1");
        ((DenseVector)init).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        long owlqnLogisticStart = System.nanoTime();
        FirstOrderMinimizer.State<Object, Object, Object> owlqnLogisticResult = owlqn.minimizeAndReturnState(elasticNetLoss, (DenseVector<Object>)init);
        long owlqnLogisticTime = System.nanoTime() - owlqnLogisticStart;
        double owlqnLogisticObj = BoxesRunTime.unboxToDouble((Object)elasticNetLoss.calculate((DenseVector<Object>)owlqnLogisticResult.x())._1());
        double s = BoxesRunTime.unboxToDouble((Object)((Vector)owlqnLogisticResult.x()).foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDD.sp & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$1), (Object)BoxesRunTime.boxToDouble((double)x$2));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double agg = BoxesRunTime.unboxToDouble((Object)tuple2._1());
            double entry = BoxesRunTime.unboxToDouble((Object)tuple2._2());
            return agg + package$.MODULE$.abs(entry);
        }));
        ((DenseVector)init).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        ProximalL1 proximalL1 = ProximalL1$.MODULE$.apply(ProximalL1$.MODULE$.$lessinit$greater$default$1()).setLambda(lambdaL1);
        long nlLogisticProximalL1Start = System.nanoTime();
        NonlinearMinimizer.State nlLogisticProximalL1Result = new NonlinearMinimizer(proximalL1, this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8()).minimizeAndReturnState(elasticNetLoss, (DenseVector<Object>)init);
        long nlLogisticProximalL1Time = System.nanoTime() - nlLogisticProximalL1Start;
        ((DenseVector)init).$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        long nlLogisticProjectL1Start = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlLogisticProjectL1Result = this.apply(problemSize, Constraint$.MODULE$.SPARSE(), s, this.apply$default$4()).minimizeAndReturnState(elasticNetLoss, (DenseVector<Object>)init);
        long nlLogisticProjectL1Time = System.nanoTime() - nlLogisticProjectL1Start;
        double proximalL1Obj = BoxesRunTime.unboxToDouble((Object)elasticNetLoss.calculate(nlLogisticProximalL1Result.z())._1());
        double projectL1Obj = BoxesRunTime.unboxToDouble((Object)elasticNetLoss.calculate(nlLogisticProjectL1Result.x())._1());
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Objective proximalL1 ").append(proximalL1Obj).append(" projectL1 ").append(projectL1Obj).append(" owlqn ").append(owlqnLogisticObj).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(43).append("time proximalL1 ").append((double)nlLogisticProximalL1Time / 1000000.0).append(" ms projectL1 ").append((double)nlLogisticProjectL1Time / 1000000.0).append(" ms owlqn ").append((double)owlqnLogisticTime / 1000000.0).append(" ms").toString());
    }
}

