/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.linear;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NumericOps;
import breeze.linalg.TensorLike;
import breeze.linalg.Vector;
import breeze.linalg.any$;
import breeze.linalg.diag$;
import breeze.linalg.max$;
import breeze.linalg.operators.HasOps$;
import breeze.math.Ring;
import breeze.math.Ring$;
import breeze.math.Semiring$;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class InteriorPoint$
implements Serializable {
    private static final double TOLERANCE;
    public static final InteriorPoint$ MODULE$;

    private InteriorPoint$() {
    }

    static {
        MODULE$ = new InteriorPoint$();
        TOLERANCE = 1.0E-18;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InteriorPoint$.class);
    }

    public double TOLERANCE() {
        return TOLERANCE;
    }

    public DenseVector<Object> minimize(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x0, double tol) {
        int m = A.rows();
        int n = A.cols();
        Vector x = DenseVector$.MODULE$.zeros(n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        ((DenseVector)x).$plus$eq(x0, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
        if (((TensorLike)((ImmutableNumericOps)A.$times(x0, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$minus(b, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double())).values().exists((JFunction1.mcZD.sp & Serializable)_$1 -> _$1 > 0.0)) {
            ((DenseVector)x).$colon$eq(this.phase1(A, b, c, x0), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
        }
        DenseVector<Object> s = DenseVector$.MODULE$.ones(m, ClassTag$.MODULE$.apply(Double.TYPE), Semiring$.MODULE$.semiringD());
        DenseVector<Object> z = DenseVector$.MODULE$.ones(m, ClassTag$.MODULE$.apply(Double.TYPE), Semiring$.MODULE$.semiringD());
        boolean converged = false;
        double lastGap = Double.POSITIVE_INFINITY;
        while (!converged) {
            try {
                Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> tuple3 = this.computeAffineScalingDir(A, b, c, (DenseVector<Object>)x, s, z);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                DenseVector zAff = (DenseVector)tuple3._1();
                DenseVector xAff = (DenseVector)tuple3._2();
                DenseVector sAff = (DenseVector)tuple3._3();
                Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)zAff, (Object)xAff, (Object)sAff);
                DenseVector zAff2 = (DenseVector)tuple32._1();
                DenseVector xAff2 = (DenseVector)tuple32._2();
                DenseVector sAff2 = (DenseVector)tuple32._3();
                double scaleX = this.lineSearch(s, sAff2);
                double scaleZ = this.lineSearch(z, zAff2);
                double sigma = package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)s.$plus(sAff2.$times(BoxesRunTime.boxToDouble((double)scaleX), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double())).dot(z.$plus(zAff2.$times(BoxesRunTime.boxToDouble((double)scaleZ), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double()), HasOps$.MODULE$.canDotD())) / BoxesRunTime.unboxToDouble((Object)s.dot(z, (UFunc.UImpl2)HasOps$.MODULE$.canDotD())), 3.0);
                Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> tuple33 = this.computeCenteringCorrectorDir(A, b, c, (DenseVector<Object>)x, s, z, sAff2, zAff2, sigma);
                if (tuple33 == null) {
                    throw new MatchError(tuple33);
                }
                DenseVector zCC = (DenseVector)tuple33._1();
                DenseVector xCC = (DenseVector)tuple33._2();
                DenseVector sCC = (DenseVector)tuple33._3();
                Tuple3 tuple34 = Tuple3$.MODULE$.apply((Object)zCC, (Object)xCC, (Object)sCC);
                DenseVector zCC2 = (DenseVector)tuple34._1();
                DenseVector xCC2 = (DenseVector)tuple34._2();
                DenseVector sCC2 = (DenseVector)tuple34._3();
                DenseVector dz = (DenseVector)zAff2.$plus$eq(zCC2, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
                DenseVector dx = (DenseVector)xAff2.$plus$eq(xCC2, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
                DenseVector ds = (DenseVector)sAff2.$plus$eq(sCC2, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
                double scaleXF = this.lineSearch(s, ds);
                double scaleZF = this.lineSearch(z, dz);
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(0.99 * scaleXF)), dx, x, HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(0.99 * scaleXF)), ds, s, HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(0.99 * scaleZF)), dz, z, HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
                double gap = BoxesRunTime.unboxToDouble((Object)c.dot(x, (UFunc.UImpl2)HasOps$.MODULE$.canDotD())) + BoxesRunTime.unboxToDouble((Object)b.dot(z, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
                boolean bl = converged = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(gap)) < tol;
                if (gap > lastGap) {
                    breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(-(0.99 * scaleXF))), dx, x, HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
                }
                lastGap = gap;
            }
            catch (MatrixSingularException m2) {
                converged = true;
            }
        }
        return x;
    }

    public double minimize$default$5() {
        return this.TOLERANCE();
    }

    private DenseVector<Object> phase1(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x0) {
        double s = BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(((ImmutableNumericOps)A.$times(x0, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$minus(b, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), max$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) + 1.0E-7;
        Matrix newA = DenseMatrix$.MODULE$.zeros(A.rows() + 1, A.cols() + 1, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        ((NumericOps)((DenseMatrix)newA).apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), A.rows()), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), A.cols()), HasOps$.MODULE$.canSliceColsAndRows())).$colon$eq(A, HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
        ((NumericOps)((DenseMatrix)newA).apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), A.rows() + 1), BoxesRunTime.boxToInteger((int)A.cols()), HasOps$.MODULE$.canSlicePartOfCol())).$colon$eq(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        DenseVector<Object> newB = DenseVector$.MODULE$.tabulate(b.size() + 1, (JFunction1.mcDI.sp & Serializable)i -> i < b.size() ? BoxesRunTime.unboxToDouble(b.apply(i)) : 0.0, ClassTag$.MODULE$.apply(Double.TYPE));
        Vector newC = DenseVector$.MODULE$.zeros(c.size() + 1, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        ((DenseVector)newC).update(c.size(), BoxesRunTime.boxToDouble((double)1.0));
        DenseVector<Object> newX = DenseVector$.MODULE$.tabulate(x0.size() + 1, (JFunction1.mcDI.sp & Serializable)i -> i < x0.size() ? BoxesRunTime.unboxToDouble(x0.apply(i)) : s, ClassTag$.MODULE$.apply(Double.TYPE));
        if (BoxesRunTime.unboxToBoolean((Object)any$.MODULE$.apply(((NumericOps)((ImmutableNumericOps)((DenseMatrix)newA).$times(newX, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$minus(newB, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double())).$greater$colon$greater(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_DV_S_eq_BV_comparison_Double_OpGT()), (UFunc.UImpl)HasOps$.MODULE$.impl_any_BV_eq_Boolean()))) {
            throw new RuntimeException("Problem seems to be infeasible!");
        }
        DenseVector<Object> r = this.minimize((DenseMatrix<Object>)newA, newB, (DenseVector<Object>)newC, newX, this.minimize$default$5());
        if (BoxesRunTime.unboxToDouble((Object)r.apply(x0.size())) > 1.0E-8) {
            Predef$.MODULE$.println((Object)new StringBuilder(34).append("Problem appears to be infeasible: ").append(r.apply(x0.size())).toString());
        }
        return r.slice(0, x0.size(), r.slice$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private double lineSearch(DenseVector<Object> x, Vector<Object> dx) {
        void var3_3;
        double alpha = 1.0;
        while (((Vector)x.$plus(dx.$times(BoxesRunTime.boxToDouble((double)alpha), HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulMatrix()), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_DV_V_eq_V_Double_OpAdd())).valuesIterator().exists((Function1)(JFunction1.mcZD.sp & Serializable)_$2 -> _$2 < 0.0)) {
            alpha *= 0.8;
        }
        return (double)var3_3;
    }

    private Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> computeAffineScalingDir(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x, DenseVector<Object> s, DenseVector<Object> z) {
        DenseMatrix XiZ = (DenseMatrix)diag$.MODULE$.apply(z.$div$colon$div(s, HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpDiv()), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()));
        DenseMatrix<Object> AtXiZ = ((ImmutableNumericOps)A.t(HasOps$.MODULE$.canTranspose_DM())).$times(XiZ, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
        DenseVector rx = (DenseVector)((ImmutableNumericOps)((NumericOps)A.$times(x, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$plus(s, HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double())).$minus(b, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        DenseVector rz = (DenseVector)((NumericOps)((ImmutableNumericOps)A.t(HasOps$.MODULE$.canTranspose_DM())).$times(z, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$plus(c, HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double());
        DenseMatrix mat = (DenseMatrix)AtXiZ.$times(A, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
        DenseVector dx = (DenseVector)mat.$bslash(((ImmutableNumericOps)((ImmutableNumericOps)((ImmutableNumericOps)A.t(HasOps$.MODULE$.canTranspose_DM())).$times(z, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$minus(rz, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double())).$minus(AtXiZ.$times(rx, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpSolveMatrixBy_DMD_DVD_eq_DVD());
        DenseVector ds = (DenseVector)((ImmutableNumericOps)rx.unary_$minus(HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(DenseVector$.MODULE$.DV_scalarOf(), (Ring)Ring$.MODULE$.ringD(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()))).$minus(A.$times(dx, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        DenseVector dz = (DenseVector)((ImmutableNumericOps)z.unary_$minus(HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(DenseVector$.MODULE$.DV_scalarOf(), (Ring)Ring$.MODULE$.ringD(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()))).$minus(XiZ.$times(ds, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        return Tuple3$.MODULE$.apply((Object)dz, (Object)dx, (Object)ds);
    }

    private Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> computeCenteringCorrectorDir(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x, DenseVector<Object> s, DenseVector<Object> z, DenseVector<Object> dsaff, DenseVector<Object> dzaff, double sigma) {
        int n = A.cols();
        int m = A.rows();
        DenseMatrix<Object> mat = DenseMatrix$.MODULE$.vertcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{DenseMatrix$.MODULE$.zeros(m, m, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()), A, DenseMatrix$.MODULE$.eye(m, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero(), Semiring$.MODULE$.semiringD())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()), DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{(DenseMatrix)A.t(HasOps$.MODULE$.canTranspose_DM()), DenseMatrix$.MODULE$.zeros(n, n + m, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()), DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{(DenseMatrix)diag$.MODULE$.apply(s, diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero())), DenseMatrix$.MODULE$.zeros(m, n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()), (DenseMatrix)diag$.MODULE$.apply(z, diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()))}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero())}), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        ((NumericOps)diag$.MODULE$.apply(mat, diag$.MODULE$.diagDMDVImpl())).$plus$eq(BoxesRunTime.boxToDouble((double)1.0E-20), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpAdd());
        Vector r = DenseVector$.MODULE$.zeros(m + n + m, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        ((DenseVector)r).slice(m + n, m + n + m, ((DenseVector)r).slice$default$3()).$minus$eq(((ImmutableNumericOps)dsaff.$times$colon$times(dzaff, HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpMulScalar())).$minus(BoxesRunTime.boxToDouble((double)(sigma / (double)m * BoxesRunTime.unboxToDouble((Object)s.dot(z, (UFunc.UImpl2)HasOps$.MODULE$.canDotD())))), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpSub()), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double());
        DenseVector sol = (DenseVector)mat.$bslash(r, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpSolveMatrixBy_DMD_DVD_eq_DVD());
        return Tuple3$.MODULE$.apply(sol.slice(0, m, sol.slice$default$3()), sol.slice(m, n + m, sol.slice$default$3()), sol.slice(n + m, n + m + m, sol.slice$default$3()));
    }
}

