/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.optimize.CubicLineSearch;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class StrongWolfeLineSearch
extends CubicLineSearch {
    private final int maxZoomIter;
    private final int maxLineSearchIter;
    private final double c1;
    private final double c2;

    public StrongWolfeLineSearch(int maxZoomIter, int maxLineSearchIter) {
        this.maxZoomIter = maxZoomIter;
        this.maxLineSearchIter = maxLineSearchIter;
        this.c1 = 1.0E-4;
        this.c2 = 0.9;
    }

    public double c1() {
        return this.c1;
    }

    public double c2() {
        return this.c2;
    }

    @Override
    public double minimize(DiffFunction<Object> f, double init) {
        return this.minimizeWithBound(f, init, Double.POSITIVE_INFINITY);
    }

    @Override
    public double minimize$default$2() {
        return 1.0;
    }

    public double minimizeWithBound(DiffFunction<Object> f, double init, double bound) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(init <= bound, StrongWolfeLineSearch::minimizeWithBound$$anonfun$1);
            DoubleRef t = DoubleRef.create((double)init);
            ObjectRef low = ObjectRef.create((Object)this.phi$1(f, 0.0));
            double fval = ((CubicLineSearch.Bracket)low.elem).fval();
            double dd = ((CubicLineSearch.Bracket)low.elem).dd();
            if (dd > 0.0) {
                throw new FirstOrderException(new StringBuilder(48).append("Line search invoked with non-descent direction: ").append(dd).toString());
            }
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxLineSearchIter).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                CubicLineSearch.Bracket c = this.phi$1(f, t$4.elem);
                if (Double.isInfinite(c.fval()) || Double.isNaN(c.fval())) {
                    double d;
                    t$4.elem = d = t$4.elem / 2.0;
                    this.logger().error((Function0<String>)((Function0 & Serializable)() -> StrongWolfeLineSearch.minimizeWithBound$$anonfun$2$$anonfun$1(t)));
                } else {
                    double d;
                    if (c.fval() > fval + this.c1() * t$4.elem * dd || c.fval() >= ((CubicLineSearch.Bracket)low$2.elem).fval() && i > 0) {
                        this.logger().debug((Function0<String>)((Function0 & Serializable)() -> StrongWolfeLineSearch.minimizeWithBound$$anonfun$2$$anonfun$2(t, c)));
                        throw new NonLocalReturnControl(object, (Object)BoxesRunTime.boxToDouble((double)this.zoom$1(f, fval, dd, (CubicLineSearch.Bracket)low$2.elem, c)));
                    }
                    if (package$.MODULE$.abs(c.dd()) <= this.c2() * package$.MODULE$.abs(dd)) {
                        throw new NonLocalReturnControl(object, (Object)BoxesRunTime.boxToDouble((double)c.t()));
                    }
                    if (c.dd() >= 0.0) {
                        this.logger().debug((Function0<String>)((Function0 & Serializable)() -> this.minimizeWithBound$$anonfun$2$$anonfun$3(t, fval, dd, c)));
                        throw new NonLocalReturnControl(object, (Object)BoxesRunTime.boxToDouble((double)this.zoom$1(f, fval, dd, c, (CubicLineSearch.Bracket)low$2.elem)));
                    }
                    CubicLineSearch.Bracket bracket = c;
                    low$2.elem = bracket;
                    bracket = null;
                    if (t$4.elem == bound) {
                        this.logger().debug((Function0<String>)((Function0 & Serializable)StrongWolfeLineSearch::minimizeWithBound$$anonfun$2$$anonfun$4));
                        throw new NonLocalReturnControl(object, (Object)BoxesRunTime.boxToDouble((double)bound));
                    }
                    t$4.elem = d = t$4.elem * 1.5;
                    if (t$4.elem > bound) {
                        double d2;
                        t$4.elem = d2 = bound;
                    }
                    this.logger().debug((Function0<String>)((Function0 & Serializable)() -> StrongWolfeLineSearch.minimizeWithBound$$anonfun$2$$anonfun$5(t)));
                }
            });
            throw new FirstOrderException("Line search failed");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return BoxesRunTime.unboxToDouble((Object)ex.value());
        }
    }

    public double minimizeWithBound$default$2() {
        return 1.0;
    }

    public double minimizeWithBound$default$3() {
        return 1.0;
    }

    private static final String minimizeWithBound$$anonfun$1() {
        return "init value should <= bound";
    }

    private final CubicLineSearch.Bracket phi$1(DiffFunction f$1, double t) {
        Tuple2<Object, Double> tuple2 = f$1.calculate(BoxesRunTime.boxToDouble((double)t));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double pval = BoxesRunTime.unboxToDouble((Object)tuple2._1());
        double pdd = BoxesRunTime.unboxToDouble((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)pval), (Object)BoxesRunTime.boxToDouble((double)pdd));
        double pval2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
        double pdd2 = BoxesRunTime.unboxToDouble((Object)tuple22._2());
        return this.Bracket().apply(t, pdd2, pval2);
    }

    private final String zoom$1$$anonfun$1$$anonfun$1(double fval$2, double dd$2, double t$3, CubicLineSearch.Bracket c$1) {
        return new StringBuilder(34).append("Line search t: ").append(t$3).append(" fval: ").append(c$1.fval()).append(" rhs: ").append(fval$2 + this.c1() * c$1.t() * dd$2).append(" cdd: ").append(c$1.dd()).toString();
    }

    private static final String zoom$1$$anonfun$1$$anonfun$2() {
        return "hi=c";
    }

    private static final String zoom$1$$anonfun$1$$anonfun$3() {
        return "flipping";
    }

    private static final String zoom$1$$anonfun$1$$anonfun$4() {
        return "low=c";
    }

    private final double zoom$1(DiffFunction f$3, double fval$3, double dd$3, CubicLineSearch.Bracket linit, CubicLineSearch.Bracket rinit) {
        Object object = new Object();
        try {
            ObjectRef low = ObjectRef.create((Object)linit);
            ObjectRef hi = ObjectRef.create((Object)rinit);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxZoomIter).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                double t = ((CubicLineSearch.Bracket)low$1.elem).t() > ((CubicLineSearch.Bracket)hi$1.elem).t() ? this.interp((CubicLineSearch.Bracket)hi$1.elem, (CubicLineSearch.Bracket)low$1.elem) : this.interp((CubicLineSearch.Bracket)low$1.elem, (CubicLineSearch.Bracket)hi$1.elem);
                CubicLineSearch.Bracket c = this.phi$1(f$3, t);
                this.logger().info((Function0<String>)((Function0 & Serializable)() -> this.zoom$1$$anonfun$1$$anonfun$1(fval$3, dd$3, t, c)));
                if (Predef$.MODULE$.double2Double(t).isNaN()) {
                    throw new FirstOrderException("Line search zoom failed");
                }
                if (c.fval() > fval$3 + this.c1() * c.t() * dd$3 || c.fval() >= ((CubicLineSearch.Bracket)low$1.elem).fval()) {
                    CubicLineSearch.Bracket bracket = c;
                    hi$1.elem = bracket;
                    bracket = null;
                    this.logger().debug((Function0<String>)((Function0 & Serializable)StrongWolfeLineSearch::zoom$1$$anonfun$1$$anonfun$2));
                } else {
                    if (package$.MODULE$.abs(c.dd()) <= this.c2() * package$.MODULE$.abs(dd$3)) {
                        throw new NonLocalReturnControl(object, (Object)BoxesRunTime.boxToDouble((double)c.t()));
                    }
                    if (c.dd() * (((CubicLineSearch.Bracket)hi$1.elem).t() - ((CubicLineSearch.Bracket)low$1.elem).t()) >= 0.0) {
                        this.logger().debug((Function0<String>)((Function0 & Serializable)StrongWolfeLineSearch::zoom$1$$anonfun$1$$anonfun$3));
                        CubicLineSearch.Bracket bracket = (CubicLineSearch.Bracket)low$1.elem;
                        hi$1.elem = bracket;
                        bracket = null;
                    }
                    this.logger().debug((Function0<String>)((Function0 & Serializable)StrongWolfeLineSearch::zoom$1$$anonfun$1$$anonfun$4));
                    CubicLineSearch.Bracket bracket = c;
                    low$1.elem = bracket;
                    bracket = null;
                }
            });
            throw new FirstOrderException("Line search zoom failed");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return BoxesRunTime.unboxToDouble((Object)ex.value());
        }
    }

    private static final String minimizeWithBound$$anonfun$2$$anonfun$1(DoubleRef t$5) {
        return new StringBuilder(71).append("Encountered bad values in function evaluation. Decreasing step size to ").append(t$5.elem).toString();
    }

    private static final String minimizeWithBound$$anonfun$2$$anonfun$2(DoubleRef t$6, CubicLineSearch.Bracket c$2) {
        return new StringBuilder(28).append("Line search t: ").append(t$6.elem).append(" fval: ").append(c$2.fval()).append(" cdd: ").append(c$2.dd()).toString();
    }

    private final String minimizeWithBound$$anonfun$2$$anonfun$3(DoubleRef t$7, double fval$5, double dd$5, CubicLineSearch.Bracket c$3) {
        return new StringBuilder(34).append("Line search t: ").append(t$7.elem).append(" fval: ").append(c$3.fval()).append(" rhs: ").append(fval$5 + this.c1() * t$7.elem * dd$5).append(" cdd: ").append(c$3.dd()).toString();
    }

    private static final String minimizeWithBound$$anonfun$2$$anonfun$4() {
        return "Reach bound, satisfy sufficent decrease condition, but not curvature condition satisfied.";
    }

    private static final String minimizeWithBound$$anonfun$2$$anonfun$5(DoubleRef t$8) {
        return new StringBuilder(84).append("Sufficent Decrease condition but not curvature condition satisfied. Increased t to: ").append(t$8.elem).toString();
    }
}

