/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.norm$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.numerics.package$I$;
import breeze.numerics.package$I$iBoolImpl$;
import breeze.optimize.BacktrackingLineSearch;
import breeze.optimize.BacktrackingLineSearch$;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.FirstOrderMinimizer$;
import breeze.optimize.LBFGS;
import breeze.optimize.OWLQN$;
import java.io.Serializable;
import scala.Conversion;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction2;

public class OWLQN<K, T>
extends LBFGS<T> {
    private final Function1<K, Object> l1reg;
    public final MutableEnumeratedCoordinateField<T, K, Object> breeze$optimize$OWLQN$$space;

    public static <K, T> double $lessinit$greater$default$4() {
        return OWLQN$.MODULE$.$lessinit$greater$default$4();
    }

    public OWLQN(FirstOrderMinimizer.ConvergenceCheck<T> convergenceCheck, int m, Function1<K, Object> l1reg, MutableEnumeratedCoordinateField<T, K, Object> space) {
        this.l1reg = l1reg;
        this.breeze$optimize$OWLQN$$space = space;
        super(convergenceCheck, m, space);
        Predef$.MODULE$.require(m > 0);
    }

    public OWLQN(int maxIter, int m, Function1<K, Object> l1reg, double tolerance, MutableEnumeratedCoordinateField<T, K, Object> space) {
        this(FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck(maxIter, tolerance, FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck$default$3(), FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck$default$4(), space), m, l1reg, space);
    }

    public OWLQN(int maxIter, int m, Function1<K, Object> l1reg, MutableEnumeratedCoordinateField<T, K, Object> space) {
        this(maxIter, m, l1reg, 1.0E-8, space);
    }

    public OWLQN(int maxIter, int m, double l1reg, double tolerance, MutableEnumeratedCoordinateField<T, K, Object> space) {
        this(maxIter, m, OWLQN.OWLQN$superArg$1(maxIter, m, l1reg, tolerance, space), tolerance, space);
    }

    public OWLQN(int maxIter, int m, double l1reg, MutableEnumeratedCoordinateField<T, K, Object> space) {
        this(maxIter, m, OWLQN.OWLQN$superArg$2(maxIter, m, l1reg, space), 1.0E-8, space);
    }

    public OWLQN(int maxIter, int m, MutableEnumeratedCoordinateField<T, K, Object> space) {
        this(maxIter, m, OWLQN.OWLQN$superArg$3(maxIter, m, space), 1.0E-8, space);
    }

    @Override
    public T chooseDescentDirection(FirstOrderMinimizer.State<T, Object, LBFGS.ApproximateInverseHessian<T>> state, DiffFunction<T> fn) {
        T descentDir = super.chooseDescentDirection(state.copy(state.copy$default$1(), state.copy$default$2(), state.adjustedGradient(), state.copy$default$4(), state.copy$default$5(), state.copy$default$6(), state.copy$default$7(), state.copy$default$8(), state.copy$default$9(), state.copy$default$10(), state.copy$default$11()), fn);
        Object correctedDir = this.breeze$optimize$OWLQN$$space.zipMapValues().map(descentDir, state.adjustedGradient(), (JFunction2.mcDDD.sp & Serializable)(x$1, x$2) -> {
            double g;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$1), (Object)BoxesRunTime.boxToDouble((double)x$2));
            if (tuple2 != null) {
            } else {
                throw new MatchError((Object)tuple2);
            }
            double d = BoxesRunTime.unboxToDouble((Object)tuple2._1());
            return d * (g = BoxesRunTime.unboxToDouble((Object)tuple2._2())) < 0.0 ? d : 0.0;
        });
        return (T)correctedDir;
    }

    @Override
    public double determineStepSize(FirstOrderMinimizer.State<T, Object, LBFGS.ApproximateInverseHessian<T>> state, DiffFunction<T> f, T dir) {
        double possibleNorm;
        int iter = state.iter();
        double normGradInDir = possibleNorm = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.breeze$optimize$OWLQN$$space.hasOps()).apply(dir)).dot(state.grad(), this.breeze$optimize$OWLQN$$space.dotVV()));
        DiffFunction<Object> ff = new DiffFunction<Object>(state, f, dir, this){
            private final FirstOrderMinimizer.State state$1;
            private final DiffFunction f$1;
            private final Object dir$1;
            private final /* synthetic */ OWLQN $outer;
            {
                this.state$1 = state$2;
                this.f$1 = f$2;
                this.dir$1 = dir$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Tuple2 calculate(double alpha) {
                Object newX = this.$outer.takeStep(this.state$1, this.dir$1, alpha);
                Tuple2<Object, Object> tuple2 = this.f$1.calculate(newX);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                Object newG = tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)v), newG);
                double v2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
                Object newG2 = tuple22._2();
                Tuple2<Object, Object> tuple23 = this.$outer.adjust(newX, newG2, v2);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                double adjv = BoxesRunTime.unboxToDouble((Object)tuple23._1());
                Object adjgrad = tuple23._2();
                Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)adjv), adjgrad);
                double adjv2 = BoxesRunTime.unboxToDouble((Object)tuple24._1());
                Object adjgrad2 = tuple24._2();
                Double d = (Double)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)adjv2));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)d, ((ImmutableNumericOps)((Conversion)this.$outer.breeze$optimize$OWLQN$$space.hasOps()).apply(adjgrad2)).dot(this.dir$1, this.$outer.breeze$optimize$OWLQN$$space.dotVV()));
            }
        };
        double d = iter < 1 ? 0.1 : 0.5;
        int n = BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$2();
        double d2 = BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$4();
        double d3 = BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$5();
        double d4 = BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$6();
        double d5 = BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$7();
        double d6 = BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$8();
        boolean bl = BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$9();
        boolean bl2 = BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$10();
        BacktrackingLineSearch search = new BacktrackingLineSearch(state.value(), n, d, d2, d3, d4, d5, d6, bl, bl2);
        double alpha = search.minimize((DiffFunction)ff, iter < 1 ? 0.5 / BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(state.grad(), this.breeze$optimize$OWLQN$$space.normImpl())) : 1.0);
        return alpha;
    }

    @Override
    public T takeStep(FirstOrderMinimizer.State<T, Object, LBFGS.ApproximateInverseHessian<T>> state, T dir, double stepSize) {
        Object stepped = ((NumericOps)((Conversion)this.breeze$optimize$OWLQN$$space.hasOps()).apply(state.x())).$plus(((ImmutableNumericOps)((Conversion)this.breeze$optimize$OWLQN$$space.hasOps()).apply(dir)).$times(BoxesRunTime.boxToDouble((double)stepSize), this.breeze$optimize$OWLQN$$space.mulVS_M()), this.breeze$optimize$OWLQN$$space.addVV());
        T orthant = this.computeOrthant(state.x(), state.adjustedGradient());
        return (T)this.breeze$optimize$OWLQN$$space.zipMapValues().map(stepped, orthant, (JFunction2.mcDDD.sp & Serializable)(x$1, x$2) -> {
            double ov;
            double v;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$1), (Object)BoxesRunTime.boxToDouble((double)x$2));
            if (tuple2 != null) {
                v = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                ov = BoxesRunTime.unboxToDouble((Object)tuple2._2());
            } else {
                throw new MatchError((Object)tuple2);
            }
            return v * BoxesRunTime.unboxToDouble((Object)package$I$.MODULE$.apply(BoxesRunTime.boxToBoolean((package$.MODULE$.signum(v) == package$.MODULE$.signum(ov) ? 1 : 0) != 0), (UFunc.UImpl)package$I$iBoolImpl$.MODULE$));
        });
    }

    @Override
    public Tuple2<Object, T> adjust(T newX, T newGrad, double newVal) {
        DoubleRef adjValue = DoubleRef.create((double)newVal);
        Object res = this.breeze$optimize$OWLQN$$space.zipMapKeyValues().mapActive(newX, newGrad, (Function3 & Serializable)(x$1, x$2, x$3) -> this.$anonfun$2(adjValue, x$1, BoxesRunTime.unboxToDouble((Object)x$2), BoxesRunTime.unboxToDouble((Object)x$3)));
        Double d = (Double)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)adjValue.elem));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)d, res);
    }

    /*
     * WARNING - void declaration
     */
    private T computeOrthant(T x, T grad) {
        void var3_3;
        Object orth = this.breeze$optimize$OWLQN$$space.zipMapValues().map(x, grad, (JFunction2.mcDDD.sp & Serializable)(x$1, x$2) -> {
            double gv;
            double v;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$1), (Object)BoxesRunTime.boxToDouble((double)x$2));
            if (tuple2 != null) {
                v = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                gv = BoxesRunTime.unboxToDouble((Object)tuple2._2());
            } else {
                throw new MatchError((Object)tuple2);
            }
            return v != 0.0 ? package$.MODULE$.signum(v) : package$.MODULE$.signum(-gv);
        });
        return var3_3;
    }

    private static <K, T> Function1<K, Object> OWLQN$superArg$1(int maxIter, int m, double l1reg, double tolerance, MutableEnumeratedCoordinateField<T, K, Object> space) {
        return (Function1 & Serializable)_$1 -> l1reg;
    }

    private static <K, T> Function1<K, Object> OWLQN$superArg$2(int maxIter, int m, double l1reg, MutableEnumeratedCoordinateField<T, K, Object> space) {
        return (Function1 & Serializable)_$2 -> l1reg;
    }

    private static <K, T> Function1<K, Object> OWLQN$superArg$3(int maxIter, int m, MutableEnumeratedCoordinateField<T, K, Object> space) {
        return (Function1 & Serializable)_$3 -> 1.0;
    }

    private final /* synthetic */ double $anonfun$2(DoubleRef adjValue$1, Object x$1, double x$2, double x$3) {
        double d;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$1, (Object)BoxesRunTime.boxToDouble((double)x$2), (Object)BoxesRunTime.boxToDouble((double)x$3));
        if (tuple3 != null) {
            Object i = tuple3._1();
            double xv = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            double l1regValue = BoxesRunTime.unboxToDouble((Object)this.l1reg.apply(i));
            Predef$.MODULE$.require(l1regValue >= 0.0);
            if (l1regValue == 0.0) {
                d = v;
            } else {
                double d2;
                adjValue$1.elem = d2 = adjValue$1.elem + Math.abs(l1regValue * xv);
                double d3 = xv;
                if (0.0 == d3) {
                    double delta_$plus = v + l1regValue;
                    double delta_$minus = v - l1regValue;
                    d = delta_$minus > 0.0 ? delta_$minus : (delta_$plus < 0.0 ? delta_$plus : 0.0);
                } else {
                    d = v + package$.MODULE$.signum(xv) * l1regValue;
                }
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        return d;
    }
}

