/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.math.MutableFiniteCoordinateField;
import breeze.numerics.package$signum$;
import breeze.numerics.package$signum$signumDoubleImpl$;
import breeze.numerics.package$sqrt$;
import breeze.numerics.package$sqrt$sqrtDoubleImpl$;
import breeze.optimize.AdaptiveGradientDescent$L1Regularization$;
import breeze.optimize.AdaptiveGradientDescent$L1Regularization$History$;
import breeze.optimize.AdaptiveGradientDescent$L2Regularization$;
import breeze.optimize.AdaptiveGradientDescent$L2Regularization$History$;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.StochasticDiffFunction;
import breeze.optimize.StochasticGradientDescent;
import breeze.optimize.StochasticGradientDescent$;
import breeze.stats.distributions.RandBasis;
import java.io.Serializable;
import scala.Conversion;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;

public final class AdaptiveGradientDescent {

    public static class L1Regularization<T>
    extends StochasticGradientDescent<T> {
        private final double lambda;
        private final double delta;
        private final MutableFiniteCoordinateField<T, ?, Object> space;
        public final AdaptiveGradientDescent$L1Regularization$History$ History$lzy2;

        public static <T> double $lessinit$greater$default$1() {
            return AdaptiveGradientDescent$L1Regularization$.MODULE$.$lessinit$greater$default$1();
        }

        public static <T> double $lessinit$greater$default$2() {
            return AdaptiveGradientDescent$L1Regularization$.MODULE$.$lessinit$greater$default$2();
        }

        public static <T> double $lessinit$greater$default$3() {
            return AdaptiveGradientDescent$L1Regularization$.MODULE$.$lessinit$greater$default$3();
        }

        public static <T> int $lessinit$greater$default$4() {
            return AdaptiveGradientDescent$L1Regularization$.MODULE$.$lessinit$greater$default$4();
        }

        public L1Regularization(double lambda, double delta, double eta, int maxIter, MutableFiniteCoordinateField<T, ?, Object> space, RandBasis rand) {
            this.lambda = lambda;
            this.delta = delta;
            this.space = space;
            super(eta, maxIter, StochasticGradientDescent$.MODULE$.$lessinit$greater$default$3(), StochasticGradientDescent$.MODULE$.$lessinit$greater$default$4(), space);
            this.History$lzy2 = new AdaptiveGradientDescent$L1Regularization$History$(this);
        }

        public double lambda() {
            return this.lambda;
        }

        public final AdaptiveGradientDescent$L1Regularization$History$ History() {
            return this.History$lzy2;
        }

        public History initialHistory(StochasticDiffFunction<T> f, T init) {
            return this.History().apply(this.space.zeroLike().apply(init));
        }

        public History updateHistory(T newX, T newGrad, double newValue, StochasticDiffFunction<T> f, FirstOrderMinimizer.State<T, Object, History> oldState) {
            Object object;
            History oldHistory = oldState.history();
            Object newG = ((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(oldState.grad())).$times$colon$times(oldState.grad(), this.space.mulVV());
            double maxAge = 200.0;
            if ((double)oldState.iter() > maxAge) {
                ((NumericOps)((Conversion)this.space.hasOps()).apply(newG)).$times$eq(BoxesRunTime.boxToDouble((double)(1.0 / maxAge)), this.space.mulIntoVS());
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)((maxAge - 1.0) / maxAge)), oldHistory.sumOfSquaredGradients(), newG, this.space.scaleAddVV());
                object = BoxedUnit.UNIT;
            } else {
                object = ((NumericOps)((Conversion)this.space.hasOps()).apply(newG)).$plus$eq(oldHistory.sumOfSquaredGradients(), this.space.addIntoVV());
            }
            return new History(this, newG);
        }

        @Override
        public T takeStep(FirstOrderMinimizer.State<T, Object, History> state, T dir, double stepSize) {
            Object s = package$sqrt$.MODULE$.apply(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(state.history().sumOfSquaredGradients())).$plus$colon$plus(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(state.grad())).$times$colon$times(state.grad(), this.space.mulVV()), this.space.addVV()))).$plus$colon$plus(BoxesRunTime.boxToDouble((double)this.delta), this.space.addVS()), HasOps$.MODULE$.fromLowOrderCanMapActiveValues(this.space.scalarOf(), (UFunc.UImpl)package$sqrt$sqrtDoubleImpl$.MODULE$, this.space.mapValues()));
            Object res = ((NumericOps)((Conversion)this.space.hasOps()).apply(state.x())).$plus(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(dir)).$times$colon$times(BoxesRunTime.boxToDouble((double)stepSize), this.space.mulVS()))).$div$colon$div(s, this.space.divVV()), this.space.addVV());
            double tlambda = this.lambda() * stepSize;
            return (T)this.space.zipMapValues().map(res, s, (JFunction2.mcDDD.sp & Serializable)(x$1, x$2) -> {
                double s_i;
                double x_half;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$1), (Object)BoxesRunTime.boxToDouble((double)x$2));
                if (tuple2 != null) {
                    x_half = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                    s_i = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                } else {
                    throw new MatchError((Object)tuple2);
                }
                return RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x_half)) < tlambda / s_i ? 0.0 : x_half - package$.MODULE$.signum(x_half) * tlambda / s_i;
            });
        }

        @Override
        public double determineStepSize(FirstOrderMinimizer.State<T, Object, History> state, StochasticDiffFunction<T> f, T dir) {
            return this.defaultStepSize();
        }

        @Override
        public Tuple2<Object, T> adjust(T newX, T newGrad, double newVal) {
            double av = newVal + BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(newX, BoxesRunTime.boxToDouble((double)1.0), this.space.normImpl2())) * this.lambda();
            Object ag = ((NumericOps)((Conversion)this.space.hasOps()).apply(newGrad)).$plus(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(package$signum$.MODULE$.apply(newX, HasOps$.MODULE$.fromLowOrderCanMapActiveValues(this.space.scalarOf(), (UFunc.UImpl)package$signum$signumDoubleImpl$.MODULE$, this.space.mapValues())))).$times$colon$times(BoxesRunTime.boxToDouble((double)this.lambda()), this.space.mulVS()), this.space.addVV());
            Double d = (Double)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)av));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)d, ag);
        }

        public class History
        implements Product,
        Serializable {
            private final Object sumOfSquaredGradients;
            private final /* synthetic */ L1Regularization $outer;

            public History(L1Regularization $outer, T sumOfSquaredGradients) {
                this.sumOfSquaredGradients = sumOfSquaredGradients;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof History)) return false;
                if (((History)object).breeze$optimize$AdaptiveGradientDescent$L1Regularization$History$$$outer() != this.$outer) return false;
                History history = (History)object;
                if (!BoxesRunTime.equals(this.sumOfSquaredGradients(), history.sumOfSquaredGradients())) return false;
                if (!history.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof History;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "History";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 != n2) {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return this._1();
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 != n2) {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return "sumOfSquaredGradients";
            }

            public T sumOfSquaredGradients() {
                return this.sumOfSquaredGradients;
            }

            public History copy(T sumOfSquaredGradients) {
                return new History(this.$outer, sumOfSquaredGradients);
            }

            public T copy$default$1() {
                return this.sumOfSquaredGradients();
            }

            public T _1() {
                return this.sumOfSquaredGradients();
            }

            public final /* synthetic */ L1Regularization breeze$optimize$AdaptiveGradientDescent$L1Regularization$History$$$outer() {
                return this.$outer;
            }
        }
    }

    public static class L2Regularization<T>
    extends StochasticGradientDescent<T> {
        private final double regularizationConstant;
        private final double delta;
        public final AdaptiveGradientDescent$L2Regularization$History$ History$lzy1;

        public static <T> double $lessinit$greater$default$1() {
            return AdaptiveGradientDescent$L2Regularization$.MODULE$.$lessinit$greater$default$1();
        }

        public static <T> double $lessinit$greater$default$4() {
            return AdaptiveGradientDescent$L2Regularization$.MODULE$.$lessinit$greater$default$4();
        }

        public static <T> int $lessinit$greater$default$5() {
            return AdaptiveGradientDescent$L2Regularization$.MODULE$.$lessinit$greater$default$5();
        }

        public L2Regularization(double regularizationConstant, double stepSize, int maxIter, double tolerance, int minImprovementWindow, MutableFiniteCoordinateField<T, ?, Object> vspace, RandBasis rand) {
            this.regularizationConstant = regularizationConstant;
            super(stepSize, maxIter, tolerance, minImprovementWindow, vspace);
            this.History$lzy1 = new AdaptiveGradientDescent$L2Regularization$History$(this);
            this.delta = 1.0E-4;
        }

        public double regularizationConstant() {
            return this.regularizationConstant;
        }

        private MutableFiniteCoordinateField<T, ?, Object> vspace$accessor() {
            return (MutableFiniteCoordinateField)super.vspace();
        }

        public double delta() {
            return this.delta;
        }

        public final AdaptiveGradientDescent$L2Regularization$History$ History() {
            return this.History$lzy1;
        }

        public History initialHistory(StochasticDiffFunction<T> f, T init) {
            return this.History().apply(this.vspace$accessor().zeroLike().apply(init));
        }

        public History updateHistory(T newX, T newGrad, double newValue, StochasticDiffFunction<T> f, FirstOrderMinimizer.State<T, Object, History> oldState) {
            Object object;
            History oldHistory = oldState.history();
            Object newG = ((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(oldState.grad())).$times$colon$times(oldState.grad(), this.vspace$accessor().mulVV());
            double maxAge = 1000.0;
            if ((double)oldState.iter() > maxAge) {
                ((NumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(newG)).$times$eq(BoxesRunTime.boxToDouble((double)(1.0 / maxAge)), this.vspace$accessor().mulIntoVS());
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)((maxAge - 1.0) / maxAge)), oldHistory.sumOfSquaredGradients(), newG, this.vspace$accessor().scaleAddVV());
                object = BoxedUnit.UNIT;
            } else {
                object = ((NumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(newG)).$plus$eq(oldHistory.sumOfSquaredGradients(), this.vspace$accessor().addIntoVV());
            }
            return new History(this, newG);
        }

        @Override
        public T takeStep(FirstOrderMinimizer.State<T, Object, History> state, T dir, double stepSize) {
            Object s = package$sqrt$.MODULE$.apply(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(state.history().sumOfSquaredGradients())).$plus$colon$plus(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(state.grad())).$times$colon$times(state.grad(), this.vspace$accessor().mulVV()), this.vspace$accessor().addVV()), HasOps$.MODULE$.fromLowOrderCanMapActiveValues(this.vspace$accessor().scalarOf(), (UFunc.UImpl)package$sqrt$sqrtDoubleImpl$.MODULE$, this.vspace$accessor().mapValues()));
            Object newx = ((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(state.x())).$times$colon$times(s, this.vspace$accessor().mulVV());
            breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)stepSize), dir, newx, this.vspace$accessor().scaleAddVV());
            ((NumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(s)).$plus$eq(BoxesRunTime.boxToDouble((double)(this.delta() + this.regularizationConstant() * stepSize)), this.vspace$accessor().addIntoVS());
            ((NumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(newx)).$colon$div$eq(s, this.vspace$accessor().divIntoVV());
            return (T)newx;
        }

        @Override
        public double determineStepSize(FirstOrderMinimizer.State<T, Object, History> state, StochasticDiffFunction<T> f, T dir) {
            return this.defaultStepSize();
        }

        @Override
        public Tuple2<Object, T> adjust(T newX, T newGrad, double newVal) {
            double av = newVal + BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(newX)).dot(newX, this.vspace$accessor().dotVV())) * this.regularizationConstant() / 2.0;
            Object ag = ((NumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(newGrad)).$plus(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(newX)).$times(BoxesRunTime.boxToDouble((double)this.regularizationConstant()), this.vspace$accessor().mulVS_M()), this.vspace$accessor().addVV());
            Double d = (Double)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)av));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)d, ag);
        }

        public class History
        implements Product,
        Serializable {
            private final Object sumOfSquaredGradients;
            private final /* synthetic */ L2Regularization $outer;

            public History(L2Regularization $outer, T sumOfSquaredGradients) {
                this.sumOfSquaredGradients = sumOfSquaredGradients;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof History)) return false;
                if (((History)object).breeze$optimize$AdaptiveGradientDescent$L2Regularization$History$$$outer() != this.$outer) return false;
                History history = (History)object;
                if (!BoxesRunTime.equals(this.sumOfSquaredGradients(), history.sumOfSquaredGradients())) return false;
                if (!history.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof History;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "History";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 != n2) {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return this._1();
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 != n2) {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return "sumOfSquaredGradients";
            }

            public T sumOfSquaredGradients() {
                return this.sumOfSquaredGradients;
            }

            public History copy(T sumOfSquaredGradients) {
                return new History(this.$outer, sumOfSquaredGradients);
            }

            public T copy$default$1() {
                return this.sumOfSquaredGradients();
            }

            public T _1() {
                return this.sumOfSquaredGradients();
            }

            public final /* synthetic */ L2Regularization breeze$optimize$AdaptiveGradientDescent$L2Regularization$History$$$outer() {
                return this.$outer;
            }
        }
    }
}

