/*
 * Decompiled with CFR 0.152.
 */
package breeze.numerics;

import breeze.generic.UFunc;
import breeze.linalg.package$;
import breeze.linalg.scaleAdd$;
import breeze.numerics.package$log$;
import breeze.numerics.package$log$logDoubleImpl$;
import scala.runtime.BoxesRunTime;

public interface Scaling {
    public int scaleConstant();

    public static int scaleArray$(Scaling $this, double[] scores, int currentScale) {
        return $this.scaleArray(scores, currentScale);
    }

    default public int scaleArray(double[] scores, int currentScale) {
        int scaleDelta = this.computeScaleDelta(scores);
        if (scaleDelta != 0) {
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = Math.scalb(scores[i], -scaleDelta);
            }
        }
        return currentScale + scaleDelta;
    }

    public static int computeScaleDelta$(Scaling $this, double[] scores) {
        return $this.computeScaleDelta(scores);
    }

    default public int computeScaleDelta(double[] scores) {
        int maxScale = -10000;
        for (int i = 0; i < scores.length; ++i) {
            double score = scores[i];
            if (score == 0.0) continue;
            int exp = Math.getExponent(score);
            maxScale = scala.math.package$.MODULE$.max(maxScale, exp);
        }
        return maxScale == -10000 ? 0 : (maxScale > this.scaleConstant() ? this.scaleConstant() * (maxScale / this.scaleConstant()) : (maxScale < -this.scaleConstant() ? this.scaleConstant() * (maxScale / this.scaleConstant()) : 0));
    }

    public static int determineScale$(Scaling $this, double score, int oldScale) {
        return $this.determineScale(score, oldScale);
    }

    default public int determineScale(double score, int oldScale) {
        int maxScale;
        return score != 0.0 ? ((maxScale = Math.getExponent(score)) == -10000 ? oldScale : (maxScale > this.scaleConstant() ? oldScale + this.scaleConstant() * (maxScale / this.scaleConstant()) : (maxScale < -this.scaleConstant() ? oldScale + this.scaleConstant() * (maxScale / this.scaleConstant()) : oldScale))) : Integer.MIN_VALUE;
    }

    public static void scaleArrayToScale$(Scaling $this, double[] scores, int currentScale, int targetScale) {
        $this.scaleArrayToScale(scores, currentScale, targetScale);
    }

    default public void scaleArrayToScale(double[] scores, int currentScale, int targetScale) {
        int scaleDelta = targetScale - currentScale;
        if (scaleDelta != 0) {
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = Math.scalb(scores[i], -scaleDelta);
            }
        }
    }

    public static int sumArrays$(Scaling $this, double[] src, int srcScale, double[] dest, int destScale) {
        return $this.sumArrays(src, srcScale, dest, destScale);
    }

    default public int sumArrays(double[] src, int srcScale, double[] dest, int destScale) {
        int n;
        if (destScale == srcScale) {
            package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)1.0), src, dest, scaleAdd$.MODULE$.scaleAddArray_Double());
            n = destScale;
        } else if (destScale - srcScale > 53 + 2 * this.scaleConstant()) {
            n = destScale;
        } else if (srcScale - destScale > 53 + 2 * this.scaleConstant()) {
            System.arraycopy(src, 0, dest, 0, dest.length);
            n = srcScale;
        } else if (srcScale > destScale) {
            this.scaleArrayToScale(dest, destScale, srcScale);
            for (int i = 0; i < dest.length; ++i) {
                int n2 = i;
                dest[n2] = dest[n2] + src[i];
            }
            n = srcScale;
        } else {
            int scaleDelta = destScale - srcScale;
            for (int i = 0; i < dest.length; ++i) {
                int n3 = i;
                dest[n3] = dest[n3] + Math.scalb(src[i], -scaleDelta);
            }
            n = destScale;
        }
        return n;
    }

    public static double unscaleValue$(Scaling $this, double score, int currentScale) {
        return $this.unscaleValue(score, currentScale);
    }

    default public double unscaleValue(double score, int currentScale) {
        return Math.scalb(score, currentScale);
    }

    public static double scaleValue$(Scaling $this, double score, int currentScale, int targetScale) {
        return $this.scaleValue(score, currentScale, targetScale);
    }

    default public double scaleValue(double score, int currentScale, int targetScale) {
        return Math.scalb(score, currentScale - targetScale);
    }

    public static double toLogSpace$(Scaling $this, double score, int currentScale) {
        return $this.toLogSpace(score, currentScale);
    }

    default public double toLogSpace(double score, int currentScale) {
        return BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)score), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$)) + (double)currentScale * BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)2.0), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$));
    }
}

