/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg.operators;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.Vector;
import breeze.linalg.operators.MatrixOps;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.scaleAdd$;
import breeze.math.Semiring;
import breeze.storage.Zero;
import breeze.storage.Zero$;
import breeze.util.ReflectionUtil$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface DenseMatrix_GenericOps
extends MatrixOps {
    public static UFunc.InPlaceImpl3 impl_scaleAdd_InPlace_DM_T_DM$(DenseMatrix_GenericOps $this, Semiring evidence$1) {
        return $this.impl_scaleAdd_InPlace_DM_T_DM(evidence$1);
    }

    default public <T> UFunc.InPlaceImpl3<scaleAdd$, DenseMatrix<T>, T, DenseMatrix<T>> impl_scaleAdd_InPlace_DM_T_DM(Semiring<T> evidence$1) {
        return new UFunc.InPlaceImpl3<scaleAdd$, DenseMatrix<T>, T, DenseMatrix<T>>(evidence$1){
            private final Semiring evidence$1$1;
            {
                this.evidence$1$1 = evidence$1$2;
            }

            public void apply(DenseMatrix a, Object s, DenseMatrix b) {
                Semiring ring = (Semiring)Predef$.MODULE$.implicitly((Object)this.evidence$1$1);
                if (a.rows() != b.rows()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(52).append("Vector row dimensions must match!").append(": ").append("a.rows.==(b.rows)").toString()})));
                }
                if (a.cols() != b.cols()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(52).append("Vector col dimensions must match!").append(": ").append("a.cols.==(b.cols)").toString()})));
                }
                int yy = a.cols();
                for (int i = 0; i < a.cols(); ++i) {
                    int n = i;
                    int i2 = 0;
                    int yy2 = a.rows();
                    while (i2 < a.rows()) {
                        int n2 = i2++;
                        a.update(n2, n, ring.$plus(a.apply(n2, n), ring.$times(s, b.apply(n2, n))));
                    }
                }
            }
        };
    }

    public static UFunc.UImpl2 impl_OpMulMatrix_DM_DM_eq_DM_Generic$(DenseMatrix_GenericOps $this, Semiring evidence$2) {
        return $this.impl_OpMulMatrix_DM_DM_eq_DM_Generic(evidence$2);
    }

    default public <T> UFunc.UImpl2<OpMulMatrix$, DenseMatrix<T>, DenseMatrix<T>, DenseMatrix<T>> impl_OpMulMatrix_DM_DM_eq_DM_Generic(Semiring<T> evidence$2) {
        return new UFunc.UImpl2<OpMulMatrix$, DenseMatrix<T>, DenseMatrix<T>, DenseMatrix<T>>(evidence$2){
            private final Semiring ring;
            {
                this.ring = (Semiring)Predef$.MODULE$.implicitly((Object)evidence$2$1);
            }

            public Semiring ring() {
                return this.ring;
            }

            public DenseMatrix apply(DenseMatrix a, DenseMatrix b) {
                ClassTag<T> ct = ReflectionUtil$.MODULE$.elemClassTagFromArray(a.data());
                Semiring r = this.ring();
                Zero<T> z = Zero$.MODULE$.zeroFromSemiring(r);
                Matrix res = DenseMatrix$.MODULE$.zeros(a.rows(), b.cols(), (ClassTag)ct, z);
                if (a.cols() != b.rows()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a.cols.==(b.rows)"})));
                }
                int colsB = b.cols();
                int colsA = a.cols();
                int rowsA = a.rows();
                for (int j = 0; j < colsB; ++j) {
                    for (int l = 0; l < colsA; ++l) {
                        V v = b.apply(l, j);
                        for (int i = 0; i < rowsA; ++i) {
                            ((DenseMatrix)res).update(i, j, this.ring().$plus(((DenseMatrix)res).apply(i, j), this.ring().$times(a.apply(i, l), v)));
                        }
                    }
                }
                return res;
            }
        };
    }

    public static UFunc.UImpl2 impl_OpMulMatrix_DM_V_eq_DV_Generic$(DenseMatrix_GenericOps $this, Semiring ring) {
        return $this.impl_OpMulMatrix_DM_V_eq_DV_Generic(ring);
    }

    default public <T, Vec extends Vector<T>> UFunc.UImpl2<OpMulMatrix$, DenseMatrix<T>, Vec, DenseVector<T>> impl_OpMulMatrix_DM_V_eq_DV_Generic(Semiring<T> ring) {
        return (a, b) -> {
            ClassTag ct = ReflectionUtil$.MODULE$.elemClassTagFromArray(a.data());
            if (a.cols() != b.length()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a.cols.==(b.length)"})));
            }
            Vector res = DenseVector$.MODULE$.zeros(a.rows(), ct, Zero$.MODULE$.zeroFromSemiring(ring));
            for (int c = 0; c < a.cols(); ++c) {
                for (int r = 0; r < a.rows(); ++r) {
                    Object v = a.apply(r, c);
                    ((DenseVector)res).update(r, ring.$plus(((DenseVector)res).apply(r), ring.$times(v, b.apply(BoxesRunTime.boxToInteger((int)c)))));
                }
            }
            return res;
        };
    }
}

