/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.BroadcastedColumns;
import breeze.linalg.BroadcastedRows;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.Matrix;
import breeze.linalg.Transpose;
import breeze.linalg.operators.HasOps$;
import breeze.storage.Zero;
import breeze.storage.Zero$;
import scala.;
import scala.$less$colon$less$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface VectorizedReduceUFunc
extends UFunc {
    public static UFunc.UImpl vectorizeRows$(VectorizedReduceUFunc $this, ClassTag evidence$1, VectorizeHelper helper, UFunc.InPlaceImpl2 baseOp) {
        return $this.vectorizeRows(evidence$1, helper, baseOp);
    }

    default public <T> UFunc.UImpl<VectorizedReduceUFunc, BroadcastedRows<DenseMatrix<T>, DenseVector<T>>, DenseVector<T>> vectorizeRows(ClassTag<T> evidence$1, VectorizeHelper<T> helper, UFunc.InPlaceImpl2<Object, DenseVector<T>, DenseVector<T>> baseOp) {
        return new UFunc.UImpl<VectorizedReduceUFunc, BroadcastedRows<DenseMatrix<T>, DenseVector<T>>, DenseVector<T>>(helper, baseOp){
            private final VectorizeHelper helper$1;
            private final UFunc.InPlaceImpl2 baseOp$1;
            {
                this.helper$1 = helper$6;
                this.baseOp$1 = baseOp$3;
            }

            /*
             * WARNING - void declaration
             */
            public DenseVector apply(BroadcastedRows v) {
                void var3_3;
                DenseMatrix mat = (DenseMatrix)v.underlying();
                DenseVector<T> result = this.helper$1.zerosLike(mat.rows());
                int i = 0;
                int yy = mat.cols();
                while (i < mat.cols()) {
                    int n = i++;
                    this.baseOp$1.apply(result, mat.apply(package$.MODULE$.$colon$colon(), BoxesRunTime.boxToInteger((int)n), HasOps$.MODULE$.canSliceCol()));
                }
                return var3_3;
            }
        };
    }

    public static UFunc.UImpl2 vectorizeRows2$(VectorizedReduceUFunc $this, ClassTag evidence$2, Zero evidence$3, UFunc.UImpl2 baseOp) {
        return $this.vectorizeRows2(evidence$2, evidence$3, baseOp);
    }

    default public <T> UFunc.UImpl2<VectorizedReduceUFunc, BroadcastedRows<DenseMatrix<T>, DenseVector<T>>, DenseVector<T>, DenseMatrix<T>> vectorizeRows2(ClassTag<T> evidence$2, Zero<T> evidence$3, UFunc.UImpl2<VectorizedReduceUFunc, T, T, T> baseOp) {
        return new UFunc.UImpl2<VectorizedReduceUFunc, BroadcastedRows<DenseMatrix<T>, DenseVector<T>>, DenseVector<T>, DenseMatrix<T>>(evidence$2, evidence$3, baseOp){
            private final ClassTag evidence$2$1;
            private final Zero evidence$3$1;
            private final UFunc.UImpl2 baseOp$2;
            {
                this.evidence$2$1 = evidence$2$2;
                this.evidence$3$1 = evidence$3$2;
                this.baseOp$2 = baseOp$4;
            }

            public DenseMatrix apply(BroadcastedRows v, DenseVector dv) {
                Matrix matrix;
                DenseMatrix mat = (DenseMatrix)v.underlying();
                if (dv.length() != mat.cols()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(72).append("Vector length must be same as number of columns!").append(": ").append("dv.length.==(mat.cols)").toString()})));
                }
                if (!mat.isTranspose()) {
                    Matrix res = DenseMatrix$.MODULE$.zeros(mat.rows(), mat.cols(), this.evidence$2$1, this.evidence$3$1);
                    int yy = mat.cols();
                    for (int i = 0; i < mat.cols(); ++i) {
                        int n = i;
                        V b = dv.apply(n);
                        int i2 = 0;
                        int yy2 = mat.rows();
                        while (i2 < mat.rows()) {
                            int n2 = i2++;
                            ((DenseMatrix)res).update(n2, n, this.baseOp$2.apply(mat.apply(n2, n), b));
                        }
                    }
                    matrix = res;
                } else {
                    DenseMatrix res = (DenseMatrix)((DenseMatrix)DenseMatrix$.MODULE$.zeros(mat.cols(), mat.rows(), this.evidence$2$1, this.evidence$3$1)).t(HasOps$.MODULE$.canTranspose_DM());
                    int yy = mat.rows();
                    for (int i = 0; i < mat.rows(); ++i) {
                        int n = i;
                        int i3 = 0;
                        int yy3 = mat.cols();
                        while (i3 < mat.cols()) {
                            int n3 = i3++;
                            res.update(n, n3, this.baseOp$2.apply(mat.apply(n, n3), dv.apply(n3)));
                        }
                    }
                    matrix = res;
                }
                return matrix;
            }
        };
    }

    public static UFunc.UImpl vectorizeCols_Double$(VectorizedReduceUFunc $this, VectorizeHelper helper) {
        return $this.vectorizeCols_Double(helper);
    }

    default public UFunc.UImpl<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, Transpose<DenseVector<Object>>> vectorizeCols_Double(VectorizeHelper<Object> helper) {
        return new UFunc.UImpl<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, Transpose<DenseVector<Object>>>(helper){
            private final VectorizeHelper helper$2;
            {
                this.helper$2 = helper$7;
            }

            public Transpose apply(BroadcastedColumns v) {
                DenseMatrix mat = (DenseMatrix)v.underlying();
                DenseVector<T> res = this.helper$2.zerosLike(mat.cols());
                if (!mat.isTranspose()) {
                    double[] d = (double[])mat.data();
                    int yy = mat.cols();
                    for (int i = 0; i < mat.cols(); ++i) {
                        int n = i;
                        double r = BoxesRunTime.unboxToDouble(res.apply(n));
                        int baseOff = mat.offset() + n * mat.majorStride();
                        int i2 = 0;
                        int yy2 = mat.rows();
                        while (i2 < mat.rows()) {
                            int n2 = i2++;
                            r = BoxesRunTime.unboxToDouble((Object)this.helper$2.combine(BoxesRunTime.boxToDouble((double)r), BoxesRunTime.boxToDouble((double)d[baseOff + n2])));
                        }
                        res.update(n, BoxesRunTime.boxToDouble((double)r));
                    }
                } else {
                    int yy = mat.rows();
                    for (int i = 0; i < mat.rows(); ++i) {
                        int n = i;
                        int i3 = 0;
                        int yy3 = mat.cols();
                        while (i3 < mat.cols()) {
                            int n3 = i3++;
                            res.update(n3, this.helper$2.combine(res.apply(n3), mat.apply(n, n3)));
                        }
                    }
                }
                return (Transpose)res.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
        };
    }

    public static UFunc.UImpl vectorizeCols_Float$(VectorizedReduceUFunc $this, VectorizeHelper helper) {
        return $this.vectorizeCols_Float(helper);
    }

    default public UFunc.UImpl<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, Transpose<DenseVector<Object>>> vectorizeCols_Float(VectorizeHelper<Object> helper) {
        return new UFunc.UImpl<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, Transpose<DenseVector<Object>>>(helper){
            private final VectorizeHelper helper$3;
            {
                this.helper$3 = helper$8;
            }

            public Transpose apply(BroadcastedColumns v) {
                DenseMatrix mat = (DenseMatrix)v.underlying();
                DenseVector<T> res = this.helper$3.zerosLike(mat.cols());
                if (!mat.isTranspose()) {
                    float[] d = (float[])mat.data();
                    int yy = mat.cols();
                    for (int i = 0; i < mat.cols(); ++i) {
                        int n = i;
                        float r = BoxesRunTime.unboxToFloat(res.apply(n));
                        int baseOff = mat.offset() + n * mat.majorStride();
                        int i2 = 0;
                        int yy2 = mat.rows();
                        while (i2 < mat.rows()) {
                            int n2 = i2++;
                            r = BoxesRunTime.unboxToFloat((Object)this.helper$3.combine(BoxesRunTime.boxToFloat((float)r), BoxesRunTime.boxToFloat((float)d[baseOff + n2])));
                        }
                        res.update(n, BoxesRunTime.boxToFloat((float)r));
                    }
                } else {
                    int yy = mat.rows();
                    for (int i = 0; i < mat.rows(); ++i) {
                        int n = i;
                        int i3 = 0;
                        int yy3 = mat.cols();
                        while (i3 < mat.cols()) {
                            int n3 = i3++;
                            res.update(n3, this.helper$3.combine(res.apply(n3), mat.apply(n, n3)));
                        }
                    }
                }
                return (Transpose)res.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
        };
    }

    public static UFunc.UImpl vectorizeCols_Int$(VectorizedReduceUFunc $this, VectorizeHelper helper) {
        return $this.vectorizeCols_Int(helper);
    }

    default public UFunc.UImpl<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, Transpose<DenseVector<Object>>> vectorizeCols_Int(VectorizeHelper<Object> helper) {
        return new UFunc.UImpl<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, Transpose<DenseVector<Object>>>(helper){
            private final VectorizeHelper helper$4;
            {
                this.helper$4 = helper$9;
            }

            public Transpose apply(BroadcastedColumns v) {
                DenseMatrix mat = (DenseMatrix)v.underlying();
                DenseVector<T> res = this.helper$4.zerosLike(mat.cols());
                if (!mat.isTranspose()) {
                    int[] d = (int[])mat.data();
                    int yy = mat.cols();
                    for (int i = 0; i < mat.cols(); ++i) {
                        int n = i;
                        int r = BoxesRunTime.unboxToInt(res.apply(n));
                        int baseOff = mat.offset() + n * mat.majorStride();
                        int i2 = 0;
                        int yy2 = mat.rows();
                        while (i2 < mat.rows()) {
                            int n2 = i2++;
                            r = BoxesRunTime.unboxToInt((Object)this.helper$4.combine(BoxesRunTime.boxToInteger((int)r), BoxesRunTime.boxToInteger((int)d[baseOff + n2])));
                        }
                        res.update(n, BoxesRunTime.boxToInteger((int)r));
                    }
                } else {
                    int yy = mat.rows();
                    for (int i = 0; i < mat.rows(); ++i) {
                        int n = i;
                        int i3 = 0;
                        int yy3 = mat.cols();
                        while (i3 < mat.cols()) {
                            int n3 = i3++;
                            res.update(n3, this.helper$4.combine(res.apply(n3), mat.apply(n, n3)));
                        }
                    }
                }
                return (Transpose)res.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
        };
    }

    public static UFunc.UImpl vectorizeCols_Long$(VectorizedReduceUFunc $this, VectorizeHelper helper) {
        return $this.vectorizeCols_Long(helper);
    }

    default public UFunc.UImpl<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, Transpose<DenseVector<Object>>> vectorizeCols_Long(VectorizeHelper<Object> helper) {
        return new UFunc.UImpl<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, Transpose<DenseVector<Object>>>(helper){
            private final VectorizeHelper helper$5;
            {
                this.helper$5 = helper$10;
            }

            public Transpose apply(BroadcastedColumns v) {
                DenseMatrix mat = (DenseMatrix)v.underlying();
                DenseVector<T> res = this.helper$5.zerosLike(mat.cols());
                if (!mat.isTranspose()) {
                    long[] d = (long[])mat.data();
                    int yy = mat.cols();
                    for (int i = 0; i < mat.cols(); ++i) {
                        int n = i;
                        long r = BoxesRunTime.unboxToLong(res.apply(n));
                        int baseOff = mat.offset() + n * mat.majorStride();
                        int i2 = 0;
                        int yy2 = mat.rows();
                        while (i2 < mat.rows()) {
                            int n2 = i2++;
                            r = BoxesRunTime.unboxToLong((Object)this.helper$5.combine(BoxesRunTime.boxToLong((long)r), BoxesRunTime.boxToLong((long)d[baseOff + n2])));
                        }
                        res.update(n, BoxesRunTime.boxToLong((long)r));
                    }
                } else {
                    int yy = mat.rows();
                    for (int i = 0; i < mat.rows(); ++i) {
                        int n = i;
                        int i3 = 0;
                        int yy3 = mat.cols();
                        while (i3 < mat.cols()) {
                            int n3 = i3++;
                            res.update(n3, this.helper$5.combine(res.apply(n3), mat.apply(n, n3)));
                        }
                    }
                }
                return (Transpose)res.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
        };
    }

    public static UFunc.UImpl2 vectorizeCols2_Double$(VectorizedReduceUFunc $this, UFunc.UImpl2 impl2) {
        return $this.vectorizeCols2_Double(impl2);
    }

    default public UFunc.UImpl2<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, DenseVector<Object>, DenseMatrix<Object>> vectorizeCols2_Double(UFunc.UImpl2<VectorizedReduceUFunc, Object, Object, Object> impl2) {
        return new UFunc.UImpl2<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, DenseVector<Object>, DenseMatrix<Object>>(impl2){
            private final UFunc.UImpl2 impl2$1;
            {
                this.impl2$1 = impl2$5;
            }

            public DenseMatrix apply(BroadcastedColumns v, DenseVector dv) {
                Matrix matrix;
                DenseMatrix mat = (DenseMatrix)v.underlying();
                if (dv.length() != mat.rows()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(69).append("Vector length must be same as number of rows!").append(": ").append("dv.length.==(mat.rows)").toString()})));
                }
                if (!mat.isTranspose()) {
                    Matrix res = DenseMatrix$.MODULE$.zeros(mat.rows(), mat.cols(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
                    double[] d = (double[])mat.data();
                    double[] rd = (double[])((DenseMatrix)res).data();
                    int yy = mat.cols();
                    for (int i = 0; i < mat.cols(); ++i) {
                        int n = i;
                        int baseOff = mat.offset() + n * mat.majorStride();
                        int rBaseOff = n * mat.majorStride();
                        int i2 = 0;
                        int yy2 = mat.rows();
                        while (i2 < mat.rows()) {
                            int n2 = i2++;
                            rd[rBaseOff + n2] = BoxesRunTime.unboxToDouble(this.impl2$1.apply(BoxesRunTime.boxToDouble((double)d[baseOff + n2]), dv.apply(n2)));
                        }
                    }
                    matrix = res;
                } else {
                    DenseMatrix res = (DenseMatrix)((DenseMatrix)DenseMatrix$.MODULE$.zeros(mat.cols(), mat.rows(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero())).t(HasOps$.MODULE$.canTranspose_DM());
                    int yy = mat.rows();
                    for (int i = 0; i < mat.rows(); ++i) {
                        int n = i;
                        double cmp = BoxesRunTime.unboxToDouble(dv.apply(n));
                        int i3 = 0;
                        int yy3 = mat.cols();
                        while (i3 < mat.cols()) {
                            int n3 = i3++;
                            res.update(n, n3, this.impl2$1.apply(mat.apply(n, n3), BoxesRunTime.boxToDouble((double)cmp)));
                        }
                    }
                    matrix = ((DenseMatrix)res.t(HasOps$.MODULE$.canTranspose_DM())).copy();
                }
                return matrix;
            }
        };
    }

    public static UFunc.UImpl2 vectorizeCols2_Float$(VectorizedReduceUFunc $this, UFunc.UImpl2 impl2) {
        return $this.vectorizeCols2_Float(impl2);
    }

    default public UFunc.UImpl2<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, DenseVector<Object>, DenseMatrix<Object>> vectorizeCols2_Float(UFunc.UImpl2<VectorizedReduceUFunc, Object, Object, Object> impl2) {
        return new UFunc.UImpl2<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, DenseVector<Object>, DenseMatrix<Object>>(impl2){
            private final UFunc.UImpl2 impl2$2;
            {
                this.impl2$2 = impl2$6;
            }

            public DenseMatrix apply(BroadcastedColumns v, DenseVector dv) {
                Matrix matrix;
                DenseMatrix mat = (DenseMatrix)v.underlying();
                if (dv.length() != mat.rows()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(69).append("Vector length must be same as number of rows!").append(": ").append("dv.length.==(mat.rows)").toString()})));
                }
                if (!mat.isTranspose()) {
                    Matrix res = DenseMatrix$.MODULE$.zeros(mat.rows(), mat.cols(), ClassTag$.MODULE$.apply(Float.TYPE), Zero$.MODULE$.FloatZero());
                    float[] d = (float[])mat.data();
                    float[] rd = (float[])((DenseMatrix)res).data();
                    int yy = mat.cols();
                    for (int i = 0; i < mat.cols(); ++i) {
                        int n = i;
                        int baseOff = mat.offset() + n * mat.majorStride();
                        int rBaseOff = n * mat.majorStride();
                        int i2 = 0;
                        int yy2 = mat.rows();
                        while (i2 < mat.rows()) {
                            int n2 = i2++;
                            rd[rBaseOff + n2] = BoxesRunTime.unboxToFloat(this.impl2$2.apply(BoxesRunTime.boxToFloat((float)d[baseOff + n2]), dv.apply(n2)));
                        }
                    }
                    matrix = res;
                } else {
                    DenseMatrix res = (DenseMatrix)((DenseMatrix)DenseMatrix$.MODULE$.zeros(mat.cols(), mat.rows(), ClassTag$.MODULE$.apply(Float.TYPE), Zero$.MODULE$.FloatZero())).t(HasOps$.MODULE$.canTranspose_DM());
                    int yy = mat.rows();
                    for (int i = 0; i < mat.rows(); ++i) {
                        int n = i;
                        float cmp = BoxesRunTime.unboxToFloat(dv.apply(n));
                        int i3 = 0;
                        int yy3 = mat.cols();
                        while (i3 < mat.cols()) {
                            int n3 = i3++;
                            res.update(n, n3, this.impl2$2.apply(mat.apply(n, n3), BoxesRunTime.boxToFloat((float)cmp)));
                        }
                    }
                    matrix = ((DenseMatrix)res.t(HasOps$.MODULE$.canTranspose_DM())).copy();
                }
                return matrix;
            }
        };
    }

    public static UFunc.UImpl2 vectorizeCols2_Int$(VectorizedReduceUFunc $this, UFunc.UImpl2 impl2) {
        return $this.vectorizeCols2_Int(impl2);
    }

    default public UFunc.UImpl2<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, DenseVector<Object>, DenseMatrix<Object>> vectorizeCols2_Int(UFunc.UImpl2<VectorizedReduceUFunc, Object, Object, Object> impl2) {
        return new UFunc.UImpl2<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, DenseVector<Object>, DenseMatrix<Object>>(impl2){
            private final UFunc.UImpl2 impl2$3;
            {
                this.impl2$3 = impl2$7;
            }

            public DenseMatrix apply(BroadcastedColumns v, DenseVector dv) {
                Matrix matrix;
                DenseMatrix mat = (DenseMatrix)v.underlying();
                if (dv.length() != mat.rows()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(69).append("Vector length must be same as number of rows!").append(": ").append("dv.length.==(mat.rows)").toString()})));
                }
                if (!mat.isTranspose()) {
                    Matrix res = DenseMatrix$.MODULE$.zeros(mat.rows(), mat.cols(), ClassTag$.MODULE$.apply(Integer.TYPE), Zero$.MODULE$.IntZero());
                    int[] d = (int[])mat.data();
                    int[] rd = (int[])((DenseMatrix)res).data();
                    int yy = mat.cols();
                    for (int i = 0; i < mat.cols(); ++i) {
                        int n = i;
                        int baseOff = mat.offset() + n * mat.majorStride();
                        int rBaseOff = n * mat.majorStride();
                        int i2 = 0;
                        int yy2 = mat.rows();
                        while (i2 < mat.rows()) {
                            int n2 = i2++;
                            rd[rBaseOff + n2] = BoxesRunTime.unboxToInt(this.impl2$3.apply(BoxesRunTime.boxToInteger((int)d[baseOff + n2]), dv.apply(n2)));
                        }
                    }
                    matrix = res;
                } else {
                    DenseMatrix res = (DenseMatrix)((DenseMatrix)DenseMatrix$.MODULE$.zeros(mat.cols(), mat.rows(), ClassTag$.MODULE$.apply(Integer.TYPE), Zero$.MODULE$.IntZero())).t(HasOps$.MODULE$.canTranspose_DM());
                    int yy = mat.rows();
                    for (int i = 0; i < mat.rows(); ++i) {
                        int n = i;
                        int cmp = BoxesRunTime.unboxToInt(dv.apply(n));
                        int i3 = 0;
                        int yy3 = mat.cols();
                        while (i3 < mat.cols()) {
                            int n3 = i3++;
                            res.update(n, n3, this.impl2$3.apply(mat.apply(n, n3), BoxesRunTime.boxToInteger((int)cmp)));
                        }
                    }
                    matrix = ((DenseMatrix)res.t(HasOps$.MODULE$.canTranspose_DM())).copy();
                }
                return matrix;
            }
        };
    }

    public static UFunc.UImpl2 vectorizeCols2_Long$(VectorizedReduceUFunc $this, UFunc.UImpl2 impl2) {
        return $this.vectorizeCols2_Long(impl2);
    }

    default public UFunc.UImpl2<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, DenseVector<Object>, DenseMatrix<Object>> vectorizeCols2_Long(UFunc.UImpl2<VectorizedReduceUFunc, Object, Object, Object> impl2) {
        return new UFunc.UImpl2<VectorizedReduceUFunc, BroadcastedColumns<DenseMatrix<Object>, DenseVector<Object>>, DenseVector<Object>, DenseMatrix<Object>>(impl2){
            private final UFunc.UImpl2 impl2$4;
            {
                this.impl2$4 = impl2$8;
            }

            public DenseMatrix apply(BroadcastedColumns v, DenseVector dv) {
                Matrix matrix;
                DenseMatrix mat = (DenseMatrix)v.underlying();
                if (dv.length() != mat.rows()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(69).append("Vector length must be same as number of rows!").append(": ").append("dv.length.==(mat.rows)").toString()})));
                }
                if (!mat.isTranspose()) {
                    Matrix res = DenseMatrix$.MODULE$.zeros(mat.rows(), mat.cols(), ClassTag$.MODULE$.apply(Long.TYPE), Zero$.MODULE$.LongZero());
                    long[] d = (long[])mat.data();
                    long[] rd = (long[])((DenseMatrix)res).data();
                    int yy = mat.cols();
                    for (int i = 0; i < mat.cols(); ++i) {
                        int n = i;
                        int baseOff = mat.offset() + n * mat.majorStride();
                        int rBaseOff = n * mat.majorStride();
                        int i2 = 0;
                        int yy2 = mat.rows();
                        while (i2 < mat.rows()) {
                            int n2 = i2++;
                            rd[rBaseOff + n2] = BoxesRunTime.unboxToLong(this.impl2$4.apply(BoxesRunTime.boxToLong((long)d[baseOff + n2]), dv.apply(n2)));
                        }
                    }
                    matrix = res;
                } else {
                    DenseMatrix res = (DenseMatrix)((DenseMatrix)DenseMatrix$.MODULE$.zeros(mat.cols(), mat.rows(), ClassTag$.MODULE$.apply(Long.TYPE), Zero$.MODULE$.LongZero())).t(HasOps$.MODULE$.canTranspose_DM());
                    int yy = mat.rows();
                    for (int i = 0; i < mat.rows(); ++i) {
                        int n = i;
                        long cmp = BoxesRunTime.unboxToLong(dv.apply(n));
                        int i3 = 0;
                        int yy3 = mat.cols();
                        while (i3 < mat.cols()) {
                            int n3 = i3++;
                            res.update(n, n3, this.impl2$4.apply(mat.apply(n, n3), BoxesRunTime.boxToLong((long)cmp)));
                        }
                    }
                    matrix = ((DenseMatrix)res.t(HasOps$.MODULE$.canTranspose_DM())).copy();
                }
                return matrix;
            }
        };
    }

    public interface VectorizeHelper<T> {
        public DenseVector<T> zerosLike(int var1);

        public T combine(T var1, T var2);
    }
}

