/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.linalg.Vector;
import breeze.linalg.support.CanCreateZeros;
import breeze.stats.distributions.Rand;
import breeze.stats.distributions.Rand$;
import breeze.storage.Zero;
import scala.Array$;
import scala.Float$;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.ScalaRunTime$;

public interface VectorConstructors<Vec extends Vector<Object>> {
    public <V> Vec zeros(int var1, ClassTag<V> var2, Zero<V> var3);

    public <V> Vec apply(Object var1);

    public static Vector apply$(VectorConstructors $this, Seq values, ClassTag evidence$3) {
        return $this.apply(values, evidence$3);
    }

    default public <V> Vec apply(Seq<V> values, ClassTag<V> evidence$3) {
        Vec Vec;
        ClassTag man;
        ClassTag classTag = man = (ClassTag)Predef$.MODULE$.implicitly(evidence$3);
        Object object = Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(Double.TYPE));
        if (!(classTag != null ? !classTag.equals(object) : object != null)) {
            Vec = this.apply((double[])values.toArray(evidence$3));
        } else {
            ClassTag classTag2 = man;
            Object object2 = Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(Float.TYPE));
            if (!(classTag2 != null ? !classTag2.equals(object2) : object2 != null)) {
                Vec = this.apply((float[])values.toArray(evidence$3));
            } else {
                ClassTag classTag3 = man;
                Object object3 = Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(Integer.TYPE));
                Vec = !(classTag3 != null ? !classTag3.equals(object3) : object3 != null) ? this.apply((int[])values.toArray(evidence$3)) : this.apply(values.toArray(evidence$3));
            }
        }
        return Vec;
    }

    public static CanCreateZeros canCreateZeros$(VectorConstructors $this, ClassTag evidence$4, Zero evidence$5) {
        return $this.canCreateZeros(evidence$4, evidence$5);
    }

    default public <V> CanCreateZeros<Vec, Object> canCreateZeros(ClassTag<V> evidence$4, Zero<V> evidence$5) {
        return new CanCreateZeros<Vec, Object>(evidence$4, evidence$5, this){
            private final ClassTag evidence$4$1;
            private final Zero evidence$5$1;
            private final /* synthetic */ VectorConstructors $outer;
            {
                this.evidence$4$1 = evidence$4$2;
                this.evidence$5$1 = evidence$5$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Vector apply(int d) {
                return this.$outer.zeros(d, this.evidence$4$1, this.evidence$5$1);
            }
        };
    }

    public static Vector rand$(VectorConstructors $this, int size, Rand rand, ClassTag evidence$6) {
        return $this.rand(size, rand, evidence$6);
    }

    default public <T> Vec rand(int size, Rand<T> rand, ClassTag<T> evidence$6) {
        Object arr = Arrays$.MODULE$.newGenericArray(size, evidence$6);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length(arr); ++i) {
            ScalaRunTime$.MODULE$.array_update(arr, i, rand.draw());
        }
        return this.apply(arr);
    }

    public static Rand rand$default$2$(VectorConstructors $this) {
        return $this.rand$default$2();
    }

    default public <T> Rand<Object> rand$default$2() {
        return Rand$.MODULE$.uniform();
    }

    public static Vector range$(VectorConstructors $this, int start, int end) {
        return $this.range(start, end);
    }

    default public Vec range(int start, int end) {
        return this.range(start, end, 1);
    }

    public static Vector range$(VectorConstructors $this, int start, int end, int step) {
        return $this.range(start, end, step);
    }

    default public Vec range(int start, int end, int step) {
        return this.apply(Array$.MODULE$.range(start, end, step));
    }

    public static Vector rangeF$(VectorConstructors $this, float start, float end, float step) {
        return $this.rangeF(start, end, step);
    }

    default public Vec rangeF(float start, float end, float step) {
        Predef$.MODULE$.require(end > start);
        Predef$.MODULE$.require(end - start > step);
        int size = (int)package$.MODULE$.ceil(Float$.MODULE$.float2double((end - start) / step));
        if (size > 0 && start + step * (float)(size - 1) >= end) {
            --size;
        }
        float[] data = new float[size];
        int i = 0;
        int yy = size;
        while (i < size) {
            int n = i++;
            data[n] = start + (float)n * step;
        }
        return this.apply(data);
    }

    public static float rangeF$default$3$(VectorConstructors $this) {
        return $this.rangeF$default$3();
    }

    default public float rangeF$default$3() {
        return 1.0f;
    }

    public static Vector rangeD$(VectorConstructors $this, double start, double end, double step) {
        return $this.rangeD(start, end, step);
    }

    default public Vec rangeD(double start, double end, double step) {
        Predef$.MODULE$.require(end > start);
        Predef$.MODULE$.require(end - start > step);
        int size = (int)package$.MODULE$.ceil((end - start) / step);
        if (size > 0 && start + step * (double)(size - 1) >= end) {
            --size;
        }
        double[] data = new double[size];
        int i = 0;
        int yy = size;
        while (i < size) {
            int n = i++;
            data[n] = start + (double)n * step;
        }
        return this.apply(data);
    }

    public static double rangeD$default$3$(VectorConstructors $this) {
        return $this.rangeD$default$3();
    }

    default public double rangeD$default$3() {
        return 1.0;
    }
}

