/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.linalg.Matrix;
import breeze.linalg.support.CanCreateZeros;
import breeze.linalg.support.LiteralRow;
import breeze.math.Semiring;
import breeze.stats.distributions.Rand;
import breeze.stats.distributions.Rand$;
import breeze.storage.Zero;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public interface MatrixConstructors<Mat extends Matrix<Object>> {
    public <V> Mat zeros(int var1, int var2, ClassTag<V> var3, Zero<V> var4);

    public <V> Mat create(int var1, int var2, Object var3, Zero<V> var4);

    public static Matrix ones$(MatrixConstructors $this, int rows, int cols, ClassTag evidence$4, Zero evidence$5, Semiring evidence$6) {
        return $this.ones(rows, cols, evidence$4, evidence$5, evidence$6);
    }

    default public <V> Mat ones(int rows, int cols, ClassTag<V> evidence$4, Zero<V> evidence$5, Semiring<V> evidence$6) {
        return this.fill(rows, cols, () -> MatrixConstructors.ones$$anonfun$1(evidence$6), evidence$4, evidence$5);
    }

    public static Matrix fill$(MatrixConstructors $this, int rows, int cols, Function0 v, ClassTag evidence$7, Zero evidence$8) {
        return $this.fill(rows, cols, v, evidence$7, evidence$8);
    }

    default public <V> Mat fill(int rows, int cols, Function0<V> v, ClassTag<V> evidence$7, Zero<V> evidence$8) {
        return this.create(rows, cols, Array$.MODULE$.fill(rows * cols, v, evidence$7), evidence$8);
    }

    public static Matrix tabulate$(MatrixConstructors $this, int rows, int cols, Function2 f, ClassTag evidence$9, Zero evidence$10) {
        return $this.tabulate(rows, cols, f, evidence$9, evidence$10);
    }

    default public <V> Mat tabulate(int rows, int cols, Function2<Object, Object, V> f, ClassTag<V> evidence$9, Zero<V> evidence$10) {
        Object z = this.zeros(rows, cols, evidence$9, evidence$10);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), cols).foreach((Function1)(JFunction1.mcVI.sp & Serializable)c -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), rows).foreach((Function1)(JFunction1.mcVI.sp & Serializable)r -> z.update(r, c, f.apply((Object)BoxesRunTime.boxToInteger((int)r), (Object)BoxesRunTime.boxToInteger((int)c)))));
        return z;
    }

    public static Matrix rand$(MatrixConstructors $this, int rows, int cols, Rand rand, ClassTag evidence$11, Zero evidence$12) {
        return $this.rand(rows, cols, rand, evidence$11, evidence$12);
    }

    default public <T> Mat rand(int rows, int cols, Rand<T> rand, ClassTag<T> evidence$11, Zero<T> evidence$12) {
        return this.fill(rows, cols, () -> MatrixConstructors.rand$$anonfun$1(rand), evidence$11, evidence$12);
    }

    public static Rand rand$default$3$(MatrixConstructors $this) {
        return $this.rand$default$3();
    }

    default public <T> Rand<Object> rand$default$3() {
        return Rand$.MODULE$.uniform();
    }

    public static Matrix apply$(MatrixConstructors $this, Seq rows, LiteralRow rl, ClassTag man, Zero zero) {
        return $this.apply(rows, rl, man, zero);
    }

    default public <R, V> Mat apply(Seq<R> rows, LiteralRow<R, V> rl, ClassTag<V> man, Zero<V> zero) {
        int n;
        int nRows = rows.length();
        Option option = rows.headOption();
        if (None$.MODULE$.equals(option)) {
            n = 0;
        } else if (option instanceof Some) {
            Object firstRow = ((Some)option).value();
            n = rl.length(firstRow);
        } else {
            throw new MatchError((Object)option);
        }
        int ns = n;
        Mat rv = this.zeros(nRows, ns, man, zero);
        this.finishLiteral((Matrix<V>)rv, rl, rows);
        return rv;
    }

    public static CanCreateZeros canCreateZeros$(MatrixConstructors $this, ClassTag evidence$13, Zero evidence$14) {
        return $this.canCreateZeros(evidence$13, evidence$14);
    }

    default public <T> CanCreateZeros<Mat, Tuple2<Object, Object>> canCreateZeros(ClassTag<T> evidence$13, Zero<T> evidence$14) {
        return new CanCreateZeros<Mat, Tuple2<Object, Object>>(evidence$13, evidence$14, this){
            private final ClassTag evidence$13$1;
            private final Zero evidence$14$1;
            private final /* synthetic */ MatrixConstructors $outer;
            {
                this.evidence$13$1 = evidence$13$2;
                this.evidence$14$1 = evidence$14$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Matrix apply(Tuple2 dims) {
                return this.$outer.zeros(BoxesRunTime.unboxToInt((Object)dims._1()), BoxesRunTime.unboxToInt((Object)dims._2()), this.evidence$13$1, this.evidence$14$1);
            }
        };
    }

    private <V, R> void finishLiteral(Matrix<V> rv, LiteralRow<R, V> rl, Seq<R> rows) {
        ((IterableOps)rows.zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object row = tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object row = tuple2._1();
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            rl.foreach(row, (Function2 & Serializable)(v1, v2) -> {
                rv.update(i, BoxesRunTime.unboxToInt((Object)v1), v2);
                return BoxedUnit.UNIT;
            });
        });
    }

    private static Object ones$$anonfun$1(Semiring evidence$6$1) {
        return ((Semiring)Predef$.MODULE$.implicitly((Object)evidence$6$1)).one();
    }

    private static Object rand$$anonfun$1(Rand rand$1) {
        return rand$1.draw();
    }
}

