/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.Matrix$;
import breeze.linalg.MatrixKeySet;
import breeze.linalg.MatrixLike;
import breeze.linalg.SliceMatrix;
import breeze.linalg.SliceVector;
import breeze.linalg.Tensor;
import breeze.linalg.Transpose;
import breeze.linalg.Vector;
import breeze.linalg.View;
import breeze.linalg.View$Prefer$;
import breeze.linalg.support.CanCreateZeros;
import breeze.linalg.support.CanSlice2;
import breeze.linalg.support.CanTraverseKeyValuePairs;
import breeze.linalg.support.CanTraverseValues;
import breeze.math.Semiring;
import breeze.stats.distributions.Rand;
import breeze.storage.Zero;
import breeze.util.Terminal$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public interface Matrix<V>
extends MatrixLike<V, Matrix<V>> {
    public static <T> CanCreateZeros<Matrix<T>, Tuple2<Object, Object>> canCreateZeros(ClassTag<T> classTag, Zero<T> zero) {
        return Matrix$.MODULE$.canCreateZeros((ClassTag)classTag, (Zero)zero);
    }

    public static <V> CanSlice2<Matrix<V>, Object, Tensor<Object, Object>, Transpose<SliceVector<Tuple2<Object, Object>, V>>> canSliceRowAndTensorBooleanCols(Semiring<V> semiring, ClassTag<V> classTag) {
        return Matrix$.MODULE$.canSliceRowAndTensorBooleanCols((Semiring)semiring, (ClassTag)classTag);
    }

    public static <V> CanSlice2<Matrix<V>, $colon$colon$, Tensor<Object, Object>, SliceMatrix<Object, Object, V>> canSliceTensorBooleanCols(Semiring<V> semiring, ClassTag<V> classTag) {
        return Matrix$.MODULE$.canSliceTensorBooleanCols((Semiring)semiring, (ClassTag)classTag);
    }

    public static <V> CanSlice2<Matrix<V>, Tensor<Object, Object>, $colon$colon$, SliceMatrix<Object, Object, V>> canSliceTensorBooleanRows(Semiring<V> semiring, ClassTag<V> classTag) {
        return Matrix$.MODULE$.canSliceTensorBooleanRows((Semiring)semiring, (ClassTag)classTag);
    }

    public static <V> CanSlice2<Matrix<V>, Tensor<Object, Object>, Object, SliceVector<Tuple2<Object, Object>, V>> canSliceTensorBooleanRowsAndCol(Semiring<V> semiring, ClassTag<V> classTag) {
        return Matrix$.MODULE$.canSliceTensorBooleanRowsAndCol((Semiring)semiring, (ClassTag)classTag);
    }

    public static <V> CanSlice2<Matrix<V>, Tensor<Object, Object>, Tensor<Object, Object>, SliceMatrix<Object, Object, V>> canSliceTensorBooleanRowsAndCols(Semiring<V> semiring, ClassTag<V> classTag) {
        return Matrix$.MODULE$.canSliceTensorBooleanRowsAndCols((Semiring)semiring, (ClassTag)classTag);
    }

    public static <V> CanSlice2<Matrix<V>, Tensor<Object, Object>, Seq<Object>, SliceMatrix<Object, Object, V>> canSliceTensorBooleanRowsAndWeirdCols(Semiring<V> semiring, ClassTag<V> classTag) {
        return Matrix$.MODULE$.canSliceTensorBooleanRowsAndWeirdCols((Semiring)semiring, (ClassTag)classTag);
    }

    public static <V> CanSlice2<Matrix<V>, Seq<Object>, Tensor<Object, Object>, SliceMatrix<Object, Object, V>> canSliceWeirdRowsAndTensorBooleanCols(Semiring<V> semiring, ClassTag<V> classTag) {
        return Matrix$.MODULE$.canSliceWeirdRowsAndTensorBooleanCols((Semiring)semiring, (ClassTag)classTag);
    }

    public static <V> CanTraverseKeyValuePairs<Matrix<V>, Tuple2<Object, Object>, V> canTraverseKeyValuePairs() {
        return Matrix$.MODULE$.canTraverseKeyValuePairs();
    }

    public static <V> CanTraverseValues<Matrix<V>, V> canTraverseValues() {
        return Matrix$.MODULE$.canTraverseValues();
    }

    public static <V> Matrix<V> create(int n, int n2, Object object, Zero<V> zero) {
        return Matrix$.MODULE$.create(n, n2, object, zero);
    }

    public static <V> Matrix<V> emptyMatrix(int n, int n2, ClassTag<V> classTag) {
        return Matrix$.MODULE$.emptyMatrix(n, n2, classTag);
    }

    public static <V> Matrix<V> fill(int n, int n2, Function0<V> function0, ClassTag<V> classTag, Zero<V> zero) {
        return Matrix$.MODULE$.fill(n, n2, (Function0)function0, (ClassTag)classTag, (Zero)zero);
    }

    public static <V> Matrix<V> ones(int n, int n2, ClassTag<V> classTag, Zero<V> zero, Semiring<V> semiring) {
        return Matrix$.MODULE$.ones(n, n2, (ClassTag)classTag, (Zero)zero, (Semiring)semiring);
    }

    public static <T> Matrix<T> rand(int n, int n2, Rand<T> rand, ClassTag<T> classTag, Zero<T> zero) {
        return Matrix$.MODULE$.rand(n, n2, (Rand)rand, (ClassTag)classTag, (Zero)zero);
    }

    public static <V> Matrix<V> tabulate(int n, int n2, Function2<Object, Object, V> function2, ClassTag<V> classTag, Zero<V> zero) {
        return Matrix$.MODULE$.tabulate(n, n2, (Function2)function2, (ClassTag)classTag, (Zero)zero);
    }

    public static <V> Matrix<V> zeroCols(int n, ClassTag<V> classTag) {
        return Matrix$.MODULE$.zeroCols(n, classTag);
    }

    public static <V> Matrix<V> zeroRows(int n, ClassTag<V> classTag) {
        return Matrix$.MODULE$.zeroRows(n, classTag);
    }

    public static <V> Matrix<V> zeros(int n, int n2, ClassTag<V> classTag, Zero<V> zero) {
        return Matrix$.MODULE$.zeros(n, n2, classTag, zero);
    }

    public static <T> Rand<Object> rand$default$3() {
        return Matrix$.MODULE$.rand$default$3();
    }

    public static Object apply$(Matrix $this, Tuple2 i) {
        return $this.apply((Tuple2<Object, Object>)i);
    }

    @Override
    default public V apply(Tuple2<Object, Object> i) {
        return this.apply(BoxesRunTime.unboxToInt((Object)i._1()), BoxesRunTime.unboxToInt((Object)i._2()));
    }

    public static void update$(Matrix $this, Tuple2 i, Object e) {
        $this.update((Tuple2<Object, Object>)i, e);
    }

    @Override
    default public void update(Tuple2<Object, Object> i, V e) {
        this.update(BoxesRunTime.unboxToInt((Object)i._1()), BoxesRunTime.unboxToInt((Object)i._2()), e);
    }

    public V apply(int var1, int var2);

    public void update(int var1, int var2, V var3);

    public static int size$(Matrix $this) {
        return $this.size();
    }

    @Override
    default public int size() {
        return this.rows() * this.cols();
    }

    public int rows();

    public int cols();

    public static Set keySet$(Matrix $this) {
        return $this.keySet();
    }

    @Override
    default public Set<Tuple2<Object, Object>> keySet() {
        return new MatrixKeySet(this.rows(), this.cols());
    }

    public static Iterator iterator$(Matrix $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<Tuple2<Tuple2<Object, Object>, V>> iterator() {
        return package$.MODULE$.Iterator().range(0, this.rows()).flatMap((Function1 & Serializable)i -> this.iterator$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
    }

    public static Iterator valuesIterator$(Matrix $this) {
        return $this.valuesIterator();
    }

    @Override
    default public Iterator<V> valuesIterator() {
        return package$.MODULE$.Iterator().range(0, this.rows()).flatMap((Function1 & Serializable)i -> this.valuesIterator$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
    }

    public static Iterator keysIterator$(Matrix $this) {
        return $this.keysIterator();
    }

    @Override
    default public Iterator<Tuple2<Object, Object>> keysIterator() {
        return package$.MODULE$.Iterator().range(0, this.rows()).flatMap((Function1 & Serializable)i -> this.keysIterator$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
    }

    public static String toString$(Matrix $this, int maxLines, int maxWidth) {
        return $this.toString(maxLines, maxWidth);
    }

    default public String toString(int maxLines, int maxWidth) {
        int showRows = this.rows() > maxLines ? maxLines - 1 : this.rows();
        ArrayBuffer colWidths = new ArrayBuffer();
        for (int col = 0; col < this.cols() && BoxesRunTime.unboxToInt((Object)colWidths.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) < maxWidth; ++col) {
            colWidths.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.colWidth$1(showRows, col)));
        }
        if (colWidths.size() < this.cols()) {
            while (BoxesRunTime.unboxToInt((Object)colWidths.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.boxToInteger((int)this.cols()).toString().length() + 12 >= maxWidth) {
                if (colWidths.isEmpty()) {
                    return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%d x %d matrix"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.rows()), BoxesRunTime.boxToInteger((int)this.cols())}));
                }
                colWidths.remove(colWidths.length() - 1);
            }
        }
        String newline = Terminal$.MODULE$.newline();
        StringBuilder rv = new StringBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), showRows).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), colWidths.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
            String cell = this.apply(row, col) != null ? this.apply(row, col).toString() : "--";
            rv.append(cell);
            rv.append(StringOps$.MODULE$.$times$extension(" ", colWidths.apply$mcII$sp(col) - cell.length()));
            if (col == colWidths.length() - 1) {
                if (col < this.cols() - 1) {
                    rv.append("...");
                    if (row == 0) {
                        rv.append(" (");
                        rv.append(this.cols());
                        rv.append(" total)");
                    }
                }
                if (row + 1 < showRows) {
                    rv.append(newline);
                }
            }
        }));
        if (this.rows() > showRows) {
            rv.append(newline);
            rv.append("... (");
            rv.append(this.rows());
            rv.append(" total)");
        }
        return rv.toString();
    }

    public static int toString$default$1$(Matrix $this) {
        return $this.toString$default$1();
    }

    default public int toString$default$1() {
        return Terminal$.MODULE$.terminalHeight() - 3;
    }

    public static int toString$default$2$(Matrix $this) {
        return $this.toString$default$2();
    }

    default public int toString$default$2() {
        return Terminal$.MODULE$.terminalWidth();
    }

    public static String toString$(Matrix $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.toString(Terminal$.MODULE$.terminalHeight(), Terminal$.MODULE$.terminalWidth());
    }

    public static DenseMatrix toDenseMatrix$(Matrix $this, ClassTag cm, Zero zero) {
        return $this.toDenseMatrix(cm, zero);
    }

    default public DenseMatrix<V> toDenseMatrix(ClassTag<V> cm, Zero<V> zero) {
        return (DenseMatrix)DenseMatrix$.MODULE$.tabulate(this.rows(), this.cols(), (Function2 & Serializable)(i, j) -> this.toDenseMatrix$$anonfun$1(BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j)), (ClassTag)cm, (Zero)zero);
    }

    public Matrix<V> copy();

    public Vector<V> flatten(View var1);

    public static View flatten$default$1$(Matrix $this) {
        return $this.flatten$default$1();
    }

    default public View flatten$default$1() {
        return View$Prefer$.MODULE$;
    }

    public static boolean equals$(Matrix $this, Object p1) {
        return $this.equals(p1);
    }

    default public boolean equals(Object p1) {
        Matrix x;
        Object object = p1;
        if (object instanceof Matrix) {
            x = (Matrix)object;
        } else {
            return false;
        }
        return this.rows() == x.rows() && this.cols() == x.cols() && this.keysIterator().forall((Function1 & Serializable)k -> BoxesRunTime.equals(this.apply((Tuple2<Object, Object>)k), x.apply((Tuple2<Object, Object>)k)));
    }

    private /* synthetic */ Tuple2 iterator$$anonfun$1$$anonfun$1(int i$1, int j) {
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i$1));
        Tuple2 tuple2 = (Tuple2)Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)BoxesRunTime.boxToInteger((int)j)));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tuple2, this.apply(i$1, j));
    }

    private /* synthetic */ IterableOnce iterator$$anonfun$1(int i) {
        return package$.MODULE$.Iterator().range(0, this.cols()).map((Function1 & Serializable)j -> this.iterator$$anonfun$1$$anonfun$1(i, BoxesRunTime.unboxToInt((Object)j)));
    }

    private /* synthetic */ Object valuesIterator$$anonfun$1$$anonfun$1(int i$2, int j) {
        return this.apply(i$2, j);
    }

    private /* synthetic */ IterableOnce valuesIterator$$anonfun$1(int i) {
        return package$.MODULE$.Iterator().range(0, this.cols()).map((Function1 & Serializable)j -> this.valuesIterator$$anonfun$1$$anonfun$1(i, BoxesRunTime.unboxToInt((Object)j)));
    }

    private static /* synthetic */ Tuple2 keysIterator$$anonfun$1$$anonfun$1(int i$3, int j) {
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i$3));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)BoxesRunTime.boxToInteger((int)j));
    }

    private /* synthetic */ IterableOnce keysIterator$$anonfun$1(int i) {
        return package$.MODULE$.Iterator().range(0, this.cols()).map((Function1 & Serializable)j -> Matrix.keysIterator$$anonfun$1$$anonfun$1(i, BoxesRunTime.unboxToInt((Object)j)));
    }

    private int colWidth$1(int showRows$1, int col) {
        return showRows$1 > 0 ? BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), showRows$1).map((Function1)(JFunction1.mcII.sp & Serializable)row -> this.apply(row, col) != null ? this.apply(row, col).toString().length() + 2 : 3).max((Ordering)Ordering.Int$.MODULE$)) : 0;
    }

    private /* synthetic */ Object toDenseMatrix$$anonfun$1(int i, int j) {
        return this.apply(i, j);
    }
}

