/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector$;
import breeze.linalg.DenseVector$SerializedForm$;
import breeze.linalg.StorageVector;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.operators.OpSet$;
import breeze.linalg.support.CanCopy;
import breeze.linalg.support.CanCreateZeros;
import breeze.linalg.support.CanCreateZerosLike;
import breeze.linalg.support.CanMapValues;
import breeze.linalg.support.CanZipMapKeyValues;
import breeze.linalg.support.CanZipMapValues;
import breeze.linalg.support.ScalarOf;
import breeze.math.Field;
import breeze.math.MutableFiniteCoordinateField;
import breeze.math.Semiring;
import breeze.stats.distributions.Rand;
import breeze.storage.Zero;
import breeze.util.ArrayUtil$;
import breeze.util.RangeUtils$;
import breeze.util.ReflectionUtil$;
import java.io.ObjectStreamException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class DenseVector<V>
implements StorageVector<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object data;
    private final int offset;
    private final int stride;
    private final int length;
    private final boolean noOffsetOrStride;

    public static <V, V2> CanMapValues<DenseVector<V>, V, V2, DenseVector<V2>> DV_canMapValues(ClassTag<V2> classTag) {
        return DenseVector$.MODULE$.DV_canMapValues(classTag);
    }

    public static <T> ScalarOf<DenseVector<T>, T> DV_scalarOf() {
        return DenseVector$.MODULE$.DV_scalarOf();
    }

    public static <V> CanCopy<DenseVector<V>> canCopyDenseVector(ClassTag<V> classTag) {
        return DenseVector$.MODULE$.canCopyDenseVector(classTag);
    }

    public static <V> CanCreateZeros<DenseVector<V>, Object> canCreateZeros(ClassTag<V> classTag, Zero<V> zero) {
        return DenseVector$.MODULE$.canCreateZeros((ClassTag)classTag, (Zero)zero);
    }

    public static <V> CanCreateZerosLike<DenseVector<V>, DenseVector<V>> canCreateZerosLike(ClassTag<V> classTag, Zero<V> zero) {
        return DenseVector$.MODULE$.canCreateZerosLike(classTag, zero);
    }

    public static <V> DenseVector<V> create(Object object, int n, int n2, int n3) {
        return DenseVector$.MODULE$.create(object, n, n2, n3);
    }

    public static <V> DenseVector<V> fill(int n, Function0<V> function0, ClassTag<V> classTag) {
        return DenseVector$.MODULE$.fill(n, function0, classTag);
    }

    public static <V> DenseVector<V> fill(int n, V v, ClassTag<V> classTag, Semiring<V> semiring) {
        return DenseVector$.MODULE$.fill(n, v, classTag, semiring);
    }

    public static <V> DenseMatrix<V> horzcat(Seq<DenseVector<V>> seq, ClassTag<V> classTag, Zero<V> zero) {
        return DenseVector$.MODULE$.horzcat(seq, classTag, zero);
    }

    public static <V> DenseVector<V> ones(int n, ClassTag<V> classTag, Semiring<V> semiring) {
        return DenseVector$.MODULE$.ones(n, classTag, semiring);
    }

    public static Vector rand(int n, Rand rand, ClassTag classTag) {
        return DenseVector$.MODULE$.rand(n, rand, classTag);
    }

    public static Vector range(int n, int n2) {
        return DenseVector$.MODULE$.range(n, n2);
    }

    public static Vector range(int n, int n2, int n3) {
        return DenseVector$.MODULE$.range(n, n2, n3);
    }

    public static Vector rangeD(double d, double d2, double d3) {
        return DenseVector$.MODULE$.rangeD(d, d2, d3);
    }

    public static Vector rangeF(float f, float f2, float f3) {
        return DenseVector$.MODULE$.rangeF(f, f2, f3);
    }

    public static <E> MutableFiniteCoordinateField<DenseVector<E>, Object, E> space(Field<E> field, ClassTag<E> classTag) {
        return DenseVector$.MODULE$.space(field, classTag);
    }

    public static MutableFiniteCoordinateField<DenseVector<Object>, Object, Object> space_Double() {
        return DenseVector$.MODULE$.space_Double();
    }

    public static MutableFiniteCoordinateField<DenseVector<Object>, Object, Object> space_Float() {
        return DenseVector$.MODULE$.space_Float();
    }

    public static MutableFiniteCoordinateField<DenseVector<Object>, Object, Object> space_Int() {
        return DenseVector$.MODULE$.space_Int();
    }

    public static MutableFiniteCoordinateField<DenseVector<Object>, Object, Object> space_Long() {
        return DenseVector$.MODULE$.space_Long();
    }

    public static <V> DenseVector<V> tabulate(int n, Function1<Object, V> function1, ClassTag<V> classTag) {
        return DenseVector$.MODULE$.tabulate(n, function1, classTag);
    }

    public static <V> DenseVector<V> tabulate(Range range, Function1<Object, V> function1, ClassTag<V> classTag) {
        return DenseVector$.MODULE$.tabulate(range, function1, classTag);
    }

    public static <V> DenseVector<V> vertcat(Seq<DenseVector<V>> seq, UFunc.InPlaceImpl2<OpSet$, DenseVector<V>, DenseVector<V>> inPlaceImpl2, ClassTag<V> classTag, Zero<V> zero) {
        return DenseVector$.MODULE$.vertcat(seq, inPlaceImpl2, classTag, zero);
    }

    public static <V> DenseVector<V> zeros(int n, ClassTag<V> classTag, Zero<V> zero) {
        return DenseVector$.MODULE$.zeros(n, (ClassTag)classTag, (Zero)zero);
    }

    public static <V, R> CanZipMapValuesDenseVector<V, R> zipMap(ClassTag<R> classTag) {
        return DenseVector$.MODULE$.zipMap(classTag);
    }

    public static <V, R> CanZipMapKeyValuesDenseVector<V, R> zipMapKV(ClassTag<R> classTag) {
        return DenseVector$.MODULE$.zipMapKV(classTag);
    }

    public static CanZipMapValuesDenseVector<Object, Object> zipMap_d() {
        return DenseVector$.MODULE$.zipMap_d();
    }

    public static CanZipMapValuesDenseVector<Object, Object> zipMap_f() {
        return DenseVector$.MODULE$.zipMap_f();
    }

    public static CanZipMapValuesDenseVector<Object, Object> zipMap_i() {
        return DenseVector$.MODULE$.zipMap_i();
    }

    public static <T> Rand<Object> rand$default$2() {
        return DenseVector$.MODULE$.rand$default$2();
    }

    public static double rangeD$default$3() {
        return DenseVector$.MODULE$.rangeD$default$3();
    }

    public static float rangeF$default$3() {
        return DenseVector$.MODULE$.rangeF$default$3();
    }

    public DenseVector(Object data, int offset, int stride, int length) {
        this.data = data;
        this.offset = offset;
        this.stride = stride;
        this.length = length;
        DenseVector$.MODULE$.breeze$linalg$DenseVector$$$init();
        this.noOffsetOrStride = offset == 0 && stride == 1;
    }

    @Override
    public Object data() {
        return this.data;
    }

    public int offset() {
        return this.offset;
    }

    public int stride() {
        return this.stride;
    }

    @Override
    public int length() {
        return this.length;
    }

    public DenseVector(Object data) {
        this(data, 0, 1, ScalaRunTime$.MODULE$.array_length(data));
    }

    public DenseVector(Object data, int offset) {
        this(data, offset, 1, ScalaRunTime$.MODULE$.array_length(data));
    }

    public DenseVector(int length, ClassTag<V> man) {
        this(Arrays$.MODULE$.newGenericArray(length, man), 0, 1, length);
    }

    @Override
    public DenseVector<V> repr() {
        return this;
    }

    @Override
    public int activeSize() {
        return this.length();
    }

    @Override
    public V apply(int i) {
        if (i < -this.size() || i >= this.size()) {
            throw new IndexOutOfBoundsException(new StringBuilder(12).append(i).append(" not in [-").append(this.size()).append(",").append(this.size()).append(")").toString());
        }
        int trueI = i < 0 ? i + this.size() : i;
        return (V)(this.noOffsetOrStride() ? ScalaRunTime$.MODULE$.array_apply(this.data(), trueI) : ScalaRunTime$.MODULE$.array_apply(this.data(), this.offset() + trueI * this.stride()));
    }

    @Override
    public void update(int i, V v) {
        int trueI;
        if (i < -this.size() || i >= this.size()) {
            throw new IndexOutOfBoundsException(new StringBuilder(12).append(i).append(" not in [-").append(this.size()).append(",").append(this.size()).append(")").toString());
        }
        int n = trueI = i < 0 ? i + this.size() : i;
        if (this.noOffsetOrStride()) {
            ScalaRunTime$.MODULE$.array_update(this.data(), trueI, v);
        } else {
            ScalaRunTime$.MODULE$.array_update(this.data(), this.offset() + trueI * this.stride(), v);
        }
    }

    public boolean noOffsetOrStride() {
        return this.noOffsetOrStride;
    }

    private void checkIfSpecialized() {
        if (this.data() instanceof double[]) {
            String string = this.getClass().getName();
            String string2 = "breeze.linalg.DenseVector";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new Exception("...");
            }
        }
    }

    @Override
    public Iterator<Tuple2<Object, V>> activeIterator() {
        return this.iterator();
    }

    @Override
    public Iterator<V> activeValuesIterator() {
        return this.valuesIterator();
    }

    @Override
    public Iterator<Object> activeKeysIterator() {
        return this.keysIterator();
    }

    @Override
    public boolean equals(Object p1) {
        DenseVector y;
        Object object = p1;
        return object instanceof DenseVector ? (y = (DenseVector)object).length() == this.length() && ArrayUtil$.MODULE$.nonstupidEquals(this.data(), this.offset(), this.stride(), this.length(), y.data(), y.offset(), y.stride(), y.length()) : Vector.equals$(this, p1);
    }

    @Override
    public int hashCode() {
        return ArrayUtil$.MODULE$.zeroSkippingHashCode(this.data(), this.offset(), this.stride(), this.length());
    }

    public String toString() {
        return this.valuesIterator().mkString("DenseVector(", ", ", ")");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseVector<V> copy() {
        DenseVector<V> denseVector;
        if (this.stride() == 1) {
            Object newData = ArrayUtil$.MODULE$.copyOfRange(this.data(), this.offset(), this.offset() + this.length());
            denseVector = new DenseVector<V>(newData);
        } else {
            void var3_3;
            ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
            DenseVector<V> r = new DenseVector<V>(Arrays$.MODULE$.newGenericArray(this.length(), man));
            r.$colon$eq(this, HasOps$.MODULE$.impl_OpSet_InPlace_DV_DV());
            denseVector = var3_3;
        }
        return denseVector;
    }

    @Override
    public V valueAt(int i) {
        return this.apply(i);
    }

    @Override
    public int indexAt(int i) {
        return i;
    }

    @Override
    public boolean isActive(int i) {
        return true;
    }

    @Override
    public boolean allVisitableIndicesActive() {
        return true;
    }

    @Override
    public <U> void foreach(Function1<V, U> fn) {
        if (this.stride() == 1) {
            int i = this.offset();
            int yy = this.offset() + this.length();
            while (i < this.offset() + this.length()) {
                int n = i++;
                fn.apply(ScalaRunTime$.MODULE$.array_apply(this.data(), n));
            }
        } else {
            int i = this.offset();
            int i2 = 0;
            int yy = this.length();
            while (i2 < this.length()) {
                int n = i2++;
                fn.apply(ScalaRunTime$.MODULE$.array_apply(this.data(), i));
                i += this.stride();
            }
        }
    }

    public DenseVector<V> slice(int start, int end, int stride) {
        if (start > end || start < 0) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Slice arguments ").append(start).append(", ").append(end).append(" invalid.").toString());
        }
        if (end > this.length() || end < 0) {
            throw new IllegalArgumentException(new StringBuilder(56).append("End ").append(end).append("is out of bounds for slice of DenseVector of length ").append(this.length()).toString());
        }
        int len = (end - start + stride - 1) / stride;
        return new DenseVector<V>(this.data(), start * this.stride() + this.offset(), stride * this.stride(), len);
    }

    public int slice$default$3() {
        return 1;
    }

    public DenseMatrix<V> toDenseMatrix() {
        return ((DenseVector)this.copy()).asDenseMatrix();
    }

    public DenseMatrix<V> asDenseMatrix() {
        return new DenseMatrix(1, this.length(), this.data(), this.offset(), this.stride(), DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object toArray(ClassTag<V> ct) {
        Object object;
        if (this.stride() == 1) {
            object = ArrayUtil$.MODULE$.copyOfRange(this.data(), this.offset(), this.offset() + this.length());
        } else {
            void var2_2;
            Object arr = Arrays$.MODULE$.newGenericArray(this.length(), ct);
            int off = this.offset();
            for (int i = 0; i < this.length(); ++i) {
                ScalaRunTime$.MODULE$.array_update(arr, i, ScalaRunTime$.MODULE$.array_apply(this.data(), off));
                off += this.stride();
            }
            object = var2_2;
        }
        return object;
    }

    @Override
    public scala.collection.immutable.Vector<V> toScalaVector() {
        ClassTag ct = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        return Predef$.MODULE$.genericWrapArray(this.toArray(ct)).toVector();
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.data(), this.offset(), this.stride(), this.length());
    }

    public boolean overlaps(DenseVector<V> other) {
        return this.data() == other.data() && RangeUtils$.MODULE$.overlaps(this.footprint(), super.footprint());
    }

    /*
     * WARNING - void declaration
     */
    private Range footprint() {
        Object object;
        if (this.length() == 0) {
            object = package$.MODULE$.Range().apply(this.offset(), this.offset());
        } else {
            void var1_1;
            Range.Inclusive r = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.offset()), this.offset() + this.stride() * (this.length() - 1), this.stride());
            object = this.stride() < 0 ? r.reverse() : var1_1;
        }
        return object;
    }

    public static class CanZipMapKeyValuesDenseVector<V, RV>
    implements CanZipMapKeyValues<DenseVector<V>, Object, V, RV, DenseVector<RV>> {
        private final ClassTag<RV> evidence$17;

        public CanZipMapKeyValuesDenseVector(ClassTag<RV> evidence$17) {
            this.evidence$17 = evidence$17;
        }

        public DenseVector<RV> create(int length) {
            return DenseVector$.MODULE$.apply(Arrays$.MODULE$.newGenericArray(length, this.evidence$17));
        }

        @Override
        public DenseVector<RV> map(DenseVector<V> from, DenseVector<V> from2, Function3<Object, V, V, RV> fn) {
            if (from.length() != from2.length()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(56).append("Vector lengths must match!").append(": ").append("from.length.==(from2.length)").toString()})));
            }
            DenseVector<RV> result = this.create(from.length());
            for (int i = 0; i < from.length(); ++i) {
                ScalaRunTime$.MODULE$.array_update(result.data(), i, fn.apply((Object)BoxesRunTime.boxToInteger((int)i), from.apply(i), from2.apply(i)));
            }
            return result;
        }

        @Override
        public DenseVector<RV> mapActive(DenseVector<V> from, DenseVector<V> from2, Function3<Object, V, V, RV> fn) {
            return this.map(from, from2, fn);
        }
    }

    public static class CanZipMapValuesDenseVector<V, RV>
    implements CanZipMapValues<DenseVector<V>, V, RV, DenseVector<RV>> {
        private final ClassTag<RV> evidence$15;

        public CanZipMapValuesDenseVector(ClassTag<RV> evidence$15) {
            this.evidence$15 = evidence$15;
        }

        public DenseVector<RV> create(int length) {
            return DenseVector$.MODULE$.apply(Arrays$.MODULE$.newGenericArray(length, this.evidence$15));
        }

        @Override
        public DenseVector<RV> map(DenseVector<V> from, DenseVector<V> from2, Function2<V, V, RV> fn) {
            if (from.length() != from2.length()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(59).append("Vectors must have same length").append(": ").append("from.length.==(from2.length)").toString()})));
            }
            DenseVector<RV> result = this.create(from.length());
            for (int i = 0; i < from.length(); ++i) {
                ScalaRunTime$.MODULE$.array_update(result.data(), i, fn.apply(from.apply(i), from2.apply(i)));
            }
            return result;
        }
    }

    public static class SerializedForm
    implements Serializable,
    Product {
        private static final long serialVersionUID = 1L;
        private final Object data;
        private final int offset;
        private final int stride;
        private final int length;

        public static SerializedForm apply(Object object, int n, int n2, int n3) {
            return DenseVector$SerializedForm$.MODULE$.apply(object, n, n2, n3);
        }

        public static SerializedForm fromProduct(Product product2) {
            return DenseVector$SerializedForm$.MODULE$.fromProduct(product2);
        }

        public static SerializedForm unapply(SerializedForm serializedForm) {
            return DenseVector$SerializedForm$.MODULE$.unapply(serializedForm);
        }

        public SerializedForm(Object data, int offset, int stride, int length) {
            this.data = data;
            this.offset = offset;
            this.stride = stride;
            this.length = length;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.data()));
            n = Statics.mix((int)n, (int)this.offset());
            n = Statics.mix((int)n, (int)this.stride());
            n = Statics.mix((int)n, (int)this.length());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SerializedForm)) return false;
            SerializedForm serializedForm = (SerializedForm)object;
            if (this.offset() != serializedForm.offset()) return false;
            if (this.stride() != serializedForm.stride()) return false;
            if (this.length() != serializedForm.length()) return false;
            if (!BoxesRunTime.equals((Object)this.data(), (Object)serializedForm.data())) return false;
            if (!serializedForm.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SerializedForm;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "SerializedForm";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this._3());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this._4());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "data";
                    break;
                }
                case 1: {
                    string = "offset";
                    break;
                }
                case 2: {
                    string = "stride";
                    break;
                }
                case 3: {
                    string = "length";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Object data() {
            return this.data;
        }

        public int offset() {
            return this.offset;
        }

        public int stride() {
            return this.stride;
        }

        public int length() {
            return this.length;
        }

        public Object readResolve() throws ObjectStreamException {
            DenseVector denseVector;
            Object object = this.data();
            if (object instanceof int[]) {
                int[] x = (int[])object;
                denseVector = new DenseVector(x, this.offset(), this.stride(), this.length());
            } else if (object instanceof long[]) {
                long[] x = (long[])object;
                denseVector = new DenseVector(x, this.offset(), this.stride(), this.length());
            } else if (object instanceof double[]) {
                double[] x = (double[])object;
                denseVector = new DenseVector(x, this.offset(), this.stride(), this.length());
            } else if (object instanceof float[]) {
                float[] x = (float[])object;
                denseVector = new DenseVector(x, this.offset(), this.stride(), this.length());
            } else if (object instanceof short[]) {
                short[] x = (short[])object;
                denseVector = new DenseVector(x, this.offset(), this.stride(), this.length());
            } else if (object instanceof byte[]) {
                byte[] x = (byte[])object;
                denseVector = new DenseVector(x, this.offset(), this.stride(), this.length());
            } else if (object instanceof char[]) {
                char[] x = (char[])object;
                denseVector = new DenseVector(x, this.offset(), this.stride(), this.length());
            } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object x = object;
                denseVector = new DenseVector(x, this.offset(), this.stride(), this.length());
            } else {
                throw new MatchError(object);
            }
            return denseVector;
        }

        public SerializedForm copy(Object data, int offset, int stride, int length) {
            return new SerializedForm(data, offset, stride, length);
        }

        public Object copy$default$1() {
            return this.data();
        }

        public int copy$default$2() {
            return this.offset();
        }

        public int copy$default$3() {
            return this.stride();
        }

        public int copy$default$4() {
            return this.length();
        }

        public Object _1() {
            return this.data();
        }

        public int _2() {
            return this.offset();
        }

        public int _3() {
            return this.stride();
        }

        public int _4() {
            return this.length();
        }
    }
}

