/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$SerializedForm$;
import breeze.linalg.DenseVector$TupleIsomorphisms$;
import breeze.linalg.DenseVectorDeps$;
import breeze.linalg.Matrix;
import breeze.linalg.NumericOps;
import breeze.linalg.Vector;
import breeze.linalg.VectorConstructors;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.operators.OpSet$;
import breeze.linalg.support.CanCopy;
import breeze.linalg.support.CanCreateZerosLike;
import breeze.linalg.support.CanMapValues;
import breeze.linalg.support.ScalarOf;
import breeze.linalg.support.ScalarOf$;
import breeze.math.Field;
import breeze.math.Field$fieldDouble$;
import breeze.math.Field$fieldFloat$;
import breeze.math.Field$fieldInt$;
import breeze.math.Field$fieldLong$;
import breeze.math.MutableFiniteCoordinateField;
import breeze.math.MutableFiniteCoordinateField$;
import breeze.math.Ring;
import breeze.math.Ring$;
import breeze.math.Semiring;
import breeze.storage.Zero;
import breeze.storage.Zero$;
import breeze.util.ArrayUtil$;
import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class DenseVector$
implements VectorConstructors<DenseVector> {
    private static final DenseVector.CanZipMapValuesDenseVector zipMap_d;
    private static final DenseVector.CanZipMapValuesDenseVector zipMap_f;
    private static final DenseVector.CanZipMapValuesDenseVector zipMap_i;
    private static final MutableFiniteCoordinateField space_Double;
    private static final MutableFiniteCoordinateField space_Float;
    private static final MutableFiniteCoordinateField space_Int;
    private static final MutableFiniteCoordinateField space_Long;
    public static final DenseVector$TupleIsomorphisms$ TupleIsomorphisms;
    public static final DenseVector$SerializedForm$ SerializedForm;
    public static final DenseVector$ MODULE$;

    private DenseVector$() {
    }

    static {
        MODULE$ = new DenseVector$();
        zipMap_d = new DenseVector.CanZipMapValuesDenseVector(ClassTag$.MODULE$.apply(Double.TYPE));
        zipMap_f = new DenseVector.CanZipMapValuesDenseVector(ClassTag$.MODULE$.apply(Float.TYPE));
        zipMap_i = new DenseVector.CanZipMapValuesDenseVector(ClassTag$.MODULE$.apply(Integer.TYPE));
        space_Double = MutableFiniteCoordinateField$.MODULE$.make(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())), Field$fieldDouble$.MODULE$, HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpAdd(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpSub(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpMulScalar(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpDiv(), MODULE$.canCopyDenseVector(ClassTag$.MODULE$.apply(Double.TYPE)), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpDiv(), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double(), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpAdd(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSub(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpMulScalar(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpDiv(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet(), HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double(), MODULE$.canCreateZerosLike(ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()), MODULE$.canCreateZeros(ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()), HasOps$.MODULE$.impl_dim_DV_eq_I(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpDiv(), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double(), HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(MODULE$.DV_scalarOf(), (Ring)Ring$.MODULE$.ringD(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.canDotD(), MODULE$.zipMap_d(), MODULE$.zipMapKV(ClassTag$.MODULE$.apply(Double.TYPE)), HasOps$.MODULE$.DV_canIterateValues(), MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Double.TYPE)), MODULE$.DV_scalarOf());
        space_Float = MutableFiniteCoordinateField$.MODULE$.make(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Float()), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Float())), Field$fieldFloat$.MODULE$, HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Float_OpAdd(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Float_OpSub(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Float_OpMulScalar(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Float_OpDiv(), MODULE$.canCopyDenseVector(ClassTag$.MODULE$.apply(Float.TYPE)), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Float_OpMulScalar(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Float_OpDiv(), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Float(), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Float(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Float_OpAdd(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Float_OpSub(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Float_OpMulScalar(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Float_OpDiv(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Float_OpSet(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Float_OpSet(), HasOps$.MODULE$.impl_scaledAdd_InPlace_DV_S_DV_Float(), MODULE$.canCreateZerosLike(ClassTag$.MODULE$.apply(Float.TYPE), Zero$.MODULE$.FloatZero()), MODULE$.canCreateZeros(ClassTag$.MODULE$.apply(Float.TYPE), Zero$.MODULE$.FloatZero()), HasOps$.MODULE$.impl_dim_DV_eq_I(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Float_OpMulScalar(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Float_OpDiv(), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Float(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Float(), HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(MODULE$.DV_scalarOf(), (Ring)Ring$.MODULE$.ringFloat(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Float_OpMulScalar()), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulInner_DV_DV_eq_S_Float(), MODULE$.zipMap_f(), MODULE$.zipMapKV(ClassTag$.MODULE$.apply(Float.TYPE)), HasOps$.MODULE$.DV_canIterateValues(), MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Float.TYPE)), MODULE$.DV_scalarOf());
        space_Int = MutableFiniteCoordinateField$.MODULE$.make(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Int()), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Int())), Field$fieldInt$.MODULE$, HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Int_OpAdd(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Int_OpSub(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Int_OpMulScalar(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Int_OpDiv(), MODULE$.canCopyDenseVector(ClassTag$.MODULE$.apply(Integer.TYPE)), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Int_OpMulScalar(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Int_OpDiv(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Int_OpAdd(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Int_OpSub(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Int_OpAdd(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Int_OpSub(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Int_OpMulScalar(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Int_OpDiv(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Int_OpSet(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Int_OpSet(), HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_S_DV_Int(), MODULE$.canCreateZerosLike(ClassTag$.MODULE$.apply(Integer.TYPE), Zero$.MODULE$.IntZero()), MODULE$.canCreateZeros(ClassTag$.MODULE$.apply(Integer.TYPE), Zero$.MODULE$.IntZero()), HasOps$.MODULE$.impl_dim_DV_eq_I(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Int_OpMulScalar(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Int_OpDiv(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Int_OpAdd(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Int_OpSub(), HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(MODULE$.DV_scalarOf(), (Ring)Ring$.MODULE$.ringInt(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Int_OpMulScalar()), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulInner_DV_DV_eq_S_Int(), MODULE$.zipMap_i(), MODULE$.zipMapKV(ClassTag$.MODULE$.apply(Integer.TYPE)), HasOps$.MODULE$.DV_canIterateValues(), MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Integer.TYPE)), MODULE$.DV_scalarOf());
        space_Long = MutableFiniteCoordinateField$.MODULE$.make(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Long()), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Long())), Field$fieldLong$.MODULE$, HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Long_OpAdd(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Long_OpSub(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Long_OpMulScalar(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Long_OpDiv(), MODULE$.canCopyDenseVector(ClassTag$.MODULE$.apply(Long.TYPE)), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Long_OpMulScalar(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Long_OpDiv(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Long_OpAdd(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Long_OpSub(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Long_OpAdd(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Long_OpSub(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Long_OpMulScalar(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Long_OpDiv(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Long_OpSet(), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Long_OpSet(), HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_S_DV_Long(), MODULE$.canCreateZerosLike(ClassTag$.MODULE$.apply(Long.TYPE), Zero$.MODULE$.LongZero()), MODULE$.canCreateZeros(ClassTag$.MODULE$.apply(Long.TYPE), Zero$.MODULE$.LongZero()), HasOps$.MODULE$.impl_dim_DV_eq_I(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Long_OpMulScalar(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Long_OpDiv(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Long_OpAdd(), HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Long_OpSub(), HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(MODULE$.DV_scalarOf(), (Ring)Ring$.MODULE$.ringLong(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Long_OpMulScalar()), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulInner_DV_DV_eq_S_Long(), MODULE$.zipMap(ClassTag$.MODULE$.apply(Long.TYPE)), MODULE$.zipMapKV(ClassTag$.MODULE$.apply(Long.TYPE)), HasOps$.MODULE$.DV_canIterateValues(), MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Long.TYPE)), MODULE$.DV_scalarOf());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DenseVector$.class);
    }

    @Override
    public <V> DenseVector<V> zeros(int size, ClassTag<V> evidence$1, Zero<V> evidence$2) {
        Object data = Arrays$.MODULE$.newGenericArray(size, evidence$1);
        if (size != 0 && !BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(data, 0), ((Zero)Predef$.MODULE$.implicitly(evidence$2)).zero())) {
            ArrayUtil$.MODULE$.fill(data, 0, ScalaRunTime$.MODULE$.array_length(data), ((Zero)Predef$.MODULE$.implicitly(evidence$2)).zero());
        }
        return this.apply(data);
    }

    @Override
    public <V> DenseVector<V> apply(Object values) {
        DenseVector denseVector;
        Object object = values;
        if (object instanceof double[]) {
            double[] v = (double[])object;
            denseVector = new DenseVector(v);
        } else if (object instanceof float[]) {
            float[] v = (float[])object;
            denseVector = new DenseVector(v);
        } else if (object instanceof int[]) {
            int[] v = (int[])object;
            denseVector = new DenseVector(v);
        } else if (object instanceof long[]) {
            long[] v = (long[])object;
            denseVector = new DenseVector(v);
        } else {
            denseVector = new DenseVector(values);
        }
        return denseVector;
    }

    public <V> DenseVector<V> tabulate(int size, Function1<Object, V> f, ClassTag<V> evidence$3) {
        ArrayBuilder b = ArrayBuilder$.MODULE$.make(evidence$3);
        b.sizeHint(size);
        for (int i = 0; i < size; ++i) {
            b.$plus$eq(f.apply((Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return this.apply(b.result());
    }

    public <V> DenseVector<V> tabulate(Range range, Function1<Object, V> f, ClassTag<V> evidence$4) {
        ArrayBuilder b = ArrayBuilder$.MODULE$.make(evidence$4);
        b.sizeHint(range.length());
        for (int i = 0; i < range.length(); ++i) {
            b.$plus$eq(f.apply((Object)BoxesRunTime.boxToInteger((int)range.apply$mcII$sp(i))));
        }
        return this.apply(b.result());
    }

    public <V> DenseVector<V> fill(int size, Function0<V> v, ClassTag<V> evidence$5) {
        return this.apply(Array$.MODULE$.fill(size, v, evidence$5));
    }

    public <V> DenseVector<V> create(Object data, int offset, int stride, int length) {
        DenseVector denseVector;
        Object object = data;
        if (object instanceof double[]) {
            double[] v = (double[])object;
            denseVector = new DenseVector(v, offset, stride, length);
        } else if (object instanceof float[]) {
            float[] v = (float[])object;
            denseVector = new DenseVector(v, offset, stride, length);
        } else if (object instanceof int[]) {
            int[] v = (int[])object;
            denseVector = new DenseVector(v, offset, stride, length);
        } else if (object instanceof long[]) {
            long[] v = (long[])object;
            denseVector = new DenseVector(v, offset, stride, length);
        } else {
            denseVector = new DenseVector(data, offset, stride, length);
        }
        return denseVector;
    }

    public <V> DenseVector<V> ones(int size, ClassTag<V> evidence$6, Semiring<V> evidence$7) {
        return this.fill(size, ((Semiring)Predef$.MODULE$.implicitly(evidence$7)).one(), evidence$6, evidence$7);
    }

    public <V> DenseVector<V> fill(int size, V v, ClassTag<V> evidence$8, Semiring<V> evidence$9) {
        Vector r = this.apply(Arrays$.MODULE$.newGenericArray(size, evidence$8));
        if (((DenseVector)r).stride() != 1) {
            throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"r.stride.==(1)"})));
        }
        ArrayUtil$.MODULE$.fill(((DenseVector)r).data(), ((DenseVector)r).offset(), ((DenseVector)r).length(), v);
        return r;
    }

    public <V> DenseMatrix<V> horzcat(Seq<DenseVector<V>> vectors, ClassTag<V> evidence$10, Zero<V> evidence$11) {
        int size = ((Vector)vectors.head()).size();
        if (!vectors.forall((Function1 & Serializable)_$1 -> _$1.size() == size)) {
            throw new IllegalArgumentException("All vectors must have the same size!");
        }
        Matrix result = DenseMatrix$.MODULE$.zeros(size, vectors.size(), (ClassTag)evidence$10, (Zero)evidence$11);
        ((IterableOps)vectors.zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                DenseVector v = (DenseVector)tuple2._1();
                int col = BoxesRunTime.unboxToInt((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach(arg_0 -> this.horzcat$$anonfun$3((DenseMatrix)result, arg_0));
        return result;
    }

    public <V> DenseVector<V> vertcat(Seq<DenseVector<V>> vectors, UFunc.InPlaceImpl2<OpSet$, DenseVector<V>, DenseVector<V>> canSet, ClassTag<V> vman, Zero<V> zero) {
        int size = BoxesRunTime.unboxToInt((Object)vectors.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(_$2, _$3) -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)_$2), (DenseVector)_$3)));
        Vector result = this.zeros(size, (ClassTag)vman, (Zero)zero);
        IntRef offset = IntRef.create((int)0);
        vectors.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> this.vertcat$$anonfun$1(canSet, (DenseVector)result, offset, arg_0)));
        return result;
    }

    public <V> CanCreateZerosLike<DenseVector<V>, DenseVector<V>> canCreateZerosLike(ClassTag<V> evidence$12, Zero<V> evidence$13) {
        return new CanCreateZerosLike<DenseVector<V>, DenseVector<V>>(evidence$12, evidence$13){
            private final ClassTag evidence$12$1;
            private final Zero evidence$13$1;
            {
                this.evidence$12$1 = evidence$12$2;
                this.evidence$13$1 = evidence$13$2;
            }

            public DenseVector apply(DenseVector v1) {
                return DenseVector$.MODULE$.zeros(v1.length(), this.evidence$12$1, this.evidence$13$1);
            }
        };
    }

    public <V> CanCopy<DenseVector<V>> canCopyDenseVector(ClassTag<V> evidence$14) {
        return DenseVectorDeps$.MODULE$.canCopyDenseVector(evidence$14);
    }

    public <V, V2> CanMapValues<DenseVector<V>, V, V2, DenseVector<V2>> DV_canMapValues(ClassTag<V2> man) {
        return new CanMapValues.DenseCanMapValues<DenseVector<V>, V, V2, DenseVector<V2>>(man){
            private final ClassTag man$1;
            {
                this.man$1 = man$2;
            }

            public DenseVector map(DenseVector from, Function1 fn) {
                Object out = Arrays$.MODULE$.newGenericArray(from.length(), this.man$1);
                if (from.noOffsetOrStride()) {
                    this.fastestPath(out, fn, from.data());
                } else if (from.stride() == 1) {
                    this.mediumPath(out, fn, from.data(), from.offset());
                } else {
                    this.slowPath(out, fn, from.data(), from.offset(), from.stride());
                }
                return DenseVector$.MODULE$.apply(out);
            }

            private void mediumPath(Object out, Function1 fn, Object data, int off) {
                int i = 0;
                int yy = ScalaRunTime$.MODULE$.array_length(out);
                while (i < ScalaRunTime$.MODULE$.array_length(out)) {
                    int n = i++;
                    ScalaRunTime$.MODULE$.array_update(out, n, fn.apply(ScalaRunTime$.MODULE$.array_apply(data, n + off)));
                }
            }

            private void fastestPath(Object out, Function1 fn, Object data) {
                int i = 0;
                int yy = ScalaRunTime$.MODULE$.array_length(out);
                while (i < ScalaRunTime$.MODULE$.array_length(out)) {
                    int n = i++;
                    ScalaRunTime$.MODULE$.array_update(out, n, fn.apply(ScalaRunTime$.MODULE$.array_apply(data, n)));
                }
            }

            private final void slowPath(Object out, Function1 fn, Object data, int off, int stride) {
                int i = 0;
                int j = off;
                while (i < ScalaRunTime$.MODULE$.array_length(out)) {
                    ScalaRunTime$.MODULE$.array_update(out, i, fn.apply(ScalaRunTime$.MODULE$.array_apply(data, j)));
                    ++i;
                    j += stride;
                }
            }
        };
    }

    public <T> ScalarOf<DenseVector<T>, T> DV_scalarOf() {
        return ScalarOf$.MODULE$.dummy();
    }

    public <V, R> DenseVector.CanZipMapValuesDenseVector<V, R> zipMap(ClassTag<R> evidence$16) {
        return new DenseVector.CanZipMapValuesDenseVector(evidence$16);
    }

    public DenseVector.CanZipMapValuesDenseVector<Object, Object> zipMap_d() {
        return zipMap_d;
    }

    public DenseVector.CanZipMapValuesDenseVector<Object, Object> zipMap_f() {
        return zipMap_f;
    }

    public DenseVector.CanZipMapValuesDenseVector<Object, Object> zipMap_i() {
        return zipMap_i;
    }

    public <V, R> DenseVector.CanZipMapKeyValuesDenseVector<V, R> zipMapKV(ClassTag<R> evidence$18) {
        return new DenseVector.CanZipMapKeyValuesDenseVector(evidence$18);
    }

    public <E> MutableFiniteCoordinateField<DenseVector<E>, Object, E> space(Field<E> field, ClassTag<E> man) {
        CanMapValues cmv = this.DV_canMapValues(man);
        return MutableFiniteCoordinateField$.MODULE$.make(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), field.normImpl()), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), field.normImpl())), field, HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.impl_OpAdd_InPlace_DV_S_Generic(field), this.canCopyDenseVector(man)), HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.impl_OpSub_InPlace_DV_S_Generic(field), this.canCopyDenseVector(man)), HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.impl_OpMulScalar_InPlace_DV_DV_Generic(field), this.canCopyDenseVector(man)), HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.impl_OpDiv_InPlace_DV_DV_Generic(field), this.canCopyDenseVector(man)), this.canCopyDenseVector(man), HasOps$.MODULE$.impl_OpMulScalar_InPlace_DV_S_Generic(field), HasOps$.MODULE$.impl_OpDiv_InPlace_DV_S_Generic(field), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Generic(field), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Generic(field), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_S_Generic(field), HasOps$.MODULE$.impl_OpSub_InPlace_DV_S_Generic(field), HasOps$.MODULE$.impl_OpMulScalar_InPlace_DV_DV_Generic(field), HasOps$.MODULE$.impl_OpDiv_InPlace_DV_DV_Generic(field), HasOps$.MODULE$.impl_OpSet_InPlace_DV_DV(), HasOps$.MODULE$.impl_OpSet_InPlace_DV_V_Generic(), HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_S_DV_Generic(field), this.canCreateZerosLike(man, Zero$.MODULE$.zeroFromSemiring(field)), this.canCreateZeros((ClassTag)man, Zero$.MODULE$.zeroFromSemiring(field)), HasOps$.MODULE$.impl_dim_DV_eq_I(), HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.impl_OpMulScalar_InPlace_DV_S_Generic(field), this.canCopyDenseVector(man)), HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.impl_OpDiv_InPlace_DV_S_Generic(field), this.canCopyDenseVector(man)), HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Generic(field), this.canCopyDenseVector(man)), HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Generic(field), this.canCopyDenseVector(man)), HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(this.DV_scalarOf(), (Ring)field, HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.impl_OpMulScalar_InPlace_DV_S_Generic(field), this.canCopyDenseVector(man))), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulInner_DV_DV_eq_S_Generic(field), this.zipMap(man), this.zipMapKV(man), HasOps$.MODULE$.DV_canIterateValues(), cmv, this.DV_scalarOf());
    }

    public MutableFiniteCoordinateField<DenseVector<Object>, Object, Object> space_Double() {
        return space_Double;
    }

    public MutableFiniteCoordinateField<DenseVector<Object>, Object, Object> space_Float() {
        return space_Float;
    }

    public MutableFiniteCoordinateField<DenseVector<Object>, Object, Object> space_Int() {
        return space_Int;
    }

    public MutableFiniteCoordinateField<DenseVector<Object>, Object, Object> space_Long() {
        return space_Long;
    }

    public void breeze$linalg$DenseVector$$$init() {
    }

    private final /* synthetic */ DenseVector horzcat$$anonfun$3(DenseMatrix result$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DenseVector v = (DenseVector)tuple2._1();
        int col = BoxesRunTime.unboxToInt((Object)tuple2._2());
        return (DenseVector)((NumericOps)result$1.apply(package$.MODULE$.$colon$colon(), BoxesRunTime.boxToInteger((int)col), HasOps$.MODULE$.canSliceCol())).$colon$eq(v, HasOps$.MODULE$.impl_OpSet_InPlace_DV_DV());
    }

    private final /* synthetic */ int $anonfun$1(int _$2, DenseVector _$3) {
        return _$2 + _$3.size();
    }

    private final /* synthetic */ void vertcat$$anonfun$1(UFunc.InPlaceImpl2 canSet$1, DenseVector result$2, IntRef offset$1, DenseVector v) {
        int n;
        result$2.slice(offset$1.elem, offset$1.elem + v.size(), result$2.slice$default$3()).$colon$eq(v, canSet$1);
        offset$1.elem = n = offset$1.elem + v.size();
    }
}

