/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.Axis$_0$;
import breeze.linalg.Axis$_1$;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.View;
import breeze.linalg.View$;
import breeze.linalg.View$Copy$;
import breeze.linalg.View$Prefer$;
import breeze.linalg.View$Require$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.operators.OpSet$;
import breeze.linalg.support.CanCreateZeros;
import breeze.linalg.support.CanCreateZerosLike;
import breeze.linalg.support.ScalarOf;
import breeze.math.Semiring;
import breeze.stats.distributions.Rand;
import breeze.storage.Zero;
import breeze.util.ArrayUtil$;
import breeze.util.ReflectionUtil$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class DenseMatrix<V>
implements Matrix<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int rows;
    private final int cols;
    private final Object data;
    private final int offset;
    private final int majorStride;
    private final boolean isTranspose;

    public static <T> CanCreateZeros<DenseMatrix<T>, Tuple2<Object, Object>> canCreateZeros(ClassTag<T> classTag, Zero<T> zero) {
        return DenseMatrix$.MODULE$.canCreateZeros((ClassTag)classTag, (Zero)zero);
    }

    public static <V> CanCreateZerosLike<DenseMatrix<V>, DenseMatrix<V>> canCreateZerosLike(ClassTag<V> classTag, Zero<V> zero) {
        return DenseMatrix$.MODULE$.canCreateZerosLike(classTag, zero);
    }

    public static <V> DenseMatrix<V> create(int n, int n2, Object object, int n3, int n4, boolean bl) {
        return DenseMatrix$.MODULE$.create(n, n2, object, n3, n4, bl);
    }

    public static <V> DenseMatrix<V> create(int n, int n2, Object object, Zero<V> zero) {
        return DenseMatrix$.MODULE$.create(n, n2, object, (Zero)zero);
    }

    public static <V> DenseMatrix<V> eye(int n, ClassTag<V> classTag, Zero<V> zero, Semiring<V> semiring) {
        return DenseMatrix$.MODULE$.eye(n, classTag, zero, semiring);
    }

    public static Matrix fill(int n, int n2, Function0 function0, ClassTag classTag, Zero zero) {
        return DenseMatrix$.MODULE$.fill(n, n2, function0, classTag, zero);
    }

    public static <M, V> DenseMatrix<V> horzcat(Seq<M> seq, .less.colon.less<M, Matrix<V>> less2, UFunc.InPlaceImpl2<OpSet$, DenseMatrix<V>, M> inPlaceImpl2, ClassTag<V> classTag, Zero<V> zero) {
        return DenseMatrix$.MODULE$.horzcat(seq, less2, inPlaceImpl2, classTag, zero);
    }

    public static <V> DenseMatrix<V> ones(int n, int n2, ClassTag<V> classTag, Zero<V> zero, Semiring<V> semiring) {
        return DenseMatrix$.MODULE$.ones(n, n2, (ClassTag)classTag, (Zero)zero, (Semiring)semiring);
    }

    public static /* synthetic */ Matrix ones(int n, int n2, ClassTag classTag, Zero zero, Semiring semiring) {
        return DenseMatrix$.MODULE$.ones(n, n2, classTag, zero, semiring);
    }

    public static Matrix rand(int n, int n2, Rand rand, ClassTag classTag, Zero zero) {
        return DenseMatrix$.MODULE$.rand(n, n2, rand, classTag, zero);
    }

    public static <T> ScalarOf<DenseMatrix<T>, T> scalarOf() {
        return DenseMatrix$.MODULE$.scalarOf();
    }

    public static Matrix tabulate(int n, int n2, Function2 function2, ClassTag classTag, Zero zero) {
        return DenseMatrix$.MODULE$.tabulate(n, n2, function2, classTag, zero);
    }

    public static <V> DenseMatrix<V> vertcat(Seq<DenseMatrix<V>> seq, UFunc.InPlaceImpl2<OpSet$, DenseMatrix<V>, DenseMatrix<V>> inPlaceImpl2, ClassTag<V> classTag, Zero<V> zero) {
        return DenseMatrix$.MODULE$.vertcat(seq, inPlaceImpl2, classTag, zero);
    }

    public static <V> DenseMatrix<V> zeros(int n, int n2, ClassTag<V> classTag, Zero<V> zero) {
        return DenseMatrix$.MODULE$.zeros(n, n2, (ClassTag)classTag, (Zero)zero);
    }

    public static <T> Rand<Object> rand$default$3() {
        return DenseMatrix$.MODULE$.rand$default$3();
    }

    public static <V> boolean $lessinit$greater$default$6() {
        return DenseMatrix$.MODULE$.$lessinit$greater$default$6();
    }

    public static <V> boolean create$default$6() {
        return DenseMatrix$.MODULE$.create$default$6();
    }

    public DenseMatrix(int rows, int cols, Object data, int offset, int majorStride, boolean isTranspose) {
        this.rows = rows;
        this.cols = cols;
        this.data = data;
        this.offset = offset;
        this.majorStride = majorStride;
        this.isTranspose = isTranspose;
        if (isTranspose && scala.math.package$.MODULE$.abs(majorStride) < cols && majorStride != 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(61).append("MajorStride == ").append(majorStride).append(" is smaller than cols == ").append(cols).append(", which is impossible").toString());
        }
        if (!isTranspose && scala.math.package$.MODULE$.abs(majorStride) < rows && majorStride != 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(61).append("MajorStride == ").append(majorStride).append(" is smaller than rows == ").append(rows).append(", which is impossible").toString());
        }
        if (rows < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(38).append("Rows must be larger than zero. It was ").append(rows).toString());
        }
        if (cols < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(38).append("Cols must be larger than zero. It was ").append(cols).toString());
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(40).append("Offset must be larger than zero. It was ").append(offset).toString());
        }
        if (majorStride > 0) {
            if (ScalaRunTime$.MODULE$.array_length(data) < this.linearIndex(rows - 1, cols - 1)) {
                Object object = Predef$.MODULE$.genericArrayOps(data);
                throw new IndexOutOfBoundsException(new StringBuilder(57).append("Storage array has size ").append(ArrayOps$.MODULE$.size$extension(object)).append(" but indices can grow as large as ").append(this.linearIndex(rows - 1, cols - 1)).toString());
            }
        } else if (majorStride < 0) {
            if (ScalaRunTime$.MODULE$.array_length(data) < this.linearIndex(rows - 1, 0)) {
                Object object = Predef$.MODULE$.genericArrayOps(data);
                throw new IndexOutOfBoundsException(new StringBuilder(57).append("Storage array has size ").append(ArrayOps$.MODULE$.size$extension(object)).append(" but indices can grow as large as ").append(this.linearIndex(rows - 1, cols - 1)).toString());
            }
            if (this.linearIndex(0, cols - 1) < 0) {
                throw new IndexOutOfBoundsException(new StringBuilder(84).append("Storage array has negative stride ").append(majorStride).append(" and offset ").append(offset).append(" which can result in negative indices.").toString());
            }
        }
        DenseMatrix$.MODULE$.breeze$linalg$DenseMatrix$$$init();
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    public Object data() {
        return this.data;
    }

    public int offset() {
        return this.offset;
    }

    public int majorStride() {
        return this.majorStride;
    }

    public boolean isTranspose() {
        return this.isTranspose;
    }

    public DenseMatrix(int rows, int cols, ClassTag<V> man) {
        this(rows, cols, Arrays$.MODULE$.newGenericArray(rows * cols, man), 0, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix(int rows, int cols, Object data, int offset) {
        this(rows, cols, data, offset, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix(int rows, int cols, Object data) {
        this(rows, cols, data, 0, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix(int rows, Object data, int offset) {
        if (ScalaRunTime$.MODULE$.array_length(data) % rows != 0) {
            throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data.length.%(rows).==(0)"})));
        }
        this(rows, ScalaRunTime$.MODULE$.array_length(data) / rows, data, offset);
    }

    @Override
    public V apply(int row, int col) {
        if (row < -this.rows() || row >= this.rows()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)row), (Object)BoxesRunTime.boxToInteger((int)col))).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        if (col < -this.cols() || col >= this.cols()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)row), (Object)BoxesRunTime.boxToInteger((int)col))).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        int trueRow = row < 0 ? row + this.rows() : row;
        int trueCol = col < 0 ? col + this.cols() : col;
        return (V)ScalaRunTime$.MODULE$.array_apply(this.data(), this.linearIndex(trueRow, trueCol));
    }

    public int linearIndex(int row, int col) {
        return this.isTranspose() ? this.offset() + col + row * this.majorStride() : this.offset() + row + col * this.majorStride();
    }

    public Tuple2<Object, Object> rowColumnFromLinearIndex(int index) {
        int r = (index - this.offset()) % this.majorStride();
        int c = (index - this.offset()) / this.majorStride();
        return this.isTranspose() ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)c), (Object)BoxesRunTime.boxToInteger((int)r)) : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)r), (Object)BoxesRunTime.boxToInteger((int)c));
    }

    @Override
    public void update(int row, int col, V v) {
        if (row < -this.rows() || row >= this.rows()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)row), (Object)BoxesRunTime.boxToInteger((int)col))).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        if (col < -this.cols() || col >= this.cols()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)row), (Object)BoxesRunTime.boxToInteger((int)col))).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        int trueRow = row < 0 ? row + this.rows() : row;
        int trueCol = col < 0 ? col + this.cols() : col;
        ScalaRunTime$.MODULE$.array_update(this.data(), this.linearIndex(trueRow, trueCol), v);
    }

    /*
     * WARNING - void declaration
     */
    public Object toArray() {
        Object object;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (this.isContiguous() && !this.isTranspose()) {
            object = ArrayUtil$.MODULE$.copyOfRange(this.data(), this.offset(), this.offset() + this.size());
        } else {
            void var2_2;
            Object ret = Arrays$.MODULE$.newGenericArray(this.rows() * this.cols(), man);
            int yy = this.cols();
            for (int i = 0; i < this.cols(); ++i) {
                int n = i;
                int i2 = 0;
                int yy2 = this.rows();
                while (i2 < this.rows()) {
                    int n2 = i2++;
                    ScalaRunTime$.MODULE$.array_update(ret, n * this.rows() + n2, ScalaRunTime$.MODULE$.array_apply(this.data(), this.linearIndex(n2, n)));
                }
            }
            object = var2_2;
        }
        return object;
    }

    public DenseVector<V> toDenseVector() {
        return DenseVector$.MODULE$.apply(this.toArray());
    }

    @Override
    public DenseVector<V> flatten(View view) {
        DenseVector<V> denseVector;
        block4: {
            View view2;
            DenseMatrix denseMatrix = this;
            View view3 = view;
            while (true) {
                if (View$Require$.MODULE$.equals(view2 = view3)) {
                    if (!denseMatrix.canFlattenView()) {
                        throw new UnsupportedOperationException("Cannot make a view of this matrix.");
                    }
                    denseVector = DenseVector$.MODULE$.create(denseMatrix.data(), denseMatrix.offset(), 1, denseMatrix.rows() * denseMatrix.cols());
                    break block4;
                }
                if (View$Copy$.MODULE$.equals(view2)) {
                    denseVector = denseMatrix.toDenseVector();
                    break block4;
                }
                if (!View$Prefer$.MODULE$.equals(view2)) break;
                DenseMatrix denseMatrix2 = denseMatrix;
                View view4 = View$.MODULE$.viewPreferenceFromBoolean(denseMatrix.canFlattenView());
                denseMatrix = denseMatrix2;
                view3 = view4;
            }
            throw new MatchError((Object)view2);
        }
        return denseVector;
    }

    @Override
    public View flatten$default$1() {
        return View$Prefer$.MODULE$;
    }

    private boolean canFlattenView() {
        return !this.isTranspose() && this.majorStride() == this.rows();
    }

    private boolean canReshapeView() {
        return this.canFlattenView();
    }

    public DenseMatrix<V> reshape(int rows, int cols, View view) {
        int _cols;
        int n;
        DenseMatrix<V> denseMatrix;
        block5: {
            View view2;
            denseMatrix = this;
            View view3 = view;
            n = cols;
            while (true) {
                if (rows * (_cols = n) != denseMatrix.size()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(41).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cannot reshape a (%d,%d) matrix to a (%d,%d) matrix!"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)denseMatrix.rows()), BoxesRunTime.boxToInteger((int)denseMatrix.cols()), BoxesRunTime.boxToInteger((int)rows), BoxesRunTime.boxToInteger((int)_cols)}))).append(": ").append("rows.*(_cols).==(DenseMatrix.this.size)").toString()})));
                }
                view2 = view3;
                if (View$Require$.MODULE$.equals(view2)) {
                    if (!denseMatrix.canReshapeView()) {
                        throw new UnsupportedOperationException("Cannot make a view of this matrix.");
                    }
                    break block5;
                }
                if (View$Copy$.MODULE$.equals(view2)) {
                    DenseMatrix<V> result = new DenseMatrix<V>(denseMatrix.rows(), denseMatrix.cols(), ArrayUtil$.MODULE$.newArrayLike(denseMatrix.data(), denseMatrix.size()));
                    result.$colon$eq(denseMatrix, HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM());
                    DenseMatrix<V> denseMatrix2 = result;
                    int n2 = _cols;
                    View$Require$ view$Require$ = View$Require$.MODULE$;
                    denseMatrix = denseMatrix2;
                    n = n2;
                    view3 = view$Require$;
                    continue;
                }
                if (!View$Prefer$.MODULE$.equals(view2)) break;
                DenseMatrix<V> denseMatrix3 = denseMatrix;
                View view4 = View$.MODULE$.viewPreferenceFromBoolean(denseMatrix.canReshapeView());
                denseMatrix = denseMatrix3;
                view3 = view4;
            }
            throw new MatchError((Object)view2);
        }
        return new DenseMatrix<V>(rows, _cols, denseMatrix.data(), denseMatrix.offset(), denseMatrix.isTranspose() ? n : rows, denseMatrix.isTranspose());
    }

    public View reshape$default$3() {
        return View$Prefer$.MODULE$;
    }

    @Override
    public DenseMatrix<V> repr() {
        return this;
    }

    @Override
    public Iterator<Tuple2<Tuple2<Object, Object>, V>> activeIterator() {
        return this.iterator();
    }

    @Override
    public Iterator<V> activeValuesIterator() {
        return this.valuesIterator();
    }

    @Override
    public Iterator<Tuple2<Object, Object>> activeKeysIterator() {
        return this.keysIterator();
    }

    @Override
    public int activeSize() {
        return ScalaRunTime$.MODULE$.array_length(this.data());
    }

    public V valueAt(int i) {
        return (V)ScalaRunTime$.MODULE$.array_apply(this.data(), i);
    }

    public V valueAt(int row, int col) {
        return this.apply(row, col);
    }

    public int indexAt(int i) {
        return i;
    }

    public boolean isActive(int i) {
        return true;
    }

    public boolean allVisitableIndicesActive() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<V> toDenseMatrix(ClassTag<V> cm, Zero<V> zero) {
        void var3_3;
        Matrix result = DenseMatrix$.MODULE$.create(this.rows(), this.cols(), Arrays$.MODULE$.newGenericArray(this.size(), cm), (Zero)zero);
        ((DenseMatrix)result).$colon$eq(this, HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<V> copy() {
        void var2_2;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        Matrix result = DenseMatrix$.MODULE$.create(this.rows(), this.cols(), Arrays$.MODULE$.newGenericArray(this.size(), man), (Zero)this.dontNeedZero());
        ((DenseMatrix)result).$colon$eq(this, HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM());
        return var2_2;
    }

    private <V> Zero<V> dontNeedZero() {
        return null;
    }

    public DenseMatrix<V> delete(int row, Axis$_0$ axis) {
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (row < 0 || row >= this.rows()) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(44).append(new StringBuilder(28).append("row ").append(row).append(" is not in bounds: [0, ").append(this.rows()).append(")").toString()).append(": ").append("row.>=(0).&&(row.<(DenseMatrix.this.rows))").toString()})));
        }
        return row == 0 ? ((DenseMatrix)this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.rows()), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())).copy() : (row == this.rows() - 1 ? ((DenseMatrix)this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.rows() - 1), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())).copy() : DenseMatrix$.MODULE$.vertcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{(DenseMatrix)this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), row), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()), (DenseMatrix)this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(row + 1), this.rows()), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())}), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.dontNeedZero()));
    }

    public DenseMatrix<V> delete(int col, Axis$_1$ axis) {
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (col < 0 || col >= this.cols()) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(44).append(new StringBuilder(28).append("col ").append(col).append(" is not in bounds: [0, ").append(this.cols()).append(")").toString()).append(": ").append("col.>=(0).&&(col.<(DenseMatrix.this.cols))").toString()})));
        }
        return col == 0 ? ((DenseMatrix)this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.cols()), HasOps$.MODULE$.canSliceCols())).copy() : (col == this.cols() - 1 ? ((DenseMatrix)this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.cols() - 1), HasOps$.MODULE$.canSliceCols())).copy() : DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{(DenseMatrix)this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), col), HasOps$.MODULE$.canSliceCols()), (DenseMatrix)this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(col + 1), this.cols()), HasOps$.MODULE$.canSliceCols())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.dontNeedZero()));
    }

    public DenseMatrix<V> delete(Seq<Object> rows, Axis$_0$ axis) {
        DenseMatrix<Object> denseMatrix;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (rows.isEmpty()) {
            denseMatrix = this.copy();
        } else if (rows.size() == 1) {
            denseMatrix = this.delete(BoxesRunTime.unboxToInt((Object)rows.apply(0)), axis);
        } else {
            Seq sorted = (Seq)rows.sorted((Ordering)Ordering.Int$.MODULE$);
            if (BoxesRunTime.unboxToInt((Object)sorted.head()) < 0 || BoxesRunTime.unboxToInt((Object)sorted.last()) >= this.rows()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(48).append(new StringBuilder(29).append("row ").append(rows).append(" are not in bounds: [0, ").append(this.rows()).append(")").toString()).append(": ").append("sorted.head.>=(0).&&(sorted.last.<(this.rows))").toString()})));
            }
            IntRef last = IntRef.create((int)0);
            Builder matrices = breeze.collection.compat.package$.MODULE$.arraySeqBuilder(ClassTag$.MODULE$.apply(DenseMatrix.class));
            sorted.foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
                int n;
                if (index < last$1.elem) {
                    throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"index.>=(last)"})));
                }
                if (index != last$1.elem) {
                    matrices.$plus$eq(this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last$1.elem), index), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()));
                }
                last$1.elem = n = index + 1;
            });
            if (last.elem != this.rows()) {
                matrices.$plus$eq(this.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last.elem), this.rows()), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()));
            }
            denseMatrix = DenseMatrix$.MODULE$.vertcat((Seq)matrices.result(), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.dontNeedZero());
        }
        return denseMatrix;
    }

    public DenseMatrix<V> delete(Seq<Object> cols, Axis$_1$ axis) {
        DenseMatrix<Object> denseMatrix;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (cols.isEmpty()) {
            denseMatrix = this.copy();
        } else if (cols.size() == 1) {
            denseMatrix = this.delete(BoxesRunTime.unboxToInt((Object)cols.apply(0)), axis);
        } else {
            Seq sorted = (Seq)cols.sorted((Ordering)Ordering.Int$.MODULE$);
            if (BoxesRunTime.unboxToInt((Object)sorted.head()) < 0 || BoxesRunTime.unboxToInt((Object)sorted.last()) >= this.cols()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(48).append(new StringBuilder(29).append("col ").append(cols).append(" are not in bounds: [0, ").append(this.cols()).append(")").toString()).append(": ").append("sorted.head.>=(0).&&(sorted.last.<(this.cols))").toString()})));
            }
            IntRef last = IntRef.create((int)0);
            Builder matrices = breeze.collection.compat.package$.MODULE$.arraySeqBuilder(ClassTag$.MODULE$.apply(DenseMatrix.class));
            sorted.foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
                int n;
                if (index < last$2.elem) {
                    throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"index.>=(last)"})));
                }
                if (index != last$2.elem) {
                    matrices.$plus$eq(this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last$2.elem), index), HasOps$.MODULE$.canSliceCols()));
                }
                last$2.elem = n = index + 1;
            });
            if (last.elem != this.cols()) {
                matrices.$plus$eq(this.apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(last.elem), this.cols()), HasOps$.MODULE$.canSliceCols()));
            }
            denseMatrix = DenseMatrix$.MODULE$.horzcat((Seq)matrices.result(), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), man, this.dontNeedZero());
        }
        return denseMatrix;
    }

    public int majorSize() {
        return this.isTranspose() ? this.rows() : this.cols();
    }

    public int minorSize() {
        return this.isTranspose() ? this.cols() : this.rows();
    }

    private int footprint() {
        return this.majorSize() * this.majorStride();
    }

    public boolean isContiguous() {
        return this.majorSize() == this.majorStride();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean overlaps(DenseMatrix<V> other) {
        if (this.data() != other.data()) return false;
        int astart = this.offset();
        int aend = this.offset() + this.footprint();
        int bstart = other.offset();
        int bend = other.offset() + super.footprint();
        if (package$.MODULE$.Range().apply(astart, aend).contains(bstart)) return true;
        if (package$.MODULE$.Range().apply(astart, aend).contains(bend)) return true;
        if (package$.MODULE$.Range().apply(bstart, bend).contains(astart)) return true;
        if (!package$.MODULE$.Range().apply(bstart, bend).contains(aend)) return false;
        return true;
    }

    private void checkIsSpecialized() {
        if (this.data() instanceof double[]) {
            String string = this.getClass().getName();
            String string2 = "breeze.linalg.DenseMatrix";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new Exception("...");
            }
        }
    }
}

