/*
 * Decompiled with CFR 0.152.
 */
package breeze.interpolation;

import breeze.interpolation.package;
import breeze.linalg.Vector;
import breeze.math.Field;
import scala.Predef$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public class LinearInterpolator<T>
extends package.HandyUnivariateInterpolator<T> {
    private final Field<T> evidence$2;
    private final Ordering<T> ord;

    public LinearInterpolator(Vector<T> x_coords, Vector<T> y_coords, ClassTag<T> evidence$1, Field<T> evidence$2, Ordering<T> evidence$3) {
        this.evidence$2 = evidence$2;
        super(x_coords, y_coords, evidence$1, evidence$2, evidence$3);
        this.ord = (Ordering)Predef$.MODULE$.implicitly(evidence$3);
    }

    @Override
    public T interpolate(T x) {
        int index = this.bisearch(x);
        return (T)(index == 0 ? ScalaRunTime$.MODULE$.array_apply(this.Y(), 0) : this.interpolate(index, x));
    }

    @Override
    public T extrapolate(T x) {
        if (ScalaRunTime$.MODULE$.array_length(this.X()) < 2) {
            throw new IndexOutOfBoundsException("Cannot extrapolate linearly when given less than two points.");
        }
        int index = this.ord.mkOrderingOps(x).$less(ScalaRunTime$.MODULE$.array_apply(this.X(), 0)) ? 1 : ScalaRunTime$.MODULE$.array_length(this.X()) - 1;
        return this.interpolate(index, x);
    }

    private T interpolate(int index, T x) {
        if (index <= 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        Object x1 = ScalaRunTime$.MODULE$.array_apply(this.X(), index - 1);
        Object x2 = ScalaRunTime$.MODULE$.array_apply(this.X(), index);
        Object y1 = ScalaRunTime$.MODULE$.array_apply(this.Y(), index - 1);
        Object y2 = ScalaRunTime$.MODULE$.array_apply(this.Y(), index);
        Field f = (Field)Predef$.MODULE$.implicitly(this.evidence$2);
        Object w = f.$div(f.$minus(x, x1), f.$minus(x2, x1));
        Object u = f.$minus(f.one(), w);
        return (T)f.$plus(f.$times(y1, u), f.$times(y2, w));
    }
}

