/*
 * Decompiled with CFR 0.152.
 */
package breeze.interpolation;

import breeze.generic.UFunc;
import breeze.interpolation.package;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import breeze.math.Field$fieldDouble$;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.Function2;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public class CubicInterpolator
extends package.HandyUnivariateInterpolator<Object> {
    private final DenseVector<Object> mp;
    private final DenseMatrix<Object> A;

    public CubicInterpolator(Vector<Object> x_coords, Vector<Object> y_coords) {
        super(x_coords, y_coords, ClassTag$.MODULE$.apply(Double.TYPE), Field$fieldDouble$.MODULE$, Ordering.DeprecatedDoubleOrdering$.MODULE$);
        if (ScalaRunTime$.MODULE$.array_length(this.X()) < 3) {
            throw new Exception("You must provide at least 3 points for CubicInterpolator.");
        }
        DenseMatrix M = (DenseMatrix)DenseMatrix$.MODULE$.tabulate(ScalaRunTime$.MODULE$.array_length(this.X()) - 2, ScalaRunTime$.MODULE$.array_length(this.X()) - 2, (Function2)(JFunction2.mcDII.sp & Serializable)(x$1, x$2) -> {
            double d;
            int i;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)BoxesRunTime.boxToInteger((int)x$2));
            if (tuple2 == null) return 0.0;
            int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
            int n2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
            int j = n2;
            if (j - (i = n) == -1) {
                d = this.ro(i + 1);
                return d;
            } else {
                int j2 = n2;
                int i2 = n;
                if (j2 == i2) {
                    return 2.0;
                }
                int j3 = n2;
                int i3 = n;
                if (j3 - i3 != 1) return 0.0;
                d = this.lambda(i3 + 1);
            }
            return d;
        }, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        DenseVector b = DenseVector$.MODULE$.tabulate(ScalaRunTime$.MODULE$.array_length(this.X()) - 2, (JFunction1.mcDI.sp & Serializable)x$1 -> {
            int n;
            int i = n = x$1;
            return (double)6 * (this.d(i + 1) - this.d(i)) / (this.h(i) + this.h(i + 1));
        }, ClassTag$.MODULE$.apply(Double.TYPE));
        this.mp = (DenseVector)M.$bslash(b, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpSolveMatrixBy_DMD_DVD_eq_DVD());
        this.A = (DenseMatrix)DenseMatrix$.MODULE$.tabulate(ScalaRunTime$.MODULE$.array_length(this.X()) - 1, 4, (Function2)(JFunction2.mcDII.sp & Serializable)(x$1, x$2) -> {
            double d;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)BoxesRunTime.boxToInteger((int)x$2));
            if (tuple2 == null) throw Scala3RunTime$.MODULE$.assertFailed((Object)"unreachable");
            int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
            int n2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
            int k = n;
            if (0 == n2) {
                d = BoxesRunTime.unboxToDouble((Object)ScalaRunTime$.MODULE$.array_apply(this.Y(), k));
                return d;
            } else {
                int k2 = n;
                if (1 == n2) {
                    d = this.d(k2) - this.h(k2) / (double)6 * ((double)2 * this.m(k2) + this.m(k2 + 1));
                    return d;
                } else {
                    int k3 = n;
                    if (2 == n2) {
                        d = this.m(k3) / (double)2;
                        return d;
                    } else {
                        int k4 = n;
                        if (3 != n2) throw Scala3RunTime$.MODULE$.assertFailed((Object)"unreachable");
                        d = (this.m(k4 + 1) - this.m(k4)) / (double)6 / this.h(k4);
                    }
                }
            }
            return d;
        }, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
    }

    private double h(int k) {
        return BoxesRunTime.unboxToDouble((Object)ScalaRunTime$.MODULE$.array_apply(this.X(), k + 1)) - BoxesRunTime.unboxToDouble((Object)ScalaRunTime$.MODULE$.array_apply(this.X(), k));
    }

    private double d(int k) {
        return (BoxesRunTime.unboxToDouble((Object)ScalaRunTime$.MODULE$.array_apply(this.Y(), k + 1)) - BoxesRunTime.unboxToDouble((Object)ScalaRunTime$.MODULE$.array_apply(this.Y(), k))) / this.h(k);
    }

    private double lambda(int k) {
        return this.h(k) / (this.h(k - 1) + this.h(k));
    }

    private double ro(int k) {
        return 1.0 - this.lambda(k);
    }

    private double m(int i) {
        double d;
        int n = i;
        if (0 == n) {
            d = 0.0;
        } else {
            int i2 = n;
            if (i2 == ScalaRunTime$.MODULE$.array_length(this.X()) - 1) {
                d = 0.0;
            } else {
                int i3 = n;
                d = BoxesRunTime.unboxToDouble((Object)this.mp.apply(i3 - 1));
            }
        }
        return d;
    }

    @Override
    public double interpolate(double x) {
        double d;
        int index = this.bisearch(BoxesRunTime.boxToDouble((double)x)) - 1;
        if (index == -1) {
            d = BoxesRunTime.unboxToDouble((Object)ScalaRunTime$.MODULE$.array_apply(this.Y(), 0));
        } else {
            double dx = x - BoxesRunTime.unboxToDouble((Object)ScalaRunTime$.MODULE$.array_apply(this.X(), index));
            d = BoxesRunTime.unboxToDouble((Object)this.A.apply(index, 0)) + BoxesRunTime.unboxToDouble((Object)this.A.apply(index, 1)) * dx + BoxesRunTime.unboxToDouble((Object)this.A.apply(index, 2)) * dx * dx + BoxesRunTime.unboxToDouble((Object)this.A.apply(index, 3)) * dx * dx * dx;
        }
        return d;
    }
}

