/*
 * Decompiled with CFR 0.152.
 */
package breeze.integrate.quasimontecarlo;

import breeze.integrate.quasimontecarlo.BaseUniformHaltonGenerator$UnboxedIntVector$;
import breeze.integrate.quasimontecarlo.Halton$;
import breeze.integrate.quasimontecarlo.QuasiMonteCarloGenerator;
import breeze.linalg.shuffle$;
import breeze.stats.distributions.RandBasis;
import breeze.stats.distributions.RandBasis$;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class BaseUniformHaltonGenerator
implements QuasiMonteCarloGenerator {
    private final int dimension;
    private final int[] bases;
    private final UnboxedIntVector[] counters;
    private final long[][] permutations;
    private final double[] currentValue;
    private long generatedCount;
    public final BaseUniformHaltonGenerator$UnboxedIntVector$ UnboxedIntVector$lzy1;

    public BaseUniformHaltonGenerator(int dimension) {
        this.dimension = dimension;
        this.UnboxedIntVector$lzy1 = new BaseUniformHaltonGenerator$UnboxedIntVector$();
        this.bases = Arrays.copyOfRange(Halton$.MODULE$.PRIMES(), 0, dimension);
        long count = 0L;
        this.counters = (UnboxedIntVector[])package$.MODULE$.List().fill(dimension, BaseUniformHaltonGenerator::$init$$$anonfun$1).toArray(ClassTag$.MODULE$.apply(UnboxedIntVector.class));
        RandBasis rand = RandBasis$.MODULE$.mt0();
        this.permutations = (long[][])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), dimension).map((Function1 & Serializable)i -> BaseUniformHaltonGenerator.$init$$$anonfun$2(rand, BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(Long.TYPE).wrap());
        this.currentValue = new double[dimension];
        this.generatedCount = 0L;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    public long[][] permutations() {
        return this.permutations;
    }

    @Override
    public long numGenerated() {
        return this.generatedCount;
    }

    @Override
    public double[] getNextUnsafe() {
        int yy = this.dimension();
        for (int i = 0; i < this.dimension(); ++i) {
            int lIndex;
            int n = i;
            for (lIndex = 0; lIndex < this.counters[n].size() && this.counters[n].get(lIndex) == this.bases[n] - 1; ++lIndex) {
                this.counters[n].set(lIndex, 0);
            }
            if (lIndex == this.counters[n].size()) {
                this.counters[n].add(1);
            } else {
                this.counters[n].set(lIndex, this.counters[n].get(lIndex) + 1);
            }
            int lCountSizeI = this.counters[n].size();
            long lBasesPow = Int$.MODULE$.int2long(this.bases[n]);
            double lValue = this.permutations()[n][this.counters[n].get(lCountSizeI - 1)];
            int i2 = lCountSizeI;
            boolean yy2 = false;
            while (i2 > 0) {
                int n2 = i2--;
                lValue += (double)(this.permutations()[n][this.counters[n].get(n2 - 1)] * lBasesPow);
                lBasesPow *= (long)this.bases[n];
            }
            this.currentValue[n] = lValue / (double)lBasesPow;
        }
        ++this.generatedCount;
        return this.currentValue;
    }

    private final BaseUniformHaltonGenerator$UnboxedIntVector$ UnboxedIntVector() {
        return this.UnboxedIntVector$lzy1;
    }

    private static final UnboxedIntVector $init$$$anonfun$1() {
        return new UnboxedIntVector(16);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ long[] $init$$$anonfun$2(RandBasis rand$1, int i) {
        void var2_2;
        long[] vv = new long[Halton$.MODULE$.PRIMES()[i]];
        int i2 = 0;
        int yy = Halton$.MODULE$.PRIMES()[i];
        while (i2 < Halton$.MODULE$.PRIMES()[i]) {
            int n = i2++;
            vv[n] = Int$.MODULE$.int2long(n);
        }
        shuffle$.MODULE$.apply(vv, shuffle$.MODULE$.implShuffle_Arr_eq_Arr(ClassTag$.MODULE$.apply(Long.TYPE), rand$1));
        return var2_2;
    }

    public class UnboxedIntVector {
        private int[] storage;
        private int actualSize;

        public UnboxedIntVector(int initialSize) {
            this.storage = new int[initialSize];
            this.actualSize = 0;
        }

        public void add(int x) {
            Object object = Predef$.MODULE$.intArrayOps(this.storage);
            if (this.actualSize == ArrayOps$.MODULE$.size$extension(object)) {
                int[] oldStorage = this.storage;
                Object object2 = Predef$.MODULE$.intArrayOps(oldStorage);
                this.storage = new int[ArrayOps$.MODULE$.size$extension(object2) * 2];
            }
            this.storage[this.actualSize] = x;
            ++this.actualSize;
        }

        public int size() {
            return this.actualSize;
        }

        public int get(int i) {
            return this.storage[i];
        }

        public void set(int i, int x) {
            this.storage[i] = x;
        }
    }
}

