/*
 * Decompiled with CFR 0.152.
 */
package breeze.collection.mutable;

import breeze.collection.mutable.SparseArray$;
import breeze.collection.mutable.SparseArrayLike;
import breeze.storage.ConfigurableDefault$;
import breeze.storage.Storage;
import breeze.storage.Zero;
import breeze.util.ArrayUtil$;
import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SparseArray<V>
implements SparseArrayLike<V>,
Storage<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int[] index;
    private Object data;
    private int used;
    private final int size;
    private final Object default;
    private int lastReturnedPos;

    public static <T> SparseArray<T> create(int n, Seq<Tuple2<Object, T>> seq, ClassTag<T> classTag, Zero<T> zero) {
        return SparseArray$.MODULE$.create(n, seq, classTag, zero);
    }

    public static <T> SparseArray<T> fill(int n, Function0<T> function0, ClassTag<T> classTag, Zero<T> zero) {
        return SparseArray$.MODULE$.fill(n, function0, classTag, zero);
    }

    public static <T> SparseArray<T> tabulate(int n, Function1<Object, T> function1, ClassTag<T> classTag, Zero<T> zero) {
        return SparseArray$.MODULE$.tabulate(n, function1, classTag, zero);
    }

    public SparseArray(int[] index, Object data, int used, int size, V v) {
        this.index = index;
        this.data = data;
        this.used = used;
        this.size = size;
        this.default = v;
        this.lastReturnedPos = -1;
    }

    public int[] index() {
        return this.index;
    }

    public void index_$eq(int[] x$1) {
        this.index = x$1;
    }

    @Override
    public Object data() {
        return this.data;
    }

    public void data_$eq(Object x$1) {
        this.data = x$1;
    }

    private int used() {
        return this.used;
    }

    private void used_$eq(int x$0) {
        this.used = x$0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public V default() {
        return (V)this.default;
    }

    public SparseArray(int size, V v, ClassTag<V> manElem) {
        this((int[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Integer.TYPE)), Array$.MODULE$.empty(manElem), 0, size, v);
    }

    public SparseArray(int size, ClassTag<V> manElem, Zero<V> zero) {
        this(size, ConfigurableDefault$.MODULE$.default().value(zero), manElem);
    }

    @Override
    public final V apply(int i) {
        int offset = this.findOffset(i);
        return (V)(offset >= 0 ? ScalaRunTime$.MODULE$.array_apply(this.data(), offset) : this.default());
    }

    @Override
    public Iterator<V> valuesIterator() {
        Object object = Predef$.MODULE$.genericArrayOps(this.data());
        return ArrayOps$.MODULE$.iterator$extension(object).take(this.used());
    }

    @Override
    public Iterator<Object> keysIterator() {
        Object object = Predef$.MODULE$.intArrayOps(this.index());
        return ArrayOps$.MODULE$.iterator$extension(object).take(this.used());
    }

    public Option<V> get(int i) {
        int offset = this.findOffset(i);
        return offset >= 0 ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(this.data(), offset)) : None$.MODULE$;
    }

    public V getOrElse(int i, Function0<V> value) {
        int offset = this.findOffset(i);
        return (V)(offset >= 0 ? ScalaRunTime$.MODULE$.array_apply(this.data(), offset) : value.apply());
    }

    public V getOrElseUpdate(int i, Function0<V> value) {
        Object object;
        int offset = this.findOffset(i);
        if (offset >= 0) {
            object = ScalaRunTime$.MODULE$.array_apply(this.data(), offset);
        } else {
            Object v = value.apply();
            this.update(i, v);
            object = v;
        }
        return (V)object;
    }

    public <B> SparseArray<B> map(Function1<V, B> f, ClassTag<B> evidence$1, Zero<B> evidence$2) {
        SparseArray<Object> sparseArray;
        Object newZero = ((Zero)Predef$.MODULE$.implicitly(evidence$2)).zero();
        if (this.used() <= this.length() && BoxesRunTime.equals((Object)f.apply(this.default()), newZero)) {
            int[] newIndex = new int[this.used()];
            Object newData = Arrays$.MODULE$.newGenericArray(this.used(), evidence$1);
            int o = 0;
            for (int i = 0; i < this.used(); ++i) {
                newIndex[o] = this.index()[i];
                Object newValue = f.apply(ScalaRunTime$.MODULE$.array_apply(this.data(), i));
                if (BoxesRunTime.equals((Object)newValue, newZero)) continue;
                ScalaRunTime$.MODULE$.array_update(newData, o, newValue);
                ++o;
            }
            sparseArray = new SparseArray(newIndex, newData, o, this.length(), newZero);
        } else {
            Object newDefault = f.apply(this.default());
            int[] newIndex = new int[this.length()];
            Object newData = Arrays$.MODULE$.newGenericArray(this.length(), evidence$1);
            int o = 0;
            for (int i = 0; i < this.used(); ++i) {
                while (o < this.index()[i]) {
                    newIndex[o] = o;
                    ScalaRunTime$.MODULE$.array_update(newData, o, newDefault);
                    ++o;
                }
                newIndex[o] = o;
                ScalaRunTime$.MODULE$.array_update(newData, o, f.apply(ScalaRunTime$.MODULE$.array_apply(this.data(), i)));
                ++o;
            }
            while (o < this.length()) {
                newIndex[o] = o;
                ScalaRunTime$.MODULE$.array_update(newData, o, newDefault);
                ++o;
            }
            SparseArray<Object> rv = new SparseArray<Object>(newIndex, newData, o, this.length(), newDefault);
            rv.compact();
            sparseArray = rv;
        }
        return sparseArray;
    }

    public SparseArray<V> filter(Function1<V, Object> f) {
        SparseArray<V> sparseArray;
        int i;
        int[] newIndex = new int[this.used()];
        Object newData = ArrayUtil$.MODULE$.copyOf(this.data(), this.used());
        int o = 0;
        for (i = 0; i < this.used(); ++i) {
            if (!BoxesRunTime.unboxToBoolean((Object)f.apply(ScalaRunTime$.MODULE$.array_apply(this.data(), i)))) continue;
            newIndex[o] = this.index()[i] - (i - o);
            ScalaRunTime$.MODULE$.array_update(newData, o, ScalaRunTime$.MODULE$.array_apply(this.data(), i));
            ++o;
        }
        if (BoxesRunTime.unboxToBoolean((Object)f.apply(this.default()))) {
            int newLength = this.length() - (i - o);
            sparseArray = new SparseArray<V>(newIndex, newData, o, newLength, this.default());
        } else {
            int newLength = o;
            Object object = Predef$.MODULE$.genericArrayOps(newData);
            SparseArray<V> sparseArray2 = new SparseArray<V>(Array$.MODULE$.range(0, newLength), ArrayOps$.MODULE$.take$extension(object, newLength), newLength, newLength, this.default());
            sparseArray = sparseArray2;
        }
        return sparseArray;
    }

    public String toString() {
        return this.iterator().mkString("SparseArray(", ", ", ")");
    }

    @Override
    public int activeSize() {
        return this.used();
    }

    @Override
    public final V valueAt(int i) {
        return (V)ScalaRunTime$.MODULE$.array_apply(this.data(), i);
    }

    @Override
    public final int indexAt(int i) {
        return this.index()[i];
    }

    public boolean contains(int i) {
        return this.findOffset(i) >= 0;
    }

    public final int findOffset(int i) {
        int n;
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException(new StringBuilder(25).append("Index ").append(i).append(" out of bounds [0,").append(this.used()).append(")").toString());
        }
        if (this.used() == 0) {
            n = -1;
        } else {
            int[] index = this.index();
            if (i > index[this.used() - 1]) {
                n = ~this.used();
            } else {
                int result;
                int mi;
                int begin = 0;
                int end = this.used() - 1;
                if (end > i) {
                    end = i;
                }
                boolean found = false;
                int mid = end + begin >> 1;
                int l = this.lastReturnedPos;
                if (l >= 0 && l < end) {
                    mid = l;
                }
                if ((mi = index[mid]) == i) {
                    found = true;
                } else if (mi > i) {
                    end = mid - 1;
                } else {
                    begin = mid + 1;
                }
                if (!found && mid < end) {
                    int mi2 = index[mid + 1];
                    if (mi2 == i) {
                        ++mid;
                        found = true;
                    } else if (mi2 > i) {
                        end = mid;
                    } else {
                        begin = mid + 2;
                    }
                }
                if (!found) {
                    mid = end + begin >> 1;
                }
                while (!found && begin <= end) {
                    if (index[mid] < i) {
                        begin = mid + 1;
                        mid = end + begin >> 1;
                        continue;
                    }
                    if (index[mid] > i) {
                        end = mid - 1;
                        mid = end + begin >> 1;
                        continue;
                    }
                    found = true;
                }
                this.lastReturnedPos = result = found || mid < 0 ? mid : (i <= index[mid] ? ~mid : ~(mid + 1));
                n = result;
            }
        }
        return n;
    }

    @Override
    public final void update(int i, V value) {
        int offset = this.findOffset(i);
        if (offset >= 0) {
            ScalaRunTime$.MODULE$.array_update(this.data(), offset, value);
        } else if (!BoxesRunTime.equals(value, this.default())) {
            int insertPos = ~offset;
            this.used_$eq(this.used() + 1);
            if (this.used() > ScalaRunTime$.MODULE$.array_length(this.data())) {
                int newLength = ScalaRunTime$.MODULE$.array_length(this.data()) == 0 ? 4 : (ScalaRunTime$.MODULE$.array_length(this.data()) < 1024 ? ScalaRunTime$.MODULE$.array_length(this.data()) * 2 : (ScalaRunTime$.MODULE$.array_length(this.data()) < 2048 ? ScalaRunTime$.MODULE$.array_length(this.data()) + 1024 : (ScalaRunTime$.MODULE$.array_length(this.data()) < 4096 ? ScalaRunTime$.MODULE$.array_length(this.data()) + 2048 : (ScalaRunTime$.MODULE$.array_length(this.data()) < 8192 ? ScalaRunTime$.MODULE$.array_length(this.data()) + 4096 : (ScalaRunTime$.MODULE$.array_length(this.data()) < 16384 ? ScalaRunTime$.MODULE$.array_length(this.data()) + 8192 : ScalaRunTime$.MODULE$.array_length(this.data()) + 16384)))));
                int[] newIndex = Arrays.copyOf(this.index(), newLength);
                Object newData = ArrayUtil$.MODULE$.copyOf(this.data(), newLength);
                System.arraycopy(this.index(), insertPos, newIndex, insertPos + 1, this.used() - insertPos - 1);
                System.arraycopy(this.data(), insertPos, newData, insertPos + 1, this.used() - insertPos - 1);
                this.index_$eq(newIndex);
                this.data_$eq(newData);
            } else if (this.used() - insertPos > 1) {
                System.arraycopy(this.index(), insertPos, this.index(), insertPos + 1, this.used() - insertPos - 1);
                System.arraycopy(this.data(), insertPos, this.data(), insertPos + 1, this.used() - insertPos - 1);
            }
            this.index()[insertPos] = i;
            ScalaRunTime$.MODULE$.array_update(this.data(), insertPos, value);
        }
    }

    @Override
    public boolean isActive(int i) {
        return true;
    }

    @Override
    public boolean allVisitableIndicesActive() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void compact() {
        void var2_1;
        int _nz = 0;
        for (int i = 0; i < this.used(); ++i) {
            if (BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(this.data(), i), this.default())) continue;
            ++_nz;
        }
        void nz = var2_1;
        Object newData = ClassTag$.MODULE$.apply(this.data().getClass().getComponentType()).newArray((int)nz);
        int[] newIndex = new int[nz];
        int o = 0;
        for (int i = 0; i < this.used(); ++i) {
            if (BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(this.data(), i), this.default())) continue;
            ScalaRunTime$.MODULE$.array_update(newData, o, ScalaRunTime$.MODULE$.array_apply(this.data(), i));
            newIndex[o] = this.index()[i];
            ++o;
        }
        this.data_$eq(newData);
        this.index_$eq(newIndex);
        this.used_$eq((int)nz);
    }

    public void use(int[] index, Object data, int used) {
        this.index_$eq(index);
        this.data_$eq(data);
        this.used_$eq(used);
    }

    public void reserve(int nnz) {
        if (nnz >= this.used() && nnz != this.index().length) {
            this.index_$eq(Arrays.copyOf(this.index(), nnz));
            this.data_$eq(ArrayUtil$.MODULE$.copyOf(this.data(), nnz));
        }
    }

    public void quickCompact() {
        this.reserve(this.used());
    }

    public SparseArray<V> concatenate(SparseArray<V> that, ClassTag<V> man) {
        if (!BoxesRunTime.equals(this.default(), that.default())) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(61).append("default values should be equal").append(": ").append("this.default.==(that.default)").toString()})));
        }
        Object object = Predef$.MODULE$.intArrayOps(this.index());
        Object object2 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.slice$extension(object, 0, this.used()));
        Object object3 = Predef$.MODULE$.intArrayOps(that.index());
        Object object4 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.slice$extension(object3, 0, super.used()));
        Object object5 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.$plus$plus$extension(object2, ArrayOps$.MODULE$.map$extension(object4, (Function1)(JFunction1.mcII.sp & Serializable)_$1 -> _$1 + this.size(), ClassTag$.MODULE$.apply(Integer.TYPE)), ClassTag$.MODULE$.apply(Integer.TYPE)));
        Object object6 = Predef$.MODULE$.genericArrayOps(this.data());
        Object object7 = Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.slice$extension(object6, 0, this.used()));
        Object object8 = Predef$.MODULE$.genericArrayOps(that.data());
        Object object9 = Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.$plus$plus$extension(object7, ArrayOps$.MODULE$.slice$extension(object8, 0, super.used()), man));
        return new SparseArray<V>((int[])ArrayOps$.MODULE$.toArray$extension(object5, ClassTag$.MODULE$.apply(Integer.TYPE)), ArrayOps$.MODULE$.toArray$extension(object9, man), this.used() + super.used(), this.size() + that.size(), this.default());
    }

    public int hashCode() {
        return ArrayUtil$.MODULE$.zeroSkippingHashCode(this.data(), 0, 1, this.used());
    }

    public boolean equals(Object o) {
        boolean bl;
        Object object = o;
        if (object instanceof SparseArray) {
            SparseArray z = (SparseArray)object;
            if (z.length() != this.length()) {
                bl = false;
            } else if (!BoxesRunTime.equals(z.default(), this.default())) {
                int i = 0;
                int yy = this.length();
                while (i < this.length()) {
                    int n;
                    if (BoxesRunTime.equals(z.apply(n = i++), this.apply(n))) continue;
                    return false;
                }
                bl = true;
            } else if (z.used() < this.used()) {
                SparseArray sparseArray = z;
                SparseArray sparseArray2 = this;
                bl = !(sparseArray != null ? !((Object)sparseArray).equals(sparseArray2) : sparseArray2 != null);
            } else {
                int off = 0;
                int zoff = 0;
                int size = this.used();
                int zsize = z.used();
                while (off < size && zoff < zsize) {
                    if (this.indexAt(off) < z.indexAt(zoff)) {
                        if (!BoxesRunTime.equals(this.valueAt(off), this.default())) {
                            return false;
                        }
                        ++off;
                        continue;
                    }
                    if (z.indexAt(zoff) < this.indexAt(off)) {
                        if (!BoxesRunTime.equals(z.valueAt(zoff), this.default())) {
                            return false;
                        }
                        ++zoff;
                        continue;
                    }
                    if (!BoxesRunTime.equals(z.valueAt(zoff), this.valueAt(off))) {
                        return false;
                    }
                    ++off;
                    ++zoff;
                }
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

