/*
 * Decompiled with CFR 0.152.
 */
package breeze.collection.mutable;

import breeze.collection.mutable.Beam$;
import breeze.collection.mutable.Beam$Added$;
import breeze.collection.mutable.Beam$NotAdded$;
import breeze.collection.mutable.IBeam;
import breeze.linalg.clip$;
import breeze.linalg.support.CanMapValues$;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import scala.Product;
import scala.collection.BuildFrom;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Cloneable;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Shrinkable;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public class Beam<T>
implements IBeam<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int maxSize;
    private final Ordering ordering;
    private final PriorityQueue queue;

    public static BeamResult<Nothing$> NothingEvicted() {
        return Beam$.MODULE$.NothingEvicted();
    }

    public static <T> Beam<T> apply(int n, Seq<T> seq, Ordering<T> ordering) {
        return Beam$.MODULE$.apply(n, seq, ordering);
    }

    public static <T, U> BuildFrom<Beam<T>, U, Beam<U>> canBuildFrom(Ordering<U> ordering) {
        return Beam$.MODULE$.canBuildFrom(ordering);
    }

    public Beam(int maxSize, Ordering<T> ordering) {
        this.maxSize = maxSize;
        this.ordering = ordering;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        Growable.$init$((Growable)this);
        Builder.$init$((Builder)this);
        Shrinkable.$init$((Shrinkable)this);
        Cloneable.$init$((Cloneable)this);
        if (maxSize < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.queue = new PriorityQueue<T>(BoxesRunTime.unboxToInt((Object)clip$.MODULE$.apply(BoxesRunTime.boxToInteger((int)maxSize), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)16), clip$.MODULE$.clipOrdering(Ordering.Int$.MODULE$, CanMapValues$.MODULE$.canMapSelfInt()))), ordering);
    }

    public Object scala$collection$mutable$Cloneable$$super$clone() {
        return super.clone();
    }

    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public Ordering<T> ordering() {
        return this.ordering;
    }

    public PriorityQueue<T> queue() {
        return this.queue;
    }

    public int size() {
        return this.queue().size();
    }

    public T min() {
        if (this.queue().isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.queue().peek();
    }

    @Override
    public Beam addOne(T x) {
        Boolean bl;
        if (this.queue().size() < this.maxSize()) {
            bl = BoxesRunTime.boxToBoolean((boolean)this.queue().add(x));
        } else if (this.maxSize() > 0 && this.ordering().compare(this.min(), x) < 0) {
            this.queue().poll();
            this.queue().add(x);
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxedUnit.UNIT;
        }
        return this;
    }

    public Beam subtractOne(T elem) {
        this.queue().remove(elem);
        return this;
    }

    @Override
    public BeamResult<T> checkedAdd(T x) {
        BeamResult<Nothing$> beamResult;
        if (this.queue().size() < this.maxSize()) {
            this.queue().add(x);
            beamResult = Beam$.MODULE$.NothingEvicted();
        } else {
            Product product2;
            if (this.maxSize() > 0 && this.ordering().compare(this.min(), x) < 0) {
                T r = this.queue().poll();
                this.queue().add(x);
                product2 = Beam$Added$.MODULE$.apply((Iterable)Iterable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{r})));
            } else {
                product2 = Beam$NotAdded$.MODULE$;
            }
            beamResult = product2;
        }
        return beamResult;
    }

    public Iterator<T> iterator() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.queue().iterator()).asScala();
    }

    public String toString() {
        return this.iterator().mkString("Beam(", ",", ")");
    }

    public void clear() {
        this.queue().clear();
    }

    public IndexedSeq<T> result() {
        ArrayBuffer r = new ArrayBuffer();
        while (!this.queue().isEmpty()) {
            r.$plus$eq(this.queue().poll());
        }
        return (ArrayBuffer)r.reverse();
    }

    public boolean equals(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof Beam) {
            Beam x = (Beam)object;
            bl = this.maxSize() == x.maxSize() && this.iterator().sameElements(x.iterator());
        } else {
            bl = false;
        }
        return bl;
    }

    public Beam<T> clone() {
        return (Beam)new Beam<T>(this.maxSize(), this.ordering()).$plus$plus$eq((IterableOnce)this.iterator());
    }

    @Override
    public Builder<T, Beam<T>> newSpecificBuilder() {
        return Beam$.MODULE$.canBuildFrom(this.ordering()).newBuilder((Object)this);
    }

    @Override
    public Beam<T> fromSpecific(IterableOnce<T> coll) {
        return (Beam)Beam$.MODULE$.canBuildFrom(this.ordering()).fromSpecific((Object)this, coll);
    }

    @Override
    public Beam<T> empty() {
        return Beam$.MODULE$.apply(this.maxSize(), ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), this.ordering());
    }

    public static class Added<T>
    implements BeamResult<T>,
    Product,
    Serializable {
        private final Iterable deleted;

        public static <T> Added<T> apply(Iterable<T> iterable) {
            return Beam$Added$.MODULE$.apply(iterable);
        }

        public static Added<?> fromProduct(Product product2) {
            return Beam$Added$.MODULE$.fromProduct(product2);
        }

        public static <T> Added<T> unapply(Added<T> added) {
            return Beam$Added$.MODULE$.unapply(added);
        }

        public Added(Iterable<T> deleted) {
            this.deleted = deleted;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Added)) return false;
            Added added = (Added)object;
            Iterable<T> iterable = this.deleted();
            Iterable<T> iterable2 = added.deleted();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            if (!added.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Added;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Added";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "deleted";
        }

        @Override
        public Iterable<T> deleted() {
            return this.deleted;
        }

        public <T> Added<T> copy(Iterable<T> deleted) {
            return new Added<T>(deleted);
        }

        public <T> Iterable<T> copy$default$1() {
            return this.deleted();
        }

        public Iterable<T> _1() {
            return this.deleted();
        }
    }

    public static interface BeamResult<T> {
        public Iterable<T> deleted();
    }
}

