/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.difflib;

import java.util.ArrayList;
import java.util.List;
import munit.internal.difflib.ChangeDelta;
import munit.internal.difflib.Chunk;
import munit.internal.difflib.DeleteDelta;
import munit.internal.difflib.Delta;
import munit.internal.difflib.DiffAlgorithm;
import munit.internal.difflib.DiffNode;
import munit.internal.difflib.DifferentiationFailedException;
import munit.internal.difflib.Equalizer;
import munit.internal.difflib.Equalizer$;
import munit.internal.difflib.InsertDelta;
import munit.internal.difflib.Patch;
import munit.internal.difflib.PathNode;
import munit.internal.difflib.Snake;

public class MyersDiff<T>
implements DiffAlgorithm<T> {
    private final Equalizer<T> equalizer;

    public MyersDiff(Equalizer<T> equalizer) {
        this.equalizer = equalizer;
    }

    public MyersDiff() {
        this(Equalizer$.MODULE$.default());
    }

    @Override
    public Patch<T> diff(List<T> original, List<T> revised) {
        Patch patch;
        try {
            patch = this.buildRevision(this.buildPath(original, revised), original, revised);
        }
        catch (DifferentiationFailedException e) {
            e.printStackTrace();
            patch = new Patch();
        }
        return patch;
    }

    private Patch<T> buildRevision(PathNode _path, List<T> orig, List<T> rev) {
        PathNode path = _path;
        Patch<T> patch = new Patch<T>();
        if (path.isSnake()) {
            path = path.prev();
        }
        while (path != null && path.prev() != null && path.prev().j() >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.i();
            int j = path.j();
            path = path.prev();
            int ianchor = path.i();
            int janchor = path.j();
            Chunk<T> original = new Chunk<T>(ianchor, this.copyOfRange(orig, ianchor, i));
            Chunk<T> revised = new Chunk<T>(janchor, this.copyOfRange(rev, janchor, j));
            Delta delta = original.size() == 0 && revised.size() != 0 ? new InsertDelta<T>(original, revised) : (original.size() > 0 && revised.size() == 0 ? new DeleteDelta<T>(original, revised) : new ChangeDelta<T>(original, revised));
            patch.addDelta(delta);
            if (!path.isSnake()) continue;
            path = path.prev();
        }
        return patch;
    }

    private ArrayList<T> copyOfRange(List<T> original, int fromIndex, int to) {
        return new ArrayList<T>(original.subList(fromIndex, to));
    }

    public PathNode buildPath(List<T> orig, List<T> rev) {
        int N = orig.size();
        int M = rev.size();
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        for (int d = 0; d < MAX; ++d) {
            for (int k = -d; k <= d; k += 2) {
                int j;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                int i = 0;
                if (k == -d || k != d && diagonal[kminus].i() < diagonal[kplus].i()) {
                    i = diagonal[kplus].i();
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].i() + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = new DiffNode(i, j, prev);
                for (j = i - k; i < N && j < M && this.equalizer.equals(orig.get(i), rev.get(j)); ++i, ++j) {
                }
                if (i > node.i()) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i < N || j < M) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d - 1] = null;
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }
}

