/*
 * Decompiled with CFR 0.152.
 */
package munit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import munit.Location;
import munit.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;

public final class Test
implements Serializable {
    private final String name;
    private final Function0 body;
    private final Set tags;
    private final Location location;

    public Test(String name, Function0<Future<Object>> body, Set<Tag> tags, Location location) {
        this.name = name;
        this.body = body;
        this.tags = tags;
        this.location = location;
    }

    public String name() {
        return this.name;
    }

    public Function0<Future<Object>> body() {
        return this.body;
    }

    public Set<Tag> tags() {
        return this.tags;
    }

    public Location location() {
        return this.location;
    }

    public Test(String name, Function0<Future<Object>> body, Location loc) {
        this(name, body, (Set<Tag>)Predef$.MODULE$.Set().empty(), loc);
    }

    public Test withName(String newName) {
        return this.copy(newName, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public Test withBody(Function0<Future<Object>> newBody) {
        return this.copy(this.copy$default$1(), newBody, this.copy$default$3(), this.copy$default$4());
    }

    public Test withTags(Set<Tag> newTags) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), newTags, this.copy$default$4());
    }

    public Test tag(Tag newTag) {
        return this.withTags((Set<Tag>)((Set)this.tags().$plus((Object)newTag)));
    }

    public Test withLocation(Location newLocation) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newLocation);
    }

    public Test withBodyMap(Function1<Future<Object>, Future<Object>> newBody) {
        return this.withBody((Function0<Future<Object>>)(Function0 & Serializable)() -> (Future)newBody.apply(this.body().apply()));
    }

    private <A> Test copy(String name, Function0<Future<Object>> body, Set<Tag> tags, Location location) {
        return new Test(name, body, tags, location);
    }

    private <A> String copy$default$1() {
        return this.name();
    }

    private <A> Function0<Future<Object>> copy$default$2() {
        return this.body();
    }

    private <A> Set<Tag> copy$default$3() {
        return this.tags();
    }

    private <A> Location copy$default$4() {
        return this.location();
    }

    public String toString() {
        return new StringBuilder(10).append("Test(").append(this.name()).append(", ").append(this.tags()).append(", ").append(this.location()).append(")").toString();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public Annotation[] annotations() {
        ArrayBuffer buf = new ArrayBuffer(this.tags().size() + 1);
        buf.$plus$plus$eq(this.tags());
        buf.$plus$eq((Object)this.location());
        return (Annotation[])buf.toArray(ClassTag$.MODULE$.apply(Annotation.class));
    }
}

