/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.lang.annotation.Annotation;
import java.util.Set;
import munit.internal.junitinterface.Tag;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class TagFilter
extends Filter {
    final Set<String> includeTags;
    final Set<String> excludeTags;

    public TagFilter(Set<String> set, Set<String> set2) {
        this.includeTags = set;
        this.excludeTags = set2;
    }

    public boolean shouldRun(Description description) {
        if (this.includeTags.isEmpty() && this.excludeTags.isEmpty()) {
            return true;
        }
        boolean bl = this.includeTags.isEmpty();
        for (Annotation annotation : description.getAnnotations()) {
            if (!(annotation instanceof Tag)) continue;
            Tag tag = (Tag)((Object)annotation);
            boolean bl2 = bl = bl || this.includeTags.contains(tag.value());
            boolean bl3 = this.excludeTags.contains(tag.value());
            if (!bl3) continue;
            return false;
        }
        return bl;
    }

    public String toString() {
        return "TagFilter{includeTags=" + this.includeTags + ", excludeTags=" + this.excludeTags + '}';
    }

    public String describe() {
        return this.toString();
    }
}

