/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import munit.internal.junitinterface.Ansi;
import munit.internal.junitinterface.JUnitRunner;
import munit.internal.junitinterface.RunSettings;
import sbt.testing.Logger;

final class RichLogger {
    private final Logger[] loggers;
    private final RunSettings settings;
    private final JUnitRunner runner;
    private final String testClassName;
    private final Map<String, Boolean> highlightedCache = new HashMap<String, Boolean>();
    private final ConcurrentLinkedDeque<String> buffer = new ConcurrentLinkedDeque();

    RichLogger(Logger[] loggerArray, RunSettings runSettings, String string, JUnitRunner jUnitRunner) {
        this.loggers = loggerArray;
        this.settings = runSettings;
        this.runner = jUnitRunner;
        this.testClassName = string;
    }

    void error(String string) {
        if (this.settings.useSbtLoggers) {
            for (Logger logger : this.loggers) {
                if (this.settings.color && logger.ansiCodesSupported()) {
                    logger.error(string);
                    continue;
                }
                logger.error(Ansi.filterAnsi(string));
            }
        } else if (this.settings.useBufferedLoggers) {
            this.bufferMessage(string);
        } else {
            System.out.println(string);
        }
    }

    void error(String string, Throwable throwable) {
        this.error(string);
        if (throwable != null && (this.settings.logAssert || !(throwable instanceof AssertionError))) {
            this.logStackTrace(throwable);
        }
    }

    void info(String string) {
        if (this.settings.useSbtLoggers) {
            for (Logger logger : this.loggers) {
                if (this.settings.color && logger.ansiCodesSupported()) {
                    logger.info(string);
                    continue;
                }
                logger.info(Ansi.filterAnsi(string));
            }
        } else if (this.settings.useBufferedLoggers) {
            this.bufferMessage(string);
        } else {
            System.out.println(string);
        }
    }

    void warn(String string) {
        if (this.settings.useSbtLoggers) {
            for (Logger logger : this.loggers) {
                if (this.settings.color && logger.ansiCodesSupported()) {
                    logger.warn(string);
                    continue;
                }
                logger.warn(Ansi.filterAnsi(string));
            }
        } else if (this.settings.useBufferedLoggers) {
            this.bufferMessage(string);
        } else {
            System.out.println(string);
        }
    }

    void flush() {
        if (!this.buffer.isEmpty()) {
            System.out.println(String.join((CharSequence)"\n", this.buffer));
            this.buffer.clear();
        }
    }

    private void bufferMessage(String string) {
        this.buffer.addLast(string);
    }

    private void logStackTrace(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string = this.settings.color ? this.findTestFileName(stackTraceElementArray, this.testClassName) : null;
        this.logStackTracePart(stackTraceElementArray, stackTraceElementArray.length - 1, 0, throwable, string);
    }

    private void logStackTracePart(StackTraceElement[] stackTraceElementArray, int n, int n2, Throwable throwable, String string) {
        int n3;
        int n4;
        int n5 = n;
        for (n4 = n3 = 0; n4 <= n; ++n4) {
            String string2;
            if (!stackTraceElementArray[n4].toString().startsWith("org.junit.") && !stackTraceElementArray[n4].toString().startsWith("org.hamcrest.") && !stackTraceElementArray[n4].toString().startsWith("org.scalatest.")) continue;
            if (n4 == n3) {
                ++n3;
                continue;
            }
            for (n = n4 - 1; n > n3 && ((string2 = stackTraceElementArray[n].toString()).startsWith("java.lang.reflect.") || string2.startsWith("sun.reflect.")); --n) {
            }
            break;
        }
        for (n4 = n3; n4 <= n; ++n4) {
            if (stackTraceElementArray[n4].getClassName().startsWith("scala.runtime.")) continue;
            this.error(this.stackTraceElementToString(stackTraceElementArray[n4], string));
        }
        if (n5 != n) {
            this.error("    ...");
        } else if (n2 != 0) {
            this.error("    ... " + n2 + " more");
        }
        this.logStackTraceAsCause(stackTraceElementArray, throwable.getCause(), string);
    }

    private void logStackTraceAsCause(StackTraceElement[] stackTraceElementArray, Throwable throwable, String string) {
        if (throwable == null) {
            return;
        }
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        this.error("Caused by: " + throwable);
        this.logStackTracePart(stackTraceElementArray2, n, stackTraceElementArray2.length - 1 - n, throwable, string);
    }

    private String findTestFileName(StackTraceElement[] stackTraceElementArray, String string) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string2 = stackTraceElement.getClassName();
            if (!string.equals(string2)) continue;
            return stackTraceElement.getFileName();
        }
        return null;
    }

    private boolean isHighlightedCached(String string2) {
        return this.highlightedCache.computeIfAbsent(string2, string -> this.isHighlighted((String)string));
    }

    private boolean isHighlighted(String string) {
        try {
            int n = string.lastIndexOf(46);
            String string2 = string.substring(0, n + 1).replace('.', '/');
            URL uRL = this.runner.testClassLoader.getResource(string2);
            return uRL.getProtocol().equals("file");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String stackTraceElementToString(StackTraceElement stackTraceElement, String string) {
        boolean bl = this.settings.color && (this.testClassName.equals(stackTraceElement.getClassName()) || string != null && string.equals(stackTraceElement.getFileName()) || this.isHighlightedCached(stackTraceElement.getClassName()));
        String string2 = bl ? "\u001b[1m" : "\u001b[90m";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Ansi.c("    at ", string2));
        stringBuilder.append(Ansi.c(this.settings.decodeName(stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName()), string2));
        stringBuilder.append(Ansi.c("(", string2));
        if (stackTraceElement.isNativeMethod()) {
            stringBuilder.append(Ansi.c("Native Method", string2));
        } else if (stackTraceElement.getFileName() == null) {
            stringBuilder.append(Ansi.c("Unknown Source", string2));
        } else {
            stringBuilder.append(Ansi.c(stackTraceElement.getFileName(), string2));
            if (stackTraceElement.getLineNumber() >= 0) {
                stringBuilder.append(':').append(Ansi.c(String.valueOf(stackTraceElement.getLineNumber()), string2));
            }
        }
        return stringBuilder.append(Ansi.c(")", string2)).toString();
    }
}

