/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class StreamLogger
extends Thread {
    private static final String LS = System.getProperty("line.separator");
    private static final boolean emacsMode = StringUtils.isNotEmpty((String)System.getProperty("emacsMode"));
    private InputStream in_;
    private Log log_;
    private boolean isErr_;
    private PrintWriter out_;

    public StreamLogger(InputStream in, Log log, boolean isErr) {
        this.in_ = in;
        this.log_ = log;
        this.isErr_ = isErr;
    }

    public void run() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.in_));
            String line = null;
            StringBuilder sb = null;
            while ((line = reader.readLine()) != null) {
                if (this.isErr_) {
                    if (!emacsMode) {
                        this.log_.warn((CharSequence)line);
                        continue;
                    }
                    if (sb == null) {
                        sb = new StringBuilder("Compilation failure" + LS);
                    }
                    sb.append(LS + line);
                    continue;
                }
                this.log_.info((CharSequence)line);
            }
            if (sb != null) {
                this.log_.warn((CharSequence)sb.toString());
            }
        }
        catch (IOException exc) {
            try {
                throw new RuntimeException("wrap: " + exc.getMessage(), exc);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                IOUtil.close((InputStream)this.in_);
                IOUtil.close((Writer)this.out_);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        IOUtil.close((InputStream)this.in_);
        IOUtil.close((Writer)this.out_);
    }
}

