/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.javac;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import sbt.internal.inc.javac.ClassFinder;
import sbt.internal.inc.javac.Classes;
import sbt.internal.inc.javac.Classes$empty$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.util.control.NonFatal$;

public class JarClassFinder
implements ClassFinder {
    private final Path jar;

    public JarClassFinder(Path jar) {
        this.jar = jar;
    }

    @Override
    public Classes classes() {
        if (Files.exists(this.jar, new LinkOption[0])) {
            JarClasses jarClasses;
            FileSystem jarFs = FileSystems.newFileSystem(this.jar, null);
            try (Stream<Path> stream = Files.find(jarFs.getRootDirectories().iterator().next(), Integer.MAX_VALUE, (path, _$2) -> path.toString().endsWith(".class"), new FileVisitOption[0]);){
                Builder builder = package$.MODULE$.Seq().newBuilder();
                stream.forEachOrdered(a -> builder.$plus$eq(a));
                jarClasses = new JarClasses(this, (Seq<Path>)((Seq)builder.result()), jarFs);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    jarFs.close();
                    throw t;
                }
                throw throwable;
            }
            return jarClasses;
        }
        return Classes$empty$.MODULE$;
    }

    public class JarClasses
    implements Classes {
        private final Seq<Path> paths;
        private final FileSystem fs;
        private final /* synthetic */ JarClassFinder $outer;

        public JarClasses(JarClassFinder $outer, Seq<Path> paths, FileSystem fs) {
            this.paths = paths;
            this.fs = fs;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Seq<Path> paths() {
            return this.paths;
        }

        @Override
        public void close() {
            this.fs.close();
            Classes.close$(this);
        }

        public final /* synthetic */ JarClassFinder sbt$internal$inc$javac$JarClassFinder$JarClasses$$$outer() {
            return this.$outer;
        }
    }
}

