/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.caching;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.ConcurrentHashMap;
import sbt.internal.inc.Stamper$;
import sbt.io.IO$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.parallel.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;
import xsbti.compile.FileHash;
import xsbti.compile.analysis.Stamp;

public final class ClasspathCache$
implements Serializable {
    private static final boolean jdkTimestamps;
    private static final ConcurrentHashMap<Path, Tuple2<Tuple2<FileTime, Object>, FileHash>> cacheMetadataJar;
    public static final ClasspathCache$ MODULE$;

    private ClasspathCache$() {
    }

    static {
        boolean bl;
        MODULE$ = new ClasspathCache$();
        String string = System.getProperty("sbt.io.jdktimestamps");
        if (string == null) {
            String string2 = System.getProperty("java.specification.version");
            if (string2 == null) {
                bl = false;
            } else {
                String sv = string2;
                try {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])sv.split("\\."));
                    if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.last$extension(object))) >= 10) {
                        bl = true;
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                        bl = false;
                    }
                    throw throwable;
                }
            }
        } else {
            String p = string;
            String string3 = p.toLowerCase();
            String string4 = "false";
            bl = string3 == null ? string4 != null : !string3.equals(string4);
        }
        jdkTimestamps = bl;
        cacheMetadataJar = new ConcurrentHashMap();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClasspathCache$.class);
    }

    private FileHash emptyFileHash(Path file) {
        return FileHash.of((Path)file, (int)42);
    }

    private FileHash genFileHash(Path file, Tuple2<FileTime, Object> metadata) {
        FileHash newHash = FileHash.of((Path)file, (int)((Stamp)Stamper$.MODULE$.forFarmHashP().apply((Object)file)).getValueId());
        cacheMetadataJar.put(file, (Tuple2<Tuple2<FileTime, Object>, FileHash>)Tuple2$.MODULE$.apply(metadata, (Object)newHash));
        return newHash;
    }

    public FileHash[] hashClasspath(Seq<Path> classpath) {
        return (FileHash[])package$.MODULE$.CollectionsHaveToParArray(classpath, Predef$.MODULE$.$conforms()).toParArray().map((Function1 & Serializable)file -> this.fromCacheOrHash$1((Path)file)).toArray(ClassTag$.MODULE$.apply(FileHash.class));
    }

    private final FileHash fromCacheOrHash$1(Path file) {
        FileHash fileHash;
        block5: {
            try {
                Tuple2 tuple2;
                BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                if (attrs.isDirectory()) {
                    fileHash = this.emptyFileHash(file);
                    break block5;
                }
                FileTime lastModified = jdkTimestamps ? attrs.lastModifiedTime() : FileTime.fromMillis(IO$.MODULE$.getModifiedTimeOrZero(file.toFile()));
                Tuple2 currentMetadata = Tuple2$.MODULE$.apply((Object)lastModified, (Object)BoxesRunTime.boxToLong((long)attrs.size()));
                Option option = Option$.MODULE$.apply(cacheMetadataJar.get(file));
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Tuple2 metadata = (Tuple2)tuple2._1();
                    FileHash hashHit = (FileHash)tuple2._2();
                    Tuple2 tuple22 = metadata;
                    Tuple2 tuple23 = currentMetadata;
                    if (!(tuple22 != null ? !tuple22.equals(tuple23) : tuple23 != null)) {
                        fileHash = hashHit;
                        break block5;
                    }
                }
                fileHash = this.genFileHash(file, (Tuple2<FileTime, Object>)currentMetadata);
            }
            catch (NoSuchFileException noSuchFileException) {
                fileHash = this.emptyFileHash(file);
            }
        }
        return fileHash;
    }
}

