/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.scripted;

import java.io.File;
import java.io.Serializable;
import java.net.SocketException;
import sbt.internal.io.Resources;
import sbt.internal.scripted.HandlersProvider;
import sbt.internal.scripted.PendingTestSuccessException;
import sbt.internal.scripted.ScriptConfig;
import sbt.internal.scripted.ScriptRunner;
import sbt.internal.scripted.TestException;
import sbt.internal.scripted.TestScriptParser;
import sbt.internal.util.Appender;
import sbt.internal.util.BufferedAppender;
import sbt.internal.util.BufferedAppender$;
import sbt.internal.util.ConsoleAppender$;
import sbt.internal.util.ManagedLogger;
import sbt.io.FileFilter;
import sbt.io.FileFilter$;
import sbt.io.syntax$;
import sbt.util.Level$;
import sbt.util.Logger$;
import sbt.util.LoggerContext;
import sbt.util.LoggerContext$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import xsbti.Logger;

public final class ScriptedTests {
    private final File resourceBaseDirectory;
    private final boolean bufferLog;
    private final HandlersProvider handlersProvider;
    private final boolean stripQuotes;
    private final Resources testResources;
    private final Appender appender;
    private final String ScriptFilename;
    private final String PendingScriptFilename;

    public ScriptedTests(File resourceBaseDirectory, boolean bufferLog, HandlersProvider handlersProvider, boolean stripQuotes) {
        this.resourceBaseDirectory = resourceBaseDirectory;
        this.bufferLog = bufferLog;
        this.handlersProvider = handlersProvider;
        this.stripQuotes = stripQuotes;
        this.testResources = new Resources(resourceBaseDirectory);
        this.appender = ConsoleAppender$.MODULE$.apply();
        this.ScriptFilename = "test";
        this.PendingScriptFilename = "pending";
    }

    public ScriptedTests(File resourceBaseDirectory, boolean bufferLog, HandlersProvider handlersProvider) {
        this(resourceBaseDirectory, bufferLog, handlersProvider, true);
    }

    public String ScriptFilename() {
        return this.ScriptFilename;
    }

    public String PendingScriptFilename() {
        return this.PendingScriptFilename;
    }

    public Seq<Function0<Option<String>>> scriptedTest(String group, String name, Logger log) {
        while (true) {
            log = Logger$.MODULE$.xlog2Log(log);
        }
    }

    public Seq<Function0<Option<String>>> scriptedTest(String group, String name, ManagedLogger log) {
        return this.scriptedTest(group, name, (Function1<File, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> {}, log, LoggerContext$.MODULE$.globalContext());
    }

    public Seq<Function0<Option<String>>> scriptedTest(String group, String name, ManagedLogger log, LoggerContext context) {
        return this.scriptedTest(group, name, (Function1<File, BoxedUnit>)(JProcedure1 & Serializable)_$4 -> {}, log, context);
    }

    public Seq<Function0<Option<String>>> scriptedTest(String group, String name, Function1<File, BoxedUnit> prescripted, ManagedLogger log) {
        return this.scriptedTest(group, name, prescripted, log, LoggerContext$.MODULE$.globalContext());
    }

    public Seq<Function0<Option<String>>> scriptedTest(String group, String name, Function1<File, BoxedUnit> prescripted, ManagedLogger log, LoggerContext context) {
        return (Seq)syntax$.MODULE$.singleFileFinder(this.resourceBaseDirectory).$times((FileFilter)FileFilter$.MODULE$.globFilter(group)).get().flatMap((Function1 & Serializable)groupDir -> (IterableOnce)syntax$.MODULE$.singleFileFinder(groupDir).$times((FileFilter)FileFilter$.MODULE$.globFilter(name)).get().map((Function1 & Serializable)nme -> {
            String g = groupDir.getName();
            String n = nme.getName();
            String str = new StringBuilder(3).append(g).append(" / ").append(n).toString();
            return (Function0 & Serializable)() -> {
                Predef$.MODULE$.println((Object)new StringBuilder(8).append("Running ").append(str).toString());
                return (Option)this.testResources.readWriteResourceDirectory(g, n, (Function1 & Serializable)testDirectory -> {
                    None$ none$;
                    boolean disabled = new File((File)testDirectory, "disabled").isFile();
                    if (disabled) {
                        log.info(() -> ScriptedTests.scriptedTest$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(str));
                        return None$.MODULE$;
                    }
                    try {
                        this.scriptedTest(str, (File)testDirectory, prescripted, log, context);
                        none$ = None$.MODULE$;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof TestException || throwable2 instanceof PendingTestSuccessException) {
                            none$ = Some$.MODULE$.apply((Object)str);
                        }
                        throw throwable;
                    }
                    return none$;
                });
            };
        }));
    }

    private void scriptedTest(String label, File testDirectory, Function1<File, BoxedUnit> prescripted, ManagedLogger log, LoggerContext context) {
        BufferedAppender buffered = BufferedAppender$.MODULE$.apply(this.appender);
        context.clearAppenders(log.name());
        BufferedAppender bufferedAppender = (BufferedAppender)Predef$.MODULE$.ArrowAssoc((Object)buffered);
        context.addAppender(log.name(), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bufferedAppender, (Object)Level$.MODULE$.Debug()));
        if (this.bufferLog) {
            buffered.record();
        }
        File normal = new File(testDirectory, this.ScriptFilename());
        File pending = new File(testDirectory, this.PendingScriptFilename());
        Tuple2 tuple2 = pending.isFile() ? Tuple2$.MODULE$.apply((Object)pending, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : Tuple2$.MODULE$.apply((Object)normal, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        File file = (File)tuple2._1();
        boolean pending2 = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
        String pendingString = pending2 ? " [PENDING]" : "";
        try {
            try {
                prescripted.apply((Object)testDirectory);
                this.runTest$1(file, label, testDirectory, log);
                log.info(() -> ScriptedTests.scriptedTest$$anonfun$4(label, pendingString));
                if (pending2) {
                    throw new PendingTestSuccessException(label);
                }
            }
            catch (TestException e) {
                ScriptedTests.testFailed$1(pending2, buffered, log, label, pendingString);
                Throwable throwable = e.getCause();
                if (throwable == null || throwable instanceof SocketException) {
                    log.error(() -> ScriptedTests.scriptedTest$$anonfun$5(e));
                } else if (!pending2) {
                    e.printStackTrace();
                }
                if (!pending2) {
                    throw e;
                }
            }
            catch (PendingTestSuccessException e) {
                ScriptedTests.testFailed$1(pending2, buffered, log, label, pendingString);
                log.error(ScriptedTests::scriptedTest$$anonfun$6);
                throw e;
            }
            catch (Exception e) {
                ScriptedTests.testFailed$1(pending2, buffered, log, label, pendingString);
                if (!pending2) {
                    throw e;
                }
            }
        }
        finally {
            buffered.clearBuffer();
        }
    }

    private static final String scriptedTest$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String str$3) {
        return new StringBuilder(13).append("D ").append(str$3).append(" [DISABLED]").toString();
    }

    private final TestScriptParser createParser$1(String label$1, File testDirectory$1, ManagedLogger log$5) {
        ScriptConfig scriptConfig = new ScriptConfig(label$1, testDirectory$1, (Logger)log$5);
        return new TestScriptParser(this.handlersProvider.getHandlers(scriptConfig));
    }

    private final void runTest$1(File file$1, String label$2, File testDirectory$2, ManagedLogger log$6) {
        ScriptRunner run = new ScriptRunner();
        TestScriptParser parser = this.createParser$1(label$2, testDirectory$2, log$6);
        run.apply(parser.parse(file$1, this.stripQuotes));
    }

    private static final String testFailed$1$$anonfun$1(String label$4, String pendingString$2) {
        return new StringBuilder(2).append("x ").append(label$4).append(pendingString$2).toString();
    }

    private static final void testFailed$1(boolean pending$1, BufferedAppender buffered$1, ManagedLogger log$7, String label$3, String pendingString$1) {
        if (pending$1) {
            buffered$1.clearBuffer();
        } else {
            buffered$1.stopBuffer();
        }
        log$7.error(() -> ScriptedTests.testFailed$1$$anonfun$1(label$3, pendingString$1));
    }

    private static final String scriptedTest$$anonfun$4(String label$5, String pendingString$3) {
        return new StringBuilder(2).append("+ ").append(label$5).append(pendingString$3).toString();
    }

    private static final String scriptedTest$$anonfun$5(TestException e$1) {
        return new StringBuilder(3).append("   ").append(e$1.getMessage()).toString();
    }

    private static final String scriptedTest$$anonfun$6() {
        return "  Mark as passing to remove this failure.";
    }
}

