/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.scripted;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import sbt.internal.scripted.HandlersProvider;
import sbt.internal.scripted.ListTests;
import sbt.internal.scripted.ScriptedTest;
import sbt.internal.scripted.ScriptedTest$;
import sbt.internal.scripted.ScriptedTests;
import sbt.internal.util.ManagedLogger;
import sbt.util.Logger;
import sbt.util.LoggerContext;
import sbt.util.LoggerContext$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.package$;

public final class ScriptedRunnerImpl$
implements Serializable {
    private static final AtomicInteger generateId;
    public static final ScriptedRunnerImpl$ MODULE$;

    private ScriptedRunnerImpl$() {
    }

    static {
        MODULE$ = new ScriptedRunnerImpl$();
        generateId = new AtomicInteger();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScriptedRunnerImpl$.class);
    }

    public void run(File resourceBaseDirectory, boolean bufferLog, String[] tests, HandlersProvider handlersProvider) {
        LoggerContext.LoggerContextImpl context = LoggerContext$.MODULE$.apply();
        ScriptedTests runner = new ScriptedTests(resourceBaseDirectory, bufferLog, handlersProvider);
        ManagedLogger logger = this.newLogger((LoggerContext)context);
        Object object = Predef$.MODULE$.refArrayOps((Object[])tests);
        Seq allTests = (Seq)this.get((Seq<String>)ArrayOps$.MODULE$.toSeq$extension(object), resourceBaseDirectory, logger).flatMap((Function1 & Serializable)x$1 -> {
            ScriptedTest scriptedTest = x$1;
            if (scriptedTest != null) {
                ScriptedTest scriptedTest2 = ScriptedTest$.MODULE$.unapply(scriptedTest);
                String string = scriptedTest2._1();
                String string2 = scriptedTest2._2();
                String group = string;
                String name = string2;
                return runner.scriptedTest(group, name, logger, (LoggerContext)context);
            }
            throw new MatchError((Object)scriptedTest);
        });
        this.runAll((Seq<Function0<Option<String>>>)allTests);
    }

    public void runAll(Seq<Function0<Option<String>>> tests) {
        Seq errors = (Seq)tests.flatMap((Function1 & Serializable)test -> ((Option)test.apply()).map((Function1 & Serializable)err -> err));
        if (errors.nonEmpty()) {
            throw package$.MODULE$.error(errors.mkString("Failed tests:\n\t", "\n\t", "\n"));
        }
    }

    public Seq<ScriptedTest> get(Seq<String> tests, File baseDirectory, ManagedLogger log) {
        if (tests.isEmpty()) {
            return this.listTests(baseDirectory, log);
        }
        return this.parseTests(tests);
    }

    public Seq<ScriptedTest> listTests(File baseDirectory, ManagedLogger log) {
        return new ListTests(baseDirectory, (Function1<ScriptedTest, Object>)(Function1 & Serializable)_$1 -> true, (Logger)log).listTests();
    }

    public Seq<ScriptedTest> parseTests(Seq<String> in) {
        return (Seq)in.map((Function1 & Serializable)testString -> {
            Object object;
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])testString.split("/"));
            String[] stringArray = (String[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$2 -> _$2.trim(), ClassTag$.MODULE$.apply(String.class));
            if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String group = string;
            String name = string2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)group, (Object)name);
            String group2 = (String)tuple2._1();
            String name2 = (String)tuple2._2();
            return ScriptedTest$.MODULE$.apply(group2, name2);
        });
    }

    public AtomicInteger generateId() {
        return generateId;
    }

    public ManagedLogger newLogger(LoggerContext context) {
        String loggerName = new StringBuilder(9).append("scripted-").append(this.generateId().incrementAndGet()).toString();
        return context.logger(loggerName, (Option)None$.MODULE$, (Option)None$.MODULE$);
    }
}

