/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.scripted;

import java.io.Serializable;
import sbt.internal.scripted.Statement;
import sbt.internal.scripted.StatementHandler;
import sbt.internal.scripted.TestException;
import sbt.internal.scripted.TestFailed;
import scala.Function$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.util.Left;
import scala.util.Right;

public class ScriptRunner {
    public void apply(List<Tuple2<StatementHandler, Statement>> statements) {
        HashMap states = new HashMap();
        Set handlers = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StatementHandler[0]))).$plus$plus((IterableOnce)statements.map((Function1 & Serializable)_$1 -> (StatementHandler)_$1._1()));
        try {
            handlers.foreach((Function1)(JProcedure1 & Serializable)handler -> states.update(handler, handler.initialState()));
            statements.foreach(Function$.MODULE$.tupled((Function2)(JProcedure2 & Serializable)(handler, statement) -> ScriptRunner.processStatement$1(states, handler, statement)));
        }
        finally {
            handlers.foreach((Function1)(JProcedure1 & Serializable)handler -> states.get(handler).foreach((Function1)(JProcedure1 & Serializable)state -> {
                try {
                    handler.finish(state);
                }
                catch (Exception exception) {}
            }));
        }
    }

    private static final void processStatement$1(HashMap states$1, StatementHandler handler, Statement statement) {
        Left nextState;
        Left left;
        Object state = states$1.apply((Object)handler);
        try {
            left = package$.MODULE$.Right().apply(handler.apply(statement.command(), statement.arguments(), state));
        }
        catch (Exception e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        Left left2 = nextState = left;
        if (left2 instanceof Left) {
            Exception err = (Exception)left2.value();
            if (statement.successExpected()) {
                Exception exception = err;
                if (exception instanceof TestFailed) {
                    TestFailed t = (TestFailed)exception;
                    throw new TestException(statement, new StringBuilder(16).append("Command failed: ").append(t.getMessage()).toString(), null);
                }
                throw new TestException(statement, "Command failed", err);
            }
            return;
        }
        if (left2 instanceof Right) {
            Object s = ((Right)left2).value();
            if (statement.successExpected()) {
                states$1.update((Object)handler, s);
                return;
            }
            throw new TestException(statement, "Command succeeded but failure was expected", null);
        }
        throw new MatchError((Object)left2);
    }
}

