/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.scripted;

import java.io.File;
import java.io.Serializable;
import sbt.internal.scripted.ListTests$;
import sbt.internal.scripted.ScriptedTest;
import sbt.internal.scripted.ScriptedTest$;
import sbt.io.DirectoryFilter$;
import sbt.io.FileFilter;
import sbt.io.HiddenFileFilter$;
import sbt.util.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public final class ListTests {
    private final File baseDirectory;
    private final Function1<ScriptedTest, Object> accept;
    private final Logger log;

    public static Seq<File> list(File file, java.io.FileFilter fileFilter) {
        return ListTests$.MODULE$.list(file, fileFilter);
    }

    public ListTests(File baseDirectory, Function1<ScriptedTest, Object> accept, Logger log) {
        this.baseDirectory = baseDirectory;
        this.accept = accept;
        this.log = log;
    }

    public FileFilter filter() {
        return DirectoryFilter$.MODULE$.$minus$minus((FileFilter)HiddenFileFilter$.MODULE$);
    }

    public Seq<ScriptedTest> listTests() {
        return (Seq)ListTests$.MODULE$.list(this.baseDirectory, (java.io.FileFilter)this.filter()).flatMap((Function1 & Serializable)group -> {
            String groupName = group.getName();
            return (IterableOnce)this.listTests((File)group).map((Function1 & Serializable)_$5 -> ScriptedTest$.MODULE$.apply(groupName, (String)_$5));
        });
    }

    private Seq<String> listTests(File group) {
        String groupName = group.getName();
        Seq allTests = (Seq)ListTests$.MODULE$.list(group, (java.io.FileFilter)this.filter()).sortBy((Function1 & Serializable)_$6 -> _$6.getName(), (Ordering)Ordering.String$.MODULE$);
        if (allTests.isEmpty()) {
            this.log.warn(() -> ListTests.listTests$$anonfun$3(groupName));
            return (Seq)package$.MODULE$.Seq().empty();
        }
        Tuple2 tuple2 = allTests.toList().partition((Function1 & Serializable)test -> BoxesRunTime.unboxToBoolean((Object)this.accept.apply((Object)ScriptedTest$.MODULE$.apply(groupName, test.getName()))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List included = (List)tuple2._1();
        List skipped = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)included, (Object)skipped);
        List included2 = (List)tuple22._1();
        List skipped2 = (List)tuple22._2();
        if (included2.isEmpty()) {
            this.log.warn(() -> ListTests.listTests$$anonfun$4(groupName));
        } else if (skipped2.nonEmpty()) {
            this.log.warn(() -> ListTests.listTests$$anonfun$5(group));
            skipped2.foreach((Function1)(JProcedure1 & Serializable)testName -> this.log.warn(() -> ListTests.listTests$$anonfun$6$$anonfun$1(testName)));
        }
        return (Seq)package$.MODULE$.Seq().apply((Seq)included2.map((Function1 & Serializable)_$7 -> _$7.getName()));
    }

    private static final String listTests$$anonfun$3(String groupName$2) {
        return new StringBuilder(23).append("No tests in test group ").append(groupName$2).toString();
    }

    private static final String listTests$$anonfun$4(String groupName$4) {
        return new StringBuilder(20).append("Test group ").append(groupName$4).append(" skipped.").toString();
    }

    private static final String listTests$$anonfun$5(File group$1) {
        return new StringBuilder(24).append("Tests skipped in group ").append(group$1.getName()).append(":").toString();
    }

    private static final String listTests$$anonfun$6$$anonfun$1(File testName$1) {
        return new StringBuilder(1).append(" ").append(testName$1.getName()).toString();
    }
}

