/*
 * Decompiled with CFR 0.152.
 */
package sbt.util;

import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import sbt.internal.io.Retry$;
import sbt.internal.util.StringVirtualFile1$;
import sbt.internal.util.Util$;
import sbt.internal.util.codec.ActionResultCodec$;
import sbt.io.IO$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.RelativeGlob;
import sbt.nio.file.package$;
import sbt.util.AbstractActionCacheStore;
import sbt.util.ActionCache$;
import sbt.util.ActionResult;
import sbt.util.ActionResult$;
import sbt.util.Digest$package$Digest$;
import sbt.util.GetActionResultRequest;
import sbt.util.Manifest;
import sbt.util.UpdateActionResultRequest;
import scala.Console$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import sjsonnew.JsonReader;
import sjsonnew.JsonWriter;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;
import sjsonnew.support.scalajson.unsafe.Converter$;
import sjsonnew.support.scalajson.unsafe.Parser$;
import xsbti.FileConverter;
import xsbti.HashedVirtualFileRef;
import xsbti.PathBasedFile;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;

public class DiskActionCacheStore
implements AbstractActionCacheStore {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DiskActionCacheStore.class.getDeclaredField("acBase$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DiskActionCacheStore.class.getDeclaredField("casBase$lzy1"));
    private final Path base;
    private final FileConverter converter;
    private volatile Object casBase$lzy1;
    private volatile Object acBase$lzy1;
    private final AtomicBoolean symlinkSupported;

    public DiskActionCacheStore(Path base, FileConverter converter) {
        this.base = base;
        this.converter = converter;
        this.symlinkSupported = new AtomicBoolean(true);
    }

    public Path casBase() {
        Object object = this.casBase$lzy1;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.casBase$lzyINIT1();
    }

    private Object casBase$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.casBase$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        Path dir = this.base.resolve("cas");
                        IO$.MODULE$.createDirectory(dir.toFile());
                        path = dir;
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.casBase$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Path acBase() {
        Object object = this.acBase$lzy1;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.acBase$lzyINIT1();
    }

    private Object acBase$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.acBase$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        Path dir = this.base.resolve("ac");
                        IO$.MODULE$.createDirectory(dir.toFile());
                        path = dir;
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.acBase$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String storeName() {
        return "disk";
    }

    @Override
    public Either<Throwable, ActionResult> get(GetActionResultRequest request) {
        File acFile = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.acBase().toFile()), request.actionDigest().toString().replace("/", "-"));
        if (acFile.exists()) {
            Right right;
            String str = IO$.MODULE$.read(acFile, IO$.MODULE$.read$default$2());
            JValue json = (JValue)Parser$.MODULE$.parseUnsafe(str);
            try {
                ActionResult value = (ActionResult)Converter$.MODULE$.fromJsonUnsafe((Object)json, (JsonReader)ActionResultCodec$.MODULE$.ActionResultFormat());
                if (request.inlineOutputFiles().isEmpty()) {
                    right = scala.package$.MODULE$.Right().apply((Object)value);
                } else {
                    Vector inlineRefs = (Vector)request.inlineOutputFiles().map((Function1 & Serializable)path -> (HashedVirtualFileRef)value.outputFiles().find((Function1 & Serializable)_$4 -> {
                        String string = _$4.id();
                        String string2 = path;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }).get());
                    Vector contents = (Vector)this.getBlobs((Seq<HashedVirtualFileRef>)inlineRefs).toVector().map((Function1 & Serializable)b -> ByteBuffer.wrap(IO$.MODULE$.readBytes(b.input())));
                    right = scala.package$.MODULE$.Right().apply((Object)value.withContents((Vector<ByteBuffer>)contents));
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    right = scala.package$.MODULE$.Left().apply((Object)e);
                }
                throw throwable;
            }
            return right;
        }
        return scala.package$.MODULE$.Left().apply((Object)this.notFound());
    }

    @Override
    public Either<Throwable, ActionResult> put(UpdateActionResultRequest request) {
        Left left;
        try {
            File acFile = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.acBase().toFile()), request.actionDigest().toString().replace("/", "-"));
            Vector refs = this.putBlobsIfNeeded((Seq)request.outputFiles()).toVector();
            ActionResult v = ActionResult$.MODULE$.apply((Vector<HashedVirtualFileRef>)refs, this.storeName());
            JValue json = (JValue)Converter$.MODULE$.toJsonUnsafe((Object)v, (JsonWriter)ActionResultCodec$.MODULE$.ActionResultFormat());
            IO$.MODULE$.write(acFile, CompactPrinter$.MODULE$.apply(json), IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
            left = scala.package$.MODULE$.Right().apply((Object)v);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                left = scala.package$.MODULE$.Left().apply((Object)e);
            }
            throw throwable;
        }
        return left;
    }

    @Override
    public Seq<HashedVirtualFileRef> putBlobs(Seq<VirtualFile> blobs) {
        return (Seq)blobs.map((Function1 & Serializable)b -> {
            this.putBlob(b.input(), Digest$package$Digest$.MODULE$.apply((HashedVirtualFileRef)b));
            return b;
        });
    }

    public Path toCasFile(String digest) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.casBase().toFile()), digest.toString().replace("/", "-")).toPath();
    }

    public Path putBlob(Path blob, String digest) {
        Path path;
        try (InputStream in = Files.newInputStream(blob, new OpenOption[0]);){
            path = this.putBlob(in, digest);
        }
        return path;
    }

    public Path putBlob(InputStream input, String digest) {
        Path casFile = this.toCasFile(digest);
        IO$.MODULE$.transfer(input, casFile.toFile());
        return casFile;
    }

    public Path putBlob(ByteBuffer input, String digest) {
        Path path;
        Path casFile = this.toCasFile(digest);
        input.flip();
        try (RandomAccessFile file = new RandomAccessFile(casFile.toFile(), "rw");){
            file.getChannel().write(input);
            path = casFile;
        }
        return path;
    }

    private Seq<VirtualFile> getBlobs(Seq<HashedVirtualFileRef> refs) {
        return (Seq)refs.flatMap((Function1 & Serializable)r -> {
            Path casFile = this.toCasFile(Digest$package$Digest$.MODULE$.apply((HashedVirtualFileRef)r));
            if (casFile.toFile().exists()) {
                HashedVirtualFileRef hashedVirtualFileRef = r;
                if (hashedVirtualFileRef instanceof PathBasedFile) {
                    PathBasedFile p = (PathBasedFile)hashedVirtualFileRef;
                    return Some$.MODULE$.apply((Object)p);
                }
                String content = IO$.MODULE$.read(casFile.toFile(), IO$.MODULE$.read$default$2());
                return Some$.MODULE$.apply((Object)StringVirtualFile1$.MODULE$.apply(r.id(), content));
            }
            return None$.MODULE$;
        });
    }

    @Override
    public Seq<Path> syncBlobs(Seq<HashedVirtualFileRef> refs, Path outputDirectory) {
        return (Seq)refs.flatMap((Function1 & Serializable)r -> {
            Path casFile = this.toCasFile(Digest$package$Digest$.MODULE$.apply((HashedVirtualFileRef)r));
            if (casFile.toFile().exists()) {
                return Some$.MODULE$.apply((Object)this.syncFile((HashedVirtualFileRef)r, casFile, outputDirectory));
            }
            return None$.MODULE$;
        });
    }

    public Path syncFile(HashedVirtualFileRef ref, Path casFile, Path outputDirectory) {
        String d = Digest$package$Digest$.MODULE$.apply(ref);
        Path path = this.converter.toPath((VirtualFileRef)ref);
        Path p = path;
        if (!Files.exists(p, new LinkOption[0])) {
            return this.writeFileAndNotify$1(casFile, ref, outputDirectory, p);
        }
        Path p2 = path;
        if (Digest$package$Digest$.MODULE$.sameDigest(p2, d)) {
            return p2;
        }
        Path p3 = path;
        IO$.MODULE$.delete(p3.toFile());
        return this.writeFileAndNotify$1(casFile, ref, outputDirectory, p3);
    }

    public void afterFileWrite(HashedVirtualFileRef ref, Path path, Path outputDirectory) {
        if (path.toString().endsWith(ActionCache$.MODULE$.dirZipExt())) {
            this.unpackageDirZip(path, outputDirectory);
            return;
        }
    }

    private Path unpackageDirZip(Path dirzip, Path outputDirectory) {
        Path dirPath = Paths.get(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(dirzip.toString()), StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(ActionCache$.MODULE$.dirZipExt()))), new String[0]);
        IO$.MODULE$.createDirectory(dirPath.toFile());
        Set allPaths = (Set)Set$.MODULE$.apply((Seq)FileTreeView.Ops$.MODULE$.list$extension(FileTreeView$.MODULE$.Ops(FileTreeView$.MODULE$.default()), Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(Glob.PathOps$.MODULE$.toGlob$extension(sbt.nio.file.syntax.package$.MODULE$.pathToPathOps(dirPath))), (RelativeGlob)package$.MODULE$.$times$times())), "*")).withFilter((Function1 & Serializable)_$5 -> !((FileAttributes)_$5._2()).isDirectory()).map((Function1 & Serializable)_$6 -> (Path)_$6._1()));
        IO$.MODULE$.withTemporaryDirectory((Function1)(JProcedure1 & Serializable)tempDir -> {
            IO$.MODULE$.unzip(dirzip.toFile(), tempDir, IO$.MODULE$.unzip$default$3(), IO$.MODULE$.unzip$default$4());
            Path mPath = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(tempDir), ActionCache$.MODULE$.manifestFileName()).toPath();
            if (!Files.exists(mPath, new LinkOption[0])) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(25).append("manifest is missing from ").append(dirzip).toString());
            }
            Manifest m = ActionCache$.MODULE$.manifestFromFile(mPath);
            m.outputFiles().foreach((Function1)(JProcedure1 & Serializable)ref -> {
                Path path;
                Path currentItem = this.converter.toPath((VirtualFileRef)ref);
                String shortPath = outputDirectory.relativize(currentItem).toString();
                allPaths.remove((Object)currentItem);
                String d = Digest$package$Digest$.MODULE$.apply((HashedVirtualFileRef)ref);
                Path p = path = currentItem;
                if (!Files.exists(p, new LinkOption[0])) {
                    this.doSync$1(outputDirectory, (HashedVirtualFileRef)ref, DiskActionCacheStore.tempPath$1(tempDir, shortPath));
                    return;
                }
                Path p2 = path;
                if (Digest$package$Digest$.MODULE$.sameDigest(p2, d)) {
                    return;
                }
                Path p3 = path;
                IO$.MODULE$.delete(p3.toFile());
                this.doSync$1(outputDirectory, (HashedVirtualFileRef)ref, DiskActionCacheStore.tempPath$1(tempDir, shortPath));
            });
        });
        allPaths.foreach((Function1)(JProcedure1 & Serializable)path -> IO$.MODULE$.delete(path.toFile()));
        return dirPath;
    }

    @Override
    public Seq<HashedVirtualFileRef> findBlobs(Seq<HashedVirtualFileRef> refs) {
        return (Seq)refs.flatMap((Function1 & Serializable)r -> {
            Path casFile = this.toCasFile(Digest$package$Digest$.MODULE$.apply((HashedVirtualFileRef)r));
            if (casFile.toFile().exists()) {
                return Some$.MODULE$.apply(r);
            }
            return None$.MODULE$;
        });
    }

    private static final Path copyFile$1(Path casFile$1, Path outPath) {
        return Files.copy(casFile$1, outPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }

    private final Path $anonfun$9(Path outPath$1, Path casFile$2) {
        if (Files.exists(outPath$1, new LinkOption[0])) {
            IO$.MODULE$.delete(outPath$1.toFile());
        }
        if (this.symlinkSupported.get()) {
            Path path;
            try {
                path = Files.createSymbolicLink(outPath$1, casFile$2, new FileAttribute[0]);
            }
            catch (FileSystemException e) {
                if (Util$.MODULE$.isWindows()) {
                    Console$.MODULE$.err().println("[info] failed to a create symbolic link. consider enabling Developer Mode");
                }
                this.symlinkSupported.set(false);
                path = DiskActionCacheStore.copyFile$1(casFile$2, outPath$1);
            }
            return path;
        }
        return DiskActionCacheStore.copyFile$1(casFile$2, outPath$1);
    }

    private final Path writeFileAndNotify$1(Path casFile$3, HashedVirtualFileRef ref$1, Path outputDirectory$3, Path outPath) {
        IO$.MODULE$.createDirectory(outPath.getParent().toFile());
        Path result = (Path)Retry$.MODULE$.apply(() -> this.$anonfun$9(outPath, casFile$3), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[0]));
        this.afterFileWrite(ref$1, result, outputDirectory$3);
        return result;
    }

    private final void doSync$1(Path outputDirectory$4, HashedVirtualFileRef ref, Path in) {
        String d = Digest$package$Digest$.MODULE$.apply(ref);
        Path casFile = this.putBlob(in, d);
        this.syncFile(ref, casFile, outputDirectory$4);
    }

    private static final Path tempPath$1(File tempDir$2, String shortPath$1) {
        return tempDir$2.toPath().resolve(shortPath$1);
    }
}

