/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.testing;

import sbt.ContentLogger;
import sbt.TestDefinition;
import sbt.TestEvent;
import sbt.TestsListener;
import sbt.internal.testing.TestLogger$;
import sbt.internal.testing.TestLogging;
import sbt.internal.util.ManagedLogger;
import sbt.internal.util.appmacro.StringTypeTag;
import sbt.protocol.testing.EndTestGroupErrorEvent;
import sbt.protocol.testing.EndTestGroupErrorEvent$;
import sbt.protocol.testing.EndTestGroupEvent;
import sbt.protocol.testing.EndTestGroupEvent$;
import sbt.protocol.testing.StartTestGroupEvent;
import sbt.protocol.testing.StartTestGroupEvent$;
import sbt.protocol.testing.TestCompleteEvent;
import sbt.protocol.testing.TestCompleteEvent$;
import sbt.protocol.testing.TestInitEvent;
import sbt.protocol.testing.TestInitEvent$;
import sbt.protocol.testing.TestItemEvent;
import sbt.protocol.testing.TestResult;
import sbt.protocol.testing.TestStringEvent;
import sbt.protocol.testing.codec.JsonProtocol$;
import sbt.testing.Logger;
import sbt.util.Level$;
import sbt.util.ShowLines;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals$;

public class TestLogger
implements TestsListener {
    private final TestLogging logging;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TestLogger$.class.getDeclaredField("testStringEventShowLines$lzy1"));

    public static TestLogger make(ManagedLogger managedLogger, Function1<TestDefinition, PerTest> function1) {
        return TestLogger$.MODULE$.make(managedLogger, function1);
    }

    public static TestLogger make(ManagedLogger managedLogger, Function1<TestDefinition, PerTest> function1, Enumeration.Value value) {
        return TestLogger$.MODULE$.make(managedLogger, function1, value);
    }

    public static ShowLines<TestStringEvent> testStringEventShowLines() {
        return TestLogger$.MODULE$.testStringEventShowLines();
    }

    public static TestItemEvent toTestItemEvent(TestEvent testEvent) {
        return TestLogger$.MODULE$.toTestItemEvent(testEvent);
    }

    public static Logger wrap(ManagedLogger managedLogger) {
        return TestLogger$.MODULE$.wrap(managedLogger);
    }

    public TestLogger(TestLogging logging) {
        this.logging = logging;
    }

    public TestLogging logging() {
        return this.logging;
    }

    @Override
    public void doInit() {
        this.logging().managed().logEvent(Level$.MODULE$.Info(), TestLogger::doInit$$anonfun$1, JsonProtocol$.MODULE$.TestInitEventFormat(), new StringTypeTag("sbt.protocol.testing.TestInitEvent"));
    }

    @Override
    public void startGroup(String name) {
        this.logging().managed().logEvent(Level$.MODULE$.Info(), () -> TestLogger.startGroup$$anonfun$1(name), JsonProtocol$.MODULE$.StartTestGroupEventFormat(), new StringTypeTag("sbt.protocol.testing.StartTestGroupEvent"));
    }

    @Override
    public void testEvent(TestEvent event) {
        this.logging().managed().logEvent(Level$.MODULE$.Info(), () -> TestLogger.testEvent$$anonfun$1(event), JsonProtocol$.MODULE$.TestItemEventFormat(), new StringTypeTag("sbt.protocol.testing.TestItemEvent"));
    }

    @Override
    public void endGroup(String name, TestResult result) {
        this.logging().managed().logEvent(Level$.MODULE$.Info(), () -> TestLogger.endGroup$$anonfun$1(name, result), JsonProtocol$.MODULE$.EndTestGroupEventFormat(), new StringTypeTag("sbt.protocol.testing.EndTestGroupEvent"));
    }

    @Override
    public void endGroup(String name, Throwable t) {
        this.logging().global().trace(t);
        this.logging().global().error(new StringBuilder(21).append("Could not run test ").append(name).append(": ").append(t).toString());
        this.logging().managed().logEvent(Level$.MODULE$.Info(), () -> TestLogger.endGroup$$anonfun$2(name, t), JsonProtocol$.MODULE$.EndTestGroupErrorEventFormat(), new StringTypeTag("sbt.protocol.testing.EndTestGroupErrorEvent"));
    }

    @Override
    public void doComplete(TestResult finalResult) {
        this.logging().managed().logEvent(Level$.MODULE$.Info(), () -> TestLogger.doComplete$$anonfun$1(finalResult), JsonProtocol$.MODULE$.TestCompleteEventFormat(), new StringTypeTag("sbt.protocol.testing.TestCompleteEvent"));
    }

    @Override
    public Option<ContentLogger> contentLogger(TestDefinition test) {
        return Some$.MODULE$.apply(this.logging().logTest().apply((Object)test));
    }

    private static final TestInitEvent doInit$$anonfun$1() {
        return TestInitEvent$.MODULE$.apply();
    }

    private static final StartTestGroupEvent startGroup$$anonfun$1(String name$1) {
        return StartTestGroupEvent$.MODULE$.apply(name$1);
    }

    private static final TestItemEvent testEvent$$anonfun$1(TestEvent event$1) {
        return TestLogger$.MODULE$.toTestItemEvent(event$1);
    }

    private static final EndTestGroupEvent endGroup$$anonfun$1(String name$2, TestResult result$1) {
        return EndTestGroupEvent$.MODULE$.apply(name$2, result$1);
    }

    private static final EndTestGroupErrorEvent endGroup$$anonfun$2(String name$3, Throwable t$1) {
        return EndTestGroupErrorEvent$.MODULE$.apply(name$3, StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(new StringBuilder(0).append(t$1.getMessage()).append(t$1.getStackTrace().toString()).toString()), "\n"));
    }

    private static final TestCompleteEvent doComplete$$anonfun$1(TestResult finalResult$1) {
        return TestCompleteEvent$.MODULE$.apply(finalResult$1);
    }

    public static final class PerTest {
        private final ManagedLogger log;
        private final Function0<BoxedUnit> flush;
        private final boolean buffered;

        public PerTest(ManagedLogger log, Function0<BoxedUnit> flush, boolean buffered) {
            this.log = log;
            this.flush = flush;
            this.buffered = buffered;
        }

        public ManagedLogger log() {
            return this.log;
        }

        public Function0<BoxedUnit> flush() {
            return this.flush;
        }

        public boolean buffered() {
            return this.buffered;
        }
    }
}

