/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.Serializable;
import sbt.SuiteResult;
import sbt.SuiteResult$;
import sbt.TestDefinition;
import sbt.TestEvent;
import sbt.TestEvent$;
import sbt.TestFramework$;
import sbt.TestReportListener;
import sbt.internal.util.ManagedLogger;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Logger;
import sbt.testing.OptionalThrowable;
import sbt.testing.Runner;
import sbt.testing.Status;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import sbt.testing.TestSelector;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public final class TestRunner {
    private final Runner delegate;
    private final Vector<TestReportListener> listeners;
    private final ManagedLogger log;

    public TestRunner(Runner delegate, Vector<TestReportListener> listeners, ManagedLogger log) {
        this.delegate = delegate;
        this.listeners = listeners;
        this.log = log;
    }

    public final Task[] tasks(Set<TestDefinition> testDefs) {
        return this.delegate.tasks((TaskDef[])((IterableOnceOps)testDefs.map((Function1 & Serializable)df -> new TaskDef(df.name(), df.fingerprint(), df.explicitlySpecified(), df.selectors()))).toArray(ClassTag$.MODULE$.apply(TaskDef.class)));
    }

    public final Tuple2<SuiteResult, Seq<Task>> run(TaskDef taskDef, Task testTask) {
        Tuple2 tuple2;
        TestDefinition testDefinition = new TestDefinition(taskDef.fullyQualifiedName(), taskDef.fingerprint(), taskDef.explicitlySpecified(), taskDef.selectors());
        this.log.debug(() -> TestRunner.run$$anonfun$1(taskDef));
        String name = testDefinition.name();
        this.safeListenersCall((Function1<TestReportListener, BoxedUnit>)(JProcedure1 & Serializable)_$5 -> _$5.startGroup(name));
        try {
            Tuple2 tuple22 = this.runTest$1(testDefinition, testTask, name);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            SuiteResult suiteResult = (SuiteResult)tuple22._1();
            Seq nestedTasks = (Seq)tuple22._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)suiteResult, (Object)nestedTasks);
            SuiteResult suiteResult2 = (SuiteResult)tuple23._1();
            Seq nestedTasks2 = (Seq)tuple23._2();
            this.safeListenersCall((Function1<TestReportListener, BoxedUnit>)(JProcedure1 & Serializable)_$6 -> _$6.endGroup(name, suiteResult2.result()));
            tuple2 = Tuple2$.MODULE$.apply((Object)suiteResult2, (Object)nestedTasks2);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.safeListenersCall((Function1<TestReportListener, BoxedUnit>)(JProcedure1 & Serializable)_$7 -> _$7.endGroup(name, e));
                tuple2 = Tuple2$.MODULE$.apply((Object)SuiteResult$.MODULE$.Error(), (Object)package$.MODULE$.Seq().empty());
            }
            throw throwable;
        }
        return tuple2;
    }

    public void safeListenersCall(Function1<TestReportListener, BoxedUnit> call) {
        TestFramework$.MODULE$.safeForeach(this.listeners, this.log, call);
    }

    private static final String run$$anonfun$1(TaskDef taskDef$1) {
        return new StringBuilder(8).append("Running ").append(taskDef$1).toString();
    }

    private static final Task[] errorEvents$1(Task testTask$2, String name$2, ListBuffer results$2, Throwable e) {
        TaskDef taskDef = testTask$2.taskDef();
        Event event = new Event(e, taskDef, name$2){
            private final Status status;
            private final OptionalThrowable throwable;
            private final String fullyQualifiedName;
            private final TestSelector selector;
            private final Fingerprint fingerprint;
            private final long duration;
            {
                this.status = Status.Error;
                this.throwable = new OptionalThrowable(e$2);
                this.fullyQualifiedName = taskDef$2.fullyQualifiedName();
                this.selector = new TestSelector(name$3);
                this.fingerprint = taskDef$2.fingerprint();
                this.duration = -1L;
            }

            public Status status() {
                return this.status;
            }

            public OptionalThrowable throwable() {
                return this.throwable;
            }

            public String fullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            public TestSelector selector() {
                return this.selector;
            }

            public Fingerprint fingerprint() {
                return this.fingerprint;
            }

            public long duration() {
                return this.duration;
            }
        };
        results$2.$plus$eq((Object)event);
        return (Task[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Task.class));
    }

    private final Tuple2 runTest$1(TestDefinition testDefinition$1, Task testTask$1, String name$1) {
        Object[] objectArray;
        ListBuffer results;
        block8: {
            results = new ListBuffer();
            EventHandler handler = new EventHandler(results){
                private final ListBuffer results$1;
                {
                    this.results$1 = results$3;
                }

                public void handle(Event e) {
                    this.results$1.$plus$eq((Object)e);
                }
            };
            Vector loggers = (Vector)this.listeners.flatMap((Function1 & Serializable)_$1 -> _$1.contentLogger(testDefinition$1));
            try {
                try {
                    objectArray = testTask$1.execute(handler, (Logger[])((IterableOnceOps)loggers.map((Function1 & Serializable)_$2 -> _$2.log())).toArray(ClassTag$.MODULE$.apply(Logger.class)));
                }
                catch (NoClassDefFoundError e) {
                    objectArray = TestRunner.errorEvents$1(testTask$1, name$1, results, e);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = (Throwable)option.get();
                        objectArray = TestRunner.errorEvents$1(testTask$1, name$1, results, e);
                        break block8;
                    }
                    if (throwable2 instanceof IllegalAccessError) {
                        IllegalAccessError e = (IllegalAccessError)throwable2;
                        objectArray = TestRunner.errorEvents$1(testTask$1, name$1, results, e);
                        break block8;
                    }
                    throw throwable;
                }
            }
            finally {
                loggers.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.flush().apply$mcV$sp());
            }
        }
        Object[] nestedTasks = objectArray;
        TestEvent event = TestEvent$.MODULE$.apply((Seq<Event>)results.toList());
        this.safeListenersCall((Function1<TestReportListener, BoxedUnit>)(JProcedure1 & Serializable)_$4 -> _$4.testEvent(event));
        Object object = Predef$.MODULE$.refArrayOps(nestedTasks);
        return Tuple2$.MODULE$.apply((Object)SuiteResult$.MODULE$.apply((Seq<Event>)results.toList()), (Object)ArrayOps$.MODULE$.toSeq$extension(object));
    }
}

