/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import sbt.ContentLogger;
import sbt.TestDefinition;
import sbt.TestEvent;
import sbt.TestsListener;
import sbt.protocol.testing.TestResult;
import sbt.testing.Event;
import sbt.testing.NestedTestSelector;
import sbt.testing.OptionalThrowable;
import sbt.testing.Status;
import sbt.testing.TestSelector;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.Properties$;
import scala.util.matching.Regex;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scala.xml.XML$;

public class JUnitXmlTestsListener
implements TestsListener {
    private final File targetDir;
    private final boolean legacyTestReport;
    private final String hostname;
    private final Elem properties;
    private final InheritableThreadLocal<Option<TestSuite>> testSuite;

    public JUnitXmlTestsListener(File targetDir, boolean legacyTestReport, Logger logger) {
        String string;
        this.targetDir = targetDir;
        this.legacyTestReport = legacyTestReport;
        long start = System.nanoTime();
        JUnitXmlTestsListener jUnitXmlTestsListener = this;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (IOException iOException) {
            string = "localhost";
        }
        String string2 = string;
        JUnitXmlTestsListener jUnitXmlTestsListener2 = jUnitXmlTestsListener;
        jUnitXmlTestsListener = null;
        String string3 = string2;
        string2 = null;
        String name = string3;
        long elapsed = System.nanoTime() - start;
        if (TimeUnit.NANOSECONDS.toSeconds(elapsed) >= 4L && Properties$.MODULE$.isMac() && logger != null) {
            logger.warn(() -> JUnitXmlTestsListener.$init$$$anonfun$1(name, elapsed));
        }
        jUnitXmlTestsListener2.hostname = name;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Hashtable clonedProperties = (Hashtable)System.getProperties().clone();
        Iterator iter = clonedProperties.entrySet().iterator();
        ListBuffer props = new ListBuffer();
        while (iter.hasNext()) {
            Map.Entry next = iter.next();
            scala.xml.Null$ $md = scala.xml.Null$.MODULE$;
            $md = new UnprefixedAttribute("value", next.getValue().toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("name", next.getKey().toString(), (MetaData)$md);
            props.$plus$eq((Object)new Elem(null, "property", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        }
        $buf.$amp$plus((Object)props);
        $buf.$amp$plus((Object)new Text("\n    "));
        this.properties = new Elem(null, "properties", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        this.testSuite = new InheritableThreadLocal<Option<TestSuite>>(){

            public Option initialValue() {
                return None$.MODULE$;
            }
        };
    }

    public File targetDir() {
        return this.targetDir;
    }

    public JUnitXmlTestsListener(String outputDir, boolean legacyTestReport, Logger logger) {
        this(new File(outputDir, "test-reports"), legacyTestReport, logger);
    }

    public JUnitXmlTestsListener(String outputDir, Logger logger) {
        this(outputDir, false, logger);
    }

    public JUnitXmlTestsListener(String outputDir) {
        this(outputDir, false, null);
    }

    public String outputDir() {
        return this.targetDir().getParent();
    }

    public String hostname() {
        return this.hostname;
    }

    public Elem properties() {
        return this.properties;
    }

    private <T> T withTestSuite(Function1<TestSuite, T> f) {
        return (T)((Option)this.testSuite.get()).map(f).getOrElse(JUnitXmlTestsListener::withTestSuite$$anonfun$1);
    }

    @Override
    public void doInit() {
        boolean bl = this.targetDir().mkdirs();
    }

    @Override
    public void startGroup(String name) {
        this.testSuite.set((Option<TestSuite>)Some$.MODULE$.apply((Object)new TestSuite(this, name)));
    }

    @Override
    public void testEvent(TestEvent event) {
        event.detail().foreach((Function1 & Serializable)e -> (ListBuffer)this.withTestSuite((Function1 & Serializable)_$4 -> _$4.addEvent((Event)e)));
    }

    @Override
    public void endGroup(String name, Throwable t) {
        Event event = new Event(name, t){
            private final String name$2;
            private final Throwable t$1;
            {
                this.name$2 = name$3;
                this.t$1 = t$2;
            }

            public String fullyQualifiedName() {
                return this.name$2;
            }

            public long duration() {
                return -1L;
            }

            public Status status() {
                return Status.Error;
            }

            public Null$ fingerprint() {
                return null;
            }

            public Null$ selector() {
                return null;
            }

            public OptionalThrowable throwable() {
                return new OptionalThrowable(this.t$1);
            }
        };
        this.withTestSuite((Function1 & Serializable)_$5 -> _$5.addEvent(event));
        this.writeSuite();
    }

    @Override
    public void endGroup(String name, TestResult result) {
        this.writeSuite();
    }

    private String normalizeName(String s) {
        return s.replaceAll("\\s+", "-");
    }

    public String sbt$JUnitXmlTestsListener$$formatISO8601DateTime(LocalDateTime d) {
        return d.truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    private void writeSuite() {
        String file = this.legacyTestReport ? new File(this.targetDir(), new StringBuilder(4).append(this.normalizeName((String)this.withTestSuite((Function1 & Serializable)_$6 -> _$6.name()))).append(".xml").toString()).getAbsolutePath() : new File(this.targetDir(), new StringBuilder(9).append("TEST-").append(this.normalizeName((String)this.withTestSuite((Function1 & Serializable)_$7 -> _$7.name()))).append(".xml").toString()).getAbsolutePath();
        Elem testSuiteResult = (Elem)this.withTestSuite((Function1 & Serializable)_$8 -> _$8.stop());
        XML$.MODULE$.save(file, (Node)testSuiteResult, "UTF-8", true, null);
        this.testSuite.remove();
    }

    @Override
    public void doComplete(TestResult finalResult) {
    }

    @Override
    public Option<ContentLogger> contentLogger(TestDefinition test) {
        return None$.MODULE$;
    }

    private static final String $init$$$anonfun$1(String name$1, long elapsed$1) {
        return new StringBuilder(200).append("Getting the hostname ").append(name$1).append(" was slow (").append((double)elapsed$1 / 1000000.0).append(" ms). ").append("This is likely because the computer's hostname is not set. You can set the ").append("hostname with the command: scutil --set HostName \"$(scutil --get LocalHostName).local\".").toString();
    }

    public static final /* synthetic */ boolean sbt$JUnitXmlTestsListener$TestSuite$$_$count$$anonfun$1(Status status$1, Event _$1) {
        Status status = _$1.status();
        Status status2 = status$1;
        return !(status != null ? !status.equals(status2) : status2 != null);
    }

    public static final /* synthetic */ long sbt$JUnitXmlTestsListener$TestSuite$$_$_$$anonfun$1(Event _$2) {
        return _$2.duration();
    }

    public static final /* synthetic */ int sbt$JUnitXmlTestsListener$TestSuite$$_$_$$anonfun$3(Regex.Match _$3) {
        return _$3.end();
    }

    public static final int sbt$JUnitXmlTestsListener$TestSuite$$_$_$$anonfun$4() {
        return 0;
    }

    private static final Object withTestSuite$$anonfun$1() {
        throw package$.MODULE$.error("no test suite");
    }

    public class TestSuite {
        private final String name;
        private final LocalDateTime timestamp;
        private final ListBuffer<Event> events;
        private final /* synthetic */ JUnitXmlTestsListener $outer;

        public TestSuite(JUnitXmlTestsListener $outer, String name, LocalDateTime timestamp) {
            this.name = name;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.events = new ListBuffer();
        }

        public String name() {
            return this.name;
        }

        public TestSuite(JUnitXmlTestsListener $outer, String name) {
            this($outer, name, LocalDateTime.now());
        }

        public ListBuffer<Event> events() {
            return this.events;
        }

        public ListBuffer<Event> addEvent(Event e) {
            return (ListBuffer)this.events().$plus$eq((Object)e);
        }

        public int count(Status status) {
            return this.events().count(arg_0 -> JUnitXmlTestsListener.sbt$JUnitXmlTestsListener$TestSuite$$_$count$$anonfun$1(status, arg_0));
        }

        public Elem stop() {
            long duration = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.events().map(JUnitXmlTestsListener::sbt$JUnitXmlTestsListener$TestSuite$$_$_$$anonfun$1)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.count(Status.Error)), (Object)BoxesRunTime.boxToInteger((int)this.count(Status.Failure)), (Object)BoxesRunTime.boxToInteger((int)this.events().size()));
            int errors = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int failures = BoxesRunTime.unboxToInt((Object)tuple3._2());
            int tests = BoxesRunTime.unboxToInt((Object)tuple3._3());
            int ignoredSkippedPending = this.count(Status.Ignored) + this.count(Status.Skipped) + this.count(Status.Pending);
            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.name()), '.'));
            Regex classnameRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(7).append("^(").append(this.name()).append("|").append((String)ArrayOps$.MODULE$.last$extension(object)).append(")\\.?").toString()));
            scala.xml.Null$ $md = scala.xml.Null$.MODULE$;
            $md = new UnprefixedAttribute("timestamp", this.$outer.sbt$JUnitXmlTestsListener$$formatISO8601DateTime(this.timestamp), (MetaData)$md);
            $md = new UnprefixedAttribute("time", BoxesRunTime.boxToDouble((double)((double)duration / 1000.0)).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("skipped", BoxesRunTime.boxToInteger((int)ignoredSkippedPending).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("failures", BoxesRunTime.boxToInteger((int)failures).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("errors", BoxesRunTime.boxToInteger((int)errors).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("tests", BoxesRunTime.boxToInteger((int)tests).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("name", this.name(), (MetaData)$md);
            $md = new UnprefixedAttribute("hostname", this.$outer.hostname(), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)this.$outer.properties());
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus(this.events().map(arg_0 -> this.$anonfun$2(classnameRegex, arg_0)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text(""));
            $buf.$amp$plus((Object)new Elem(null, "system-out", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text(""));
            $buf.$amp$plus((Object)new Elem(null, "system-err", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf.$amp$plus((Object)new Text("\n        "));
            Elem result = new Elem(null, "testsuite", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            return result;
        }

        public final /* synthetic */ JUnitXmlTestsListener sbt$JUnitXmlTestsListener$TestSuite$$$outer() {
            return this.$outer;
        }

        /*
         * Unable to fully structure code
         */
        private final /* synthetic */ Elem $anonfun$2(Regex classnameRegex$1, Event e) {
            block15: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block14: {
                                            $md = scala.xml.Null$.MODULE$;
                                            $md = new UnprefixedAttribute("time", BoxesRunTime.boxToDouble((double)((double)e.duration() / 1000.0)).toString(), (MetaData)$md);
                                            var4_4 = e.selector();
                                            if (var4_4 instanceof TestSelector) {
                                                selector = (TestSelector)var4_4;
                                                matchEnd = BoxesRunTime.unboxToInt((Object)classnameRegex$1.findFirstMatchIn((CharSequence)selector.testName()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, sbt$JUnitXmlTestsListener$TestSuite$$_$_$$anonfun$3(scala.util.matching.Regex$Match ), (Lscala/util/matching/Regex$Match;)I)()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, sbt$JUnitXmlTestsListener$TestSuite$$_$_$$anonfun$4(), ()I)()));
                                                v0 = selector.testName().substring(matchEnd);
                                            } else if (var4_4 instanceof NestedTestSelector) {
                                                nested = (NestedTestSelector)var4_4;
                                                v0 = nested.testName();
                                            } else {
                                                other = var4_4;
                                                v0 = new StringBuilder(27).append("(It is not a test it is a ").append(other.getClass().getCanonicalName()).append(")").toString();
                                            }
                                            $md = new UnprefixedAttribute("name", v0, (MetaData)$md);
                                            var9_9 = e.selector();
                                            if (var9_9 instanceof NestedTestSelector) {
                                                nested = (NestedTestSelector)var9_9;
                                                v1 = nested.suiteId();
                                            } else {
                                                v1 = this.name();
                                            }
                                            $md = new UnprefixedAttribute("classname", v1, (MetaData)$md);
                                            $buf = new NodeBuffer();
                                            $buf.$amp$plus((Object)new Text("\n                      "));
                                            if (e.throwable().isDefined()) {
                                                stringWriter = new StringWriter();
                                                writer = new PrintWriter(stringWriter);
                                                e.throwable().get().printStackTrace(writer);
                                                writer.flush();
                                                v2 = stringWriter.toString();
                                            } else {
                                                v2 = "";
                                            }
                                            trace = v2;
                                            var15_15 = e.status();
                                            v3 = Status.Error;
                                            var16_16 = var15_15;
                                            if (v3 != null ? v3.equals(var16_16) == false : var16_16 != null) break block14;
                                            if (e.throwable().isDefined()) {
                                                $md = scala.xml.Null$.MODULE$;
                                                $md = new UnprefixedAttribute("type", e.throwable().get().getClass().getName(), (MetaData)$md);
                                                $md = new UnprefixedAttribute("message", e.throwable().get().getMessage(), (MetaData)$md);
                                                $buf = new NodeBuffer();
                                                $buf.$amp$plus((Object)trace);
                                                v4 = new Elem(null, "error", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
                                                v5 = v4;
                                            } else {
                                                $md = scala.xml.Null$.MODULE$;
                                                $md = new UnprefixedAttribute("message", "No Exception or message provided", (MetaData)$md);
                                                v5 = new Elem(null, "error", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0]));
                                            }
                                            break block15;
                                        }
                                        v6 = Status.Failure;
                                        var20_20 = var15_15;
                                        if (v6 != null ? v6.equals(var20_20) == false : var20_20 != null) break block16;
                                        if (e.throwable().isDefined()) {
                                            $md = scala.xml.Null$.MODULE$;
                                            $md = new UnprefixedAttribute("type", e.throwable().get().getClass().getName(), (MetaData)$md);
                                            $md = new UnprefixedAttribute("message", e.throwable().get().getMessage(), (MetaData)$md);
                                            $buf = new NodeBuffer();
                                            $buf.$amp$plus((Object)trace);
                                            v7 = new Elem(null, "failure", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
                                            v5 = v7;
                                        } else {
                                            $md = scala.xml.Null$.MODULE$;
                                            $md = new UnprefixedAttribute("message", "No Exception or message provided", (MetaData)$md);
                                            v5 = new Elem(null, "failure", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0]));
                                        }
                                        break block15;
                                    }
                                    v8 = Status.Ignored;
                                    var24_24 = var15_15;
                                    if (v8 != null) break block17;
                                    if (var24_24 == null) ** GOTO lbl-1000
                                    break block18;
                                }
                                if (v8.equals(var24_24)) ** GOTO lbl-1000
                            }
                            v9 = Status.Skipped;
                            var25_25 = var15_15;
                            if (v9 != null) break block19;
                            if (var25_25 == null) ** GOTO lbl-1000
                            break block20;
                        }
                        if (v9.equals(var25_25)) ** GOTO lbl-1000
                    }
                    v10 = Status.Pending;
                    var26_26 = var15_15;
                    if (v10 != null) break block21;
                    if (var26_26 == null) ** GOTO lbl-1000
                    ** GOTO lbl-1000
                }
                if (v10.equals(var26_26)) lbl-1000:
                // 6 sources

                {
                    v5 = new Elem(null, "skipped", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0]));
                } else lbl-1000:
                // 2 sources

                {
                    v5 = BoxedUnit.UNIT;
                }
            }
            $buf.$amp$plus((Object)v5);
            $buf.$amp$plus((Object)new Text("\n                    "));
            return new Elem(null, "testcase", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }
    }
}

