/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import sbt.ForkConfiguration;
import sbt.ForkTags;
import sbt.FrameworkWrapper;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Logger;
import sbt.testing.OptionalThrowable;
import sbt.testing.Runner;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.SubclassFingerprint;
import sbt.testing.SuiteSelector;
import sbt.testing.Task;
import sbt.testing.TaskDef;

public final class ForkMain {
    public static void main(String[] args) throws Exception {
        ClassLoader classLoader = new Run().getClass().getClassLoader();
        try {
            ForkMain.main(args, classLoader);
        }
        finally {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args, ClassLoader classLoader) throws Exception {
        Socket socket = new Socket(InetAddress.getByName(null), (int)Integer.valueOf(args[0]));
        ObjectInputStream is = new ObjectInputStream(socket.getInputStream());
        ObjectOutputStream os = new ObjectOutputStream(socket.getOutputStream());
        os.flush();
        try {
            new Run().run(is, os, classLoader);
        }
        finally {
            is.close();
            os.close();
        }
    }

    private static final class Run {
        private Run() {
        }

        private void run(ObjectInputStream is, ObjectOutputStream os, ClassLoader classLoader) {
            try {
                this.runTests(is, os, classLoader);
            }
            catch (RunAborted e) {
                this.internalError(e);
            }
            catch (Throwable t) {
                try {
                    this.logError(os, "Uncaught exception when running tests: " + t.toString());
                    this.write(os, new ForkError(t));
                }
                catch (Throwable t2) {
                    this.internalError(t2);
                }
            }
        }

        private boolean matches(Fingerprint f1, Fingerprint f2) {
            if (f1 instanceof SubclassFingerprint && f2 instanceof SubclassFingerprint) {
                SubclassFingerprint sf1 = (SubclassFingerprint)f1;
                SubclassFingerprint sf2 = (SubclassFingerprint)f2;
                return sf1.isModule() == sf2.isModule() && sf1.superclassName().equals(sf2.superclassName());
            }
            if (f1 instanceof AnnotatedFingerprint && f2 instanceof AnnotatedFingerprint) {
                AnnotatedFingerprint af1 = (AnnotatedFingerprint)f1;
                AnnotatedFingerprint af2 = (AnnotatedFingerprint)f2;
                return af1.isModule() == af2.isModule() && af1.annotationName().equals(af2.annotationName());
            }
            return false;
        }

        private synchronized void write(ObjectOutputStream os, Object obj) {
            try {
                os.writeObject(obj);
                os.flush();
            }
            catch (IOException e) {
                throw new RunAborted(e);
            }
        }

        private void log(ObjectOutputStream os, String message, ForkTags level) {
            this.write(os, new Object[]{level, message});
        }

        private void logDebug(ObjectOutputStream os, String message) {
            this.log(os, message, ForkTags.Debug);
        }

        private void logInfo(ObjectOutputStream os, String message) {
            this.log(os, message, ForkTags.Info);
        }

        private void logWarn(ObjectOutputStream os, String message) {
            this.log(os, message, ForkTags.Warn);
        }

        private void logError(ObjectOutputStream os, String message) {
            this.log(os, message, ForkTags.Error);
        }

        private Logger remoteLogger(final boolean ansiCodesSupported, final ObjectOutputStream os) {
            return new Logger(){

                public boolean ansiCodesSupported() {
                    return ansiCodesSupported;
                }

                public void error(String s) {
                    this.logError(os, s);
                }

                public void warn(String s) {
                    this.logWarn(os, s);
                }

                public void info(String s) {
                    this.logInfo(os, s);
                }

                public void debug(String s) {
                    this.logDebug(os, s);
                }

                public void trace(Throwable t) {
                    this.write(os, new ForkError(t));
                }
            };
        }

        private void writeEvents(ObjectOutputStream os, TaskDef taskDef, ForkEvent[] events) {
            this.write(os, new Object[]{taskDef.fullyQualifiedName(), events});
        }

        private ExecutorService executorService(ForkConfiguration config, ObjectOutputStream os) {
            if (config.isParallel()) {
                int nbThreads = Runtime.getRuntime().availableProcessors();
                this.logDebug(os, "Create a test executor with a thread pool of " + nbThreads + " threads.");
                return Executors.newFixedThreadPool(nbThreads);
            }
            this.logDebug(os, "Create a single-thread test executor");
            return Executors.newSingleThreadExecutor();
        }

        private void runTests(ObjectInputStream is, ObjectOutputStream os, ClassLoader classLoader) throws Exception {
            ForkConfiguration config = (ForkConfiguration)is.readObject();
            ExecutorService executor = this.executorService(config, os);
            TaskDef[] tests = (TaskDef[])is.readObject();
            int nFrameworks = is.readInt();
            Logger[] loggers = new Logger[]{this.remoteLogger(config.isAnsiCodesSupported(), os)};
            for (int i = 0; i < nFrameworks; ++i) {
                String[] implClassNames = (String[])is.readObject();
                String[] frameworkArgs = (String[])is.readObject();
                String[] remoteFrameworkArgs = (String[])is.readObject();
                Framework framework = null;
                for (String implClassName : implClassNames) {
                    try {
                        Object rawFramework = Class.forName(implClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (rawFramework instanceof Framework) {
                            framework = (Framework)rawFramework;
                            break;
                        }
                        framework = new FrameworkWrapper((org.scalatools.testing.Framework)rawFramework);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        this.logDebug(os, "Framework implementation '" + implClassName + "' not present.");
                    }
                }
                if (framework == null) continue;
                LinkedHashSet<TaskDef> filteredTests = new LinkedHashSet<TaskDef>();
                for (Fingerprint testFingerprint : framework.fingerprints()) {
                    for (TaskDef test : tests) {
                        if (!this.matches(testFingerprint, test.fingerprint())) continue;
                        filteredTests.add(new TaskDef(test.fullyQualifiedName(), test.fingerprint(), test.explicitlySpecified(), test.selectors()));
                    }
                }
                Runner runner = framework.runner(frameworkArgs, remoteFrameworkArgs, classLoader);
                Task[] tasks = runner.tasks(filteredTests.toArray(new TaskDef[filteredTests.size()]));
                this.logDebug(os, "Runner for " + framework.getClass().getName() + " produced " + tasks.length + " initial tasks for " + filteredTests.size() + " tests.");
                Thread callDoneOnShutdown = new Thread(() -> runner.done());
                Runtime.getRuntime().addShutdownHook(callDoneOnShutdown);
                this.runTestTasks(executor, tasks, loggers, os);
                runner.done();
                Runtime.getRuntime().removeShutdownHook(callDoneOnShutdown);
            }
            this.write(os, (Object)ForkTags.Done);
            is.readObject();
        }

        /*
         * WARNING - void declaration
         */
        private void runTestTasks(ExecutorService executor, Task[] tasks, Logger[] loggers, ObjectOutputStream os) {
            if (tasks.length > 0) {
                void var8_10;
                ArrayList<Future<Task[]>> futureNestedTasks = new ArrayList<Future<Task[]>>();
                Task[] taskArray = tasks;
                int n = taskArray.length;
                boolean bl = false;
                while (var8_10 < n) {
                    Task task = taskArray[var8_10];
                    futureNestedTasks.add(this.runTest(executor, task, loggers, os));
                    ++var8_10;
                }
                ArrayList<Object> nestedTasks = new ArrayList<Object>();
                for (Future future : futureNestedTasks) {
                    try {
                        nestedTasks.addAll(Arrays.asList((Object[])future.get()));
                    }
                    catch (Exception e) {
                        this.logError(os, "Failed to execute task " + future);
                    }
                }
                this.runTestTasks(executor, nestedTasks.toArray(new Task[nestedTasks.size()]), loggers, os);
            }
        }

        private Future<Task[]> runTest(ExecutorService executor, Task task, Logger[] loggers, ObjectOutputStream os) {
            return executor.submit(() -> {
                ForkEvent[] events;
                Task[] nestedTasks;
                TaskDef taskDef = task.taskDef();
                try {
                    final ConcurrentLinkedDeque eventList = new ConcurrentLinkedDeque();
                    EventHandler handler = new EventHandler(){

                        public void handle(Event e) {
                            eventList.add(new ForkEvent(e));
                        }
                    };
                    this.logDebug(os, "  Running " + taskDef);
                    nestedTasks = task.execute(handler, loggers);
                    if (nestedTasks.length > 0 || eventList.size() > 0) {
                        this.logDebug(os, "    Produced " + nestedTasks.length + " nested tasks and " + eventList.size() + " events.");
                    }
                    events = eventList.toArray(new ForkEvent[eventList.size()]);
                }
                catch (Throwable t) {
                    nestedTasks = new Task[]{};
                    events = new ForkEvent[]{this.testError(os, taskDef, "Uncaught exception when running " + taskDef.fullyQualifiedName() + ": " + t.toString(), t)};
                }
                this.writeEvents(os, taskDef, events);
                return nestedTasks;
            });
        }

        private void internalError(Throwable t) {
            System.err.println("Internal error when running tests: " + t.toString());
        }

        private ForkEvent testEvent(final String fullyQualifiedName, final Fingerprint fingerprint, final Selector selector, final Status r, ForkError err, final long duration) {
            final OptionalThrowable throwable = err == null ? new OptionalThrowable() : new OptionalThrowable((Throwable)err);
            return new ForkEvent(new Event(){

                public String fullyQualifiedName() {
                    return fullyQualifiedName;
                }

                public Fingerprint fingerprint() {
                    return fingerprint;
                }

                public Selector selector() {
                    return selector;
                }

                public Status status() {
                    return r;
                }

                public OptionalThrowable throwable() {
                    return throwable;
                }

                public long duration() {
                    return duration;
                }
            });
        }

        private ForkEvent testError(ObjectOutputStream os, TaskDef taskDef, String message, Throwable t) {
            this.logError(os, message);
            ForkError fe = new ForkError(t);
            this.write(os, fe);
            return this.testEvent(taskDef.fullyQualifiedName(), taskDef.fingerprint(), (Selector)new SuiteSelector(), Status.Error, fe, 0L);
        }

        class RunAborted
        extends RuntimeException {
            RunAborted(Exception e) {
                super(e);
            }
        }
    }

    static final class ForkError
    extends Exception {
        private final String originalMessage;
        private final String originalName;
        private ForkError cause;

        ForkError(Throwable t) {
            this.originalMessage = t.getMessage();
            this.originalName = t.getClass().getName();
            this.setStackTrace(t.getStackTrace());
            if (t.getCause() != null) {
                this.cause = new ForkError(t.getCause());
            }
        }

        @Override
        public String getMessage() {
            return this.originalName + ": " + this.originalMessage;
        }

        @Override
        public Exception getCause() {
            return this.cause;
        }
    }

    static final class ForkEvent
    implements Event,
    Serializable {
        private final String fullyQualifiedName;
        private final Fingerprint fingerprint;
        private final Selector selector;
        private final Status status;
        private final OptionalThrowable throwable;
        private final long duration;

        ForkEvent(Event e) {
            this.fullyQualifiedName = e.fullyQualifiedName();
            Fingerprint rawFingerprint = e.fingerprint();
            this.fingerprint = rawFingerprint instanceof SubclassFingerprint ? new SubclassFingerscan((SubclassFingerprint)rawFingerprint) : new AnnotatedFingerscan((AnnotatedFingerprint)rawFingerprint);
            this.selector = e.selector();
            ForkEvent.checkSerializableSelector(this.selector);
            this.status = e.status();
            OptionalThrowable originalThrowable = e.throwable();
            this.throwable = originalThrowable.isDefined() ? new OptionalThrowable((Throwable)new ForkError(originalThrowable.get())) : originalThrowable;
            this.duration = e.duration();
        }

        public String fullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public Fingerprint fingerprint() {
            return this.fingerprint;
        }

        public Selector selector() {
            return this.selector;
        }

        public Status status() {
            return this.status;
        }

        public OptionalThrowable throwable() {
            return this.throwable;
        }

        public long duration() {
            return this.duration;
        }

        private static void checkSerializableSelector(Selector selector) {
            if (!(selector instanceof Serializable)) {
                throw new UnsupportedOperationException("Selector implementation must be Serializable, but " + selector.getClass().getName() + " is not.");
            }
        }
    }

    public static final class AnnotatedFingerscan
    implements AnnotatedFingerprint,
    Serializable {
        private final boolean isModule;
        private final String annotationName;

        public AnnotatedFingerscan(AnnotatedFingerprint print) {
            this.isModule = print.isModule();
            this.annotationName = print.annotationName();
        }

        public boolean isModule() {
            return this.isModule;
        }

        public String annotationName() {
            return this.annotationName;
        }
    }

    public static final class SubclassFingerscan
    implements SubclassFingerprint,
    Serializable {
        private final boolean isModule;
        private final String superclassName;
        private final boolean requireNoArgConstructor;

        public SubclassFingerscan(SubclassFingerprint print) {
            this.isModule = print.isModule();
            this.superclassName = print.superclassName();
            this.requireNoArgConstructor = print.requireNoArgConstructor();
        }

        public boolean isModule() {
            return this.isModule;
        }

        public String superclassName() {
            return this.superclassName;
        }

        public boolean requireNoArgConstructor() {
            return this.requireNoArgConstructor;
        }
    }
}

