/*
 * Decompiled with CFR 0.152.
 */
package sbt.scriptedtest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.Path;
import sbt.internal.io.Resources;
import sbt.internal.scripted.CommentHandler$;
import sbt.internal.scripted.FileCommands;
import sbt.internal.scripted.Statement;
import sbt.internal.scripted.Statement$;
import sbt.internal.scripted.StatementHandler;
import sbt.internal.scripted.TestException;
import sbt.internal.scripted.TestScriptParser;
import sbt.internal.util.BufferedLogger;
import sbt.internal.util.FullLogger;
import sbt.io.FileFilter;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.PathFilter;
import sbt.nio.file.PathFilter$;
import sbt.nio.file.RelativeGlob;
import sbt.package$;
import sbt.scriptedtest.BatchScriptRunner;
import sbt.scriptedtest.LauncherBasedRemoteSbtCreator;
import sbt.scriptedtest.RemoteSbtCreator;
import sbt.scriptedtest.RemoteSbtCreatorProp;
import sbt.scriptedtest.RemoteSbtCreatorProp$LauncherBased$;
import sbt.scriptedtest.RemoteSbtCreatorProp$RunFromSourceBased$;
import sbt.scriptedtest.RunFromSourceBasedRemoteSbtCreator;
import sbt.scriptedtest.SbtHandler;
import sbt.scriptedtest.ScriptedTest;
import sbt.scriptedtest.ScriptedTests$;
import sbt.util.AbstractLogger;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.parallel.ParSeq;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Properties$;
import scala.util.control.Exception$;
import scala.util.control.NonFatal$;

public final class ScriptedTests {
    private final File resourceBaseDirectory;
    private final boolean bufferLog;
    private final String javaCommand;
    private final Seq<String> launchOpts;
    private final Resources testResources;
    private final String ScriptFilename;
    private final String PendingScriptFilename;
    private final Function1<Tuple2<Tuple2<String, String>, File>, Object> windowsExclude;
    private final String PendingLabel;

    public static Seq<ScriptedTest> get(Seq<String> seq, File file, Function1<ScriptedTest, Object> function1, Logger logger) {
        return ScriptedTests$.MODULE$.get(seq, file, function1, logger);
    }

    public static Seq<ScriptedTest> get(Seq<String> seq, File file, Logger logger) {
        return ScriptedTests$.MODULE$.get(seq, file, logger);
    }

    public static Seq<ScriptedTest> listTests(File file, Function1<ScriptedTest, Object> function1, Logger logger) {
        return ScriptedTests$.MODULE$.listTests(file, function1, logger);
    }

    public static Seq<ScriptedTest> listTests(File file, Logger logger) {
        return ScriptedTests$.MODULE$.listTests(file, logger);
    }

    public static void main(String[] stringArray) {
        ScriptedTests$.MODULE$.main(stringArray);
    }

    public static Seq<ScriptedTest> parseTests(Seq<String> seq) {
        return ScriptedTests$.MODULE$.parseTests(seq);
    }

    public static void run(File file, boolean bl, String[] stringArray, File file2, String string, String[] stringArray2, java.util.List<File> list) {
        ScriptedTests$.MODULE$.run(file, bl, stringArray, file2, string, stringArray2, list);
    }

    public static void run(File file, boolean bl, String[] stringArray, File file2, String[] stringArray2) {
        ScriptedTests$.MODULE$.run(file, bl, stringArray, file2, stringArray2);
    }

    public static void run(File file, boolean bl, String[] stringArray, File file2, String[] stringArray2, java.util.List<File> list) {
        ScriptedTests$.MODULE$.run(file, bl, stringArray, file2, stringArray2, list);
    }

    public static void runAll(ParSeq<Function0<Seq<Option<String>>>> parSeq) {
        ScriptedTests$.MODULE$.runAll(parSeq);
    }

    public static void runAll(Seq<Function0<Seq<Option<String>>>> seq) {
        ScriptedTests$.MODULE$.runAll(seq);
    }

    public static void runInParallel(File file, boolean bl, String[] stringArray, File file2, String string, String[] stringArray2, java.util.List<File> list, int n) {
        ScriptedTests$.MODULE$.runInParallel(file, bl, stringArray, file2, string, stringArray2, list, n);
    }

    public static void runInParallel(File file, boolean bl, String[] stringArray, File file2, String[] stringArray2, java.util.List<File> list, int n) {
        ScriptedTests$.MODULE$.runInParallel(file, bl, stringArray, file2, stringArray2, list, n);
    }

    public static void runInParallel(File file, boolean bl, String[] stringArray, Logger logger, String string, String[] stringArray2, java.util.List<File> list, RemoteSbtCreatorProp remoteSbtCreatorProp, int n) {
        ScriptedTests$.MODULE$.runInParallel(file, bl, stringArray, logger, string, stringArray2, list, remoteSbtCreatorProp, n);
    }

    public static void runInParallel(File file, boolean bl, String[] stringArray, Logger logger, String[] stringArray2, java.util.List<File> list, String string, String string2, File[] fileArray, int n) {
        ScriptedTests$.MODULE$.runInParallel(file, bl, stringArray, logger, stringArray2, list, string, string2, fileArray, n);
    }

    public static void runInParallel(File file, boolean bl, String[] stringArray, String[] stringArray2, java.util.List<File> list, String string, String string2, File[] fileArray, int n) {
        ScriptedTests$.MODULE$.runInParallel(file, bl, stringArray, stringArray2, list, string, string2, fileArray, n);
    }

    public ScriptedTests(File resourceBaseDirectory, boolean bufferLog, String javaCommand, Seq<String> launchOpts) {
        this.resourceBaseDirectory = resourceBaseDirectory;
        this.bufferLog = bufferLog;
        this.javaCommand = javaCommand;
        this.launchOpts = launchOpts;
        this.testResources = new Resources(resourceBaseDirectory);
        this.ScriptFilename = "test";
        this.PendingScriptFilename = "pending";
        this.windowsExclude = Properties$.MODULE$.isWin() ? (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 testName = (Tuple2)tuple2._1();
                Tuple2 tuple22 = testName;
                if (tuple22 != null) {
                    String string = (String)tuple22._1();
                    String string2 = (String)tuple22._2();
                    if ("classloader-cache".equals(string)) {
                        if ("jni".equals(string2)) {
                            return true;
                        }
                        if ("snapshot".equals(string2)) {
                            return true;
                        }
                        if ("spark".equals(string2)) {
                            return true;
                        }
                    }
                    if ("nio".equals(string) && "make-clone".equals(string2)) {
                        return true;
                    }
                    if ("watch".equals(string) && "symlinks".equals(string2)) {
                        return true;
                    }
                }
                return false;
            }
            throw new MatchError((Object)tuple2);
        } : (Function1 & Serializable)_$4 -> false;
        this.PendingLabel = "[PENDING]";
    }

    public ScriptedTests(File resourceBaseDirectory, boolean bufferLog, Seq<String> launchOpts) {
        this(resourceBaseDirectory, bufferLog, "java", launchOpts);
    }

    public String ScriptFilename() {
        return this.ScriptFilename;
    }

    public String PendingScriptFilename() {
        return this.PendingScriptFilename;
    }

    public Seq<Function0<Seq<Option<String>>>> singleScriptedTest(String group, String name, Function1<File, BoxedUnit> prescripted, Logger log, RemoteSbtCreatorProp prop) {
        return (Seq)package$.MODULE$.singleFileFinder(this.resourceBaseDirectory).$times((FileFilter)package$.MODULE$.globFilter(group)).get().flatMap((Function1 & Serializable)groupDir -> (IterableOnce)package$.MODULE$.singleFileFinder(groupDir).$times((FileFilter)package$.MODULE$.globFilter(name)).get().withFilter((Function1 & Serializable)nme -> !nme.isFile()).map((Function1 & Serializable)nme -> {
            String g = groupDir.getName();
            String n = nme.getName();
            String label = new StringBuilder(3).append(g).append(" / ").append(n).toString();
            return (Function0 & Serializable)() -> {
                log.info(() -> ScriptedTests.singleScriptedTest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(label));
                Option result = (Option)this.testResources.readWriteResourceDirectory(g, n, (Function1 & Serializable)testDirectory -> {
                    BufferedLogger buffer = new BufferedLogger((AbstractLogger)new FullLogger(log));
                    Function0 & Serializable singleTestRunner = (Function0 & Serializable)() -> {
                        Map<Object, StatementHandler> handlers = this.createScriptedHandlers((File)testDirectory, (Logger)buffer, prop);
                        BatchScriptRunner runner = new BatchScriptRunner();
                        HashMap states = new HashMap();
                        return this.commonRunTest(label, (File)testDirectory, prescripted, handlers, runner, (HashMap<StatementHandler, Object>)states, buffer);
                    };
                    return this.runOrHandleDisabled(label, (File)testDirectory, (Function0<Option<String>>)singleTestRunner, (Logger)buffer);
                });
                return (Seq)((SeqOps)new .colon.colon((Object)result, (List)Nil$.MODULE$));
            };
        }));
    }

    private Map<Object, StatementHandler> createScriptedHandlers(File testDir, Logger buffered, RemoteSbtCreatorProp prop) {
        RemoteSbtCreator remoteSbtCreator;
        FileCommands fileHandler = new FileCommands(testDir);
        RemoteSbtCreatorProp remoteSbtCreatorProp = prop;
        if (remoteSbtCreatorProp instanceof RemoteSbtCreatorProp.LauncherBased) {
            File file;
            RemoteSbtCreatorProp.LauncherBased launcherBased = RemoteSbtCreatorProp$LauncherBased$.MODULE$.unapply((RemoteSbtCreatorProp.LauncherBased)remoteSbtCreatorProp);
            File launcherJar = file = launcherBased._1();
            remoteSbtCreator = new LauncherBasedRemoteSbtCreator(testDir, launcherJar, buffered, this.javaCommand, this.launchOpts);
        } else if (remoteSbtCreatorProp instanceof RemoteSbtCreatorProp.RunFromSourceBased) {
            RemoteSbtCreatorProp.RunFromSourceBased runFromSourceBased = RemoteSbtCreatorProp$RunFromSourceBased$.MODULE$.unapply((RemoteSbtCreatorProp.RunFromSourceBased)remoteSbtCreatorProp);
            String string = runFromSourceBased._1();
            String string2 = runFromSourceBased._2();
            Seq<File> seq = runFromSourceBased._3();
            String scalaVersion = string;
            String sbtVersion = string2;
            Seq<File> classpath = seq;
            remoteSbtCreator = new RunFromSourceBasedRemoteSbtCreator(testDir, buffered, this.javaCommand, this.launchOpts, scalaVersion, sbtVersion, classpath);
        } else {
            throw new MatchError((Object)remoteSbtCreatorProp);
        }
        LauncherBasedRemoteSbtCreator remoteSbtCreator2 = remoteSbtCreator;
        SbtHandler sbtHandler = new SbtHandler(remoteSbtCreator2);
        Object[] objectArray = new Tuple2[3];
        Character c = (Character)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'$'));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)c, (Object)fileHandler);
        Character c2 = (Character)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'>'));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)c2, (Object)sbtHandler);
        Character c3 = (Character)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'#'));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)c3, (Object)CommentHandler$.MODULE$);
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Seq<Function0<Seq<Option<String>>>> batchScriptedRunner(Seq<Tuple2<String, String>> testGroupAndNames, Function1<File, BoxedUnit> prescripted, int sbtInstances, RemoteSbtCreatorProp prop, Logger log) {
        int s;
        Seq groupAndNameDirs = (Seq)testGroupAndNames.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String group = (String)tuple2._1();
                String name = (String)tuple2._2();
                return (Seq)package$.MODULE$.singleFileFinder(this.resourceBaseDirectory).$times((FileFilter)package$.MODULE$.globFilter(group)).get().flatMap((Function1 & Serializable)groupDir -> (IterableOnce)package$.MODULE$.singleFileFinder(groupDir).$times((FileFilter)package$.MODULE$.globFilter(name)).get().map((Function1 & Serializable)testDir -> Tuple2$.MODULE$.apply(groupDir, testDir)));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq labelsAndDirs = (Seq)((IterableOps)groupAndNameDirs.filterNot((Function1 & Serializable)_$1 -> ((File)_$1._2()).isFile())).map((Function1 & Serializable)x$1 -> {
            File file = (File)x$1._1();
            File file2 = (File)x$1._2();
            String groupName = file.getName();
            String testName = file2.getName();
            File testDirectory = this.testResources.readOnlyResourceDirectory(groupName, testName);
            Tuple2 tuple2 = (Tuple2)Predef$.MODULE$.ArrowAssoc((Object)Tuple2$.MODULE$.apply((Object)groupName, (Object)testName));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tuple2, (Object)testDirectory);
        });
        if (labelsAndDirs.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        int totalSize = labelsAndDirs.size();
        int n = totalSize / sbtInstances;
        int batchSize = 0 == n ? 1 : (s = n);
        Seq runFromSourceBasedTestsUnfiltered = labelsAndDirs;
        Seq runFromSourceBasedTests = (Seq)runFromSourceBasedTestsUnfiltered.filterNot(this.windowsExclude);
        ScriptedTests.logTests$1(log, totalSize, runFromSourceBasedTests.size(), prop.toString());
        return this.createTestRunners$1(batchSize, prescripted, prop, log, runFromSourceBasedTests);
    }

    private Seq<Option<String>> runBatchedTests(Seq<Tuple2<Tuple2<String, String>, File>> groupedTests, File tempTestDir, Function1<File, BoxedUnit> preHook, RemoteSbtCreatorProp prop, Logger log) {
        Seq seq;
        BatchScriptRunner runner = new BatchScriptRunner();
        BufferedLogger buffer = new BufferedLogger((AbstractLogger)new FullLogger(log));
        Map<Object, StatementHandler> handlers = this.createScriptedHandlers(tempTestDir, (Logger)buffer, prop);
        HashMap states = new HashMap();
        List seqHandlers = handlers.values().toList();
        runner.initStates((HashMap<StatementHandler, Object>)states, (Seq<StatementHandler>)seqHandlers);
        try {
            seq = this.runBatchTests$1(groupedTests, log, tempTestDir, handlers, preHook, runner, states, buffer);
        }
        finally {
            runner.cleanUpHandlers((Seq<StatementHandler>)seqHandlers, (HashMap<StatementHandler, Object>)states);
        }
        return seq;
    }

    private Option<String> runOrHandleDisabled(String label, File testDirectory, Function0<Option<String>> runTest, Logger log) {
        boolean existsDisabled = new File(testDirectory, "disabled").isFile();
        if (!existsDisabled) {
            return (Option)runTest.apply();
        }
        log.info(() -> ScriptedTests.runOrHandleDisabled$$anonfun$1(label));
        return None$.MODULE$;
    }

    private Option<String> commonRunTest(String label, File testDirectory, Function1<File, BoxedUnit> preScriptedHook, Map<Object, StatementHandler> handlers, BatchScriptRunner runner, HashMap<StatementHandler, Object> states, BufferedLogger log) {
        Tuple2 pendingScript;
        if (this.bufferLog) {
            log.record();
        }
        Tuple2 normal = Tuple2$.MODULE$.apply((Object)new File(testDirectory, this.ScriptFilename()), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Tuple2 normalScript = Tuple2$.MODULE$.apply((Object)new File(testDirectory, new StringBuilder(7).append(this.ScriptFilename()).append(".script").toString()), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Tuple2 pending = Tuple2$.MODULE$.apply((Object)new File(testDirectory, this.PendingScriptFilename()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Option option = ((List)new .colon.colon((Object)pending, (List)new .colon.colon((Object)(pendingScript = Tuple2$.MODULE$.apply((Object)new File(testDirectory, new StringBuilder(7).append(this.PendingScriptFilename()).append(".script").toString()), (Object)BoxesRunTime.boxToBoolean((boolean)true))), (List)new .colon.colon((Object)normal, (List)new .colon.colon((Object)normalScript, (List)Nil$.MODULE$))))).find((Function1 & Serializable)_$6 -> ((File)_$6._1()).isFile());
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new FileNotFoundException("no test scripts found");
            }
            throw new MatchError((Object)option);
        }
        Tuple2 script = (Tuple2)((Some)option).value();
        Tuple2 tuple2 = script;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._1();
        boolean pending2 = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)file, (Object)BoxesRunTime.boxToBoolean((boolean)pending2));
        File file2 = (File)tuple22._1();
        boolean pending3 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        String pendingMark = pending3 ? this.PendingLabel : "";
        return (Option)Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{TestException.class})).withApply((Function1 & Serializable)t -> ScriptedTests.testFailed$1(pending3, log, label, pendingMark, t)).andFinally((Function0 & Serializable)() -> {
            ScriptedTests.commonRunTest$$anonfun$2(log);
            return BoxedUnit.UNIT;
        }).apply(() -> ScriptedTests.commonRunTest$$anonfun$3(preScriptedHook, testDirectory, handlers, file2, runner, states, log, label, pendingMark, pending3));
    }

    private static final String singleScriptedTest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(String label$2) {
        return new StringBuilder(8).append("Running ").append(label$2).toString();
    }

    private static final String logTests$1$$anonfun$1(int size$1, int totalSize$2, String how$1) {
        return StringOps$.MODULE$.format$extension("Running %s / %s (%3.2f%%) scripted tests with %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size$1), BoxesRunTime.boxToInteger((int)totalSize$2), BoxesRunTime.boxToDouble((double)((double)size$1 * 100.0 / (double)totalSize$2)), how$1}));
    }

    private static final void logTests$1(Logger log$5, int totalSize$1, int size, String how) {
        log$5.info(() -> ScriptedTests.logTests$1$$anonfun$1(size, totalSize$1, how));
    }

    private final Seq createTestRunners$1(int batchSize$1, Function1 prescripted$6, RemoteSbtCreatorProp prop$6, Logger log$6, Seq tests) {
        return ((IterableOps)tests.sortBy((Function1 & Serializable)_$2 -> (Tuple2)_$2._1(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$))).grouped(batchSize$1).map((Function1 & Serializable)batch -> (Function0 & Serializable)() -> (Seq)package$.MODULE$.IO().withTemporaryDirectory((Function1 & Serializable)_$3 -> this.runBatchedTests((Seq<Tuple2<Tuple2<String, String>, File>>)batch, (File)_$3, (Function1<File, BoxedUnit>)prescripted$6, prop$6, log$6))).toList();
    }

    private static final String runBatchTests$1$$anonfun$1$$anonfun$1(String label$5) {
        return new StringBuilder(8).append("Running ").append(label$5).toString();
    }

    private static final Nothing$ sbtHandlerError$1() {
        return scala.sys.package$.MODULE$.error("Missing sbt handler. Scripted is misconfigured.");
    }

    private static final StatementHandler $anonfun$7() {
        throw ScriptedTests.sbtHandlerError$1();
    }

    private static final PathFilter recursiveFilter$1(Glob glob) {
        return PathFilter.Ops$.MODULE$.$bar$bar$extension(PathFilter$.MODULE$.Ops(PathFilter$.MODULE$.globToPathFilter(glob)), PathFilter$.MODULE$.globToPathFilter(Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(glob), (RelativeGlob)package$.MODULE$.$times$times())));
    }

    private final Seq runBatchTests$1(Seq groupedTests$1, Logger log$10, File tempTestDir$1, Map handlers$1, Function1 preHook$1, BatchScriptRunner runner$1, HashMap states$1, BufferedLogger buffer$2) {
        return (Seq)groupedTests$1.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                String group = (String)tuple2._1();
                String name = (String)tuple2._2();
                File originalDir = (File)tuple22._2();
                String label = new StringBuilder(1).append(group).append("/").append(name).toString();
                log$10.info(() -> ScriptedTests.runBatchTests$1$$anonfun$1$$anonfun$1(label));
                package$.MODULE$.IO().copyDirectory(originalDir, tempTestDir$1);
                Function0 & Serializable runTest = (Function0 & Serializable)() -> {
                    StatementHandler sbtHandler = (StatementHandler)handlers$1.getOrElse((Object)BoxesRunTime.boxToCharacter((char)'>'), ScriptedTests::$anonfun$7);
                    Statement statement = Statement$.MODULE$.apply("reload;initialize", (List)scala.package$.MODULE$.Nil(), true, -1);
                    JProcedure1 & Serializable wrapHook = (JProcedure1 & Serializable)file -> {
                        preHook$1.apply(file);
                        try {
                            runner$1.processStatement(sbtHandler, statement, (HashMap<StatementHandler, Object>)states$1);
                        }
                        catch (Throwable t) {
                            String newMsg = "Reload for scripted batch execution failed.";
                            throw new TestException(statement, newMsg, t);
                        }
                    };
                    return this.commonRunTest(label, tempTestDir$1, (Function1<File, BoxedUnit>)wrapHook, (Map<Object, StatementHandler>)handlers$1, runner$1, (HashMap<StatementHandler, Object>)states$1, buffer$2);
                };
                Option<String> result = this.runOrHandleDisabled(label, tempTestDir$1, (Function0<Option<String>>)runTest, (Logger)buffer$2);
                FileTreeView view = FileTreeView$.MODULE$.default();
                Glob base = Glob.FileOps$.MODULE$.toGlob$extension(package$.MODULE$.fileToFileOps(tempTestDir$1.getCanonicalFile()));
                Glob global = Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(base), "global");
                Glob globalLogging = Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(base), (RelativeGlob)package$.MODULE$.$times$times())), "global-logging");
                PathFilter keep = PathFilter.Ops$.MODULE$.$bar$bar$extension(PathFilter$.MODULE$.Ops(ScriptedTests.recursiveFilter$1(global)), ScriptedTests.recursiveFilter$1(globalLogging));
                Seq toDelete = (Seq)((SeqOps)((SeqOps)FileTreeView.Ops$.MODULE$.list$extension(FileTreeView$.MODULE$.Ops(view), Glob.GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(base), (RelativeGlob)package$.MODULE$.$times$times()), PathFilter.Ops$.MODULE$.unary_$bang$extension(PathFilter$.MODULE$.Ops(keep))).map((Function1 & Serializable)_$5 -> (Path)_$5._1())).sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).reverse();
                toDelete.foreach((Function1 & Serializable)p -> {
                    Boolean bl;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(p));
                    }
                    catch (IOException iOException) {
                        bl = BoxedUnit.UNIT;
                    }
                    return bl;
                });
                return result;
            }
            throw new MatchError((Object)tuple22);
        });
    }

    private static final String runOrHandleDisabled$$anonfun$1(String label$7) {
        return new StringBuilder(13).append("D ").append(label$7).append(" [DISABLED]").toString();
    }

    private static final String testFailed$1$$anonfun$1(String label$9, String pendingMark$2) {
        return new StringBuilder(3).append("x ").append(label$9).append(" ").append(pendingMark$2).toString();
    }

    private static final String testFailed$1$$anonfun$2(Throwable t$1) {
        return new StringBuilder(26).append(" Cause of test exception: ").append(t$1.getMessage()).toString();
    }

    private static final Option testFailed$1(boolean pending$1, BufferedLogger log$12, String label$8, String pendingMark$1, Throwable t) {
        if (pending$1) {
            log$12.clear();
        } else {
            log$12.stop();
        }
        log$12.error(() -> ScriptedTests.testFailed$1$$anonfun$1(label$8, pendingMark$1));
        if (!NonFatal$.MODULE$.apply(t)) {
            throw t;
        }
        if (t instanceof TestException) {
            Throwable throwable = t.getCause();
            if (throwable == null || throwable instanceof SocketException) {
                log$12.error(() -> ScriptedTests.testFailed$1$$anonfun$2(t));
            } else if (!pending$1) {
                t.printStackTrace();
            }
        }
        if (pending$1) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)label$8);
    }

    private static final void commonRunTest$$anonfun$2(BufferedLogger log$13) {
        log$13.clear();
    }

    private static final String commonRunTest$$anonfun$3$$anonfun$1(String label$11, String pendingMark$4) {
        return new StringBuilder(3).append("+ ").append(label$11).append(" ").append(pendingMark$4).toString();
    }

    private static final String commonRunTest$$anonfun$3$$anonfun$2() {
        return " Pending test passed. Mark as passing to remove this failure.";
    }

    private static final Option commonRunTest$$anonfun$3(Function1 preScriptedHook$1, File testDirectory$2, Map handlers$4, File file$1, BatchScriptRunner runner$5, HashMap states$5, BufferedLogger log$14, String label$10, String pendingMark$3, boolean pending$2) {
        preScriptedHook$1.apply((Object)testDirectory$2);
        TestScriptParser parser = new TestScriptParser(handlers$4);
        List handlersAndStatements = parser.parse(file$1, false);
        runner$5.apply((List<Tuple2<StatementHandler, Statement>>)handlersAndStatements, (HashMap<StatementHandler, Object>)states$5);
        log$14.info(() -> ScriptedTests.commonRunTest$$anonfun$3$$anonfun$1(label$10, pendingMark$3));
        if (pending$2) {
            log$14.clear();
            log$14.error(ScriptedTests::commonRunTest$$anonfun$3$$anonfun$2);
            return Some$.MODULE$.apply((Object)label$10);
        }
        return None$.MODULE$;
    }
}

