/*
 * Decompiled with CFR 0.152.
 */
package sbt.scriptedtest;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import sbt.internal.scripted.StatementHandler;
import sbt.internal.scripted.TestFailed;
import sbt.internal.util.RunningProcesses$;
import sbt.package$;
import sbt.scriptedtest.RemoteSbtCreator;
import sbt.scriptedtest.SbtInstance;
import sbt.scriptedtest.SbtInstance$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process;
import xsbt.IPC;
import xsbt.IPC$;

public final class SbtHandler
implements StatementHandler {
    private final RemoteSbtCreator remoteSbtCreator;

    public SbtHandler(RemoteSbtCreator remoteSbtCreator) {
        this.remoteSbtCreator = remoteSbtCreator;
        package$.MODULE$.Signals().register((Function0)(JFunction0.mcV.sp & Serializable)() -> RunningProcesses$.MODULE$.killAll(), package$.MODULE$.Signals().register$default$2());
    }

    public Option<SbtInstance> initialState() {
        return None$.MODULE$;
    }

    public Option<SbtInstance> apply(String command, List<String> arguments, Option<SbtInstance> i) {
        return this.onSbtInstance(i, (Function2<Process, IPC.Server, BoxedUnit>)(JProcedure2 & Serializable)(_$1, server) -> {
            this.send(arguments.$colon$colon((Object)command).mkString(" "), (IPC.Server)server);
            this.receive(new StringBuilder(7).append(command).append(" failed").toString(), (IPC.Server)server);
        });
    }

    public Option<SbtInstance> onSbtInstance(Option<SbtInstance> i, Function2<Process, IPC.Server, BoxedUnit> f) {
        SbtInstance sbtInstance;
        Option<SbtInstance> option = i;
        if (option instanceof Some && (sbtInstance = (SbtInstance)((Some)option).value()) != null) {
            SbtInstance sbtInstance2 = SbtInstance$.MODULE$.unapply(sbtInstance);
            Process process = sbtInstance2._1();
            IPC.Server server = sbtInstance2._2();
            IPC.Server server2 = server;
            if (server2.isClosed()) {
                this.finish(i);
                return this.onNewSbtInstance(f);
            }
            Process process2 = process;
            IPC.Server server3 = server;
            f.apply((Object)process2, (Object)server3);
            return i;
        }
        if (None$.MODULE$.equals(option)) {
            return this.onNewSbtInstance(f);
        }
        throw new MatchError(option);
    }

    private Option<SbtInstance> onNewSbtInstance(Function2<Process, IPC.Server, BoxedUnit> f) {
        Process process;
        IPC.Server server = IPC$.MODULE$.unmanagedServer();
        try {
            process = this.newRemote(server);
        }
        catch (Throwable e) {
            server.close();
            throw e;
        }
        Process p = process;
        Some i = Some$.MODULE$.apply((Object)SbtInstance$.MODULE$.apply(p, server));
        try {
            f.apply((Object)p, (Object)server);
        }
        catch (Throwable e) {
            this.finish((Option<SbtInstance>)i);
            throw e;
        }
        return i;
    }

    public void finish(Option<SbtInstance> state) {
        SbtInstance sbtInstance;
        Option<SbtInstance> option = state;
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some && (sbtInstance = (SbtInstance)((Some)option).value()) != null) {
            SbtInstance sbtInstance2 = SbtInstance$.MODULE$.unapply(sbtInstance);
            Process process = sbtInstance2._1();
            IPC.Server server = sbtInstance2._2();
            Process process2 = process;
            IPC.Server server2 = server;
            try {
                try {
                    this.send("exit", server2);
                    process2.exitValue();
                }
                catch (IOException iOException) {
                    process2.destroy();
                }
            }
            finally {
                if (process2.isAlive()) {
                    process2.destroy();
                }
                RunningProcesses$.MODULE$.remove(process2);
            }
            return;
        }
        throw new MatchError(option);
    }

    public void send(String message, IPC.Server server) {
        server.connection((Function1)(JProcedure1 & Serializable)_$2 -> _$2.send(message));
    }

    public void receive(String errorMessage, IPC.Server server) {
        server.connection((Function1)(JProcedure1 & Serializable)ipc -> {
            String resultMessage = ipc.receive();
            if (!StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(resultMessage))) {
                throw new TestFailed(errorMessage);
            }
        });
    }

    public Process newRemote(IPC.Server server) {
        Process p = this.remoteSbtCreator.newRemote(server);
        RunningProcesses$.MODULE$.add(p);
        try {
            this.receive("Remote sbt initialization failed", server);
        }
        catch (SocketException socketException) {
            throw new TestFailed("Remote sbt initialization failed");
        }
        return p;
    }
}

