/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.worker;

import java.io.Serializable;
import sbt.internal.worker.JvmRunInfo;
import sbt.internal.worker.NativeRunInfo;
import sbt.internal.worker.RunInfo$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class RunInfo
implements Serializable {
    private final boolean jvm;
    private final Option<JvmRunInfo> jvmRunInfo;
    private final Option<NativeRunInfo> nativeRunInfo;

    public static RunInfo apply(boolean bl, JvmRunInfo jvmRunInfo) {
        return RunInfo$.MODULE$.apply(bl, jvmRunInfo);
    }

    public static RunInfo apply(boolean bl, JvmRunInfo jvmRunInfo, NativeRunInfo nativeRunInfo) {
        return RunInfo$.MODULE$.apply(bl, jvmRunInfo, nativeRunInfo);
    }

    public static RunInfo apply(boolean bl, Option<JvmRunInfo> option) {
        return RunInfo$.MODULE$.apply(bl, option);
    }

    public static RunInfo apply(boolean bl, Option<JvmRunInfo> option, Option<NativeRunInfo> option2) {
        return RunInfo$.MODULE$.apply(bl, option, option2);
    }

    public RunInfo(boolean jvm, Option<JvmRunInfo> jvmRunInfo, Option<NativeRunInfo> nativeRunInfo) {
        this.jvm = jvm;
        this.jvmRunInfo = jvmRunInfo;
        this.nativeRunInfo = nativeRunInfo;
    }

    public boolean jvm() {
        return this.jvm;
    }

    public Option<JvmRunInfo> jvmRunInfo() {
        return this.jvmRunInfo;
    }

    public Option<NativeRunInfo> nativeRunInfo() {
        return this.nativeRunInfo;
    }

    public RunInfo(boolean jvm, Option<JvmRunInfo> jvmRunInfo) {
        this(jvm, jvmRunInfo, (Option<NativeRunInfo>)None$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        Object object = o;
        if (!(object instanceof RunInfo)) return false;
        RunInfo x = (RunInfo)object;
        if (this.jvm() != x.jvm()) return false;
        Option<JvmRunInfo> option = this.jvmRunInfo();
        Option<JvmRunInfo> option2 = x.jvmRunInfo();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<NativeRunInfo> option3 = this.nativeRunInfo();
        Option<NativeRunInfo> option4 = x.nativeRunInfo();
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (17 + Statics.anyHash((Object)"sbt.internal.worker.RunInfo")) + Statics.anyHash((Object)BoxesRunTime.boxToBoolean((boolean)this.jvm()))) + Statics.anyHash(this.jvmRunInfo())) + Statics.anyHash(this.nativeRunInfo()));
    }

    public String toString() {
        return new StringBuilder(13).append("RunInfo(").append(this.jvm()).append(", ").append(this.jvmRunInfo()).append(", ").append(this.nativeRunInfo()).append(")").toString();
    }

    private RunInfo copy(boolean jvm, Option<JvmRunInfo> jvmRunInfo, Option<NativeRunInfo> nativeRunInfo) {
        return new RunInfo(jvm, jvmRunInfo, nativeRunInfo);
    }

    private boolean copy$default$1() {
        return this.jvm();
    }

    private Option<JvmRunInfo> copy$default$2() {
        return this.jvmRunInfo();
    }

    private Option<NativeRunInfo> copy$default$3() {
        return this.nativeRunInfo();
    }

    public RunInfo withJvm(boolean jvm) {
        return this.copy(jvm, this.copy$default$2(), this.copy$default$3());
    }

    public RunInfo withJvmRunInfo(Option<JvmRunInfo> jvmRunInfo) {
        return this.copy(this.copy$default$1(), jvmRunInfo, this.copy$default$3());
    }

    public RunInfo withJvmRunInfo(JvmRunInfo jvmRunInfo) {
        Option option = Option$.MODULE$.apply((Object)jvmRunInfo);
        boolean bl = this.copy$default$1();
        Option<NativeRunInfo> option2 = this.copy$default$3();
        return this.copy(bl, (Option<JvmRunInfo>)option, option2);
    }

    public RunInfo withNativeRunInfo(Option<NativeRunInfo> nativeRunInfo) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), nativeRunInfo);
    }

    public RunInfo withNativeRunInfo(NativeRunInfo nativeRunInfo) {
        Option option = Option$.MODULE$.apply((Object)nativeRunInfo);
        boolean bl = this.copy$default$1();
        Option<JvmRunInfo> option2 = this.copy$default$2();
        return this.copy(bl, option2, (Option<NativeRunInfo>)option);
    }
}

